; include file
#dontinclude




function	init_sound
rem	init_sound()
rem	sets up a basic sound driver for small wave files to be played back
rem	make sure you are in ram/ram mode for playback if you are $8000+
rem

def	sound_play	byte
def	sound_pos	word
def	sound_end	word

init_sound

	orcc	#$50	;kill interupt

;tv on
	lda	$ff01
	ora	#8
	eora	#8
	sta	$ff01

	lda	$ff03
	ora	#8
	sta	$ff03
	lda	$ff23
	ora	#8
	sta	$ff23

	ldx	#sound_irq
	stx	$010d
	andcc	#$ef

	rts


;*******************************************************************************
sound_irq

; update system clock
	ldd	$112	;sys clock
	addd	#1
	std	$112


;tv on
	lda	$ff01
	ora	#8
	eora	#8
	sta	$ff01

	lda	$ff03
	ora	#8
	sta	$ff03
	lda	$ff23
	ora	#8
	sta	$ff23
;? did i need that?



	if	b,sound_play=#1
	ldb	#20
	ldx	sound_pos
sound_sample
	lda	,x+
	stx	sound_pos
	sta	$ff20
	cmpx	sound_end
	bhs	sound_finished
	jsr	sound_delay
	decb
	bne	sound_sample
	endif

sound_exit
	lda	$ff02	;ack irq
	rti

sound_finished
	clr	sound_play
	bra	sound_exit
;*******************************************************************
sound_delay
	ldy	#20
sound_delay1
	leay	-1,y
	bne	sound_delay1
	rts


endfunction


function	play_sound	play_sound_adr,play_sound_adre,play_sound_delay
rem	play_sound( address.w , end.w , delay.w )
rem	
rem	
rem	

def	play_sound_adr	word
def	play_sound_adre	word
def	play_sound_delay	word

play_sound
	orcc	#$50
;skip 44 bytes
	ldx	play_sound_adr
	leax	44,x
	stx	sound_pos

	ldd	play_sound_adre
	std	sound_end

	ldx	#sound_delay
	leax	2,x
	ldd	play_sound_delay
	std	,x
	lda	#1
	sta	sound_play
	andcc	#$ef
	rts
endfunction



function	stop_sound
rem	stop_sound()
rem	
rem	
rem	

stop_sound
	orcc	#$50
	lda	#0
	sta	sound_play
	andcc	#$ef
	rts
endfunction


















