#dontinclude
; include file

; 4 color graphics 128x96

; coco3 can edit palette

function	a_information
rem	cg3 is a display of 128x96x4	
rem	using sprites requires your background layer to be draw on both screens 0,1 
rem	and have your sync to screen 1.    can not be double buffered
rem	pages start at 32k +
rem	pages are at 3584,6656,9728
a_information

	rts

endfunction


function	cg3_setdisplay	cg3_setdisplay_c
rem	cg3_setdisplay( mode.b )
rem	
rem	sets the display mode to 128x96x4 color mode with color set 0 or 1
rem	

def	cg3_setdisplay_c	byte

stack	x

cg3_setdisplay

	lda	#0
	ldx	#65472
	sta	0,x
	ldx	#65474
	sta	0,x
	ldx	#65476
	sta	1,x



;setup page 0 at e00
;7
	sta	65479
	sta	65481
	sta	65483
	sta	65484
	sta	65486
	sta	65488
	sta	65490

	if	b,cg3_setdisplay_c=#0
;192 / 200
	lda	$ff22
	ora	#192
	sta	$ff22
	endif

	if	b,cg3_setdisplay_c=#1
	lda	$ff22
	ora	#200
	sta	$ff22
	endif

	if	b,cg3_setdisplay_c=#2
	lda	#248
	sta	$ff22
	endif


	rts

endfunction




;**********************************************************************************************************************

function	cg3_sync	cg3_sync_pg
rem	cg3_sync( page.b )
rem	syncs the working display onto screen
rem	
rem	
	
def	cg3_sync_pg	byte



cg3_sync
	lda	$ff03
	bpl	cg3_sync
	if	b,cg3_sync_pg=#0
;setup page 0 at e00
;7
	sta	65479
	sta	65481
	sta	65483
	sta	65484
	sta	65486
	sta	65488
	sta	65490
	endif
	if	b,cg3_sync_pg=#1
;13
;setup page 1
	sta	65479
	sta	65480
	sta	65483
	sta	65485
	sta	65486
	sta	65488
	sta	65490
	endif
	if	b,cg3_sync_pg=#2
; setup memory page 2
;19
	sta	65479
	sta	65481
	sta	65482
	sta	65484
	sta	65487
	sta	65488
	sta	65490
	endif
	rts
endfunction





;**********************************************************************************************************************

function	cg3_nosync	cg3_nosync_pg
rem	cg3_nosync( page.b )
rem	syncs the working display onto screen
rem	
rem	
def	cg3_nosync_pg	byte
def	cg3_nosync_cn	byte


cg3_nosync
	inc	cg3_nosync_cn
	if	b,cg3_nosync_cn=>#99
cg3_nosync_w
	lda	$ff03
	bpl	cg3_nosync_w
	clr	cg3_nosync_cn
	endif


	if	b,cg3_nosync_pg=#0
;setup page 0 at e00
;7
;	sta	65479
	sta	65481
	sta	65483
	sta	65484
	sta	65486
;	sta	65488
	sta	65490
	endif
	if	b,cg3_nosync_pg=#1
;13
;setup page 1
;	sta	65479
	sta	65480
	sta	65483
	sta	65485
	sta	65486
;	sta	65488
;	sta	65490
	endif
	if	b,cg3_nosync_pg=#2
; setup memory page 2
;19
;	sta	65479
	sta	65481
	sta	65482
	sta	65484
	sta	65487
;	sta	65488
;	sta	65490
	endif

	rts
endfunction




;**********************************************************************************************************************************

function	cg3_cls	cg3_cls_page,cg3_cls_color
rem	cg3_cls( page.b , color.b  )
rem	
rem	clears color 0-3 on pages 0-1
rem	
def	cg3_cls_page	byte
def	cg3_cls_color	byte


cg3_cls_pages	fdb	3584,6656,9728

stack	x,y,u

cg3_cls
	lda	cg3_cls_color
	anda	#3
	sta	cg3_cls_color

	ldu	#cg3_cls_pages	;end of page 1
	ldb	cg3_cls_page
	lda	#2
	mul
	leau	b,u
	ldd	,u
	tfr	d,u

	ldd	#3072
	leau	d,u
	lda	cg3_cls_color
	lsla
	lsla
	adda	cg3_cls_color
	lsla
	lsla
	adda	cg3_cls_color
	lsla
	lsla
	adda	cg3_cls_color
	tfr	a,b
	tfr	d,x
	tfr	d,y
	ldb	#24
cg3_cls_pg0
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y	;32

	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y	;32

	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y	;32

	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y
	pshu	x,y	;32

	decb
	bne	cg3_cls_pg0
	rts

endfunction
























; *************************************************************************************
function	cg3_triangle_b	cg3_triangle_b_scrn,cg3_triangle_b_x1,cg3_triangle_b_y1,cg3_triangle_b_x2,cg3_triangle_b_y2,cg3_triangle_b_x3,cg3_triangle_b_y3,cg3_triangle_b_p
rem	cg3_triangle_b( page.b , x1.b , y1.b , x2.b , y2.b , x3.b , y3.b , pointer.w)
rem	resolution x=0-127 y=0-95 color=0-3
rem	expiremental
rem	

def	cg3_triangle_b_scrn	byte
def	cg3_triangle_b_x1	byte
def	cg3_triangle_b_y1	byte
def	cg3_triangle_b_x2	byte
def	cg3_triangle_b_y2	byte
def	cg3_triangle_b_x3	byte
def	cg3_triangle_b_y3	byte



def	cg3_triangle_b_p	byte	;pointer at some point
def	cg3_triangle_b_xdist	byte
def	cg3_triangle_b_ydist	byte
def	cg3_triangle_b_wn	byte	;whole fraction
def	cg3_triangle_b_xc	byte	;direction control
def	cg3_triangle_b_yc	byte
def	cg3_triangle_b_ycnt	byte
def	cg3_triangle_b_xcnt	byte
def	cg3_triangle_b_cnt	byte
cg3_triangle_b_scrntbl	fdb	3584,6656,9728


;cg3_triangle_b_dotmsk	fcb	63,207,243,252
;cg3_triangle_b_dotmsk2	fcb	192,48,12,3
;cg3_triangle_b_dotcol	fcb	0,85,170,255



;cg3_triangle_a_dotmsk	fcb	63,207,243,252
;cg3_triangle_a_dotmsk2	fcb	192,48,12,3
;cg3_triangle_a_dotcol	fcb	0,85,170,255


cg3_triangle_b_dotmsk	fcb	15,240
cg3_triangle_b_dotmsk2	fcb	240,15
cg3_triangle_b_dotcol	fcb	0,85,170,255


def	cg3_triangle_b_dotst	byte	; dot store
def	cg3_triangle_b_dotm	byte	;dot masked color

;second line
def	cg3_triangle_b_xdist2	byte
def	cg3_triangle_b_ydist2	byte
def	cg3_triangle_b_wn2	byte	;whole fraction
def	cg3_triangle_b_xc2	byte	;direction control
def	cg3_triangle_b_yc2	byte
def	cg3_triangle_b_ycnt2	byte
def	cg3_triangle_b_xcnt2	byte
def	cg3_triangle_b_cnt2	byte

;third line
def	cg3_triangle_b_xdist3	byte
def	cg3_triangle_b_ydist3	byte
def	cg3_triangle_b_wn3	byte	;whole fraction
def	cg3_triangle_b_xc3	byte	;direction control
def	cg3_triangle_b_yc3	byte
def	cg3_triangle_b_ycnt3	byte
def	cg3_triangle_b_xcnt3	byte
def	cg3_triangle_b_cnt3	byte



def	cg3_triangle_b_x0	byte
def	cg3_triangle_b_y0	byte


;third point


stack	x,y,u

cg3_triangle_b

; figure out line 3 start
	lda	cg3_triangle_b_x1
	sta	cg3_triangle_b_x0
	lda	cg3_triangle_b_y1
	sta	cg3_triangle_b_y0





; line 2
; x dist**************************************************************************************
	lda	cg3_triangle_b_x0
	cmpa	cg3_triangle_b_x3
	bls	cg3_triangle_b_lind02
	lda	cg3_triangle_b_x0
	suba	cg3_triangle_b_x3
	sta	cg3_triangle_b_xdist2
	clr	cg3_triangle_b_xc2	; direction x-
	bra	cg3_triangle_b_lind12
cg3_triangle_b_lind02
	lda	cg3_triangle_b_x3
	suba	cg3_triangle_b_x0
	sta	cg3_triangle_b_xdist2
	lda	#1
	sta	cg3_triangle_b_xc2	; direction x+
; y dist *****************************************************************************************
cg3_triangle_b_lind12
	lda	cg3_triangle_b_y0
	cmpa	cg3_triangle_b_y3
	bls	cg3_triangle_b_lind22
	lda	cg3_triangle_b_y0
	suba	cg3_triangle_b_y3
	sta	cg3_triangle_b_ydist2
	clr	cg3_triangle_b_yc2	; direction y-
	bra	cg3_triangle_b_lind32
cg3_triangle_b_lind22
	lda	cg3_triangle_b_y3
	suba	cg3_triangle_b_y0
	sta	cg3_triangle_b_ydist2
	lda	#1
	sta	cg3_triangle_b_yc2	; direction y+
; lets grab whole fraction*********************************************************************
cg3_triangle_b_lind32
	lda	cg3_triangle_b_xdist2
	cmpa	cg3_triangle_b_ydist2
	bls	cg3_triangle_b_yiswn22
	lda	cg3_triangle_b_xdist2
	sta	cg3_triangle_b_wn2	; x is the whole number
	bra	cg3_triangle_b_drawln22
cg3_triangle_b_yiswn22
	lda	cg3_triangle_b_ydist2
	sta	cg3_triangle_b_wn2

;additional setup*****************************************************************************
cg3_triangle_b_drawln22
	lda	cg3_triangle_b_wn2
	lsra
	sta	cg3_triangle_b_xcnt2
	sta	cg3_triangle_b_ycnt2
	lda	cg3_triangle_b_wn2
	sta	cg3_triangle_b_cnt2	;set counter
	inc	cg3_triangle_b_cnt2



; 2nd line done




;third line

;line 3
; x dist**************************************************************************************
	lda	cg3_triangle_b_x2
	cmpa	cg3_triangle_b_x3
	bls	cg3_triangle_b_lind03
	lda	cg3_triangle_b_x2
	suba	cg3_triangle_b_x3
	sta	cg3_triangle_b_xdist3
	clr	cg3_triangle_b_xc3	; direction x-
	bra	cg3_triangle_b_lind13
cg3_triangle_b_lind03
	lda	cg3_triangle_b_x3
	suba	cg3_triangle_b_x2
	sta	cg3_triangle_b_xdist3
	lda	#1
	sta	cg3_triangle_b_xc3	; direction x+
; y dist *****************************************************************************************
cg3_triangle_b_lind13
	lda	cg3_triangle_b_y2
	cmpa	cg3_triangle_b_y3
	bls	cg3_triangle_b_lind23
	lda	cg3_triangle_b_y2
	suba	cg3_triangle_b_y3
	sta	cg3_triangle_b_ydist3
	clr	cg3_triangle_b_yc3	; direction y-
	bra	cg3_triangle_b_lind33
cg3_triangle_b_lind23
	lda	cg3_triangle_b_y3
	suba	cg3_triangle_b_y2
	sta	cg3_triangle_b_ydist3
	lda	#1
	sta	cg3_triangle_b_yc3	; direction y+
; lets grab whole fraction*********************************************************************
cg3_triangle_b_lind33
	lda	cg3_triangle_b_xdist3
	cmpa	cg3_triangle_b_ydist3
	bls	cg3_triangle_b_yiswn23
	lda	cg3_triangle_b_xdist3
	sta	cg3_triangle_b_wn3	; x is the whole number
	bra	cg3_triangle_b_drawln23
cg3_triangle_b_yiswn23
	lda	cg3_triangle_b_ydist3
	sta	cg3_triangle_b_wn3

;additional setup*****************************************************************************
cg3_triangle_b_drawln23
	lda	cg3_triangle_b_wn3
	lsra
	sta	cg3_triangle_b_xcnt3
	sta	cg3_triangle_b_ycnt3
	lda	cg3_triangle_b_wn3
	sta	cg3_triangle_b_cnt3	;set counter
	inc	cg3_triangle_b_cnt3



; 3rd line done
;	lda	#128
;	sta	cg3_triangle_b_dummy



;******************************************************************************************************************repeat for line change 2
cg3_triangle_b_lp2




; x dist**************************************************************************************
	lda	cg3_triangle_b_x1
	cmpa	cg3_triangle_b_x2
	bls	cg3_triangle_b_lind0
	lda	cg3_triangle_b_x1
	suba	cg3_triangle_b_x2
	sta	cg3_triangle_b_xdist
	clr	cg3_triangle_b_xc	; direction x-
	bra	cg3_triangle_b_lind1
cg3_triangle_b_lind0
	lda	cg3_triangle_b_x2
	suba	cg3_triangle_b_x1
	sta	cg3_triangle_b_xdist
	lda	#1
	sta	cg3_triangle_b_xc	; direction x+
; y dist *****************************************************************************************
cg3_triangle_b_lind1
	lda	cg3_triangle_b_y1
	cmpa	cg3_triangle_b_y2
	bls	cg3_triangle_b_lind2
	lda	cg3_triangle_b_y1
	suba	cg3_triangle_b_y2
	sta	cg3_triangle_b_ydist
	clr	cg3_triangle_b_yc	; direction y-
	bra	cg3_triangle_b_lind3
cg3_triangle_b_lind2
	lda	cg3_triangle_b_y2
	suba	cg3_triangle_b_y1
	sta	cg3_triangle_b_ydist
	lda	#1
	sta	cg3_triangle_b_yc	; direction y+
; lets grab whole fraction*********************************************************************
cg3_triangle_b_lind3
	lda	cg3_triangle_b_xdist
	cmpa	cg3_triangle_b_ydist
	bls	cg3_triangle_b_yiswn
	lda	cg3_triangle_b_xdist
	sta	cg3_triangle_b_wn	; x is the whole number
	bra	cg3_triangle_b_drawln
cg3_triangle_b_yiswn
	lda	cg3_triangle_b_ydist
	sta	cg3_triangle_b_wn

;additional setup*****************************************************************************
cg3_triangle_b_drawln

	lda	cg3_triangle_b_wn
	lsra
	sta	cg3_triangle_b_xcnt
	sta	cg3_triangle_b_ycnt
	lda	cg3_triangle_b_wn
	sta	cg3_triangle_b_cnt	;set counter
	inc	cg3_triangle_b_cnt




cg3_triangle_b_drawln1



	



; main loop *************************************************************************************************************************************************************
cg3_triangle_b_drawln2



; dot draw
	lda	cg3_triangle_b_x1
	cmpa	#127
	bhi	cg3_triangle_b_nope2
	lda	cg3_triangle_b_y1
	cmpa	#95
	bhi	cg3_triangle_b_nope2
	ldb	cg3_triangle_b_scrn
	ldx	#cg3_triangle_b_scrntbl
	ldy	#cg3_triangle_b_dotmsk2
	ldu	#cg3_triangle_b_dotcol
	lslb	; scrn #*2
	abx
	ldx	,x
; x index is at start of screen
	lda	cg3_triangle_b_y1
	ldb	#32
	mul
	leax	d,x	; advance y pos
	lda	cg3_triangle_b_x1
	anda	#1	;mask out which dot of 4 was 3
	sta	cg3_triangle_b_dotst
	ldb	cg3_triangle_b_x1
	lsrb
	lsrb
	abx	;ok we are ready to draw (again, result is always 8 bits lcb)
; mask color

; load color from new table

	ldb	cg3_triangle_b_p

	ldu	#cg3_triangle_b_dotcol
	lda	b,u
	ldb	cg3_triangle_b_dotst
	anda	b,y
	sta	cg3_triangle_b_dotm	;dot saved
; grab original
	ldu	#cg3_triangle_b_dotmsk	; 1 byte smaller/1 cycle faster
	lda	,x
	anda	b,u
	adda	cg3_triangle_b_dotm
	sta	,x

cg3_triangle_b_nope2

; end draw dot




;check x line**************************************************************************
	lda	cg3_triangle_b_xcnt
	adda	cg3_triangle_b_xdist
	cmpa	cg3_triangle_b_wn
	bhs	cg3_triangle_b_adv2
	sta	cg3_triangle_b_xcnt
	bra	cg3_triangle_b_chk2
;
cg3_triangle_b_adv2
	suba	cg3_triangle_b_wn
	sta	cg3_triangle_b_xcnt
	lda	cg3_triangle_b_xc	;the direction? 0 left 1 right
	beq	cg3_triangle_b_xleft
; right
	inc	cg3_triangle_b_x1
	bra	cg3_triangle_b_chk2
cg3_triangle_b_xleft
	dec	cg3_triangle_b_x1

;check y line ************************************************************************
cg3_triangle_b_chk2
	lda	cg3_triangle_b_ycnt
	adda	cg3_triangle_b_ydist
	cmpa	cg3_triangle_b_wn
	bhs	cg3_triangle_b_advy2
	sta	cg3_triangle_b_ycnt
	bra	cg3_triangle_b_chk3
cg3_triangle_b_advy2
	suba	cg3_triangle_b_wn
	sta	cg3_triangle_b_ycnt
	lda	cg3_triangle_b_yc	;the direction? 0 left 1 right
	beq	cg3_triangle_b_yleft
; right
	inc	cg3_triangle_b_y1
	bra	cg3_triangle_b_chk3
cg3_triangle_b_yleft
	dec	cg3_triangle_b_y1
cg3_triangle_b_chk3
	dec	cg3_triangle_b_cnt
	lbne	cg3_triangle_b_drawln2






;adjust for next line
	lda	cg3_triangle_b_x0
	sta	cg3_triangle_b_x1
	lda	cg3_triangle_b_y0
	sta	cg3_triangle_b_y1





;line 2 advancement

;check x line**************************************************************************
	lda	cg3_triangle_b_xcnt2
	adda	cg3_triangle_b_xdist2
	cmpa	cg3_triangle_b_wn2
	bhs	cg3_triangle_b_adv22
	sta	cg3_triangle_b_xcnt2
	bra	cg3_triangle_b_chk22
;
cg3_triangle_b_adv22
	suba	cg3_triangle_b_wn2
	sta	cg3_triangle_b_xcnt2
	lda	cg3_triangle_b_xc2	;the direction? 0 left 1 right
	beq	cg3_triangle_b_xleft22
; right
	inc	cg3_triangle_b_x0
	lda	cg3_triangle_b_x0
	sta	cg3_triangle_b_x1
	bra	cg3_triangle_b_chk22
cg3_triangle_b_xleft22
	dec	cg3_triangle_b_x0
	lda	cg3_triangle_b_x0
	sta	cg3_triangle_b_x1

;check y line ************************************************************************
cg3_triangle_b_chk22
	lda	cg3_triangle_b_ycnt2
	adda	cg3_triangle_b_ydist2
	cmpa	cg3_triangle_b_wn2
	bhs	cg3_triangle_b_advy22
	sta	cg3_triangle_b_ycnt2
	bra	cg3_triangle_b_chk32
cg3_triangle_b_advy22
	suba	cg3_triangle_b_wn2
	sta	cg3_triangle_b_ycnt2
	lda	cg3_triangle_b_yc2	;the direction? 0 left 1 right
	beq	cg3_triangle_b_yleft22
; right
	inc	cg3_triangle_b_y0
	lda	cg3_triangle_b_y0
	sta	cg3_triangle_b_y1
;hack?
;	inc	cg3_triangle_b_y2

	bra	cg3_triangle_b_chk32
cg3_triangle_b_yleft22
	dec	cg3_triangle_b_y0
	lda	cg3_triangle_b_y0
	sta	cg3_triangle_b_y1
;hack
;	dec	cg3_triangle_b_y2
cg3_triangle_b_chk32
	dec	cg3_triangle_b_cnt2

	lbeq	cg3_triangle_b_lp2done


cg3_triangle_b_lp2dones



;extra
; move line 3

;check x line**************************************************************************
	lda	cg3_triangle_b_xcnt3
	adda	cg3_triangle_b_xdist3
	cmpa	cg3_triangle_b_wn3
	bhs	cg3_triangle_b_adv23
	sta	cg3_triangle_b_xcnt3
	bra	cg3_triangle_b_chk23
;
cg3_triangle_b_adv23
	suba	cg3_triangle_b_wn3
	sta	cg3_triangle_b_xcnt3
	lda	cg3_triangle_b_xc3	;the direction? 0 left 1 right
	beq	cg3_triangle_b_xleft23
; right
	inc	cg3_triangle_b_x2
	bra	cg3_triangle_b_chk23
cg3_triangle_b_xleft23
	dec	cg3_triangle_b_x2

;check y line ************************************************************************
cg3_triangle_b_chk23
	lda	cg3_triangle_b_ycnt3
	adda	cg3_triangle_b_ydist3
	cmpa	cg3_triangle_b_wn3
	bhs	cg3_triangle_b_advy23
	sta	cg3_triangle_b_ycnt3
	bra	cg3_triangle_b_chk33
cg3_triangle_b_advy23
	suba	cg3_triangle_b_wn3
	sta	cg3_triangle_b_ycnt3
	lda	cg3_triangle_b_yc3	;the direction? 0 left 1 right
	beq	cg3_triangle_b_yleft23
; right
	inc	cg3_triangle_b_y2
	bra	cg3_triangle_b_chk33
cg3_triangle_b_yleft23
	dec	cg3_triangle_b_y2
cg3_triangle_b_chk33
	dec	cg3_triangle_b_cnt3

	lbne	cg3_triangle_b_lp2





cg3_triangle_b_lp2done



	rts

endfunction












 
; **********************************************************************************************************************
function	cg3_circle	cg3_circle_page,cg3_circle_sintb1,cg3_circle_plotx,cg3_circle_ploty,cg3_circle_radx,cg3_circle_rady,cg3_circle_angles,cg3_circle_anglee,cg3_circle_color
rem	cg3_circle( page.b , sinetable.w ,x1.b , y1.b , diamx.b , diamy.b , anglestart.b , angleend.b , color.b)
rem	max rad 34 circle angle 0-255 as percentage of 360
rem	does not push to stack uses x for sine table
rem	

def	cg3_circle_page	byte
def	cg3_circle_sintb1	word
def	cg3_circle_angles	byte
def	cg3_circle_anglee	byte
def	cg3_circle_plotx	byte
def	cg3_circle_ploty	byte
def	cg3_circle_radx	byte
def	cg3_circle_rady	byte
def	cg3_circle_color	byte

; pass over to dot

cg3_circle_scrntbl	fdb	3584,6656,9728
cg3_circle_dotmsk	fcb	63,207,243,252
cg3_circle_dotmsk2	fcb	192,48,12,3
cg3_circle_dotcol	fcb	0,85,170,255

def	cg3_circle_dotst	byte	; dot store
def	cg3_circle_dotm	byte	;dot masked color

def	cg3_circle_x1	byte
def	cg3_circle_y1	byte

stack	x,y,u

cg3_circle

	clra
	ldx	cg3_circle_sintb1
	ldb	cg3_circle_angles
	abx
	ldb	,x
	lda	cg3_circle_radx
	mul
	aslb
	rola
	suba	cg3_circle_radx
	adda	cg3_circle_plotx
	sta	cg3_circle_x1
;cos
	ldx	cg3_circle_sintb1
	ldb	cg3_circle_angles
	addb	#64
	abx
	ldb	,x
	lda	cg3_circle_rady
	mul
	aslb
	rola
	suba	cg3_circle_rady
	adda	cg3_circle_ploty
	sta	cg3_circle_y1
;****************************************************************************
; dot draw
	lda	cg3_circle_x1
	cmpa	#127
	bhi	cg3_circle_nope2
	lda	cg3_circle_y1
	cmpa	#95
	bhi	cg3_circle_nope2
	ldb	cg3_circle_page
	ldx	#cg3_circle_scrntbl
	ldy	#cg3_circle_dotmsk2
	ldu	#cg3_circle_dotcol
	lslb	; scrn #*2
	abx
	ldx	,x
; x index is at start of screen
	lda	cg3_circle_y1
	ldb	#32
	mul
	leax	d,x	; advance y pos
	lda	cg3_circle_x1
	anda	#3	;mask out which dot of 4
	sta	cg3_circle_dotst
	ldb	cg3_circle_x1
	lsrb
	lsrb
	abx	;ok we are ready to draw (again, result is always 8 bits lcb)
; mask color
	ldb	cg3_circle_color
	lda	b,u
	ldb	cg3_circle_dotst
	anda	b,y
	sta	cg3_circle_dotm	;dot saved
; grab original
	ldu	#cg3_circle_dotmsk	; 1 byte smaller/1 cycle faster
	lda	,x
	anda	b,u
	adda	cg3_circle_dotm
	sta	,x

cg3_circle_nope2
; end draw dot

	lda	cg3_circle_angles
	inca
	sta	cg3_circle_angles
	cmpa	cg3_circle_anglee
	lbne	cg3_circle

	rts
endfunction






; *************************************************************************************
function	cg3_line	cg3_line_scrn,cg3_line_x1,cg3_line_y1,cg3_line_x2,cg3_line_y2,cg3_line_col1
rem	cg3_line( page.b , x1.b , y1.b , x2.b , y2.b , color.b)
rem	resolution x=0-127 y=0-95 color=0-3
def	cg3_line_scrn	byte
def	cg3_line_x1	byte
def	cg3_line_y1	byte
def	cg3_line_x2	byte
def	cg3_line_y2	byte
def	cg3_line_col1	byte
def	cg3_line_xdist	byte
def	cg3_line_ydist	byte
def	cg3_line_wn	byte	;whole fraction
def	cg3_line_xc	byte	;direction control
def	cg3_line_yc	byte
def	cg3_line_ycnt	byte
def	cg3_line_xcnt	byte
def	cg3_line_cnt	byte
cg3_line_scrntbl	fdb	3584,6656,9728
cg3_line_dotmsk	fcb	63,207,243,252
cg3_line_dotmsk2	fcb	192,48,12,3
cg3_line_dotcol	fcb	0,85,170,255

def	cg3_line_dotst	byte	; dot store
def	cg3_line_dotm	byte	;dot masked color

stack	x,y,u

cg3_line
	lda	cg3_line_x1
	cmpa	cg3_line_x2
	bls	cg3_line_lind0
	lda	cg3_line_x1
	suba	cg3_line_x2
	sta	cg3_line_xdist
	clr	cg3_line_xc	; direction x-
	bra	cg3_line_lind1
cg3_line_lind0	lda	cg3_line_x2
	suba	cg3_line_x1
	sta	cg3_line_xdist
	lda	#1
	sta	cg3_line_xc	; direction x+
cg3_line_lind1	lda	cg3_line_y1
	cmpa	cg3_line_y2
	bls	cg3_line_lind2
	lda	cg3_line_y1
	suba	cg3_line_y2
	sta	cg3_line_ydist
	clr	cg3_line_yc	; direction y-
	bra	cg3_line_lind3
cg3_line_lind2	lda	cg3_line_y2
	suba	cg3_line_y1
	sta	cg3_line_ydist
	lda	#1
	sta	cg3_line_yc	; direction y+
; lets grab whole fraction
cg3_line_lind3	lda	cg3_line_xdist
	cmpa	cg3_line_ydist
	bls	cg3_line_yiswn
	lda	cg3_line_xdist
	sta	cg3_line_wn	; x is the whole number
	bra	cg3_line_drawln
cg3_line_yiswn	lda	cg3_line_ydist
	sta	cg3_line_wn
; ok the distances are sorted
cg3_line_drawln
	lda	cg3_line_wn
	lsra
	sta	cg3_line_xcnt
	sta	cg3_line_ycnt
	lda	cg3_line_wn
	sta	cg3_line_cnt	;set counter
	inc	cg3_line_cnt
cg3_line_drawln1


; dot draw
	lda	cg3_line_x1
	cmpa	#127
	bhi	cg3_line_nope2
	lda	cg3_line_y1
	cmpa	#95
	bhi	cg3_line_nope2
	ldb	cg3_line_scrn
	ldx	#cg3_line_scrntbl
	ldy	#cg3_line_dotmsk2
	ldu	#cg3_line_dotcol
	lslb	; scrn #*2
	abx
	ldx	,x
; x index is at start of screen
	lda	cg3_line_y1
	ldb	#32
	mul
	leax	d,x	; advance y pos
	lda	cg3_line_x1
	anda	#3	;mask out which dot of 4
	sta	cg3_line_dotst
	ldb	cg3_line_x1
	lsrb
	lsrb
	abx	;ok we are ready to draw (again, result is always 8 bits lcb)
; mask color
	ldb	cg3_line_col1
	lda	b,u
	ldb	cg3_line_dotst
	anda	b,y
	sta	cg3_line_dotm	;dot saved
; grab original
	ldu	#cg3_line_dotmsk	; 1 byte smaller/1 cycle faster
	lda	,x
	anda	b,u
	adda	cg3_line_dotm
	sta	,x

cg3_line_nope2
; end draw dot

	lda	cg3_line_xcnt
	adda	cg3_line_xdist
	cmpa	cg3_line_wn
	bhs	cg3_line_adv2
	sta	cg3_line_xcnt
	bra	cg3_line_chk2
;
cg3_line_adv2
	suba	cg3_line_wn
	sta	cg3_line_xcnt
	lda	cg3_line_xc	;the direction? 0 left 1 right
	beq	cg3_line_xleft
; right
	inc	cg3_line_x1
	bra	cg3_line_chk2
cg3_line_xleft	dec	cg3_line_x1
cg3_line_chk2	lda	cg3_line_ycnt
	adda	cg3_line_ydist
	cmpa	cg3_line_wn
	bhs	cg3_line_advy2
	sta	cg3_line_ycnt
	bra	cg3_line_chk3
cg3_line_advy2	suba	cg3_line_wn
	sta	cg3_line_ycnt
	lda	cg3_line_yc	;the direction? 0 left 1 right
	beq	cg3_line_yleft
; right
	inc	cg3_line_y1
	bra	cg3_line_chk3
cg3_line_yleft	dec	cg3_line_y1
cg3_line_chk3	dec	cg3_line_cnt
	lbne	cg3_line_drawln1
cg3_line_nope
	rts

endfunction





; ************************************************************************************************************************
function	cg3_ppoint	cg3_ppoint_scrn,cg3_ppoint_xp1,cg3_ppoint_yp1
rem	cg3_ppoint( page.b , xpos.b , ypos.b ) 0-127 x 0-95 
rem	returns color back to b register
rem	
rem	

def	cg3_ppoint_scrn	byte
def	cg3_ppoint_xp1	byte
def	cg3_ppoint_yp1	byte
def	cg3_ppoint_dotst	byte

cg3_ppoint_scrntbl	fdb	3584,6656,9728

stack	x

cg3_ppoint
	lda	cg3_ppoint_scrn
	ldx	#cg3_ppoint_scrntbl
	ldb	#2
	mul
	leax	b,x
	ldx	,x
; x index is at start of screen
	lda	cg3_ppoint_yp1
	ldb	#32
	mul
	leax	d,x	; advance y pos
	lda	cg3_ppoint_xp1
	anda	#3	;mask out which dot of 4
	sta	cg3_ppoint_dotst
	ldb	cg3_ppoint_xp1
	lsrb
	lsrb
	leax	b,x	;ok we are ready to draw
	lda	cg3_ppoint_dotst
	cmpa	#3
	beq	cg3_ppoint_howb0
	cmpa	#2
	beq	cg3_ppoint_howb1
	cmpa	#1
	beq	cg3_ppoint_howb2
; its 4th dot
	ldb	,x
	lsrb
	lsrb
	lsrb
	lsrb
	lsrb
	lsrb
	andb	#3
	rts
cg3_ppoint_howb0	ldb	,x
	andb	#3
	rts
cg3_ppoint_howb1	ldb	,x
	lsrb
	lsrb
	andb	#3
	rts
cg3_ppoint_howb2	ldb	,x
	lsrb
	lsrb
	lsrb
	lsrb
	andb	#3
	rts
endfunction




;*****************************************************************************************************************************************


function	cg3_pset	cg3_pset_page,cg3_pset_x,cg3_pset_y,cg3_pset_col
rem	cg3_pset( page.b , x.b , y.b , color.b )
rem	sets a dot with specified color on the screen
rem	page 0-1 x 0-127 y 0-95 color 0-3
rem	uses stack x,y,u,d

def	cg3_pset_page	byte
def	cg3_pset_x	byte
def	cg3_pset_y	byte
def	cg3_pset_col	byte
def	cg3_pset_dotst	byte
def	cg3_pset_dotm	byte

cg3_pset_scrtbl	fdb	3584,6656,9728
cg3_pset_dotmsk	fcb	63,207,243,252
cg3_pset_dotmsk2	fcb	192,48,12,3
cg3_pset_dotcol	fcb	0,85,170,255

stack	x,y,u

cg3_pset
	if	b,cg3_pset_x>#127
	rts
	endif
	if	b,cg3_pset_y>#95
	rts
	endif

	ldb	cg3_pset_page
	ldx	#cg3_pset_scrtbl
	ldy	#cg3_pset_dotmsk2
	ldu	#cg3_pset_dotcol
	lslb	; scrn #*2
	abx
	ldx	,x
; x index is at start of screen
	lda	cg3_pset_y
	ldb	#32
	mul
	leax	d,x	; advance y pos
	lda	cg3_pset_x
	anda	#3	;mask out which dot of 4
	sta	cg3_pset_dotst
	ldb	cg3_pset_x
	lsrb
	lsrb
	abx	;ok we are ready to draw (again, result is always 8 bits lcb)
; mask color
	ldb	cg3_pset_col
	lda	b,u
	ldb	cg3_pset_dotst
	anda	b,y
	sta	cg3_pset_dotm	;dot saved
; grab original
	ldu	#cg3_pset_dotmsk	; 1 byte smaller/1 cycle faster
	lda	,x
	anda	b,u
	adda	cg3_pset_dotm
	sta	,x

	rts

endfunction





;******************************************************************************************************************************************
function	cg3_print	cg3_print_page,cg3_print_x,cg3_print_y,cg3_print_text,cg3_print_skip,cg3_print_max,cg3_print_font
rem	cg3_print( page.b , posx.b , posy.b , textpointer.w , skipchrs.b , length.b , font.w  )
rem	
rem	print text on the screen res tiles x=0-119  y=0-87


def	cg3_print_page	byte
def	cg3_print_x	byte
def	cg3_print_y	byte
def	cg3_print_text	word
def	cg3_print_skip	byte
def	cg3_print_max	byte
def	cg3_print_chr	byte
def	cg3_print_font	word


cg3_print_scrtbl	fdb	3584,6656,9728

stack	x,y,u


cg3_print


	ldx	#cg3_print_scrtbl
	ldb	cg3_print_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


; x has screen start


	lda	#32
	ldb	cg3_print_y
	mul
	leax	d,x


	ldb	cg3_print_x
	lsrb
	lsrb
	abx

; x is ready for printing
	ldu	cg3_print_text
	ldb	cg3_print_skip
	clra
	leau	d,u
; u is ready for reading text


cg3_print_mainlp
	lda	,u+
	sta	cg3_print_chr

	if	b,cg3_print_chr=#0	or	b,cg3_print_max=>#127	;BELOW ZERO
	rts
	endif

	lda	cg3_print_chr	;sub 32 for ascii font
	suba	#32
	sta	cg3_print_chr

	lda	cg3_print_max	;length subtract 1
	suba	#1
	sta	cg3_print_max

; load y with graphic
	ldy	cg3_print_font	;start of font
	lda	#16
	ldb	cg3_print_chr
	mul
	leay	d,y
; ready with chr

;	if	b,cg3_print_chr=#0
;	leax	2,x
;
;	lbra	cg3_print_mainlp
;	endif
	

	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y++
	std	,x++
	leax	30,x	;next line
	ldd	,y
	std	,x
	leax	-100,x	;back to top
	leax	-122,x	;back to top - 8



	lbra	cg3_print_mainlp



endfunction





;***********************************************************************************************************************************************************
function	cg3_sprite2	cg3_sprite2_page,cg3_sprite2_tile,cg3_sprite2_x,cg3_sprite2_y
rem	cg3_sprite2( page.b , sprite.w , posx.b , posy.b )
rem	alignment at byte level with transparency
rem	
rem	

def	cg3_sprite2_page	byte
def	cg3_sprite2_tile	word
def	cg3_sprite2_x	byte
def	cg3_sprite2_y	byte
def	cg3_sprite2_sx	byte
def	cg3_sprite2_sy	byte


def	cg3_sprite2_d0	byte
def	cg3_sprite2_d1	byte
def	cg3_sprite2_d2	byte
def	cg3_sprite2_d3	byte

def	cg3_sprite2_cnt	byte
def	cg3_sprite2_sxc	byte
def	cg3_sprite2_syc	byte
def	cg3_sprite2_savex	word

def	cg3_sprite2_trans	byte

cg3_sprite2_scrtbl	fdb	3584,6656,9728

stack	x,y,u

cg3_sprite2

;not used
	lda	#1
	sta	cg3_sprite2_sx
	sta	cg3_sprite2_sy


	ldx	#cg3_sprite2_scrtbl
	ldb	cg3_sprite2_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


; prep x for screen start


	lda	#32
	ldb	cg3_sprite2_y
	mul
	leax	d,x

	lda	cg3_sprite2_x
	lsra
	lsra
	leax	a,x
; x is ready to draw
	stx	cg3_sprite2_savex



	ldy	cg3_sprite2_tile

; y is ready with tile


	ldb	#0
	stb	cg3_sprite2_sxc
	stb	cg3_sprite2_syc


cg3_sprite2_lp0

	ldb	#8
cg3_sprite2_lp1
	lda	,x
	anda	#192
	sta	cg3_sprite2_d0
	lda	,x
	anda	#48
	sta	cg3_sprite2_d1
	lda	,x
	anda	#12
	sta	cg3_sprite2_d2
	lda	,x
	anda	#3
	sta	cg3_sprite2_d3

	lda	,y
	anda	#192
	beq	cg3_sprite2_n0
	sta	cg3_sprite2_d0	;write
cg3_sprite2_n0

	lda	,y
	anda	#48
	beq	cg3_sprite2_n1
	sta	cg3_sprite2_d1	;write
cg3_sprite2_n1

	lda	,y
	anda	#12
	beq	cg3_sprite2_n2
	sta	cg3_sprite2_d2	;write
cg3_sprite2_n2

	lda	,y
	anda	#3
	beq	cg3_sprite2_n3
	sta	cg3_sprite2_d3	;write
cg3_sprite2_n3

	lda	cg3_sprite2_d3
	adda	cg3_sprite2_d2
	adda	cg3_sprite2_d1
	adda	cg3_sprite2_d0
	sta	,x




	lda	1,x
	anda	#192
	sta	cg3_sprite2_d0
	lda	1,x
	anda	#48
	sta	cg3_sprite2_d1
	lda	1,x
	anda	#12
	sta	cg3_sprite2_d2
	lda	1,x
	anda	#3
	sta	cg3_sprite2_d3

	lda	1,y
	anda	#192
	beq	cg3_sprite2_nn0
	sta	cg3_sprite2_d0	;write
cg3_sprite2_nn0

	lda	1,y
	anda	#48
	beq	cg3_sprite2_nn1
	sta	cg3_sprite2_d1	;write
cg3_sprite2_nn1

	lda	1,y
	anda	#12
	beq	cg3_sprite2_nn2
	sta	cg3_sprite2_d2	;write
cg3_sprite2_nn2

	lda	1,y
	anda	#3
	beq	cg3_sprite2_nn3
	sta	cg3_sprite2_d3	;write
cg3_sprite2_nn3

	lda	cg3_sprite2_d3
	adda	cg3_sprite2_d2
	adda	cg3_sprite2_d1
	adda	cg3_sprite2_d0
	sta	1,x


	leax	32,x
	leay	2,y
	decb
	lbne	cg3_sprite2_lp1


	inc	cg3_sprite2_syc
	lda	cg3_sprite2_syc
	cmpa	cg3_sprite2_sy
	lblo	cg3_sprite2_lp0

	clr	cg3_sprite2_syc
	inc	cg3_sprite2_sxc


; prep x for screen start
	ldx	cg3_sprite2_savex
	lda	cg3_sprite2_sxc
	ldb	#2
	mul
	leax	d,x

	lda	cg3_sprite2_sxc
	cmpa	cg3_sprite2_sx
	lblo	cg3_sprite2_lp0


	rts

endfunction















;***********************************************************************************************************************************************************
function	cg3_sprite1	cg3_sprite1_page,cg3_sprite1_tile,cg3_sprite1_x,cg3_sprite1_y
rem	cg3_sprite1( page.b , sprite.w , posx.b , posy.b )
rem	alignment at byte level no transparency
rem	8x8
rem	

def	cg3_sprite1_page	byte
def	cg3_sprite1_tile	word
def	cg3_sprite1_x	byte
def	cg3_sprite1_y	byte



cg3_sprite1_scrtbl	fdb	3584,6656,9728


stack	x,y,u

cg3_sprite1

	ldx	#cg3_sprite1_scrtbl
	ldb	cg3_sprite1_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready

; prep x for screen start

	lda	#32
	ldb	cg3_sprite1_y
	mul
	leax	d,x

	lda	cg3_sprite1_x
	lsra
	lsra
	leax	a,x


	ldy	cg3_sprite1_tile
; y is ready with tile

	ldd	0,y
	std	0,x
	leax	32,x
	ldd	2,y
	std	0,x
	leax	32,x
	ldd	4,y
	std	0,x
	leax	32,x
	ldd	6,y
	std	0,x
	leax	32,x
	ldd	8,y
	std	0,x
	leax	32,x
	ldd	10,y
	std	0,x
	leax	32,x
	ldd	12,y
	std	0,x
	leax	32,x
	ldd	14,y
	std	0,x

	rts

endfunction











;**********************************************************************************************************************************
function	cg3_scroll_up	cg3_scroll_up_page,cg3_scroll_up_lines
rem	cg3_scroll_up( page.b, lines.b)
rem	scrolls working page up by lines
rem	
rem
	

def	cg3_scroll_up_page	byte
def	cg3_scroll_up_lines	byte

cg3_scroll_up_scrtbl	fdb	3584,6656,9728

stack	x,y,u

cg3_scroll_up

	ldx	#cg3_scroll_up_scrtbl
	ldb	cg3_scroll_up_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	#32
	lda	cg3_scroll_up_lines
	lbeq	cg3_scroll_up_dn
	mul
	leau	d,x


	ldb	#96
	subb	cg3_scroll_up_lines
	clra
	tfr	d,y
cg3_scroll_up_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	32,x
	leau	32,u
	leay	-1,y
	lbne	cg3_scroll_up_lp

;
	clra
	ldb	cg3_scroll_up_lines
	tfr	d,y
	ldd	#0
cg3_scroll_up_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	32,x
	leay	-1,y
	bne	cg3_scroll_up_lp2


cg3_scroll_up_dn
	rts
endfunction





;**********************************************************************************************************************************
function	cg3_scroll_up2	cg3_scroll_up2_page,cg3_scroll_up2_lines
rem	cg3_scroll_up2( page.b, lines.b)
rem	scrolls working page up2 by lines
rem	
rem
	

def	cg3_scroll_up2_page	byte
def	cg3_scroll_up2_lines	byte

cg3_scroll_up2_scrtbl	fdb	4096,7168,10240	;adjusted 16 lines down

stack	x,y,u

cg3_scroll_up2

	ldx	#cg3_scroll_up2_scrtbl
	ldb	cg3_scroll_up2_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	#32
	lda	cg3_scroll_up2_lines
	lbeq	cg3_scroll_up2_dn
	mul
	leau	d,x


	ldb	#80
	subb	cg3_scroll_up2_lines
	clra
	tfr	d,y
cg3_scroll_up2_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	32,x
	leau	32,u
	leay	-1,y
	lbne	cg3_scroll_up2_lp

;
	clra
	ldb	cg3_scroll_up2_lines
	tfr	d,y
	ldd	#0
cg3_scroll_up2_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	32,x
	leay	-1,y
	bne	cg3_scroll_up2_lp2


cg3_scroll_up2_dn
	rts
endfunction





;**********************************************************************************************************************************
function	cg3_scroll_down	cg3_scroll_down_page,cg3_scroll_down_lines
rem	cg3_scroll_down( page.b, lines.b)
rem	scrolls working page down by lines
rem	
rem
	

def	cg3_scroll_down_page	byte
def	cg3_scroll_down_lines	byte


cg3_scroll_down_scrtbl	fdb	3584,6656,9728

stack	x,y,u

cg3_scroll_down


	ldx	#cg3_scroll_down_scrtbl
	ldb	cg3_scroll_down_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready
	leax	3040,x

	leau	,x
	ldb	cg3_scroll_down_lines
	lbeq	cg3_scroll_down_dn

cg3_scroll_down_adj
	leau	-32,u
	decb
	bne	cg3_scroll_down_adj

	ldb	#96
	subb	cg3_scroll_down_lines
	clra
	tfr	d,y
cg3_scroll_down_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	-32,x
	leau	-32,u
	leay	-1,y
	lbne	cg3_scroll_down_lp

;
	clra
	ldb	cg3_scroll_down_lines
	tfr	d,y
	ldd	#0
cg3_scroll_down_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	-32,x
	leay	-1,y
	bne	cg3_scroll_down_lp2
cg3_scroll_down_dn


	rts
endfunction




;**********************************************************************************************************************************
function	cg3_scroll_down2	cg3_scroll_down2_page,cg3_scroll_down2_lines
rem	cg3_scroll_down2( page.b, lines.b)
rem	scrolls working page down2 by lines
rem	
rem
	

def	cg3_scroll_down2_page	byte
def	cg3_scroll_down2_lines	byte


cg3_scroll_down2_scrtbl	fdb	3584,6656,9728


stack	x,y,u

cg3_scroll_down2


	ldx	#cg3_scroll_down2_scrtbl
	ldb	cg3_scroll_down2_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready
	leax	3040,x

	leau	,x
	ldb	cg3_scroll_down2_lines
	lbeq	cg3_scroll_down2_dn

cg3_scroll_down2_adj
	leau	-32,u
	decb
	bne	cg3_scroll_down2_adj

	ldb	#80
	subb	cg3_scroll_down2_lines
	clra
	tfr	d,y
cg3_scroll_down2_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	-32,x
	leau	-32,u
	leay	-1,y
	lbne	cg3_scroll_down2_lp

;
	clra
	ldb	cg3_scroll_down2_lines
	tfr	d,y
	ldd	#0
cg3_scroll_down2_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	-32,x
	leay	-1,y
	bne	cg3_scroll_down2_lp2
cg3_scroll_down2_dn


	rts
endfunction






;**********************************************************************************************************************************
function	cg3_scroll_left	cg3_scroll_left_page,cg3_scroll_left_lines
rem	cg3_scroll_left( page.b, lines.b)
rem	scrolls working page left by lines
rem	
rem
	

def	cg3_scroll_left_page	byte
def	cg3_scroll_left_lines	byte


cg3_scroll_left_scrtbl	fdb	3584,6656,9728


stack	x,y,u

cg3_scroll_left

	ldx	#cg3_scroll_left_scrtbl
	ldb	cg3_scroll_left_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	cg3_scroll_left_lines
	cmpb	#8
	lbeq	cg3_scroll_left_full


	ldb	cg3_scroll_left_lines
	lbeq	cg3_scroll_left_dn

	ldy	#96
cg3_scroll_left_lp1
	andcc	#$fe
	rol	31,x
	rol	30,x
	rol	29,x
	rol	28,x
	rol	27,x
	rol	26,x
	rol	25,x
	rol	24,x
	rol	23,x
	rol	22,x
	rol	21,x
	rol	20,x
	rol	19,x
	rol	18,x
	rol	17,x
	rol	16,x
	rol	15,x
	rol	14,x
	rol	13,x
	rol	12,x
	rol	11,x
	rol	10,x
	rol	9,x
	rol	8,x
	rol	7,x
	rol	6,x
	rol	5,x
	rol	4,x
	rol	3,x
	rol	2,x
	rol	1,x
	rol	0,x
	decb
	bne	cg3_scroll_left_lp1
	leax	32,x
	ldb	cg3_scroll_left_lines
	leay	-1,y
	bne	cg3_scroll_left_lp1


cg3_scroll_left_dn
	rts

cg3_scroll_left_full
	ldy	#96

cg3_scroll_left_fullp
	ldd	1,x
	std	0,x
	ldd	3,x
	std	2,x
	ldd	5,x
	std	4,x
	ldd	7,x
	std	6,x
	ldd	9,x
	std	8,x
	ldd	11,x
	std	10,x
	ldd	13,x
	std	12,x
	ldd	15,x
	std	14,x
	ldd	17,x
	std	16,x
	ldd	19,x
	std	18,x
	ldd	21,x
	std	20,x
	ldd	23,x
	std	22,x
	ldd	25,x
	std	24,x
	ldd	27,x
	std	26,x
	ldd	29,x
	std	28,x
	lda	31,x
	ldb	#0
	std	30,x

	leax	32,x
	leay	-1,y
	lbne	cg3_scroll_left_fullp
	rts

endfunction








;**********************************************************************************************************************************
function	cg3_scroll_left2	cg3_scroll_left2_page,cg3_scroll_left2_lines
rem	cg3_scroll_left2( page.b, lines.b)
rem	scrolls working page left2 by lines
rem	
rem
	

def	cg3_scroll_left2_page	byte
def	cg3_scroll_left2_lines	byte




cg3_scroll_left2_scrtbl	fdb	4096,7168,10240	;adjusted 16 lines down


stack	x,y,u

cg3_scroll_left2

	ldx	#cg3_scroll_left2_scrtbl
	ldb	cg3_scroll_left2_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	cg3_scroll_left2_lines
	cmpb	#8
	lbeq	cg3_scroll_left2_full


	ldb	cg3_scroll_left2_lines
	lbeq	cg3_scroll_left2_dn

	ldy	#80
cg3_scroll_left2_lp1
	andcc	#$fe
	rol	31,x
	rol	30,x
	rol	29,x
	rol	28,x
	rol	27,x
	rol	26,x
	rol	25,x
	rol	24,x
	rol	23,x
	rol	22,x
	rol	21,x
	rol	20,x
	rol	19,x
	rol	18,x
	rol	17,x
	rol	16,x
	rol	15,x
	rol	14,x
	rol	13,x
	rol	12,x
	rol	11,x
	rol	10,x
	rol	9,x
	rol	8,x
	rol	7,x
	rol	6,x
	rol	5,x
	rol	4,x
	rol	3,x
	rol	2,x
	rol	1,x
	rol	0,x
	decb
	bne	cg3_scroll_left2_lp1
	leax	32,x
	ldb	cg3_scroll_left2_lines
	leay	-1,y
	bne	cg3_scroll_left2_lp1


cg3_scroll_left2_dn
	rts

cg3_scroll_left2_full
	ldy	#80

cg3_scroll_left2_fullp
	ldd	1,x
	std	0,x
	ldd	3,x
	std	2,x
	ldd	5,x
	std	4,x
	ldd	7,x
	std	6,x
	ldd	9,x
	std	8,x
	ldd	11,x
	std	10,x
	ldd	13,x
	std	12,x
	ldd	15,x
	std	14,x
	ldd	17,x
	std	16,x
	ldd	19,x
	std	18,x
	ldd	21,x
	std	20,x
	ldd	23,x
	std	22,x
	ldd	25,x
	std	24,x
	ldd	27,x
	std	26,x
	ldd	29,x
	std	28,x
	lda	31,x
	ldb	#0
	std	30,x

	leax	32,x
	leay	-1,y
	lbne	cg3_scroll_left2_fullp
	rts

endfunction








;**********************************************************************************************************************************
function	cg3_scroll_right	cg3_scroll_right_page,cg3_scroll_right_lines
rem	cg3_scroll_right( page.b, lines.b)
rem	scrolls working page right by lines
rem	
rem
	

def	cg3_scroll_right_page	byte
def	cg3_scroll_right_lines	byte


cg3_scroll_right_scrtbl	fdb	3584,6656,9728


stack	x,y,u

cg3_scroll_right

	ldx	#cg3_scroll_right_scrtbl
	ldb	cg3_scroll_right_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	cg3_scroll_right_lines
	cmpb	#8
	lbeq	cg3_scroll_right_full


	ldb	cg3_scroll_right_lines
	lbeq	cg3_scroll_right_dn

	ldy	#96
cg3_scroll_right_lp1
	andcc	#$fe
	ror	0,x
	ror	1,x
	ror	2,x
	ror	3,x
	ror	4,x
	ror	5,x
	ror	6,x
	ror	7,x
	ror	8,x
	ror	9,x
	ror	10,x
	ror	11,x
	ror	12,x
	ror	13,x
	ror	14,x
	ror	15,x
	ror	16,x
	ror	17,x
	ror	18,x
	ror	19,x
	ror	20,x
	ror	21,x
	ror	22,x
	ror	23,x
	ror	24,x
	ror	25,x
	ror	26,x
	ror	27,x
	ror	28,x
	ror	29,x
	ror	30,x
	ror	31,x

	decb
	bne	cg3_scroll_right_lp1
	leax	32,x
	ldb	cg3_scroll_right_lines
	leay	-1,y
	bne	cg3_scroll_right_lp1


cg3_scroll_right_dn
	rts

cg3_scroll_right_full
	ldy	#96

cg3_scroll_right_fullp
	ldd	29,x
	std	30,x
	ldd	27,x
	std	28,x
	ldd	25,x
	std	26,x
	ldd	23,x
	std	24,x
	ldd	21,x
	std	22,x
	ldd	19,x
	std	20,x
	ldd	17,x
	std	18,x
	ldd	15,x
	std	16,x
	ldd	13,x
	std	14,x
	ldd	11,x
	std	12,x
	ldd	9,x
	std	10,x
	ldd	7,x
	std	8,x
	ldd	5,x
	std	6,x
	ldd	3,x
	std	4,x
	ldd	1,x
	std	2,x
	clra
	ldb	0,x
	std	0,x

	leax	32,x
	leay	-1,y
	lbne	cg3_scroll_right_fullp
	rts

endfunction









;**********************************************************************************************************************************
function	cg3_scroll_right2	cg3_scroll_right2_page,cg3_scroll_right2_lines
rem	cg3_scroll_right2( page.b, lines.b)
rem	scrolls working page right2 by lines
rem	
rem
	

def	cg3_scroll_right2_page	byte
def	cg3_scroll_right2_lines	byte


cg3_scroll_right2_scrtbl	fdb	4096,7168,10240	;adjusted 16 lines down


stack	x,y,u

cg3_scroll_right2

	ldx	#cg3_scroll_right2_scrtbl
	ldb	cg3_scroll_right2_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready


	ldb	cg3_scroll_right2_lines
	cmpb	#8
	lbeq	cg3_scroll_right2_full


	ldb	cg3_scroll_right2_lines
	lbeq	cg3_scroll_right2_dn

	ldy	#80
cg3_scroll_right2_lp1
	andcc	#$fe
	ror	0,x
	ror	1,x
	ror	2,x
	ror	3,x
	ror	4,x
	ror	5,x
	ror	6,x
	ror	7,x
	ror	8,x
	ror	9,x
	ror	10,x
	ror	11,x
	ror	12,x
	ror	13,x
	ror	14,x
	ror	15,x
	ror	16,x
	ror	17,x
	ror	18,x
	ror	19,x
	ror	20,x
	ror	21,x
	ror	22,x
	ror	23,x
	ror	24,x
	ror	25,x
	ror	26,x
	ror	27,x
	ror	28,x
	ror	29,x
	ror	30,x
	ror	31,x

	decb
	bne	cg3_scroll_right2_lp1
	leax	32,x
	ldb	cg3_scroll_right2_lines
	leay	-1,y
	bne	cg3_scroll_right2_lp1


cg3_scroll_right2_dn
	rts

cg3_scroll_right2_full
	ldy	#79

cg3_scroll_right2_fullp
	ldd	29,x
	std	30,x
	ldd	27,x
	std	28,x
	ldd	25,x
	std	26,x
	ldd	23,x
	std	24,x
	ldd	21,x
	std	22,x
	ldd	19,x
	std	20,x
	ldd	17,x
	std	18,x
	ldd	15,x
	std	16,x
	ldd	13,x
	std	14,x
	ldd	11,x
	std	12,x
	ldd	9,x
	std	10,x
	ldd	7,x
	std	8,x
	ldd	5,x
	std	6,x
	ldd	3,x
	std	4,x
	ldd	1,x
	std	2,x
	clra
	ldb	0,x
	std	0,x

	leax	32,x
	leay	-1,y
	lbne	cg3_scroll_right2_fullp
	rts

endfunction














;**********************************************************************************************************************************
function	cg3_copypage	cg3_copypage_page,cg3_copypage_topage
rem	cg3_copypage( page.b, to_page.b)
rem	copies page
rem	
rem
	

def	cg3_copypage_page	byte
def	cg3_copypage_topage	byte

cg3_copypage_scrtbl	fdb	3584,6656,9728

stack	x,y,u

cg3_copypage

	ldx	#cg3_copypage_scrtbl
	ldb	cg3_copypage_page
	lda	#2
	mul
	leax	b,x
	ldx	0,x	;screen ready

	ldy	#cg3_copypage_scrtbl
	ldb	cg3_copypage_topage
	lda	#2
	mul
	leay	b,y
	ldy	0,y	;screen ready

	ldu	#0
cg3_copypage_lp

	ldd	0,x
	std	0,y
	ldd	2,x
	std	2,y
	ldd	4,x
	std	4,y
	ldd	6,x
	std	6,y
	ldd	8,x
	std	8,y
	ldd	10,x
	std	10,y
	ldd	12,x
	std	12,y
	ldd	14,x
	std	14,y
	ldd	16,x
	std	16,y
	ldd	18,x
	std	18,y
	ldd	20,x
	std	20,y
	ldd	22,x
	std	22,y
	ldd	24,x
	std	24,y
	ldd	26,x
	std	26,y
	ldd	28,x
	std	28,y
	ldd	30,x
	std	30,y
	leax	32,x
	leay	32,y
	leau	1,u
	cmpu	#96
	lblo	cg3_copypage_lp

	rts
endfunction






;**********************************************************************************************************************************
function	cg3_copypage1	cg3_copypage1_page,cg3_copypage1_topage
rem	cg3_copypage1( page.b, to_page.b)
rem	copies page
rem	
rem
	

def	cg3_copypage1_page	byte
def	cg3_copypage1_topage	byte



cg3_copypage1_scrtbl	fdb	3584,6656,9728

def	cg3_copypage1_cnt	byte


stack	x,y,u

cg3_copypage1

	clr	cg3_copypage1_cnt

	ldx	#cg3_copypage1_scrtbl
	lda	#2
	ldb	cg3_copypage1_topage
	mul
	leax	b,x
	ldx	0,x

	ldu	#cg3_copypage1_scrtbl
	lda	#2
	ldb	cg3_copypage1_page
	mul
	leau	b,u
	ldu	0,u

cg3_copypage1_lp

	pulu	d,y
	std	0,x
	sty	2,x
	pulu	d,y
	std	4,x
	sty	6,x
	pulu	d,y
	std	8,x
	sty	10,x
	pulu	d,y
	std	12,x
	sty	14,x
	pulu	d,y
	std	16,x
	sty	18,x
	pulu	d,y
	std	20,x
	sty	22,x
	pulu	d,y
	std	24,x
	sty	26,x
	pulu	d,y
	std	28,x
	sty	30,x
	pulu	d,y
	std	32,x
	sty	34,x
	pulu	d,y
	std	36,x
	sty	38,x
	pulu	d,y
	std	40,x
	sty	42,x
	pulu	d,y
	std	44,x
	sty	46,x
	pulu	d,y
	std	48,x
	sty	50,x
	pulu	d,y
	std	52,x
	sty	54,x
	pulu	d,y
	std	56,x
	sty	58,x
	pulu	d,y
	std	60,x
	sty	62,x
; 2 lines
	leax	64,x
	inc	cg3_copypage1_cnt
	lda	cg3_copypage1_cnt
	cmpa	#48
	lblo	cg3_copypage1_lp

	rts
endfunction




;**********************************************************************************************************************************
function	cg3_copypage2	cg3_copypage2_page,cg3_copypage2_topage
rem	cg3_copypage2( page.b, to_page.b)
rem	copies page
rem	leaves a border after first 16 lines
rem
	

def	cg3_copypage2_page	byte
def	cg3_copypage2_topage	byte



cg3_copypage2_scrtbl	fdb	3584,6656,9728

def	cg3_copypage2_cnt	byte


stack	x,y,u

cg3_copypage2

	clr	cg3_copypage2_cnt

	ldx	#cg3_copypage2_scrtbl
	lda	#2
	ldb	cg3_copypage2_topage
	mul
	leax	b,x
	ldx	0,x

	ldu	#cg3_copypage2_scrtbl
	lda	#2
	ldb	cg3_copypage2_page
	mul
	leau	b,u
	ldu	0,u

cg3_copypage2_lp

	pulu	d,y
	std	0,x
	sty	2,x
	pulu	d,y
	std	4,x
	sty	6,x
	pulu	d,y
	std	8,x
	sty	10,x
	pulu	d,y
	std	12,x
	sty	14,x
	pulu	d,y
	std	16,x
	sty	18,x
	pulu	d,y
	std	20,x
	sty	22,x
	pulu	d,y
	std	24,x
	sty	26,x
	pulu	d,y
	std	28,x
	sty	30,x
	pulu	d,y
	std	32,x
	sty	34,x
	pulu	d,y
	std	36,x
	sty	38,x
	pulu	d,y
	std	40,x
	sty	42,x
	pulu	d,y
	std	44,x
	sty	46,x
	pulu	d,y
	std	48,x
	sty	50,x
	pulu	d,y
	std	52,x
	sty	54,x
	pulu	d,y
	std	56,x
	sty	58,x
	pulu	d,y
	std	60,x
	sty	62,x
; 2 lines
	leax	64,x
	inc	cg3_copypage2_cnt
	lda	cg3_copypage2_cnt
	cmpa	#8	;next 40
	lblo	cg3_copypage2_lp
;skip 4 lines
	ldd	#128
	leax	d,x
	leau	d,u

cg3_copypage2_lp2

	pulu	d,y
	stb	1,x	;skip border
	sty	2,x
	pulu	d,y
	std	4,x
	sty	6,x
	pulu	d,y
	std	8,x
	sty	10,x
	pulu	d,y
	std	12,x
	sty	14,x
	pulu	d,y
	std	16,x
	sty	18,x
	pulu	d,y
	std	20,x
	sty	22,x
	pulu	d,y
	std	24,x
	sty	26,x
	pulu	d
	std	28,x
	pulu	d
	sta	30,x	;skip border

	pulu	d,y
	stb	33,x
	sty	34,x
	pulu	d,y
	std	36,x
	sty	38,x
	pulu	d,y
	std	40,x
	sty	42,x
	pulu	d,y
	std	44,x
	sty	46,x
	pulu	d,y
	std	48,x
	sty	50,x
	pulu	d,y
	std	52,x
	sty	54,x
	pulu	d,y
	std	56,x
	sty	58,x
	pulu	d
	std	60,x
	pulu	d
	sta	62,x	;skip border
; 2 lines
	leax	64,x
	inc	cg3_copypage2_cnt
	lda	cg3_copypage2_cnt
	cmpa	#44	;next 36 and leave last 8 pixels
	lblo	cg3_copypage2_lp2

	rts
endfunction





