#dontinclude
; include file
; universal joystick 1 player code


function	joystick
rem	joystick()
rem	
rem	once a button is pressed a joystick will be assigned
rem	y = $15a x = $15b device = $15c buttons = $15d

joystick_xp	equ	$15b
joystick_yp	equ	$15a
joystick_btn	equ	$15d
joystick_dev	equ	$15c

def	joystick_ystate	byte
def	joystick_xstate	byte
def	joystick_dump	string	8
def	joystick_cc3	byte

def	joystick_firea	byte
def	joystick_fireb	byte


joystick_chk	fcb	254,253,251,247,239,223,191,127

stack	x,y,u

joystick






	if	b,joystick_dev<#128	b,joystick>#132
	lda	#128
	sta	joystick_dev
	lda	#32
	sta	$15a
	sta	$15b
	lda	#15
	sta	$15d


	clr	joystick_cc3
	ldd	$fffe	;check if coco3
	addd	$ffff
	cmpa	#167
	bne	joystick_nocc3
	ldb	#1
	stb	joystick_cc3
joystick_nocc3



	endif

;buttons first
	clr	joystick_btn
	ldy	#joystick_dump
	ldx	#joystick_chk

	ldb	#7
joystick_loop1
	lda	b,x
	sta	$ff02	;load it to pia
	lda	$ff00	;read it back
	anda	#15
	sta	b,y
	decb
	bpl	joystick_loop1	;branch till negative

	lda	0,y
	cmpa	1,y
	bne	joystick_nobuttons
	cmpa	2,y
	bne	joystick_nobuttons
	cmpa	3,y
	bne	joystick_nobuttons
	cmpa	4,y
	bne	joystick_nobuttons
	cmpa	5,y
	bne	joystick_nobuttons
	cmpa	6,y
	bne	joystick_nobuttons
	cmpa	7,y
	bne	joystick_nobuttons
	sta	joystick_btn
	bra	joystick_axis

joystick_nobuttons
	lda	#15
	sta	joystick_btn

joystick_axis

; what joystick are we working with?
	lda	joystick_dev
	anda	#3
	cmpa	#1
	beq	joystick_rightchk
	cmpa	#2
	beq	joystick_leftchk
; ok at this point we dont know
; lets look at buttons
	if	x,#1!joystick_btn
	lda	#129	;right joystick
	sta	joystick_dev
	endif
	if	x,#2!joystick_btn
	lda	#130	;left joystick
	sta	joystick_dev
	endif


joystick_leftchk
; y axis
	lda	$ff03
	anda	#247
	adda	#8
	sta	$ff03
	lda	$ff01
	anda	#247
	adda	#8
	sta	$ff01
	clrb

joystick_check_y
	stb	$ff20
	lda	$ff00	;check voltage
	bpl	joystick_check_ylp
	addb	#$04
	cmpb	#$fc
	bne	joystick_check_y
joystick_check_ylp
	stb	joystick_ystate
	lsrb
	lsrb
	stb	joystick_yp
; x axis
	lda	$ff03
	anda	#247
	adda	#8
	sta	$ff03
	lda	$ff01
	anda	#247
;	adda	#8	cleared mux bit
	sta	$ff01
	clrb

joystick_check_x
	stb	$ff20
	lda	$ff00	;check voltage
	bpl	joystick_check_xlp
	addb	#$04
	cmpb	#$fc
	bne	joystick_check_x
joystick_check_xlp
	stb	joystick_xstate
	lsrb
	lsrb
	stb	joystick_xp

	lbra	joystick_buttons



joystick_rightchk
; y axis
	lda	$ff03
	anda	#247
;	adda	#8
	sta	$ff03
	lda	$ff01
	anda	#247
	adda	#8
	sta	$ff01
	clrb

joystick_check_y1
	stb	$ff20
	lda	$ff00	;check voltage
	bpl	joystick_check_ylp1
	addb	#$04
	cmpb	#$fc
	bne	joystick_check_y1
joystick_check_ylp1
	stb	joystick_ystate
	lsrb
	lsrb
	stb	joystick_yp
; x axis
	lda	$ff03
	anda	#247
;	adda	#8
	sta	$ff03
	lda	$ff01
	anda	#247
;	adda	#8	cleared mux bit
	sta	$ff01
	clrb

joystick_check_x1
	stb	$ff20
	lda	$ff00	;check voltage
	bpl	joystick_check_xlp1
	addb	#$04
	cmpb	#$fc
	bne	joystick_check_x1
joystick_check_xlp1
	stb	joystick_xstate
	lsrb
	lsrb
	stb	joystick_xp

joystick_buttons
	if	b,joystick_cc3=#0
	lda	joystick_btn
	anda	#3
	sta	joystick_btn
	sta	$15d
	rts
	endif
; its an actual cc3 with 2 button support
	if	b,joystick_dev=#130	;left
	lda	joystick_btn
	lsra
	lsra
	lsra
	anda	#1
	sta	joystick_fireb
	lda	joystick_btn
	lsra
	anda	#1
	sta	joystick_firea
; ok kill others
	lda	joystick_fireb
	lsla
	adda	joystick_firea
	sta	joystick_btn
	sta	$15d
	endif

	if	b,joystick_dev=#129	;right
	lda	joystick_btn
	lsra
	lsra
	anda	#1
	sta	joystick_fireb
	lda	joystick_btn
	anda	#1
	sta	joystick_firea
; ok kill others
	lda	joystick_fireb
	lsla
	adda	joystick_firea
	sta	joystick_btn
	sta	$15d
	endif

	rts



endfunction




