#dontinclude
; main libraries for tandy for sg4 mode mainly and input
; 
; now has pages

;*********************************************************************************************************************************************************************************
;
;*********************************************************************************************************************************************************************************
function	sg4_setdisplay
rem	sg4_setdisplay()
rem	sets the screen up at 1024 for regular sg4 viewing also coded as page 0
rem	
rem	

stack	x

sg4_setdisplay

;setup memory to 1024
	clra
	ldx	#65478
	sta	0,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
; set sg4 mode
	ldx	#65472
	sta	,x
	sta	2,x
	sta	4,x
; vdg cc3 extra
	ldx	#65314
	sta	,x
	ldx	#65436
	lda	#15
	sta	,x

	rts
endfunction


;*********************************************************************************************************************************************************************************
;
;*********************************************************************************************************************************************************************************
function	sg4_nosync	sg4_nosync_page
rem	sg4_nosync( page.b )
rem	changes screen page without waiting for vsync
rem	
rem	pages 0,1,2

def	sg4_nosync_page	byte


stack	x

sg4_nosync

	if	b,sg4_nosync_page=#0
;setup memory to 1024 set value 2
	clra
	ldx	#65478
	sta	0,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	if	b,sg4_nosync_page=#1
;setup memory to 3584 should be 7
	clra
	ldx	#65478
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	if	b,sg4_nosync_page=#2
;setup memory to 4096 should be 8
	clra
	ldx	#65478
	sta	0,x
	sta	2,x
	sta	4,x
	sta	7,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	rts
endfunction



;*********************************************************************************************************************************************************************************
;
;*********************************************************************************************************************************************************************************
function	sg4_sync	sg4_sync_page
rem	sg4_sync( page.b )
rem	changes screen page waiting for vsync
rem	
rem	pages 0,1,2

def	sg4_sync_page	byte


stack	x

sg4_sync

;wait for vsync
sg4_syncs
	lda	$ff03
	bpl	sg4_syncs

	if	b,sg4_sync_page=#0
;setup memory to 1024 set value 2
	clra
	ldx	#65478
	sta	0,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	if	b,sg4_sync_page=#1
;setup memory to 3584 should be 7
	clra
	ldx	#65478
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	if	b,sg4_sync_page=#2
;setup memory to 4096 should be 8
	clra
	ldx	#65478
	sta	0,x
	sta	2,x
	sta	4,x
	sta	7,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif

	rts
endfunction




;********************************************************************************************************************************************************************************************
;* cls(page , color) 0-8 semi graphics default mode
;********************************************************************************************************************************************************************************************
function	cls	cls_page,cls_cc
def	cls_page	byte
def	cls_cc	byte

rem	cls( page.b , color.b)
rem	page 0,1,2 
rem	color number from 0 to 8.
rem	
stack	x,y

cls_c0
	fcb	128	;black
	fcb	143	;green
	fcb	159	;yellow
	fcb	175	;blue
	fcb	191	;red
	fcb	207	;white
	fcb	223	;cyan
	fcb	239	;megenta
	fcb	255	;orange
cls

	if	b,cls_cc=>#8
	ldb	#8
	stb	cls_cc
	endif

	if	b,cls_page=#0
	ldy	#1024
	ldx	#cls_c0
	ldb	cls_cc
	abx
	ldb	,x
	lda	,x
cls_lp1
	std	,y++
	cmpy	#1536
	blo	cls_lp1
	endif

	if	b,cls_page=#1
	ldy	#3584
	ldx	#cls_c0
	ldb	cls_cc
	abx
	ldb	,x
	lda	,x
cls_lp2
	std	,y++
	cmpy	#4096
	blo	cls_lp2
	endif

	if	b,cls_page=>#2
	ldy	#4096
	ldx	#cls_c0
	ldb	cls_cc
	abx
	ldb	,x
	lda	,x
cls_lp3
	std	,y++
	cmpy	#4608
	blo	cls_lp3
	endif


	rts
endfunction













;********************************************************************************************************************************************************************************************
;* cls_ray(page , color , subtract) 0-8 semi graphics default mode
;********************************************************************************************************************************************************************************************
function	cls_ray	cls_ray_page,cls_ray_cc,cls_ray_cc2,cls_ray_sub
def	cls_ray_page	byte
def	cls_ray_cc	byte
def	cls_ray_cc2	byte
def	cls_ray_sub	byte

rem	cls_ray( page.b , color1.b , color2.b , sub.b )
rem	page 0,1,2 
rem	color number from 0 to 8.
rem	
stack	x,y

cls_ray_c0
	fcb	128	;black
	fcb	143	;green
	fcb	159	;yellow
	fcb	175	;blue
	fcb	191	;red
	fcb	207	;white
	fcb	223	;cyan
	fcb	239	;megenta
	fcb	255	;orange
	fcb	128	;black
cls_ray

	if	b,cls_ray_cc=>#9
	ldb	#9
	stb	cls_ray_cc
	endif
	if	b,cls_ray_cc2=>#9
	ldb	#9
	stb	cls_ray_cc2
	endif

	if	b,cls_ray_page=#0
	ldy	#1024
	ldx	#cls_ray_c0
	ldb	cls_ray_cc
	abx
	ldb	,x
	lda	,x
cls_ray_lp1
	std	,y++
	cmpy	#1248
	blo	cls_ray_lp1
	ldx	#cls_ray_c0
	ldb	cls_ray_cc2
	abx
	ldb	,x
	subb	cls_ray_sub
	lda	,x
	suba	cls_ray_sub
cls_ray_lp11
	std	,y++
	cmpy	#1536
	blo	cls_ray_lp11
	rts
	endif

	if	b,cls_ray_page=#1
	ldy	#3584
	ldx	#cls_ray_c0
	ldb	cls_ray_cc
	abx
	ldb	,x
	lda	,x
cls_ray_lp2
	std	,y++
	cmpy	#3808
	blo	cls_ray_lp2

	ldx	#cls_ray_c0
	ldb	cls_ray_cc2
	abx
	ldb	,x
	lda	,x
	subb	cls_ray_sub
	suba	cls_ray_sub
cls_ray_lp22
	std	,y++
	cmpy	#4096
	blo	cls_ray_lp22
	rts
	endif

	if	b,cls_ray_page=>#2
	ldy	#4096
	ldx	#cls_ray_c0
	ldb	cls_ray_cc
	abx
	ldb	,x
	lda	,x
cls_ray_lp3
	std	,y++
	cmpy	#4320
	blo	cls_ray_lp3

	ldx	#cls_ray_c0
	ldb	cls_ray_cc2
	abx
	ldb	,x
	lda	,x
	subb	cls_ray_sub
	suba	cls_ray_sub
cls_ray_lp33
	std	,y++
	cmpy	#4608
	blo	cls_ray_lp33


	endif


	rts
endfunction
































;********************************************************************************************************************************************************************************************
;* fast_hline2(page , posx, posy1, posy2 ,color) 0-8 semi graphics default mode
;********************************************************************************************************************************************************************************************
function	fast_hline2	fast_hline2_page,fast_hline2_x,fast_hline2_y1,fast_hline2_y2,fast_hline2_cc
def	fast_hline2_page	byte
def	fast_hline2_cc	byte
def	fast_hline2_x	byte
def	fast_hline2_y1	byte
def	fast_hline2_y2	byte


rem	fast_hline2( page.b , color.b)
rem	page 0,1,2 
rem	color number from 0 to 8.
rem	
stack	x,y

fast_hline2_c0

	fcb	128	;black
	fcb	143	;green
	fcb	159	;yellow
	fcb	175	;blue
	fcb	191	;red
	fcb	207	;white
	fcb	223	;cyan
	fcb	239	;megenta
	fcb	255	;orange
	fcb	128	;black
fast_hline2
	lda	fast_hline2_x
	lsra
	sta	fast_hline2_x
	lda	fast_hline2_y1
	lsra
	sta	fast_hline2_y1
	lda	fast_hline2_y2
	lsra
	sta	fast_hline2_y2


	if	b,fast_hline2_cc=>#9
	ldb	#9
	stb	fast_hline2_cc
	endif
;3584,4096
	if	b,fast_hline2_page=#0
	ldy	#1024
	endif
	if	b,fast_hline2_page=#1
	ldy	#3584
	endif
	if	b,fast_hline2_page=>#2
	ldy	#4096
	endif

	lda	#32
	ldb	fast_hline2_y1
	mul
	leay	d,y
	ldb	fast_hline2_x
	leay	b,y	;ready
	ldx	#fast_hline2_c0
	ldb	fast_hline2_cc
	abx

fast_hline2_lp1
;	ldb	,x
	lda	,x
	sta	,y
	leay	32,y
	inc	fast_hline2_y1
	lda	fast_hline2_y1
	cmpa	fast_hline2_y2
	blo	fast_hline2_lp1

	rts


endfunction






;**************************************************************************************
;* coco3()
;**************************************************************************************
function	iscoco3	
rem	iscoco3()
rem	returns value of 1 to b register
rem
iscoco3
	ldd	$fffe	;check if coco3
	addd	$ffff
	cmpa	#167
	beq	iscoco3_setupcc3
	clrb
	rts
iscoco3_setupcc3
	ldb	#1
	rts
endfunction


;**************************************************************************************
;* inkeystring
;**************************************************************************************
function	inkeystring	
rem	inkeystring()
rem	returns keypress value into a register...  =0 if nothing pressed
rem	uses basic rom location $A000
rem	(trying not to use) use keystring()

stack	x,y,u

inkeystring
	jsr	[$a000]
	rts
endfunction



;
; *************************************************************************************************************************************************************************************
; *  createsinetable()
; *************************************************************************************************************************************************************************************
function	createsinetable
rem	createsinetable() creates and returns sine table location to d
rem	this table is needed for rotational graphics such as circle
rem	

createsinetable_tbl


	fcb	128,131,134,137,140,144,147,150,153,156,159,162,165,168,171,174
	fcb	177,179,182,185,188,191,193,196,199,201,204,206,209,211,213,216
	fcb	218,220,222,224,226,228,230,232,234,235,237,239,240,241,243,244
	fcb	245,246,248,249,250,250,251,252,253,253,254,254,254,254,254,254
	fcb	254,254,254,254,254,254,254,253,253,252,251,250,250,249,248,246
	fcb	245,244,243,241,240,239,237,235,234,232,230,228,226,224,222,220
	fcb	218,216,213,211,209,206,204,201,199,196,193,191,188,185,182,179
	fcb	177,174,171,168,165,162,159,156,153,150,147,144,140,137,134,131
	fcb	128,125,122,119,116,112,109,106,103,100,97,94,91,88,85,82
	fcb	79,77,74,71,68,65,63,60,57,55,52,50,47,45,43,40
	fcb	38,36,34,32,30,28,26,24,22,21,19,17,16,15,13,12
	fcb	11,10,8,7,6,6,5,4,3,3,2,2,2,1,1,1
	fcb	1,1,1,1,2,2,2,3,3,4,5,6,6,7,8,10
	fcb	11,12,13,15,16,17,19,21,22,24,26,28,30,32,34,36
	fcb	38,40,43,45,47,50,52,55,57,60,63,65,68,71,74,77
	fcb	79,82,85,88,91,94,97,100,103,106,109,112,116,119,122,125

createsinetable

	ldd	#createsinetable_tbl

	rts

endfunction







;
; *******************************************************************************************************************
; * tanjoystick()
; *******************************************************************************************************************
function	tanjoystick
rem	tanjoystick() returns angle from joystick
rem	returns angle to b register 0-255
rem	
rem	

tanjoystick_table
	fcb	160,154,147,139,128,117,109,102,096	;0
	fcb	166,160,152,141,128,115,104,096,090	;1
	fcb	173,168,160,144,128,112,096,088,083	;2
	fcb	182,179,176,000,000,000,080,077,074	;3
;	fcb	192,192,192,000,000,000,064,064,064	;4
	fcb	202,205,208,000,000,000,048,051,054	;5
	fcb	211,216,224,240,255,016,032,040,045	;6
	fcb	218,224,232,243,255,013,024,032,038	;7
	fcb	224,230,237,246,255,010,019,026,032	;8



tanjoystick

	lda	$015a
	lsra
	lsra
	lsra


	ldx	#tanjoystick_table
	ldb	#8
	mul
	leax	d,x

	ldb	$015b
	lsrb
	lsrb
	lsrb

	ldb	b,x

	rts
endfunction









; **********************************************************************************************************************
; * plot(sin_costable,x1,y1,dx,dy,angle)
; * 
; **********************************************************************************************************************
function	plot	plot_sintb1,plot_plotx,plot_ploty,plot_radx,plot_rady,plot_angle
rem	plot(sintblpointer.w,x1.b,y1.b,diamx.b,diamy.b,angle.b)
rem	max rad 34 circle angle 0-255 as percentage of 360
rem	
rem	returns x,y on a,b

def	plot_sintb1	word
def	plot_angle	byte
def	plot_plotx	byte
def	plot_ploty	byte
def	plot_radx	byte
def	plot_rady	byte
def	plot_x1	byte
def	plot_y1	byte

stack	x

plot
	clra
	ldx	plot_sintb1
	ldb	plot_angle
	abx
	ldb	,x
	lda	plot_radx
	mul
	aslb
	rola
	suba	plot_radx
	adda	plot_plotx
	sta	plot_x1

	if	b,plot_x1<plot_plotx
	inc	plot_x1
	endif

;cos
	ldx	plot_sintb1
	ldb	plot_angle
	addb	#64
	abx
	ldb	,x
	lda	plot_rady
	mul
	aslb
	rola
	suba	plot_rady
	adda	plot_ploty
	sta	plot_y1
	if	b,plot_y1<plot_ploty
	inc	plot_y1
	endif


	ldd	plot_x1
	rts
endfunction



; ***************************************************************************************************************************************************************************************************
; * rnd(x,y)
; ***************************************************************************************************************************************************************************************************
function	rnd	rnd_lowv,rnd_highv
rem	rnd(low range, high range) value is from range 0-254 and low cannot be higher then high range
rem	Returns result to b register
rem	
rem	

def	rnd_rndr	byte
def	rnd_lowv	byte
def	rnd_highv	byte
def	rnd_stepr	byte
def	rnd_res	byte
def	rnd_subt	byte

rnd

	ldb	rnd_highv
	incb
	stb	rnd_highv
	subb	rnd_lowv
	stb	rnd_rndr
	dec	rnd_highv
rnd15
	ldb	$113
	addb	rnd_stepr
	stb	rnd_res
;now i should have 0-15 in the bit bucket
;wrap it
;	LSLB
	stb	rnd_stepr
rnd_rndl15
	cmpb	rnd_rndr
	bls	rnd_rndr15
	subb	rnd_rndr
	bra	rnd_rndl15
rnd_rndr15
	addb	rnd_lowv
rnd_rnx15
	cmpb	rnd_highv
	bls	rnd_rny15
	inc	rnd_stepr
	ldb	rnd_lowv
rnd_rny15
	stb	rnd_res
	rts
endfunction


;
;**************************************************************************************
;* print(page,caps on,pos,string) 
;**************************************************************************************
function	print	print_page,print_cap,print_cc,print_x
rem	print( page.b , capson.b , position.w, string.w)
rem	page 0,1,2   c=0 or 1 for starting in caps mode. pos=0-511 for screen position.
rem	
rem	

def	print_page	byte
def	print_cap	byte	;start in caps mode or not?
def	print_cc	word	;its 2 bytes print position
def	print_x	word	;populate x register with string at x
def	print_end	word

stack	x,y

print
	ldx	print_x
	ldd	print_cc	;check if out of bounds
	cmpd	#511
	bls	print_lp0
	ldd	#511
	std	print_cc
print_lp0

	if	b,print_page=#0
	ldd	#1024	; x=has string  y is screen
	addd	print_cc
	tfr	d,y	;y is set
	addd	#512
	std	print_end
	endif

	if	b,print_page=#1
	ldd	#3584	; x=has string  y is screen
	addd	print_cc
	tfr	d,y	;y is set
	addd	#512
	std	print_end
	endif

	if	b,print_page=>#2
	ldd	#4096	; x=has string  y is screen
	addd	print_cc
	tfr	d,y	;y is set
	addd	#512
	std	print_end
	endif


	ldb	print_cap	;load b with caps flag
print_lp1
	lda	,x+
;process this ascii code
	cmpa	#97
	blo	print_lp2
	clrb
	stb	print_cap
;assume lowercase
	suba	#96
print_lp2
	cmpa	#65
	blo	print_lp3
	cmpa	#90
	bhi	print_lp3
	ldb	#1
	stb	print_cap
print_lp3	
	cmpa	#32
	bne	print_lp4
	cmpb	#1	;is cap on
	bne	print_lp4
	adda	#64	;fix green space
;lets look at numbers
print_lp4
	cmpa	#33
	blo	print_lp5
	cmpa	#63
	bhi	print_lp5
;its a number
	cmpb	#1
	bne	print_lp5
;change number to cap
	adda	#64
print_lp5
	sta	,y+
	cmpy	print_end
	bhs	print_lp6
	lda	,x
	cmpa	#0
	bne	print_lp1
print_lp6
	rts	;return
endfunction



;
; **********************************************************************************************************************************************************************************************
; * wordstring(word address,return string address)
; **********************************************************************************************************************************************************************************************
; convert number to string
; put numbers in for string add
; 
function	wordstring	wordstring_num,wordstring_ret
rem	wordstring( word.w , address.w) 
rem	word is a value or 0-65535 and needs a return address to populate string. 6 BYTES REQUIRED
rem	
rem	

def	wordstring_num	word
def	wordstring_ret	word




wordstring_data

	fcb	3,2,7,6,8
	fcb	1,6,3,8,4
	fcb	0,8,1,9,2
	fcb	0,4,0,9,6
	fcb	0,2,0,4,8
	fcb	0,1,0,2,4
	fcb	0,0,5,1,2
	fcb	0,0,2,5,6
wordstring_data2
	fcb	0,0,1,2,8
	fcb	0,0,0,6,4
	fcb	0,0,0,3,2
	fcb	0,0,0,1,6
	fcb	0,0,0,0,8
	fcb	0,0,0,0,4
	fcb	0,0,0,0,2
	fcb	0,0,0,0,1

stack	x,y,u

wordstring

	ldy	#wordstring_num	;has word
	ldx	#wordstring_data	;counters
	ldu	wordstring_ret	;six byte string

; clear 6 bytes

	clr	0,u
	clr	1,u
	clr	2,u
	clr	3,u
	clr	4,u
	clr	5,u

; start counting

	lda	,y
	lbeq	wordstring_cc8	;skip first byte
; hack
	bita	#128
	beq	wordstring_cc1
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc1

	leax	5,x
	lda	,y
	bita	#64
	beq	wordstring_cc2
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc2

	leax	5,x
	lda	,y
	bita	#32
	beq	wordstring_cc3
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc3

	leax	5,x
	lda	,y
	bita	#16
	beq	wordstring_cc4
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc4

	leax	5,x
	lda	,y
	bita	#8
	beq	wordstring_cc5
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc5

	leax	5,x
	lda	,y
	bita	#4
	beq	wordstring_cc6
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc6

	leax	5,x
	lda	,y
	bita	#2
	beq	wordstring_cc7
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc7

	leax	5,x
	lda	,y
	bita	#1
	beq	wordstring_cc8
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc8

	leay	1,y

	ldx	#wordstring_data2

	lda	,y
	bita	#128
	beq	wordstring_cc9
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc9

	leax	5,x
	lda	,y
	bita	#64
	beq	wordstring_cc10
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc10

	leax	5,x
	lda	,y
	bita	#32
	beq	wordstring_cc11
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc11

	leax	5,x
	lda	,y
	bita	#16
	beq	wordstring_cc12
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc12

	leax	5,x
	lda	,y
	bita	#8
	beq	wordstring_cc13
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc13

	leax	5,x
	lda	,y
	bita	#4
	beq	wordstring_cc14
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc14

	leax	5,x
	lda	,y
	bita	#2
	beq	wordstring_cc15
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc15

	leax	5,x
	lda	,y
	bita	#1
	beq	wordstring_cc16
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u
	ldb	3,x
	addb	3,u
	stb	3,u
	ldb	4,x
	addb	4,u
	stb	4,u

wordstring_cc16

; ok lets add some values together

	clrb
	lda	4,u

wordstring_ccs1

	cmpa	#9
	bls	wordstring_cs1
	incb
	suba	#10
	bra	wordstring_ccs1


wordstring_cs1

	sta	4,u
	addb	3,u
	tfr	b,a
	clrb


wordstring_ccs2

	cmpa	#9
	bls	wordstring_cs2
	incb
	suba	#10
	bra	wordstring_ccs2


wordstring_cs2

	sta	3,u
	addb	2,u
	tfr	b,a
	clrb





wordstring_ccs3

	cmpa	#9
	bls	wordstring_cs3
	incb
	suba	#10
	bra	wordstring_ccs3


wordstring_cs3

	sta	2,u
	addb	1,u
	tfr	b,a
	clrb




wordstring_ccs4

	cmpa	#9
	bls	wordstring_cs4
	incb
	suba	#10
	bra	wordstring_ccs4

wordstring_cs4

	sta	1,u
	addb	0,u
	stb	0,u
	clrb


; lets add $30 to each

	lda	#$30
	adda	0,u
	sta	0,u

	lda	#$30
	adda	1,u
	sta	1,u

	lda	#$30
	adda	2,u
	sta	2,u

	lda	#$30
	adda	3,u
	sta	3,u

	lda	#$30
	adda	4,u
	sta	4,u

; now get rid of extra 0rs
	lda	#0
	sta	5,u
	rts

;hack

	ldx	wordstring_ret
	ldu	wordstring_ret
	ldb	#4
wordstring_lpp
	lda	,u
	cmpa	#48
	beq	wordstring_drop0
	rts
wordstring_drop0
	lda	1,u
	sta	0,x
	lda	2,u
	sta	1,x
	lda	3,u
	sta	2,x
	lda	4,u
	sta	3,x
	lda	5,u
	sta	4,x
	lda	6,u
	sta	5,x

	decb
	bne	wordstring_lpp

	rts

endfunction



;
; **********************************************************************************************************************************************************************************************
; * bytestring(byte,return string address)
; **********************************************************************************************************************************************************************************************
; convert number to string
; put numbers in for string add
; 
function	bytestring	bytestring_num,bytestring_ret
rem	bytestring(byte.b , address.w)
rem	word is a value or 0-255 and needs a return address to populate string. 4 BYTES REQUIRED
rem	
rem	

def	bytestring_num	byte
def	bytestring_ret	word





bytestring_data
	fcb	1,2,8
	fcb	0,6,4
	fcb	0,3,2
	fcb	0,1,6
	fcb	0,0,8
	fcb	0,0,4
	fcb	0,0,2
	fcb	0,0,1


stack	x,y,u

bytestring

	ldx	#bytestring_data	;counters
	ldu	bytestring_ret	;4 byte string

; clear 4 bytes

	clr	0,u
	clr	1,u
	clr	2,u
	clr	3,u

; start counting

	lda	bytestring_num

	bita	#128
	beq	bytestring_cc1
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc1

	leax	3,x
	bita	#64
	beq	bytestring_cc2
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc2

	leax	3,x
	bita	#32
	beq	bytestring_cc3
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc3

	leax	3,x
	bita	#16
	beq	bytestring_cc4
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc4

	leax	3,x
	bita	#8
	beq	bytestring_cc5
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc5

	leax	3,x
	bita	#4
	beq	bytestring_cc6
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc6

	leax	3,x
	bita	#2
	beq	bytestring_cc7
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u

bytestring_cc7

	leax	3,x
	bita	#1
	beq	bytestring_cc16
	ldb	0,x
	addb	0,u
	stb	0,u
	ldb	1,x
	addb	1,u
	stb	1,u
	ldb	2,x
	addb	2,u
	stb	2,u



bytestring_cc16

; ok lets add some values together

	clrb
	lda	2,u





bytestring_ccs3

	cmpa	#9
	bls	bytestring_cs3
	incb
	suba	#10
	bra	bytestring_ccs3


bytestring_cs3

	sta	2,u
	addb	1,u
	tfr	b,a
	clrb




bytestring_ccs4

	cmpa	#9
	bls	bytestring_cs4
	incb
	suba	#10
	bra	bytestring_ccs4

bytestring_cs4

	sta	1,u
	addb	0,u
	stb	0,u
	clrb


; lets add $30 to each

	lda	#$30
	adda	0,u
	sta	0,u

	lda	#$30
	adda	1,u
	sta	1,u

	lda	#$30
	adda	2,u
	sta	2,u


; now get rid of extra 0rs

;	ldx	bytestring_ret
;	ldu	bytestring_ret
;	ldb	#2
;bytestring_lpp
;	lda	,u
;	cmpa	#48
;	beq	bytestring_drop0
;	lda	#0
;	sta	3,u
;	rts
;bytestring_drop0
;	lda	1,u
;	sta	0,x
;	lda	2,u
;	sta	1,x
;	lda	3,u
;	sta	2,x
;	lda	#32
;	sta	3,x
;
;	decb
;	bne	bytestring_lpp

	rts

endfunction


; 
;
; *************************************************************************************
; * binstring(byte address,retstring adr)
; *************************************************************************************
; convert number to string
; put numbers in for string add
; 
function	binstring	binstring_numsta,binstring_x
rem	binstring(byte,return string) 
rem	byte is a value of 0-255 and needs a return address to populate string. 9 BYTES REQUIRED
rem	Does not push to stack and uses A,B,X,Y
rem	
	
def	binstring_x	word	;populate x register with string at x
def	binstring_numsta	byte	;save 

stack	x,y,u

binstring
	ldx	binstring_x
	ldb	#48
	lda	binstring_numsta
	bita	#128
	beq	binstring_checkbit7
	incb
binstring_checkbit7
	stb	,x+
	ldb	#48
	bita	#64
	beq	binstring_checkbit6
	incb
binstring_checkbit6
	stb	,x+
	ldb	#48
	bita	#32
	beq	binstring_checkbit5
	incb
binstring_checkbit5
	stb	,x+
	ldb	#48
	bita	#16
	beq	binstring_checkbit4
	incb
binstring_checkbit4
	stb	,x+
	ldb	#48
	bita	#8
	beq	binstring_checkbit3
	incb
binstring_checkbit3
	stb	,x+
	ldb	#48
	bita	#4
	beq	binstring_checkbit2
	incb
binstring_checkbit2
	stb	,x+
	ldb	#48
	bita	#2
	beq	binstring_checkbit1
	incb
binstring_checkbit1
	stb	,x+
	ldb	#48
	bita	#1
	beq	binstring_checkbit0
	incb
binstring_checkbit0
	stb	,x+
	clr	,x
	rts	;return from subroutine with a register restored

endfunction
; 





; **********************************************************************************************************************************************************************************************
; * circle
;
function	circle	circle_page,circle_x,circle_plotx,circle_ploty,circle_radx,circle_rady,circle_angle,circle_dist,circle_setcol
rem	circle( page.b , sinetable.w, x1.b , y1.b , diamx.b, diamy.b, angle.b, dist.b, color.b) 
rem	page 0,1,2 max rad 34 dist=0-255 full circle angle 0-255 as percentage of 360
rem	
rem	

def	circle_page	byte
def	circle_x	word
def	circle_angle	byte
def	circle_dist	byte
def	circle_plotx	byte
def	circle_ploty	byte
def	circle_radx	byte
def	circle_rady	byte
def	circle_setcol	byte
def	circle_xrow	byte	;0
def	circle_yrow	byte	;0
def	circle_bit1	byte	;0
def	circle_bit2	byte	;0
def	circle_bit3	byte	;0
def	circle_bit4	byte	;0
def	circle_draw	byte	;0
def	circle_orchr	byte	;0
def	circle_wcol	byte	;0
def	circle_coltmp	byte	;0
def	circle_odd	byte	;0
def	circle_mcol	byte	;4
def	circle_cnt	byte	;0 counter from 0-255 to make circle
def	circle_calcx	byte	;0
def	circle_calcy	byte	;0
def	circle_sintb1	word
def	circle_costb1	word
def	circle_stepp	byte

stack	x,y,u

circle_color0

	fcb	128
	fcb	128
	fcb	144
	fcb	160
	fcb	176
	fcb	192
	fcb	208
	fcb	224
	fcb	240

circle

	ldx	circle_x
	ldb	circle_angle	;rotation
	stb	circle_sintb1
	addb	#64
	stb	circle_costb1
	clr	circle_cnt	;counter set


circle_loop
	lda	circle_cnt
	ldx	circle_x
	ldb	circle_sintb1
	addb	circle_cnt
	abx
	ldb	,x
	decb	;correction
	lda	circle_radx
	mul
	aslb	;taken from simons code.... i dont understand it fyi
	rola	;same
	suba	circle_radx
	adda	circle_plotx
	sta	circle_calcx
;cos
	ldb	circle_cnt
	ldx	circle_x
	addb	circle_costb1
	abx
	ldb	,x
	decb	;correction

	lda	circle_rady
	mul
	aslb	;taken from simons code.... i dont understand it fyi
	rola	;same
	suba	circle_rady
	adda	circle_ploty
	sta	circle_calcy
;ok lets try it out...??
;	ldd	circle_calcx	;temp code for test
	jsr	circle_dots2
	lda	circle_cnt
	inca
	sta	circle_cnt
	deca
	cmpa	circle_dist
	blo	circle_loop
	rts

;sg4 mode
circle_dots2
	clr	circle_draw
	ldd	circle_calcx	;save x,y
	cmpa	#63
	bls	circle_chky1
	rts	;dot is off the screen
circle_chky1
	cmpb	#31
	bls	circle_drawd1
	rts	;dots off the screen
circle_drawd1
	lda	circle_setcol
	beq	circle_drawd2
	inc	circle_draw
circle_drawd2
	clra
	clrb
	std	circle_bit1
	std	circle_bit3
	std	circle_xrow

	if	b,circle_page=#0
	ldx	#1024
	endif
	if	b,circle_page=#1
	ldx	#3584
	endif
	if	b,circle_page=>#2
	ldx	#4096
	endif

	lda	circle_calcy
	bita	#1
	beq	circle_setrd	;odd or even y
	inc	circle_yrow
circle_setrd
	lsra	;half value y
	ldb	#32
	mul
	leax	d,x
	lda	circle_calcx
	bita	#1
	beq	circle_setcnd	;odd or even x
	inc	circle_xrow
circle_setcnd
	lsra	;half value from 64 to 32
	leax	a,x
	lda	,x	;ready to check
;set color correctly
	sta	circle_orchr	;saved original chr code
	sta	circle_wcol	;lets destroy this copy
;see if color is wrong
;if so and not black then errase it all
	lda	circle_setcol
circle_contd3
	ldu	#circle_color0	;first color index
	leau	a,u
	lda	,u	;color loaded in a
	ldb	circle_wcol	;load b with whats on screen currently
	andb	#240	;extract color from it
	stb	circle_wcol	;only has color now
	cmpa	circle_wcol	;compare the two colors
	beq	circle_contd	;same color? ok we are good to go
;ok we need to kill it
	lda	,u
	sta	circle_orchr	;destroy original color cause its diff
circle_contd
	ldb	#1	;this is needed to set bit flags
	lda	circle_orchr	;load the one we are using
	anda	#15	;extract dots
	bita	#8
	bne	circle_setdot1
circle_retd1
	bita	#4
	bne	circle_setdot2
circle_retd2	bita	#2
	bne	circle_setdot3
circle_retd3	bita	#1
	bne	circle_setdot4
	bra	circle_setdots
circle_setdot1	stb	circle_bit1
	bra	circle_retd1
circle_setdot2	stb	circle_bit2
	bra	circle_retd2
circle_setdot3	stb	circle_bit3
	bra	circle_retd3
circle_setdot4	stb	circle_bit4
;now we are here
circle_setdots
	ldu	#circle_bit1	;working color= wcol
	lda	circle_yrow	
	ldb	#2
	mul
	addb	circle_xrow
	leau	b,u
	ldb	circle_draw
	stb	,u	;set draw on or off for that bit
;reconstruct it
	ldu	#circle_color0
	lda	circle_setcol
	leau	a,u
	lda	,u	;ok got color
	ldb	circle_bit1	;load the bits in
	lslb
	addb	circle_bit2
	lslb
	addb	circle_bit3
	lslb
	addb	circle_bit4
	stb	circle_coltmp
	adda	circle_coltmp
	sta	,x
	rts
endfunction
;

;
; *******************************************************************************************************************************************************************************************
; * set(page ,x,y,c)
; *******************************************************************************************************************************************************************************************
function	set	set_page,set_x1,set_y1,set_setcol
rem	set( page.b , x.b, y.b, color.b)
rem	page 0-2 x 0-63 ,y 0-31 ,color 0-8
rem	
rem

stack	x,y,u

def	set_page	byte
def	set_x1	byte
def	set_y1	byte
def	set_setcol	byte	;kk
def	set_xrow	byte	;0kk
def	set_yrow	byte	;0k
def	set_bit1	byte	;0kk
def	set_bit2	byte	;0kk
def	set_bit3	byte	;0kk
def	set_bit4	byte	;0kk
def	set_draw	byte	;0kk
def	set_orchr	byte	;0kk
def	set_wcol	byte	;0kk
def	set_coltmp	byte	;0kk
def	set_odd	byte	;0kk

set_color0
	fcb	128
	fcb	128
	fcb	144
	fcb	160
	fcb	176
	fcb	192
	fcb	208
	fcb	224
	fcb	240

set
	clra
	clrb
	std	set_xrow
	std	set_bit1
	std	set_bit3
	std	set_draw
;sg4 mode
set_dots2
	ldd	set_x1	;save x,y
	cmpa	#63
	bls	set_chky1
	rts	;dot is off the screen
set_chky1
	cmpb	#31
	bls	set_drawd1
	rts	;dots off the screen
set_drawd1
	lda	set_setcol
	beq	set_drawd2
	inc	set_draw
set_drawd2
	clra
	clrb
	std	set_bit1
	std	set_bit3
	std	set_xrow


	if	b,set_page=#0
	ldx	#1024
	endif
	if	b,set_page=#1
	ldx	#3584
	endif
	if	b,set_page=>#2
	ldx	#4096
	endif

	lda	set_y1
	bita	#1
	beq	set_setrd	;odd or even y
	inc	set_yrow
set_setrd
	lsra	;half value y
	ldb	#32
	mul
	leax	d,x
	lda	set_x1
	bita	#1
	beq	set_setcnd	;odd or even x
	inc	set_xrow
set_setcnd
	lsra	;half value from 64 to 32
	leax	a,x
	lda	,x	;ready to check
;set color correctly
	sta	set_orchr	;saved original chr code
	sta	set_wcol	;lets destroy this copy
;see if color is wrong
;if so and not black then errase it all
	lda	set_setcol
set_contd3
	ldu	#set_color0	;first color index
	leau	a,u
	lda	,u	;color loaded in a
	ldb	set_wcol	;load b with whats on screen currently
	andb	#240	;extract color from it
	stb	set_wcol	;only has color now
	cmpa	set_wcol	;compare the two colors
	beq	set_contd	;same color? ok we are good to go
;ok we need to kill it
	lda	,u
	sta	set_orchr	;destroy original color cause its diff
set_contd
	ldb	#1	;this is needed to set bit flags
	lda	set_orchr	;load the one we are using
	anda	#15	;extract dots
	bita	#8
	bne	set_setdot1
set_retd1	bita	#4
	bne	set_setdot2
set_retd2	bita	#2
	bne	set_setdot3
set_retd3	bita	#1
	bne	set_setdot4
	bra	set_setdots
set_setdot1	stb	set_bit1
	bra	set_retd1
set_setdot2	stb	set_bit2
	bra	set_retd2
set_setdot3	stb	set_bit3
	bra	set_retd3
set_setdot4	stb	set_bit4
;now we are here
set_setdots	ldu	#set_bit1	;working color= wcol
	lda	set_yrow	
	ldb	#2
	mul
	addb	set_xrow
	leau	b,u
	ldb	set_draw
	stb	,u	;set draw on or off for that bit
;reconstruct it
	ldu	#set_color0
	lda	set_setcol
	leau	a,u
	lda	,u	;ok got color
	ldb	set_bit1	;load the bits in
	lslb
	addb	set_bit2
	lslb
	addb	set_bit3
	lslb
	addb	set_bit4
	stb	set_coltmp
	adda	set_coltmp
	sta	,x
	rts
endfunction
;


;
;
; ***************************************************************************************************************
; *   line( page ,x1,y1,x2,y2,color)   sg mode
; ***************************************************************************************************************
function	line	line_page,line_x1,line_y1,line_x2,line_y2,line_setcol
rem	line( page.b , x1.b , y1.b , x2.b , y2.b , color.b )  
rem	page 0-2  x1,x2 range 0-63 y1,y2 range 0-31 color 0-8.  please note that if you go out of range it may crash.
rem	
rem	

def	line_page	byte
def	line_x1	byte
def	line_y1	byte
def	line_x2	byte
def	line_y2	byte
def	line_setcol	byte

def	line_tmp	byte
def	line_xd	byte
def	line_yd	byte
def	line_xc	byte
def	line_yc	byte
def	line_wn	byte
def	line_cnt	byte

stack	x,y,u

line_color0
	fcb	128	;green but we can take original screen value
	fcb	128	;green
	fcb	144	;yellow
	fcb	160	;blue
	fcb	176	;red
	fcb	192	;white
	fcb	208	;cyan
	fcb	224	;magenta
	fcb	240	;orange

def	line_setx	byte
def	line_sety	byte
def	line_wcol	byte	;working with
def	line_xrow	byte
def	line_yrow	byte
def	line_orchr	byte
def	line_draw	byte
def	line_odd	byte	;is it setting or erasing
def	line_bit1	byte
def	line_bit2	byte
def	line_bit3	byte
def	line_bit4	byte
def	line_coltmp	byte



line
	clr	line_draw
	lda	line_setcol
	cmpa	#0
	beq	line_contd2	;this is a dot off command
	inc	line_draw	
line_contd2	cmpa	#8
	blo	line_contd7
	lda	#8
	sta	line_setcol
line_contd7	lda	line_x1	;ok no swapping just get distances
	cmpa	line_x2
	bls	line_lins1	;if x1 is lower
	suba	line_x2	;its greater so sub x2
	sta	line_xd	;save x distance
	bra	line_lins2
line_lins1	lda	line_x2
	suba	line_x1
	sta	line_xd
;
line_lins2	lda	line_y1	;ok now lets look at y
	cmpa	line_y2
	bls	line_lins3	;y1 is lower?
	suba	line_y2
	sta	line_yd	;save y distance
	bra	line_lins4
line_lins3	lda	line_y2
	suba	line_y1
	sta	line_yd
;
;which is greater?
line_lins4	lda	line_yd
	cmpa	line_xd
	blo	line_lins5	;y is lower then goto lins5
	sta	line_wn	;x is lower so save y as whole fraction
	bra	line_lins6	;done
line_lins5	lda	line_xd	;nope y is lower so save x as whole fraction
	sta	line_wn	;stored it
; ok now the main loop
line_lins6	clra
	sta	line_xc	;x counter
	sta	line_yc	;y counter
	lda	line_wn
	sta	line_cnt	;set counter
	inc	line_cnt
;ok check what display
;main loop for sg 2
line_line1	jsr	line_dot2
;	ldd	x1	;main loop
;	std	setx
;	jsr	dot2	;jump to draw dot
	lda	line_xc
	adda	line_xd	;add distance to xc counter
	cmpa	line_wn	;has it gone over or same as our whole fraction?
	bhs	line_adv1	;it has on x.... lets advance it
	sta	line_xc	;nope keep counting 
	bra	line_chk1	;lets check y now
;
line_adv1	suba	line_wn	;advance the x counter....subtract the whole fraction
	sta	line_xc	;store remainder to play with next loop
	lda	line_x1
	cmpa	line_x2
	bhi	line_advx1
	inc	line_x1	;increase y plot or dec?
	bra	line_chk1
line_advx1	dec	line_x1
line_chk1	lda	line_yc	;now the y axis.... loader up
	adda	line_yd	;add its distance
	cmpa	line_wn	;has it gone over or the same as our whole fraction
	bhs	line_advy1	;it has on y.... lets advance it
	sta	line_yc	;nope... keep counting
	bra	line_chkx1	;done
;advance it
line_advy1	suba	line_wn	;subtract the whole number from y counter
	sta	line_yc	;store the remainder for next loop
	lda	line_y1
	cmpa	line_y2
	bhi	line_ady1
	inc	line_y1	;increase y plot or dec?
	bra	line_chkx1
line_ady1	dec	line_y1
;done?
line_chkx1	dec	line_cnt	;check the counter
	bne	line_line1	;nope keep plotting the line
	rts	;we are done
; no safety checks
line_dot2	clra
	clrb
	std	line_bit1
	std	line_bit3
	std	line_xrow
line_chdtl1


	if	b,line_page=#0
	ldx	#1024
	endif
	if	b,line_page=#1
	ldx	#3584
	endif
	if	b,line_page=>#2
	ldx	#4096
	endif


	lda	line_y1
	bita	#1
	beq	line_setrd	;odd or even y
	inc	line_yrow
line_setrd	lsra	;half value y
	ldb	#32
	mul
	leax	d,x
	lda	line_x1
	bita	#1
	beq	line_setcnd	;odd or even x
	inc	line_xrow
line_setcnd	lsra	;half value from 64 to 32
	leax	a,x
	lda	,x	;ready to check
;set color correctly
	sta	line_orchr	;saved original chr code
	sta	line_wcol	;lets destroy this copy
;see if color is wrong
;if so and not black then errase it all
	lda	line_setcol
line_contd3	ldu	#line_color0	;first color index
	leau	a,u
	lda	,u	;color loaded in a
	ldb	line_wcol	;load b with whats on screen currently
	andb	#240	;extract color from it
	stb	line_wcol	;only has color now
	cmpa	line_wcol	;compare the two colors
	beq	line_contd	;same color? ok we are good to go
;ok we need to kill it
	lda	,u
	sta	line_orchr	;destroy original color cause its diff
line_contd	ldb	#1	;this is needed to set bit flags
	lda	line_orchr	;load the one we are using
	anda	#15	;extract dots
	bita	#8
	bne	line_setdot1
line_retd1	bita	#4
	bne	line_setdot2
line_retd2	bita	#2
	bne	line_setdot3
line_retd3	bita	#1
	bne	line_setdot4
	bra	line_setdots
line_setdot1	stb	line_bit1
	bra	line_retd1
line_setdot2	stb	line_bit2
	bra	line_retd2
line_setdot3	stb	line_bit3
	bra	line_retd3
line_setdot4	stb	line_bit4
;now we are here
line_setdots	ldu	#line_bit1	;working color= wcol
	lda	line_yrow	
	ldb	#2
	mul
	addb	line_xrow
	leau	b,u
	ldb	line_draw
	stb	,u	;set draw on or off for that bit
;reconstruct it
	ldu	#line_color0
	lda	line_setcol
	leau	a,u
	lda	,u	;ok got color
	ldb	line_bit1	;load the bits in
	lslb
	addb	line_bit2
	lslb
	addb	line_bit3
	lslb
	addb	line_bit4
	stb	line_coltmp
	adda	line_coltmp
	sta	,x
	rts
endfunction













;
; *******************************************************************************************************************************************************************************************
; * fast_line(page ,x,y1,y2,c)
; *******************************************************************************************************************************************************************************************
function	fast_line	fast_line_page,fast_line_x1,fast_line_y1,fast_line_y2,fast_line_fast_linecol
rem	fast_line( page.b , x.b, y1.b , y2.b , color.b)
rem	page 0-2 x 0-63 ,y 0-31 ,color 0-8
rem	
rem

stack	x,y,u

def	fast_line_page	byte
def	fast_line_x1	byte
def	fast_line_y1	byte
def	fast_line_y2	byte
def	fast_line_fast_linecol	byte	;kk
def	fast_line_xrow	byte	;0kk
def	fast_line_yrow	byte	;0k
def	fast_line_bit1	byte	;0kk
def	fast_line_bit2	byte	;0kk
def	fast_line_bit3	byte	;0kk
def	fast_line_bit4	byte	;0kk
def	fast_line_draw	byte	;0kk
def	fast_line_orchr	byte	;0kk
def	fast_line_wcol	byte	;0kk
def	fast_line_coltmp	byte	;0kk
def	fast_line_odd	byte	;0kk

fast_line_color0
	fcb	128
	fcb	128
	fcb	144
	fcb	160
	fcb	176
	fcb	192
	fcb	208
	fcb	224
	fcb	240

fast_line



	clra
	clrb
	std	fast_line_xrow
	std	fast_line_bit1
	std	fast_line_bit3
	std	fast_line_draw
;sg4 mode
fast_line_dots2
	ldd	fast_line_x1	;save x,y
	cmpa	#63
	bls	fast_line_chky1
	rts	;dot is off the screen
fast_line_chky1
	cmpb	#31
	bls	fast_line_drawd1
	rts	;dots off the screen
fast_line_drawd1
	lda	fast_line_fast_linecol
	beq	fast_line_drawd2
	inc	fast_line_draw
fast_line_drawd2
	clra
	clrb
	std	fast_line_bit1
	std	fast_line_bit3
	std	fast_line_xrow


	if	b,fast_line_page=#0
	ldx	#1024
	endif
	if	b,fast_line_page=#1
	ldx	#3584
	endif
	if	b,fast_line_page=>#2
	ldx	#4096
	endif

	lda	fast_line_y1
	bita	#1
	beq	fast_line_fast_linerd	;odd or even y
	inc	fast_line_yrow
fast_line_fast_linerd
	lsra	;half value y
	ldb	#32
	mul
	leax	d,x
	lda	fast_line_x1
	bita	#1
	beq	fast_line_fast_linecnd	;odd or even x
	inc	fast_line_xrow
fast_line_fast_linecnd
	lsra	;half value from 64 to 32
	leax	a,x
	lda	,x	;ready to check
;fast_line color correctly
	sta	fast_line_orchr	;saved original chr code
	sta	fast_line_wcol	;lets destroy this copy
;see if color is wrong
;if so and not black then errase it all
	lda	fast_line_fast_linecol
fast_line_contd3
	ldu	#fast_line_color0	;first color index
	leau	a,u
	lda	,u	;color loaded in a
	ldb	fast_line_wcol	;load b with whats on screen currently
	andb	#240	;extract color from it
	stb	fast_line_wcol	;only has color now
	cmpa	fast_line_wcol	;compare the two colors
	beq	fast_line_contd	;same color? ok we are good to go
;ok we need to kill it
	lda	,u
	sta	fast_line_orchr	;destroy original color cause its diff
fast_line_contd
	ldb	#1	;this is needed to fast_line bit flags
	lda	fast_line_orchr	;load the one we are using
	anda	#15	;extract dots
	bita	#8
	bne	fast_line_fast_linedot1
fast_line_retd1	bita	#4
	bne	fast_line_fast_linedot2
fast_line_retd2	bita	#2
	bne	fast_line_fast_linedot3
fast_line_retd3	bita	#1
	bne	fast_line_fast_linedot4
	bra	fast_line_fast_linedots
fast_line_fast_linedot1	stb	fast_line_bit1
	bra	fast_line_retd1
fast_line_fast_linedot2	stb	fast_line_bit2
	bra	fast_line_retd2
fast_line_fast_linedot3	stb	fast_line_bit3
	bra	fast_line_retd3
fast_line_fast_linedot4	stb	fast_line_bit4
;now we are here
fast_line_fast_linedots	ldu	#fast_line_bit1	;working color= wcol
	lda	fast_line_yrow	
	ldb	#2
	mul
	addb	fast_line_xrow
	leau	b,u
	ldb	fast_line_draw
	stb	,u	;fast_line draw on or off for that bit
;reconstruct it
	ldu	#fast_line_color0
	lda	fast_line_fast_linecol
	leau	a,u
	lda	,u	;ok got color
	ldb	fast_line_bit1	;load the bits in
	lslb
	addb	fast_line_bit2
	lslb
	addb	fast_line_bit3
	lslb
	addb	fast_line_bit4
	stb	fast_line_coltmp
	adda	fast_line_coltmp
	sta	,x

	inc	fast_line_y1
	lda	fast_line_y1
	cmpa	fast_line_y2
	lblo	fast_line

	rts

endfunction











; new key input
; *************************************************************
; * keystring(state)
; *************************************************************
function	keystring	keystring_state
rem	keystring( state.b ) #0 for now
rem	returns key
rem	
rem	8 bytes dumped at #keystring_dump

keystring_chk	fcb	254,253,251,247,239,223,191,127

stack	x,y

keystring_table
;127 chk
;	fcb	0,15,47,55,32,119,111,103	;shft / 7 sp w o g
	fcb	0,15,63,39,32,87,79,71	;shft ? ' sp W O G
; 191 chk
;	fcb	0,0,46,54,9,118,110,102	; . 6 rt v n f
	fcb	0,0,62,38,93,86,78,70	; > & ] V N F
; 223 chk
;	fcb	0,0,45,53,8,117,109,101	; - 5 lt u m e
	fcb	0,0,61,37,10,85,77,69	; = % dl U M E
; 239 chk
;	fcb	0,0,44,52,7,116,108,100	; , 4 dn t l d
	fcb	0,0,60,36,91,84,76,68	; < $ [ T L D
; 247 chk
;	fcb	0,0,59,51,6,115,107,99	; 3 up s k c
	fcb	0,0,43,35,95,83,75,67	; + # _ S K C
; 251 chk
;	fcb	0,27,58,50,122,114,106,98	; brk : 2 z r j b
	fcb	0,27,42,34,90,82,74,66	; brk * " Z R J B
; 253 chk
;	fcb	0,12,57,49,121,113,105,97	; clr 9 1 y q i a
	fcb	0,92,41,33,89,81,73,65	; \ ) ! Y Q I A
; 254 chk
;	fcb	0,13,56,48,120,112,104,64	; ent 8 0 x p h @
	fcb	0,13,40,48,88,80,72,64	; ent ( uplow=14 X P H @



def	keystring_state	byte
def	keystring_temp	byte
def	keystring_shift	byte
def	keystring_key	byte
def	keystring_dump	string	8





keystring
	clr	keystring_key	;0 pressed

	ldx	#keystring_chk
	ldy	#keystring_dump

	ldb	#7
keystring_loop1
	lda	b,x
	sta	$ff02	;load it to pia
	lda	$ff00	;read it back
	anda	#127
	sta	b,y
	decb
	bpl	keystring_loop1	;branch till negative

; decifer
	ldx	#keystring_dump
	ldb	#7	;loop
	ldy	#keystring_table


keystring_loop2
	lda	b,x
	cmpa	#127
	bne	keystring_grabkey
	leay	8,y	;advance chrs
	decb
	bpl	keystring_loop2
;ok no key
	ldb	#0
	rts
keystring_grabkey
	ldb	#7
keystring_loop3
	lsla
	leay	1,y
	bita	#128
	beq	keystring_foundkey
	decb
	bpl	keystring_loop3
	ldb	#0

	rts
keystring_foundkey

	ldb	0,y
	rts

endfunction


















