; include file
#dontinclude

function	cg6_display	cg6_display_c
rem	cg6_display( mode.b )
rem	starts page 0 at 3584
rem	sets the display mode to 256x192 - 2 color mode with color set 0 or 1
rem	
def	cg6_display_c	byte

stack	x

cg6_display

	lda	#0
	ldx	#65472
	sta	0,x
	ldx	#65475
	sta	0,x
	ldx	#65477
	sta	0,x

; setup memory page 0
; @e00
	clra	;set value 7 so its at 3584 view
	ldx	#$ffc6
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x

	if	b,cg6_display_c=#0
	lda	#240
	sta	$ff22
	endif

	if	b,cg6_display_c=#1
	lda	#248
	sta	$ff22
	endif

	rts

endfunction





;**********************************************************************************************************************

function	cg6_sync	cg6_sync_pg
rem	cg6_sync( page.b )
rem	syncs the working display onto screen
rem	pages 0,1,2
rem
	
def	cg6_sync_pg	byte

stack	x

cg6_sync
	lda	$ff03
	bpl	cg6_sync

	if	b,cg6_sync_pg=#0
; setup memory page 0
; @e00=7
	clra	;set value 7 so its at 3584 view
	ldx	#$ffc6
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	endif


	if	b,cg6_sync_pg=#1
; setup memory page 2
; @2600 = 19
	clra	;set value 7 so its at 9728 view
	ldx	#$ffc6
	sta	1,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	9,x
	sta	10,x
	sta	12,x
	endif


	rts
endfunction


;**********************************************************************************************************************

function	cg6_nosync	cg6_nosync_pg
rem	cg6_nosync( page.b )
rem	nosyncs the working display onto screen
rem	pages 0,1
rem
	
def	cg6_nosync_pg	byte

stack	x

cg6_nosync

	if	b,cg6_nosync_pg=#0
; setup memory page 0
; @e00=7
	clra	;set value 7 so its at 3584 view
	ldx	#$ffc6
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	rts
	endif


; setup memory page 2
; @2600 = 19
	clra	;set value 7 so its at 9728 view
	ldx	#$ffc6
	sta	1,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	9,x
	sta	10,x
	sta	12,x


	rts
endfunction


;**********************************************************************************************************************************
function	cg6_cls	cg6_cls_page,cg6_cls_col,cg6_cls_copy
rem	cg6_cls( page.b , color.b , copy.w )
rem	clears working screen with color 0 or 1 and can copy from ram instead of clear screen
rem	
rem
	
def	cg6_cls_col	byte
def	cg6_cls_page	byte
def	cg6_cls_copy	word
def	cg6_cls_stack	word


cg6_cls

	if	b,cg6_cls_page=#0
	ldu	#$2600
	else
	ldu	#$3e00
	endif

	lda	#32
	sta	cg6_cls_page	;tmp counter

	lda	cg6_cls_col
	ldb	cg6_cls_col
	tfr	d,x
	tfr	d,y

cg6_cls_lp

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes
	pshu	x,y,d,a,b	;8 bytes

	dec	cg6_cls_page
	lbne	cg6_cls_lp


	rts
endfunction








;********************************************************************************************************************************************************************

;**********************************************************************************************************************************
function	cg6_dot	cg6_dot_page,cg6_dot_x,cg6_dot_y,cg6_dot_col
rem	cg6_dot( page.b , x.b, y.b , color.b )
rem	draws a dot color 0 or 1
rem	
rem
	
def	cg6_dot_col	byte
def	cg6_dot_page	byte
def	cg6_dot_x	byte
def	cg6_dot_y	byte

stack	x

cg6_dot_mask
	fcb	127,191,223,239,247,251,253,254
cg6_dot_mask2
	fcb	128,64,32,16,8,4,2,1

cg6_dot
	if	b,cg6_dot_y>#191
	ldb	#191
	stb	cg6_dot_y
	endif

	if	b,cg6_dot_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

	if	b,cg6_dot_col=#1
	lda	cg6_dot_y
	ldb	#32
	mul
	leax	d,x
	ldb	cg6_dot_x
	lsrb
	lsrb
	lsrb
	leax	b,x
; we are at said dot set of 8
	ldb	cg6_dot_x
	andb	#7
	ldy	#cg6_dot_mask
	ldu	#cg6_dot_mask2
	lda	,x
	anda	b,y
	adda	b,u
	sta	,x

	else

	lda	cg6_dot_y
	ldb	#32
	mul
	leax	d,x
	ldb	cg6_dot_x
	lsrb
	lsrb
	lsrb
	leax	b,x
; we are at said dot set of 8
	ldb	cg6_dot_x
	andb	#7
	ldy	#cg6_dot_mask
	lda	,x
	anda	b,y
	sta	,x
	endif

	rts
endfunction











;********************************************************************************************************************************************************************

;**********************************************************************************************************************************
function	cg6_ppoint	cg6_ppoint_page,cg6_ppoint_x,cg6_ppoint_y
rem	cg6_ppoint( page.b , x.b, y.b)
rem	draws a ppoint color 0 or 1
rem	
rem

stack	x

def	cg6_ppoint_page	byte
def	cg6_ppoint_x	byte
def	cg6_ppoint_y	byte

cg6_ppoint_mask
	fcb	128,64,32,16,8,4,2,1


cg6_ppoint
	if	b,cg6_ppoint_y>#191
	ldb	#191
	stb	cg6_ppoint_y
	endif

	if	b,cg6_ppoint_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif


	lda	cg6_ppoint_y
	ldb	#32
	mul
	leax	d,x
	ldb	cg6_ppoint_x
	lsrb
	lsrb
	lsrb
	leax	b,x
; we are at said ppoint set of 8
	ldb	cg6_ppoint_x
	andb	#7
	ldy	#cg6_ppoint_mask
	lda	,x
	anda	b,y
	tfr	a,b
	rts
endfunction


















;**********************************************************************************************************************************
function	cg6_line	cg6_line_page,cg6_line_x1,cg6_line_y1,cg6_line_x2,cg6_line_y2,cg6_line_col
rem	cg6_line( page.b , x1.b, y1.b , x2.b , y2.b , color.b )
rem	draws a line color 0 or 1
rem	
rem

stack	x
	
def	cg6_line_col	byte
def	cg6_line_page	byte
def	cg6_line_x	byte
def	cg6_line_y	byte
def	cg6_line_x1	byte
def	cg6_line_y1	byte
def	cg6_line_x2	byte
def	cg6_line_y2	byte

def	cg6_line_distx	word
def	cg6_line_disty	word
def	cg6_line_wn	word
def	cg6_line_cntx	word
def	cg6_line_cnty	word
def	cg6_line_dirx	byte
def	cg6_line_diry	byte

def	cg6_line_count	byte


cg6_line_mask
	fcb	127,191,223,239,247,251,253,254
cg6_line_mask2
	fcb	128,64,32,16,8,4,2,1

cg6_line

;check distances

;x first
	if	b,cg6_line_x1<cg6_line_x2
	clra
	ldb	cg6_line_x2
	subb	cg6_line_x1
	std	cg6_line_distx
	lda	#1
	sta	cg6_line_dirx

	else

	clra
	ldb	cg6_line_x1
	subb	cg6_line_x2
	std	cg6_line_distx
	clr	cg6_line_dirx
	dec	cg6_line_dirx
	endif

;y next
	if	b,cg6_line_y1<cg6_line_y2
	clra
	ldb	cg6_line_y2
	subb	cg6_line_y1
	std	cg6_line_disty
	lda	#1
	sta	cg6_line_diry

	else

	clra
	ldb	cg6_line_y1
	subb	cg6_line_y2
	std	cg6_line_disty
	clr	cg6_line_diry
	dec	cg6_line_diry
	endif

	ldd	#0
	std	cg6_line_cntx
	std	cg6_line_cnty
;deal out whole number
	if	w,cg6_line_distx>cg6_line_disty
	ldd	cg6_line_distx
	std	cg6_line_wn
	stb	cg6_line_count
;	ldb	cg6_line_disty
;	clra
;	std	cg6_line_cnty
	else

	ldd	cg6_line_disty
	std	cg6_line_wn
	stb	cg6_line_count
;	ldb	cg6_line_distx
;	clra
;	std	cg6_line_cntx
	endif


; ok lets draw line
	inc	cg6_line_count


	ldy	#cg6_line_mask
	ldu	#cg6_line_mask2

cg6_line_drawlp

;draw dot
	if	b,cg6_line_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

	if	b,cg6_line_col=#1
	lda	cg6_line_y1
	ldb	#32
	mul
	leax	d,x
	ldb	cg6_line_x1
	lsrb
	lsrb
	lsrb
	leax	b,x
; we are at said line set of 8
	ldb	cg6_line_x1
	andb	#7

	lda	,x
	anda	b,y
	adda	b,u
	sta	,x

	else

	lda	cg6_line_y1
	ldb	#32
	mul
	leax	d,x
	ldb	cg6_line_x1
	lsrb
	lsrb
	lsrb
	leax	b,x
; we are at said line set of 8
	ldb	cg6_line_x1
	andb	#7

	lda	,x
	anda	b,y
	sta	,x
	endif

;drew a dot

;look at x
	ldd	cg6_line_cntx
	addd	cg6_line_distx
	std	cg6_line_cntx

	if	w,cg6_line_cntx=>cg6_line_wn
	ldd	cg6_line_cntx
	subd	cg6_line_wn
	std	cg6_line_cntx

	lda	cg6_line_x1
	adda	cg6_line_dirx
	sta	cg6_line_x1

;	if	b,cg6_line_dirx=#1
;	inc	cg6_line_x1
;	else
;	dec	cg6_line_x1
;	endif

	endif
	
;look at y	
	ldd	cg6_line_cnty
	addd	cg6_line_disty
	std	cg6_line_cnty

	if	w,cg6_line_cnty=>cg6_line_wn
	ldd	cg6_line_cnty
	subd	cg6_line_wn
	std	cg6_line_cnty

	lda	cg6_line_y1
	adda	cg6_line_diry
	sta	cg6_line_y1

;	if	b,cg6_line_diry=#1
;	inc	cg6_line_y1
;	else
;	dec	cg6_line_y1
;	endif

	endif

	dec	cg6_line_count
	lbne	cg6_line_drawlp


	rts
endfunction







;**********************************************************************************************************************************
function	cg6_scroll_up	cg6_scroll_up_page,cg6_scroll_up_lines
rem	cg6_scroll_up( page.b, lines.b)
rem	scrolls working page up by lines
rem	
rem
	

def	cg6_scroll_up_page	byte
def	cg6_scroll_up_lines	byte

cg6_scroll_up
	if	b,cg6_scroll_up_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

	ldb	#32
	lda	cg6_scroll_up_lines
	lbeq	cg6_scroll_up_dn
	mul
	leau	d,x


	ldb	#192
	subb	cg6_scroll_up_lines
	clra
	tfr	d,y
cg6_scroll_up_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	32,x
	leau	32,u
	leay	-1,y
	lbne	cg6_scroll_up_lp

;
	clra
	ldb	cg6_scroll_up_lines
	tfr	d,y
	ldd	#0
cg6_scroll_up_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	32,x
	leay	-1,y
	bne	cg6_scroll_up_lp2


cg6_scroll_up_dn
	rts
endfunction




;**********************************************************************************************************************************
function	cg6_scroll_down	cg6_scroll_down_page,cg6_scroll_down_lines
rem	cg6_scroll_down( page.b, lines.b)
rem	scrolls working page down by lines
rem	
rem
	

def	cg6_scroll_down_page	byte
def	cg6_scroll_down_lines	byte

cg6_scroll_down
	if	b,cg6_scroll_down_page=#0
	ldx	#$25e0
	else
	ldx	#$3de0
	endif

	leau	,x
	ldb	cg6_scroll_down_lines
	lbeq	cg6_scroll_down_dn

cg6_scroll_down_adj
	leau	-32,u
	decb
	bne	cg6_scroll_down_adj

	ldb	#192
	subb	cg6_scroll_down_lines
	clra
	tfr	d,y
cg6_scroll_down_lp

	ldd	0,u
	std	0,x
	ldd	2,u
	std	2,x
	ldd	4,u
	std	4,x
	ldd	6,u
	std	6,x
	ldd	8,u
	std	8,x
	ldd	10,u
	std	10,x
	ldd	12,u
	std	12,x
	ldd	14,u
	std	14,x
	ldd	16,u
	std	16,x
	ldd	18,u
	std	18,x
	ldd	20,u
	std	20,x
	ldd	22,u
	std	22,x
	ldd	24,u
	std	24,x
	ldd	26,u
	std	26,x
	ldd	28,u
	std	28,x
	ldd	30,u
	std	30,x

	leax	-32,x
	leau	-32,u
	leay	-1,y
	lbne	cg6_scroll_down_lp

;
	clra
	ldb	cg6_scroll_down_lines
	tfr	d,y
	ldd	#0
cg6_scroll_down_lp2
	std	0,x
	std	2,x
	std	4,x
	std	6,x
	std	8,x
	std	10,x
	std	12,x
	std	14,x
	std	16,x
	std	18,x
	std	20,x
	std	22,x
	std	24,x
	std	26,x
	std	28,x
	std	30,x
	leax	-32,x
	leay	-1,y
	bne	cg6_scroll_down_lp2
cg6_scroll_down_dn


	rts
endfunction





;**********************************************************************************************************************************
function	cg6_scroll_left	cg6_scroll_left_page,cg6_scroll_left_lines
rem	cg6_scroll_left( page.b, lines.b)
rem	scrolls working page left by lines
rem	
rem
	

def	cg6_scroll_left_page	byte
def	cg6_scroll_left_lines	byte


cg6_scroll_left
	if	b,cg6_scroll_left_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

	ldb	cg6_scroll_left_lines
	cmpb	#8
	lbeq	cg6_scroll_left_full


	ldb	cg6_scroll_left_lines
	lbeq	cg6_scroll_left_dn

	ldy	#192
cg6_scroll_left_lp1
	andcc	#$fe
	rol	31,x
	rol	30,x
	rol	29,x
	rol	28,x
	rol	27,x
	rol	26,x
	rol	25,x
	rol	24,x
	rol	23,x
	rol	22,x
	rol	21,x
	rol	20,x
	rol	19,x
	rol	18,x
	rol	17,x
	rol	16,x
	rol	15,x
	rol	14,x
	rol	13,x
	rol	12,x
	rol	11,x
	rol	10,x
	rol	9,x
	rol	8,x
	rol	7,x
	rol	6,x
	rol	5,x
	rol	4,x
	rol	3,x
	rol	2,x
	rol	1,x
	rol	0,x
	decb
	bne	cg6_scroll_left_lp1
	leax	32,x
	ldb	cg6_scroll_left_lines
	leay	-1,y
	bne	cg6_scroll_left_lp1


cg6_scroll_left_dn
	rts

cg6_scroll_left_full
	ldy	#192

cg6_scroll_left_fullp
	ldd	1,x
	std	0,x
	ldd	3,x
	std	2,x
	ldd	5,x
	std	4,x
	ldd	7,x
	std	6,x
	ldd	9,x
	std	8,x
	ldd	11,x
	std	10,x
	ldd	13,x
	std	12,x
	ldd	15,x
	std	14,x
	ldd	17,x
	std	16,x
	ldd	19,x
	std	18,x
	ldd	21,x
	std	20,x
	ldd	23,x
	std	22,x
	ldd	25,x
	std	24,x
	ldd	27,x
	std	26,x
	ldd	29,x
	std	28,x
	lda	31,x
	ldb	#0
	std	30,x

	leax	32,x
	leay	-1,y
	lbne	cg6_scroll_left_fullp
	rts

endfunction















;**********************************************************************************************************************************
function	cg6_scroll_left2	cg6_scroll_left2_page,cg6_scroll_left2_lines
rem	cg6_scroll_left2( page.b, lines.b)
rem	scrolls working page left 1 for a total of x lines
rem	
rem


def	cg6_scroll_left2_page	byte
def	cg6_scroll_left2_lines	byte


cg6_scroll_left2
	if	b,cg6_scroll_left2_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif


	ldb	cg6_scroll_left2_lines

cg6_scroll_left2lp
	andcc	#$fe
	rol	31,x
	rol	30,x
	rol	29,x
	rol	28,x
	rol	27,x
	rol	26,x
	rol	25,x
	rol	24,x
	rol	23,x
	rol	22,x
	rol	21,x
	rol	20,x
	rol	19,x
	rol	18,x
	rol	17,x
	rol	16,x
	rol	15,x
	rol	14,x
	rol	13,x
	rol	12,x
	rol	11,x
	rol	10,x
	rol	9,x
	rol	8,x
	rol	7,x
	rol	6,x
	rol	5,x
	rol	4,x
	rol	3,x
	rol	2,x
	rol	1,x
	rol	0,x
	leax	32,x
	decb
	bne	cg6_scroll_left2lp


	rts

endfunction






;**********************************************************************************************************************************
function	cg6_scroll_right	cg6_scroll_right_page,cg6_scroll_right_lines
rem	cg6_scroll_right( page.b, lines.b)
rem	scrolls working page right by lines
rem	
rem
	

def	cg6_scroll_right_page	byte
def	cg6_scroll_right_lines	byte

cg6_scroll_right
	if	b,cg6_scroll_right_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

	ldb	cg6_scroll_right_lines
	cmpb	#8
	lbeq	cg6_scroll_right_full


	ldb	cg6_scroll_right_lines
	lbeq	cg6_scroll_right_dn

	ldy	#192
cg6_scroll_right_lp1
	andcc	#$fe
	ror	0,x
	ror	1,x
	ror	2,x
	ror	3,x
	ror	4,x
	ror	5,x
	ror	6,x
	ror	7,x
	ror	8,x
	ror	9,x
	ror	10,x
	ror	11,x
	ror	12,x
	ror	13,x
	ror	14,x
	ror	15,x
	ror	16,x
	ror	17,x
	ror	18,x
	ror	19,x
	ror	20,x
	ror	21,x
	ror	22,x
	ror	23,x
	ror	24,x
	ror	25,x
	ror	26,x
	ror	27,x
	ror	28,x
	ror	29,x
	ror	30,x
	ror	31,x

	decb
	bne	cg6_scroll_right_lp1
	leax	32,x
	ldb	cg6_scroll_right_lines
	leay	-1,y
	bne	cg6_scroll_right_lp1


cg6_scroll_right_dn
	rts

cg6_scroll_right_full
	ldy	#191

cg6_scroll_right_fullp
	ldd	29,x
	std	30,x
	ldd	27,x
	std	28,x
	ldd	25,x
	std	26,x
	ldd	23,x
	std	24,x
	ldd	21,x
	std	22,x
	ldd	19,x
	std	20,x
	ldd	17,x
	std	18,x
	ldd	15,x
	std	16,x
	ldd	13,x
	std	14,x
	ldd	11,x
	std	12,x
	ldd	9,x
	std	10,x
	ldd	7,x
	std	8,x
	ldd	5,x
	std	6,x
	ldd	3,x
	std	4,x
	ldd	1,x
	std	2,x
	clra
	ldb	0,x
	std	0,x

	leax	32,x
	leay	-1,y
	lbne	cg6_scroll_right_fullp
	rts

endfunction



;
;**************************************************************************************
;* cg6_print(page,posx , posy,string) 
;**************************************************************************************
function	cg6_print	cg6_print_page,cg6_print_skip,cg6_print_max,cg6_print_x,cg6_print_y,cg6_print_s
rem	cg6_print( page.b , skipchr.w , maxchar.b , position_x.b , position_y.b, string.w)
rem	
rem	
rem	

def	cg6_print_page	byte
def	cg6_print_x	byte	;
def	cg6_print_y	byte
def	cg6_print_s	word	;populate x register with string at x
def	cg6_print_skip	word
def	cg6_print_max	byte

cg6_print_font



; sprite #1
	fcb	0,0,0,0,0,0,0,0
; sprite #2
	fcb	0,24,24,24,0,0,24,0
; sprite #3
	fcb	0,40,40,0,0,0,0,0
; sprite #4
	fcb	0,40,124,40,124,40,0,0
; sprite #5
	fcb	20,62,96,62,2,126,20,0
; sprite #6
	fcb	0,98,100,8,16,38,70,0
; sprite #7
	fcb	24,36,36,24,42,68,58,0
; sprite #8
	fcb	0,24,24,0,0,0,0,0
; sprite #9
	fcb	0,24,48,48,48,48,24,0
; sprite #10
	fcb	0,24,12,12,12,12,24,0
; sprite #11
	fcb	0,24,60,24,36,0,0,0
; sprite #12
	fcb	0,8,8,62,8,8,0,0
; sprite #13
	fcb	0,0,0,0,0,0,24,48
; sprite #14
	fcb	0,0,0,60,0,0,0,0
; sprite #15
	fcb	0,0,0,0,0,0,24,24
; sprite #16
	fcb	0,2,6,12,24,48,96,0
; sprite #17
	fcb	0,60,102,98,98,102,60,0
; sprite #18
	fcb	0,24,56,56,24,24,126,0
; sprite #19
	fcb	0,60,98,2,28,112,126,0
; sprite #20
	fcb	0,60,98,2,14,98,60,0
; sprite #21
	fcb	0,100,100,126,12,12,12,0
; sprite #22
	fcb	0,62,96,124,2,98,124,0
; sprite #23
	fcb	0,62,96,124,98,98,60,0
; sprite #24
	fcb	0,126,6,12,24,24,24,0
; sprite #25
	fcb	0,60,98,60,98,98,60,0
; sprite #26
	fcb	0,60,98,98,62,6,6,0
; sprite #27
	fcb	0,24,24,0,0,24,24,0
; sprite #28
	fcb	0,24,24,0,0,0,24,48
; sprite #29
	fcb	0,12,24,48,96,48,24,12
; sprite #30
	fcb	0,0,60,0,0,60,0,0
; sprite #31
	fcb	0,48,24,12,6,12,24,48
; sprite #32
	fcb	0,60,98,2,28,24,0,24
; sprite #33
	fcb	0,60,98,106,110,96,62,0
; sprite #34
	fcb	0,60,118,98,126,98,98,0
; sprite #35
	fcb	0,124,98,124,98,98,124,0
; sprite #36
	fcb	0,60,98,96,96,98,60,0
; sprite #37
	fcb	0,124,98,98,98,98,124,0
; sprite #38
	fcb	0,126,96,120,96,96,126,0
; sprite #39
	fcb	0,126,96,120,96,96,96,0
; sprite #40
	fcb	0,126,98,96,110,98,126,0
; sprite #41
	fcb	0,98,98,126,98,98,98,0
; sprite #42
	fcb	0,126,24,24,24,24,126,0
; sprite #43
	fcb	0,126,8,8,104,104,120,0
; sprite #44
	fcb	0,98,100,120,120,100,98,0
; sprite #45
	fcb	0,96,96,96,96,96,126,0
; sprite #46
	fcb	0,98,118,126,126,106,98,0
; sprite #47
	fcb	0,98,114,122,110,102,98,0
; sprite #48
	fcb	0,60,98,98,98,98,60,0
; sprite #49
	fcb	0,124,98,98,124,96,96,0
; sprite #50
	fcb	0,60,98,98,106,102,62,1
; sprite #51
	fcb	0,124,98,98,124,98,98,0
; sprite #52
	fcb	0,60,98,112,12,98,60,0
; sprite #53
	fcb	0,126,24,24,24,24,24,0
; sprite #54
	fcb	0,98,98,98,98,98,126,0
; sprite #55
	fcb	0,98,98,98,52,60,24,0
; sprite #56
	fcb	0,98,98,106,126,118,98,0
; sprite #57
	fcb	0,98,52,24,24,52,98,0
; sprite #58
	fcb	0,98,118,60,24,24,24,0
; sprite #59
	fcb	0,126,100,8,16,98,126,0
; sprite #60
	fcb	0,30,24,24,24,24,30,0
; sprite #61
	fcb	0,64,96,48,24,12,6,0
; sprite #62
	fcb	0,120,24,24,24,24,120,0
; sprite #63
	fcb	0,24,24,52,98,0,0,0
; sprite #64
	fcb	0,0,0,0,0,0,0,126


cg6_print

	ldu	cg6_print_s	;load text
	ldd	cg6_print_skip
	leau	d,u	;skipped
	
	if	b,cg6_print_page=#0
	ldx	#$e00
	else
	ldx	#$2600
	endif

; prep text dump start
	lda	cg6_print_y
	ldb	#32
	mul
	leax	d,x
	lda	cg6_print_x
	lsra
	lsra
	lsra
	leax	a,x
;ready

cg6_print_lps
	lda	,u+
	lbeq	cg6_print_exit
	cmpa	#96
	blo	cg6_print_process
	suba	#32
cg6_print_process
	suba	#32
	ldy	#cg6_print_font
	ldb	#8
	mul
	leay	d,y	;y ready with graphic

;1 of 8
	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y+
	sta	,x
	leax	32,x

	lda	,y
	sta	,x
	ldd	#-223
	leax	d,x

	dec	cg6_print_max
	beq	cg6_print_exit
	
	lbra	cg6_print_lps

cg6_print_exit

	rts	;return
endfunction




