#dontinclude

; disk library vr 2.0




;
; ***************************************************************************************************************
; * disk_granuals()
; ***************************************************************************************************************
function	disk_granuals
rem	disk_granuals()
rem	creates a granual table 70 bytes long
rem	returns address on d
rem	

;def	disk_granual70	string	70

disk_granuals

	ldd	#$600

	rts

endfunction


;
; ***************************************************************************************************************
; * disk_buffer()
; ***************************************************************************************************************
function	disk_buffer
rem	disk_buffer()
rem	creates a 256 byte table for reading disk sectors
rem	returns address on d
rem	

;def	disk_buffer256	string	256

disk_buffer

	ldd	#$cc0

	rts
endfunction


;
; **************************************************************************************************************
; * disk_filelist()
; **************************************************************************************************************
function	disk_filelist
rem	disk_filelist()
rem	creates a file table for loading and saving
rem	returns address on d
rem	uses 1088 bytes.... ya its alot!

def	disk_filelists	string	1088

disk_filelist

	ldd	#disk_filelists

	rts

endfunction




;
; ***************************************************************************************************************
; * disk_bytes16()
; ***************************************************************************************************************
function	disk_bytes16
rem	disk_bytes16()
rem	creates a 16 byte header to read and write from file system 
rem	returns address on d
rem	

def	disk_bytes_l16	string	16

disk_bytes16

	ldd	#disk_bytes_l16

	rts

endfunction




; ***************************************************************************************************************
; * disk_dir()
; ***************************************************************************************************************
function	disk_dir	disk_dir_drive,disk_dir_sect,disk_dir_gran,disk_dir_list
rem	disk_dir( drive.b , buffertable.w , granualtable.w , filelist.w )
rem	fills granual table and populates file list
rem	
rem	


def	disk_dir_list	word
def	disk_dir_gran	word	;68 byte granual list
def	disk_dir_sect	word	;256 byte table
def	disk_dir_tempd	word


def	disk_dir_dcopc	byte
def	disk_dir_dctrk	byte
def	disk_dir_dsect	byte
def	disk_dir_dcsta	byte	;error report
def	disk_dir_retry	byte	
def	disk_dir_bcnt	byte	;b counter
def	disk_dir_dcfiles	byte	;files found
def	disk_dir_drive	byte

stack	x,y,u

disk_dir

	ldy	disk_dir_sect	;256 byte temp storage
	ldd	disk_dir_sect
	addd	#250
	std	disk_dir_tempd	;cutoff check
; ok setup for granual read
	lda	#2
	sta	disk_dir_dcopc	;opcode read
	lda	#17
	sta	disk_dir_dctrk	;track
	lda	#2
	sta	disk_dir_dsect	;sector
	jsr	disk_dir_getsector	;jump to grab data off disk
	cmpa	#1
	beq	disk_dir_nextp1	;it loaded
; problem occured
	clrb
	rts	; return result 0 on b register..... failed

; ok lets fill directory files in
disk_dir_nextp1

	jsr	disk_dir_copysect	;copy the sector table only once
	ldb	#3	;start search
	stb	disk_dir_bcnt	;save counter
	clr	disk_dir_retry	;clear disk_dir_retry times
	clr	disk_dir_dcfiles	;clear file entry
disk_dir_loopd1
	lda	disk_dir_dcfiles
	ldb	disk_dir_bcnt
	cmpa	#67
	bhs	disk_dir_loopd4	;done lets exit
	stb	disk_dir_dsect	;adjust sector search
	jsr	disk_dir_getsector
	cmpa	#1	;load?
	beq	disk_dir_contdl
; oops failed
	inc	disk_dir_retry
	lda	disk_dir_retry
	cmpa	#12
	blo	disk_dir_loopd1	;disk_dir_retry
	clra
	sta	$ff40
	rts	;failed and lets exit
disk_dir_contdl
	clr	disk_dir_retry	;reset disk_dir_retry counter cause last one loaded
	ldx	disk_dir_sect	; 256 byte temp
; start look
	ldu	disk_dir_sect
	lda	disk_dir_dcfiles
	ldb	#16
	mul
	leau	d,u
disk_dir_loopd2
	lda	disk_dir_dcfiles
	cmpa	#67
	bhs	disk_dir_loopd4	;done lets exit
	clrb
disk_dir_loopd3
	lda	b,x
	sta	,u+
	incb
	cmpb	#16
	blo	disk_dir_loopd3
	leax	32,x	;next file
	inc	disk_dir_dcfiles
	cmpx	disk_dir_tempd
	blo	disk_dir_loopd2
	inc	disk_dir_bcnt	;sector counter
	ldb	disk_dir_bcnt
	cmpb	#12	;sector 9 is 68 files
	blo	disk_dir_loopd1
disk_dir_loopd4
	clra
	sta	$ff40
	lda	#1
	rts	;exit and we are done
; *************************
; * disk_dir_getsector
; *************************
; try 6 times then fail
disk_dir_getsector
	ldx	$c006
	lda	disk_dir_dcopc
	sta	0,x
	lda	disk_dir_drive
	sta	1,x
	lda	disk_dir_dctrk
	sta	2,x
	lda	disk_dir_dsect
	sta	3,x
	ldd	disk_dir_sect
	std	4,x
	clr	disk_dir_retry
disk_dir_retr1
	jsr	[$c004]	;run ml routine
; check for errors
	ldx	$c006
	lda	6,x
	sta	disk_dir_dcsta
	beq	disk_dir_good1
; not good
	inc	disk_dir_retry
	lda	disk_dir_retry
	cmpa	#12
	blo	disk_dir_retr1
	clra
	rts	;failed 0 returned on a
; lets copy 68 granuals of data
disk_dir_good1
	lda	#1
	rts
disk_dir_copysect
	ldu	disk_dir_gran
	ldx	disk_dir_sect	;256 byte temp table
	clrb
disk_dir_loopm
	lda	,x+
	sta	,u+
	incb
	cmpb	#68	;data 0-67
	blo	disk_dir_loopm
	rts	;return
endfunction
;





; *************************************************************************************************************
; * disk_find(filename$,filetable pointer)
; *************************************************************************************************************
function	disk_find	disk_find_savex,disk_find_saveu
rem	disk_find(file name pointer, file list pointer) "myfile01bas"=11 chrs and the file pointer list
rem	see examples dsk returns file number to b reg
rem	
rem	

def	disk_find_savex	word
def	disk_find_saveu	word
def	disk_find_temp2	byte
def	disk_find_fndfile	byte	;file location

stack	x,u

disk_find

	ldu	disk_find_saveu
	lda	#255
	sta	disk_find_fndfile
	clr	disk_find_temp2
disk_find_fndlp0
	ldx	disk_find_savex
	clrb
disk_find_fndlp1
	lda	b,x
	cmpa	b,u
	bne	disk_find_nomat
	incb
	cmpb	#11
	blo	disk_find_fndlp1
disk_find_match
	ldb	disk_find_temp2
	stb	disk_find_fndfile
	rts	;b has file number	
disk_find_nomat
	leau	16,u
	inc	disk_find_temp2
	lda	disk_find_temp2
	cmpa	#67
	bls	disk_find_fndlp0
; complete fail
	ldb	#255
	rts

endfunction







;***************************************************************************************************************************************************
;disk_loadsector( drive,track,sector,bytes256 pointer)
;***************************************************************************************************************************************************
function	disk_loadsector	disk_loadsector_d,disk_loadsector_t,disk_loadsector_s,disk_loadsector_256
rem	disk_loadsector( drive.b , track.b , sector.b , 256byte_table.w )
rem	loads contents from disk to table for examination
rem	
rem	
def	disk_loadsector_d	byte
def	disk_loadsector_t	byte
def	disk_loadsector_s	byte
def	disk_loadsector_256	word
def	disk_loadsector_retry	byte
def	disk_loadsector_dcsta	byte
disk_loadsector
	orcc	#$50	;kill irq	for loading
	ldx	$c006
	lda	#2	;read
	sta	0,x
	lda	disk_loadsector_d
	sta	1,x
	lda	disk_loadsector_t
	sta	2,x
	lda	disk_loadsector_s
	sta	3,x
	ldd	disk_loadsector_256
	std	4,x
	clr	disk_loadsector_retry
disk_loadsector_retr1
	jsr	[$c004]	;run ml routine
; check for errors
	ldx	$c006
	lda	6,x
	sta	disk_loadsector_dcsta
	beq	disk_loadsector_good1
; not good
	inc	disk_loadsector_retry
	lda	disk_loadsector_retry
	cmpa	#12
	blo	disk_loadsector_retr1
	clra
	sta	$ff40
	andcc	#$ef
	rts	;failed 0 returned on a
disk_loadsector_good1
	clra
	sta	$ff40
	lda	#1
	andcc	#$ef
	rts
endfunction






; ****************************************************************************************************************************
; * disk_loadm( drive, filename$, bytewrite,bytes256 pointer, gran68 pointer)
; ****************************************************************************************************************************
function	disk_loadm	disk_loadm_dcdrv,disk_loadm_savex,disk_loadm_bytewrite,disk_loadm_dcbpt,disk_loadm_saveu,disk_loadm_b16
rem	disk_loadm( drive.b , filename.w , header start.w , buffer.w ,granuals.w , 16byte.w)
rem	see examples
rem	
rem	


def	disk_loadm_saveu	word	;68 granual table
def	disk_loadm_savex	word	;filename loc
def	disk_loadm_dcopc	byte	;op code
def	disk_loadm_dcdrv	byte	;drive number
def	disk_loadm_dctrk	byte	;track
def	disk_loadm_dcsec	byte	;sector
def	disk_loadm_header	byte	;=1 if it does not use header system
def	disk_loadm_dcbpt	word	;256byte table
def	disk_loadm_dcsta	byte	;error report
def	disk_loadm_retry	byte	;how many retries before giving up
def	disk_loadm_bcnt	byte	;b counter
def	disk_loadm_dcfiles	byte	;files found
def	disk_loadm_tempd	word	;end256byte tbl
def	disk_loadm_fndfile	byte	;file number
def	disk_loadm_mach1	byte
def	disk_loadm_mach2	word
def	disk_loadm_firstgran	byte
def	disk_loadm_lastbytes	byte
def	disk_loadm_nextgran	byte
def	disk_loadm_readtrk	byte
def	disk_loadm_readsec	byte
def	disk_loadm_readsec2	byte
def	disk_loadm_bytestof	word
def	disk_loadm_bytescntr	word
def	disk_loadm_bytewrite	word
def	disk_loadm_gran	byte
def	disk_loadm_temp2	byte
def	disk_loadm_temp	byte
def	disk_loadm_chfile	byte	;safety check
def	disk_loadm_lastgr	byte

def	disk_loadm_b16	word

stack	x,y,u

disk_loadm

	orcc	#$50	;kill irq	for loading
;	lda	#1
	sta	$ffde	;ram/rom
	clr	disk_loadm_bcnt
	lda	#1
	sta	disk_loadm_header
	ldd	disk_loadm_bytewrite
	cmpd	#0
	bne	disk_loadm_contdl1
	clr	disk_loadm_header
disk_loadm_contdl1
	ldx	disk_loadm_savex
	ldy	disk_loadm_dcbpt
	ldu	disk_loadm_saveu

	ldd	disk_loadm_dcbpt
	addd	#250
	std	disk_loadm_tempd	;256 bytes cut off look
	clr	disk_loadm_lastgr
; ok setup for grabing granual table
	lda	#2
	sta	disk_loadm_dcopc
	lda	#17
	sta	disk_loadm_dctrk
	lda	#2
	sta	disk_loadm_dcsec
	jsr	disk_loadm_getsector
	cmpa	#1
	beq	disk_loadm_nextp1	;it loaded
; problem
	clrb
	clra
	sta	$ff40
	andcc	#$ef
	rts	;return 0 as did not load
; its good lets grab granuals

disk_loadm_nextp1
	jsr	disk_loadm_copysect
; ok so we need to grab directory and search for a match
	ldb	#3	;start search on sector 3
	stb	disk_loadm_bcnt	;save counter
	clr	disk_loadm_retry
	clr	disk_loadm_dcfiles
disk_loadm_loopd1
	ldb	disk_loadm_bcnt
	stb	disk_loadm_dcsec	;store sector search
	jsr	disk_loadm_getsector
	cmpa	#1	;load?
	beq	disk_loadm_contdl
; oops failed
	inc	disk_loadm_retry
	lda	disk_loadm_retry
	cmpa	#6
	blo	disk_loadm_loopd1	;retry
disk_loadm_exiterror
	clrb
	clra
	sta	$ff40
	andcc	#$ef
	rts	;done exiting in error 
; 
disk_loadm_contdl
	clr	disk_loadm_retry
	ldx	disk_loadm_dcbpt	;256 byte table
; start looking for file match
	ldu	disk_loadm_savex	;get addr
	clrb
disk_loadm_fndlp1
	lda	b,x
	cmpa	b,u
	bne	disk_loadm_nomat
	incb	;it looks to be starting to match
	cmpb	#11
	blo	disk_loadm_fndlp1
; ok we found the file
disk_loadm_match
	lbra	disk_loadm_loadm	;jump to loadm
disk_loadm_nomat
	leax	32,x	;jump to next file
	inc	disk_loadm_dcfiles	;lets look at next file
	lda	disk_loadm_dcfiles
	cmpa	#68
	lbhs	disk_loadm_exiterror	;exit in error
	clrb	;clear b register
	cmpx	disk_loadm_tempd
	blo	disk_loadm_fndlp1	;lets look at next file
; ok we have gone over
	inc	disk_loadm_bcnt
	ldb	disk_loadm_bcnt	;load the sector and increase it
	cmpb	#12
	lblo	disk_loadm_loopd1
	lbra	disk_loadm_exiterror	;bad exit
; * get sector 
disk_loadm_getsector
	ldx	$c006
	lda	disk_loadm_dcopc
	sta	0,x
	lda	disk_loadm_dcdrv
	sta	1,x
	lda	disk_loadm_dctrk
	sta	2,x
	lda	disk_loadm_dcsec
	sta	3,x
	ldd	disk_loadm_dcbpt
	std	4,x
	clr	disk_loadm_retry
disk_loadm_retr1
	jsr	[$c004]	;run ml
; check for errors
	ldx	$c006
	lda	6,x
	sta	disk_loadm_dcsta
	beq	disk_loadm_good1
; not good
	inc	disk_loadm_retry
	lda	disk_loadm_retry
	cmpa	#12
	blo	disk_loadm_retr1
	clra
	rts	;failed and 0 returned to a reg
; its good
disk_loadm_good1
	lda	#1
	rts	;return good
; * copy sect
disk_loadm_copysect
	ldu	disk_loadm_saveu
	ldx	disk_loadm_dcbpt
	clrb
disk_loadm_loopm
	lda	,x+
	sta	,u+
	incb
	cmpb	#68	;data 0-67
	blo	disk_loadm_loopm
	rts	;done
; * load it 
; x has file marker on 256 byte table
; u has filename but its been confirmed exists
disk_loadm_loadm
	lda	13,x	;first granual 0-67
	sta	disk_loadm_firstgran
	lda	15,x
	sta	disk_loadm_lastbytes	;last bytes of the last sector


;hack into file header 16 bytes
	ldu	disk_loadm_b16
	ldd	16,x
	std	0,u
	ldd	18,x
	std	2,u
	ldd	20,x
	std	4,u
	ldd	22,x
	std	6,u
	ldd	24,x
	std	8,u
	ldd	26,x
	std	10,u
	ldd	28,x
	std	12,u
	ldd	30,x
	std	14,u
;hacked


	ldu	disk_loadm_saveu	;load the 68byte gran table
	lda	disk_loadm_firstgran
	ldb	a,u
	stb	disk_loadm_nextgran
	lda	disk_loadm_firstgran
	jsr	disk_loadm_setdisk
	clra
	clrb
	std	disk_loadm_bytestof	;starts with needing a header
	std	disk_loadm_bytescntr	;the counter
; transfer loop start
disk_loadm_transfer2
	lda	disk_loadm_readtrk
	sta	disk_loadm_dctrk
	lda	disk_loadm_readsec
	sta	disk_loadm_dcsec
	clr	disk_loadm_retry
disk_loadm_tfrretry
	jsr	disk_loadm_getsector
	cmpa	#1	;load?
	beq	disk_loadm_tfrsucc
; oops failed
	inc	disk_loadm_retry
	lda	disk_loadm_retry
	cmpa	#6
	bls	disk_loadm_tfrretry	;retry
	clrb
	rts	;done exiting in error 
; process data
disk_loadm_tfrsucc
	clr	disk_loadm_temp
	ldx	disk_loadm_dcbpt	;256 byte table
; check no header?
	lda	disk_loadm_header
	bne	disk_loadm_transfer1	;just get the data =1 if no header
	ldd	disk_loadm_bytestof
	cmpd	#0
	bne	disk_loadm_transfer1
disk_loadm_newhd
	ldx	disk_loadm_dcbpt	;the buffer
	ldb	disk_loadm_temp
	abx
	lda	0,x
	beq	disk_loadm_grabheader
	cmpa	#255
	beq	disk_loadm_footer
; exit in error
	lbne	disk_loadm_exiterror
; was footer
disk_loadm_footer
	ldd	3,x
	std	disk_loadm_mach2
	jmp	disk_loadm_donebasld	;we are done and loaded
disk_loadm_grabheader
	ldd	1,x
	std	disk_loadm_bytestof
	ldb	#5	;play with this number
	addb	disk_loadm_temp
	stb	disk_loadm_temp
	clra
	clrb
	std	disk_loadm_bytescntr
	ldd	3,x
	std	disk_loadm_bytewrite	;reset y addr write
; transfer actual
disk_loadm_transfer1
	ldx	disk_loadm_dcbpt
	ldy	disk_loadm_bytewrite
	ldb	disk_loadm_temp
	abx
	lda	,x
	sta	$ffdf	;ram/rom return ffdf =ramram
	sta	,y+
	sta	$ffde	;ram/rom
	sty	disk_loadm_bytewrite
	inc	disk_loadm_temp
; is this the end
; does it have a header?
	lda	disk_loadm_header
	bne	disk_loadm_itsfinecnt	;needs to skip header checks
; has header system
	ldd	disk_loadm_bytescntr
	addd	#1
	std	disk_loadm_bytescntr
; is it mach1
; yes it is
	ldd	disk_loadm_bytescntr
	cmpd	disk_loadm_bytestof
; may need adjustment
	bhs	disk_loadm_newhd	;need new header
disk_loadm_itsfinecnt
	lda	disk_loadm_nextgran
	cmpa	#192
	blo	disk_loadm_notlastg1
; yes last but final?
	lda	#1
	sta	disk_loadm_lastgr	;safety
	lda	disk_loadm_readsec
	cmpa	disk_loadm_readsec2
; bne possibly? instead of blo
	blo	disk_loadm_notlastg1
; yes last chunk
	ldb	disk_loadm_temp
	cmpb	disk_loadm_lastbytes
	lbhs	disk_loadm_donebasld	;its done loading exit for no header also
disk_loadm_notlastg1
	ldb	disk_loadm_temp
	cmpb	#0	;should be 0
	lbne	disk_loadm_transfer1
; end of inner loop

	inc	disk_loadm_readsec
	lda	disk_loadm_readsec
	cmpa	disk_loadm_readsec2
	lbls	disk_loadm_transfer2
; now its same
	lda	disk_loadm_lastgr
	cmpa	#1
	bne	disk_loadm_getnextgg
; run a test
	lda	disk_loadm_lastbytes
	cmpa	#0
	beq	disk_loadm_donebasld
	lbra	disk_loadm_transfer2
; now we need next gran
disk_loadm_getnextgg
	lda	disk_loadm_nextgran
	cmpa	#192
	bhs	disk_loadm_donebasld	;done loading
	sta	disk_loadm_firstgran
	ldu	disk_loadm_saveu
	ldb	a,u
	stb	disk_loadm_nextgran
	lda	disk_loadm_firstgran
	jsr	disk_loadm_setdisk
	lbra	disk_loadm_transfer2
disk_loadm_donebasld
	ldd	disk_loadm_mach2
	std	157
	clra
	ldb	#1
	sta	$ff40
	andcc	#$ef
	rts	;its loaded exit with b=1 

; function of finding track,sector,granual
disk_loadm_setdisk
	clr	disk_loadm_readsec
	clr	disk_loadm_readsec2
	sta	disk_loadm_gran
	lsra
	sta	disk_loadm_readtrk
	cmpa	#17
	bhs	disk_loadm_trkadd
disk_loadm_getds1
	lda	disk_loadm_gran
	anda	#1
	ldb	#1
	stb	disk_loadm_readsec
	ldb	#9
	stb	disk_loadm_readsec2
	cmpa	#1
	beq	disk_loadm_sect1
	bra	disk_loadm_isdske
disk_loadm_sect1
	ldb	#10
	stb	disk_loadm_readsec
	ldb	#18
	stb	disk_loadm_readsec2
	bra	disk_loadm_isdske
disk_loadm_trkadd
	adda	#1
	sta	disk_loadm_readtrk
	bra	disk_loadm_getds1
disk_loadm_isdske
	lda	disk_loadm_nextgran
	cmpa	#68
	bls	disk_loadm_fullsetd
	suba	#193
	sta	disk_loadm_temp2
	lda	disk_loadm_readsec
	adda	disk_loadm_temp2
	sta	disk_loadm_readsec2

disk_loadm_fullsetd
	ldb	disk_loadm_readsec
	clra
	rts
endfunction




;
; ****************************************************************************************************************************
; * disk_savem( drive, header on, filename$,bytewrite,sizef,bytes256 pointer, gran68 pointer,disk_savem_save16)
; ****************************************************************************************************************************
function	disk_savem	disk_savem_dcdrv,disk_savem_header,disk_savem_savex,disk_savem_bytewrite,disk_savem_sizef,disk_savem_dcbpt,disk_savem_saveu,disk_savem_save16
rem	disk_savem( drive.b , no_header.b , filename.w , savestart.w, saveend.w , buffer.w , granuals.w , 16bytes.w)
rem	see examples
rem	
rem	


def	disk_savem_dcbpt	word	;256byte table
def	disk_savem_sizef	word	;size of file to write
def	disk_savem_saveu	word	;68 granual table
def	disk_savem_savex	word	;filename loc
def	disk_savem_dcopc	byte	;op code
def	disk_savem_dcdrv	byte	;drive number
def	disk_savem_dctrk	byte	;track
def	disk_savem_dcsec	byte	;sector
def	disk_savem_header	byte	;=1 if it does not use header system
def	disk_savem_dcsta	byte	;error report
def	disk_savem_retry	byte	;how many retries before giving up
def	disk_savem_bcnt	byte	;b counter
def	disk_savem_dcfiles	byte	;files found
def	disk_savem_tempd	word	;end256byte tbl
def	disk_savem_fndfile	byte	;file number
def	disk_savem_mach1	byte
def	disk_savem_mach2	word
def	disk_savem_firstgran	byte
def	disk_savem_lastbytes	byte
def	disk_savem_nextgran	byte
def	disk_savem_readtrk	byte
def	disk_savem_readsec	byte
def	disk_savem_readsec2	byte
def	disk_savem_bytestof	word
def	disk_savem_bytescntr	word
def	disk_savem_bytewrite	word
def	disk_savem_gran	byte
def	disk_savem_temp2	byte
def	disk_savem_temp3	word
def	disk_savem_temp	byte
def	disk_savem_chfile	byte	;safety check
def	disk_savem_lastgr	byte
def	disk_savem_usefilen	byte	;file number to save to
def	disk_savem_usefiles	byte	;sector file is located on
def	disk_savem_save16	word

;def	disk_savem_erase	byte	;erase existing grans

stack	x,y,u

disk_savem

; file exists?
;	lda	#255	;says no
;	sta	disk_savem_erase

	orcc	#$50
	lda	#1
	sta	$ffde
	lda	#255
	sta	disk_savem_usefilen
	clr	disk_savem_usefiles
	clr	disk_savem_bcnt
disk_savem_contdl1
	ldx	disk_savem_savex
	ldy	disk_savem_dcbpt	;only store
	ldu	disk_savem_saveu
	ldd	disk_savem_dcbpt
	addd	#250
	std	disk_savem_tempd	;256 bytes cut off look
	clr	disk_savem_lastgr
; ok setup for grabing granual table
	lda	#2
	sta	disk_savem_dcopc
	lda	#17
	sta	disk_savem_dctrk
	lda	#2
	sta	disk_savem_dcsec
	jsr	disk_savem_getsector
	cmpa	#1
	beq	disk_savem_nextp1	;it loaded
; problem
	lbra	disk_savem_exiterror8
; its good lets grab granuals
disk_savem_nextp1
	jsr	disk_savem_copysect
; ok so we need to grab directory and search for a match
	ldb	#3	;start search on sector 3
	stb	disk_savem_bcnt	;save counter
	clr	disk_savem_retry
	clr	disk_savem_dcfiles
disk_savem_loopd1
	ldb	disk_savem_bcnt
	stb	disk_savem_dcsec	;store sector search
	jsr	disk_savem_getsector
	cmpa	#1	;load?
	beq	disk_savem_contdl
; oops failed
	inc	disk_savem_retry
	lda	disk_savem_retry
	cmpa	#6
	blo	disk_savem_loopd1	;retry
disk_savem_exiterror
	clrb
	clra
	sta	$ff40
	andcc	#$ef
	rts	;done exiting in error ***************************************************************
; 
disk_savem_contdl
	clr	disk_savem_retry
	ldx	disk_savem_dcbpt	;256 byte table
; start looking for file match
; also look for first free file number and save its pos on file chain
	ldu	disk_savem_savex	;get gran info
disk_savem_fndlp1
	clrb
	inc	disk_savem_dcfiles
	lda	b,x
	beq	disk_savem_fndlp7	;could be 0
	cmpa	#255	;could be 255 
	bne	disk_savem_fndlp2
; if marker is blank lets call it a spot to save
disk_savem_fndlp7
	lda	disk_savem_usefilen
	cmpa	#255
	beq	disk_savem_fndlp3
	bra	disk_savem_fndlp2
; ok lets record first blank file
disk_savem_fndlp3
	lda	disk_savem_dcfiles
	sta	disk_savem_usefilen
	lda	disk_savem_bcnt
	sta	disk_savem_usefiles	;its sector
disk_savem_fndlp2
	lda	b,x
	cmpa	b,u
	bne	disk_savem_nomat
	incb	;it looks to be starting to match
	cmpb	#11
	blo	disk_savem_fndlp2


; ok we found the file
disk_savem_match
	lda	disk_savem_dcfiles
	sta	disk_savem_usefilen
	lda	disk_savem_dcsec
	sta	disk_savem_usefiles

; mark that we need to chase delete granuals

;	lda	13,x	
;	sta	disk_savem_erase
;	jsr	disk_savem_chasekill

	lbra	disk_savem_savem	;jump to loadm

disk_savem_nomat
	leax	32,x	;jump to next file
	clrb	;clear b register
	cmpx	disk_savem_tempd
	blo	disk_savem_fndlp1	;lets look at next file
; ok we have gone over
	lda	#0
	sta	disk_savem_dcfiles
	inc	disk_savem_bcnt
	ldb	disk_savem_bcnt	;load the sector and increase it
	cmpb	#12
	lblo	disk_savem_loopd1
	lbra	disk_savem_savem	;bad exit but see if we have a file num anyways
; * get sector *****************************************************
disk_savem_getsector
	ldx	$c006
	lda	disk_savem_dcopc
	sta	0,x
	lda	disk_savem_dcdrv
	sta	1,x
	lda	disk_savem_dctrk
	sta	2,x
	lda	disk_savem_dcsec
	sta	3,x
	ldd	disk_savem_dcbpt
	std	4,x
	clr	disk_savem_retry
disk_savem_retr1
	jsr	[$c004]	;run ml
; check for errors
	ldx	$c006
	lda	6,x
	sta	disk_savem_dcsta
	beq	disk_savem_good1
; not good
	inc	disk_savem_retry
	lda	disk_savem_retry
	cmpa	#12
	blo	disk_savem_retr1
	lbra	disk_savem_exiterror9
; its good
disk_savem_good1
	lda	#1
	rts	;return good
; * copy sect *************************************************************
disk_savem_copysect
	ldu	disk_savem_saveu
	ldx	disk_savem_dcbpt
	clrb
disk_savem_loopm
	lda	,x+
	sta	,u+
	incb
	cmpb	#68	;data 0-67
	blo	disk_savem_loopm
	rts	;done
; * load it **********************************************************************************************
; x has file marker on 256 byte table
; u has filename but its been confirmed exists
disk_savem_savem
	lda	disk_savem_usefilen	; file 3 sector 3 seems ok
	cmpa	#255
	lbeq	disk_savem_exiterror11	;no files avail
; ok lets reload the sector data file system i was on
	lda	#2
	sta	disk_savem_dcopc	;read
	lda	disk_savem_usefiles
	sta	disk_savem_dcsec
	lda	#17
	sta	disk_savem_dctrk
	jsr	disk_savem_getsector
	bne	disk_savem_savem1	;its set
	lbra	disk_savem_exiterror6	;problems
disk_savem_savem1
	clr	disk_savem_temp
	ldx	disk_savem_dcbpt	;the 256 byte table
	ldb	disk_savem_usefilen
	decb
	lda	#32
	mul
	leax	d,x	;should be looking at correct file
	lda	0,x
	cmpa	#255
	beq	disk_savem_nocounth
	ldb	13,x	;loaded first granual on b
disk_savem_checkhh
	ldu	disk_savem_saveu	;load the granual table
	lda	b,u	;read granual
	sta	disk_savem_temp
	lda	#255
	sta	b,u	;erase original ready
	lda	disk_savem_temp
	cmpa	#192
	bhs	disk_savem_nocounth
	ldb	disk_savem_temp
	bra	disk_savem_checkhh
; was no file or we counted it
disk_savem_nocounth
	clr	disk_savem_temp
	ldu	disk_savem_saveu	;68 byte gran table
	clrb
disk_savem_ccnt1
	lda	b,u
	cmpa	#255
	bne	disk_savem_jump1
	inc	disk_savem_temp
disk_savem_jump1
	incb
	cmpb	#68
	bhs	disk_savem_donecnt
	bra	disk_savem_ccnt1
; hack
; usefilen has file number
; usefiles has the sector
; calc my space bytescntr
disk_savem_donecnt
	clra
	clrb
	std	disk_savem_bytescntr
disk_savem_lpcntr
	lda	disk_savem_temp	; possibly a zero by accident?
	cmpa	#28
	bhs	disk_savem_donemc2	;too big lots of space avail
	cmpa	#0
	beq	disk_savem_donemc
	dec	disk_savem_temp
	ldd	disk_savem_bytescntr
	addd	#2304
	std	disk_savem_bytescntr
	bra	disk_savem_lpcntr
disk_savem_donemc
	ldd	disk_savem_sizef
	subd	disk_savem_bytewrite
	std	disk_savem_bytestof	;bytes to save
	cmpd	disk_savem_bytescntr
	blo	disk_savem_yupwes
	ldd	#10000	;error 10
	rts	;nope no space avail
disk_savem_donemc2
	ldd	disk_savem_sizef
	subd	disk_savem_bytewrite
	std	disk_savem_bytestof	;bytes to save
; this works
disk_savem_yupwes
	lda	disk_savem_header	;1= no header 0=header
	bne	disk_savem_nohead1
	ldd	disk_savem_bytestof
	addd	#10
	std	disk_savem_temp3
	bra	disk_savem_lpendb
disk_savem_nohead1
	ldd	disk_savem_bytestof
	std	disk_savem_temp3
disk_savem_lpendb
	ldd	disk_savem_temp3
	cmpd	#256
	blo	disk_savem_lpgotv
	subd	#256
	std	disk_savem_temp3
	bra	disk_savem_lpendb
; got the value
disk_savem_lpgotv
	stb	disk_savem_lastbytes
	lda	disk_savem_usefilen
	suba	#1
	ldb	#32
	mul
	ldx	disk_savem_dcbpt	;256 byte table
	leax	d,x	;at file
; lets copy new file name over
	ldy	disk_savem_savex	;the file name transfer 11 bytes
	clrb
disk_savem_copynm
	lda	b,y
	sta	b,x
	incb
	cmpb	#12
	blo	disk_savem_copynm	;continue name copy
; cont
	lda	#2
	sta	11,x	; file type bin
	lda	#0
	sta	12,x	; not ascii
	jsr	disk_savem_freegran	;only use u return on a
	sta	disk_savem_gran
	sta	13,x	;store first gran
	clr	14,x
	lda	disk_savem_lastbytes
	sta	15,x	;how many bytes

;hack into file header 16 bytes
	ldu	disk_savem_save16

	ldd	0,u
	std	16,x
	ldd	2,u
	std	18,x
	ldd	4,u
	std	20,x
	ldd	6,u
	std	22,x
	ldd	8,u
	std	24,x
	ldd	10,u
	std	26,x
	ldd	12,u
	std	28,x
	ldd	14,u
	std	30,x

; ok so far so good
	lda	#3
	sta	disk_savem_dcopc	;change to write status
	lda	disk_savem_usefiles	;the file sector
	sta	disk_savem_dcsec
	lda	#17
	sta	disk_savem_dctrk
	jsr	disk_savem_getsector	;lets see if i changed the name?
	lbeq	disk_savem_exiterror5	;exit in error
; setup sector range
	lda	disk_savem_gran	;first granual
	sta	disk_savem_firstgran
	jsr	disk_savem_setdisk	;this gives me the range
; x=dcbpt
; y=data
disk_savem_copyits
	ldy	disk_savem_bytewrite	;start of read
	ldx	disk_savem_dcbpt	;256 byte buffer
; bytestof has how many bytes not including header
; header ?
	clrb
	clra
	std	disk_savem_bytescntr	;counter
	clr	disk_savem_temp	;256 counter	
	lda	disk_savem_header
	beq	disk_savem_jumphead
	bra	disk_savem_noheadj
disk_savem_jumphead
	lda	#0
	ldb	disk_savem_temp	;256 byte counter
	abx
	sta	,x+
	ldd	disk_savem_bytestof
	std	,x++
	ldd	disk_savem_bytewrite
	std	,x++
	ldb	disk_savem_temp
	addb	#5
	stb	disk_savem_temp
	ldx	disk_savem_dcbpt
; transfer code
disk_savem_noheadj
	ldx	disk_savem_dcbpt
	ldb	disk_savem_temp
	abx
	sta	$ffdf
	lda	,y+	;load from potential ram/ram
	sta	$ffde
	sta	,x	;
	ldd	disk_savem_bytescntr
	addd	#1
	std	disk_savem_bytescntr
	inc	disk_savem_temp
; do a check if last bytes
	ldd	disk_savem_bytescntr
	cmpd	disk_savem_bytestof
	bhs	disk_savem_wedonewg	;we are done write out granual table and call it a day***********************
	lda	disk_savem_temp
	beq	disk_savem_writeouts
	bra	disk_savem_noheadj
disk_savem_writeouts
	lda	#3
	sta	disk_savem_dcopc	;change to write status
	lda	disk_savem_readsec
	sta	disk_savem_dcsec
	lda	disk_savem_readtrk
	sta	disk_savem_dctrk
	jsr	disk_savem_getsector	;lets see if i changed the name?
	lbeq	disk_savem_exiterror4	;exit in error
; wrote it? i hope...
	inc	disk_savem_readsec
	lda	disk_savem_readsec
	cmpa	disk_savem_readsec2
	lbls	disk_savem_noheadj	;keep the copy going
; ok at this point i need another granual
	ldu	disk_savem_saveu	;grantable
	ldb	disk_savem_firstgran
	lda	#99	;temp
	sta	b,u
	jsr	disk_savem_freegran	;exits with new granual on a
	sta	disk_savem_nextgran
	ldb	disk_savem_firstgran
	sta	b,u	;ok i hope its set fixes that 99 write
	lda	disk_savem_nextgran
	sta	disk_savem_firstgran
	clr	disk_savem_nextgran
	jsr	disk_savem_setdisk
	lbra	disk_savem_noheadj
disk_savem_wedonewg
	lda	disk_savem_header	;1=no header
	beq	disk_savem_addfoot
	bra	disk_savem_nofoot
disk_savem_addfoot
	ldb	disk_savem_temp
	ldx	disk_savem_dcbpt
	abx
	lda	#255	;end file
	sta	,x+
	ldd	#0
	std	,x++
	ldd	disk_savem_bytewrite
	std	,x++
	ldb	disk_savem_temp
	addb	#5
	stb	disk_savem_temp
disk_savem_nofoot
	ldx	disk_savem_dcbpt
	lda	disk_savem_readsec
	cmpa	#10
	blo	disk_savem_itsg55
; its range is 10-18
	suba	#9
; range 1-9
; its range is 1-9
disk_savem_itsg55
	adda	#192	;c0
	sta	disk_savem_nextgran	temp
	lda	disk_savem_lastbytes
; hack dunno
	beq	disk_savem_addmore
	bra	disk_savem_nodont	;this needed a fix i think
disk_savem_addmore
	inc	disk_savem_nextgran
disk_savem_nodont
	lda	disk_savem_nextgran
	ldb	disk_savem_firstgran
	sta	b,u	;saved it hopefully
; write out new granual table
; * copy sector new data *************************************************************
	lda	#3
	sta	disk_savem_dcopc	;change to write status
	lda	disk_savem_readsec
	sta	disk_savem_dcsec
	lda	disk_savem_readtrk
	sta	disk_savem_dctrk
	jsr	disk_savem_getsector	;last sec
	lbeq	disk_savem_exiterror3	;exit in error
; wrote it? i hope...
	ldu	disk_savem_saveu
	ldx	disk_savem_dcbpt
	clrb
disk_savem_loopm3
	lda	,u+
	sta	,x+
	incb
	cmpb	#68	;data 0-67
	blo	disk_savem_loopm3
	lda	#0
disk_savem_lpdf
	sta	,x+
	incb
	bne	disk_savem_lpdf
	lda	#3
	sta	disk_savem_dcopc	;change to write status
	lda	#2
	sta	disk_savem_dcsec
	lda	#17
	sta	disk_savem_dctrk
	jsr	disk_savem_getsector	;lets see if i changed the name?
	lbeq	disk_savem_exiterror2
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#1000	;pass
	rts	;its loaded exit with b=1
disk_savem_exiterror2
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#2000
	rts
disk_savem_exiterror3
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#3000
	rts
disk_savem_exiterror4
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#4000
	rts
disk_savem_exiterror5
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#5000
	rts
disk_savem_exiterror6
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#6000
	rts
disk_savem_exiterror7
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#7000
	rts
disk_savem_exiterror8
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#8000
	rts
disk_savem_exiterror9
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#9000
	rts
disk_savem_exiterror11
	clra
	sta	$ff40
	andcc	#$ef
	ldd	#11000
	rts
; ********************************************************************************************************
; of finding track,sector,granual
disk_savem_setdisk
	clr	disk_savem_readsec
	clr	disk_savem_readsec2
	sta	disk_savem_gran
	lsra
	sta	disk_savem_readtrk
	cmpa	#17
	bhs	disk_savem_trkadd
disk_savem_getds1
	lda	disk_savem_gran
	anda	#1
	ldb	#1
	stb	disk_savem_readsec
	ldb	#9
	stb	disk_savem_readsec2
	cmpa	#1
	beq	disk_savem_sect1
	bra	disk_savem_isdske
disk_savem_sect1
	ldb	#10
	stb	disk_savem_readsec
	ldb	#18
	stb	disk_savem_readsec2
	bra	disk_savem_isdske
disk_savem_trkadd
	adda	#1
	sta	disk_savem_readtrk
	bra	disk_savem_getds1
disk_savem_isdske
	clra
disk_savem_fullsetd
	clrb
	clra
	rts
; ok*******************************************************************************************************************
disk_savem_freegran
	ldu	disk_savem_saveu	;gran table
	clra
disk_savem_lpfree
	ldb	a,u
	cmpb	#255
	beq	disk_savem_yupfg
	inca
	bra	disk_savem_lpfree
disk_savem_yupfg
	rts	;exit with gran on a



;**********************************************kill granual list

;disk_savem_chasekill
;
;
;	pshs	u
;	ldu	disk_savem_saveu
;	lda	disk_savem_erase
;	cmpa	#68
;	bhi	disk_savem_chasekille
;
;disk_savem_chasekilllp
;
;	ldb	disk_savem_erase	;load the first gran
;	cmpb	#255
;	beq	disk_savem_chasekille
;	lda	b,u
;	sta	disk_savem_erase	;save
;	lda	#255
;	sta	b,u
;	lda	disk_savem_erase
;	cmpa	#191
;	blo	disk_savem_chasekilllp
;
;disk_savem_chasekille
;	puls	u
;	rts


endfunction










; ****************************************************************************************************************************
; * disk_loadmcount( drive, filename$,bytes256 pointer, gran68 pointer)
; ****************************************************************************************************************************
function	disk_loadmcount	disk_loadmcount_dcdrv,disk_loadmcount_savex,disk_loadmcount_dcbpt,disk_loadmcount_saveu
rem	disk_loadmcount( drive.b , filename.w , buffer.w ,granuals.w )
rem	returns how big file is in bytes on y register and does no loading
rem

def	disk_loadmcount_dcdrv	byte

def	disk_loadmcount_saveu	word	;68 granual table
def	disk_loadmcount_savex	word	;filename loc
def	disk_loadmcount_dcopc	byte	;op code
def	disk_loadmcount_dcdrv	byte	;drive number
def	disk_loadmcount_dctrk	byte	;track
def	disk_loadmcount_dcsec	byte	;sector
def	disk_loadmcount_header	byte	;=1 if it does not use header system
def	disk_loadmcount_dcbpt	word	;256byte table
def	disk_loadmcount_dcsta	byte	;error report
def	disk_loadmcount_retry	byte	;how many retries before giving up
def	disk_loadmcount_bcnt	byte	;b counter
def	disk_loadmcount_dcfiles	byte	;files found
def	disk_loadmcount_tempd	word	;end256byte tbl
def	disk_loadmcount_fndfile	byte	;file number
def	disk_loadmcount_mach1	byte
def	disk_loadmcount_mach2	word
def	disk_loadmcount_firstgran	byte
def	disk_loadmcount_lastbytes	byte
def	disk_loadmcount_nextgran	byte
def	disk_loadmcount_readtrk	byte
def	disk_loadmcount_readsec	byte
def	disk_loadmcount_readsec2	byte
def	disk_loadmcount_bytestof	word
def	disk_loadmcount_bytescntr	word
def	disk_loadmcount_bytewrite	word	;hack
def	disk_loadmcount_gran	byte
def	disk_loadmcount_temp2	byte
def	disk_loadmcount_temp	byte
def	disk_loadmcount_chfile	byte	;safety check
def	disk_loadmcount_lastgr	byte

stack	x,y,u

disk_loadmcount

	orcc	#$50
	lda	#1
	sta	$ffde
	clr	disk_loadmcount_bcnt
	lda	#1
	sta	disk_loadmcount_header
	ldb	#1
	clra
	std	disk_loadmcount_bytewrite
	ldd	disk_loadmcount_bytewrite
	cmpd	#0
	bne	disk_loadmcount_contdl1
	clr	disk_loadmcount_header
disk_loadmcount_contdl1
	ldx	disk_loadmcount_savex
	ldy	disk_loadmcount_dcbpt
	ldu	disk_loadmcount_saveu

	ldd	disk_loadmcount_dcbpt
	addd	#250
	std	disk_loadmcount_tempd	;256 bytes cut off look
	clr	disk_loadmcount_lastgr
; ok setup for grabing granual table
	lda	#2
	sta	disk_loadmcount_dcopc
	lda	#17
	sta	disk_loadmcount_dctrk
	lda	#2
	sta	disk_loadmcount_dcsec
	jsr	disk_loadmcount_getsector
	cmpa	#1
	beq	disk_loadmcount_nextp1	;it loaded
; problem
	clrb
	ldy	#$00	;clear y hopefully
	stb	$ff40
	andcc	#$ef
	rts	;return 0 as did not load
; its good lets grab granuals
disk_loadmcount_nextp1
	jsr	disk_loadmcount_copysect
; ok so we need to grab directory and search for a match
	ldb	#3	;start search on sector 3
	stb	disk_loadmcount_bcnt	;save counter
	clr	disk_loadmcount_retry
	clr	disk_loadmcount_dcfiles
disk_loadmcount_loopd1
	ldb	disk_loadmcount_bcnt
	stb	disk_loadmcount_dcsec	;store sector search
	jsr	disk_loadmcount_getsector
	cmpa	#1	;load?
	beq	disk_loadmcount_contdl
; oops failed
	inc	disk_loadmcount_retry
	lda	disk_loadmcount_retry
	cmpa	#6
	blo	disk_loadmcount_loopd1	;retry
disk_loadmcount_exiterror
	clrb
	ldy	#$00	;clear y hopefully
	andcc	#$ef
	stb	$ff40
	rts	;done exiting in error ***************************************************************

disk_loadmcount_contdl
	clr	disk_loadmcount_retry
	ldx	disk_loadmcount_dcbpt	;256 byte table
; start looking for file match
	ldu	disk_loadmcount_savex	;get addr
	clrb
disk_loadmcount_fndlp1
	lda	b,x
	cmpa	b,u
	bne	disk_loadmcount_nomat
	incb	;it looks to be starting to match
	cmpb	#11
	blo	disk_loadmcount_fndlp1
; ok we found the file
disk_loadmcount_match
	lbra	disk_loadmcount_loadm	;jump to loadm
disk_loadmcount_nomat
	leax	32,x	;jump to next file
	inc	disk_loadmcount_dcfiles	;lets look at next file
	lda	disk_loadmcount_dcfiles
	cmpa	#68
	lbhs	disk_loadmcount_exiterror	;exit in error
	clrb	;clear b register
	cmpx	disk_loadmcount_tempd
	blo	disk_loadmcount_fndlp1	;lets look at next file
; ok we have gone over
	inc	disk_loadmcount_bcnt
	ldb	disk_loadmcount_bcnt	;load the sector and increase it
	cmpb	#12
	lblo	disk_loadmcount_loopd1
	lbra	disk_loadmcount_exiterror	;bad exit
; * get sector *****************************************************
disk_loadmcount_getsector
	ldx	$c006
	lda	disk_loadmcount_dcopc
	sta	0,x
	lda	disk_loadmcount_dcdrv
	sta	1,x
	lda	disk_loadmcount_dctrk
	sta	2,x
	lda	disk_loadmcount_dcsec
	sta	3,x
	ldd	disk_loadmcount_dcbpt
	std	4,x
	clr	disk_loadmcount_retry
disk_loadmcount_retr1
	jsr	[$c004]	;run ml
; check for errors
	ldx	$c006
	lda	6,x
	sta	disk_loadmcount_dcsta
	beq	disk_loadmcount_good1
; not good
	inc	disk_loadmcount_retry
	lda	disk_loadmcount_retry
	cmpa	#12
	blo	disk_loadmcount_retr1
	clra
	rts	;failed and 0 returned to a reg
; its good
disk_loadmcount_good1
	lda	#1
	rts	;return good
; * copy sect *************************************************************
disk_loadmcount_copysect
	ldu	disk_loadmcount_saveu
	ldx	disk_loadmcount_dcbpt
	clrb
disk_loadmcount_loopm
	lda	,x+
	sta	,u+
	incb
	cmpb	#68	;data 0-67
	blo	disk_loadmcount_loopm
	rts	;done
; * load it **********************************************************************************************
; x has file marker on 256 byte table
; u has filename but its been confirmed exists
disk_loadmcount_loadm
	lda	13,x	;first granual 0-67
	sta	disk_loadmcount_firstgran
	lda	15,x
	sta	disk_loadmcount_lastbytes	;last bytes of the last sector
	ldu	disk_loadmcount_saveu	;load the 68byte gran table
	lda	disk_loadmcount_firstgran
	ldb	a,u
	stb	disk_loadmcount_nextgran
	lda	disk_loadmcount_firstgran
	jsr	disk_loadmcount_setdisk
	clra
	clrb
	std	disk_loadmcount_bytestof	;starts with needing a header
	std	disk_loadmcount_bytescntr	;the counter
; transfer loop start
disk_loadmcount_transfer2
	lda	disk_loadmcount_readtrk
	sta	disk_loadmcount_dctrk
	lda	disk_loadmcount_readsec
	sta	disk_loadmcount_dcsec
	clr	disk_loadmcount_retry
disk_loadmcount_tfrretry
	jsr	disk_loadmcount_getsector
	cmpa	#1	;load?
	beq	disk_loadmcount_tfrsucc
; oops failed
	inc	disk_loadmcount_retry
	lda	disk_loadmcount_retry
	cmpa	#6
	bls	disk_loadmcount_tfrretry	;retry
	clrb
	rts	;done exiting in error ***************************************************************
; process data
disk_loadmcount_tfrsucc
	clr	disk_loadmcount_temp
	ldx	disk_loadmcount_dcbpt	;256 byte table
; check no header?
	lda	disk_loadmcount_header
	bne	disk_loadmcount_transfer1	;just get the data =1 if no header
	ldd	disk_loadmcount_bytestof
	cmpd	#0
	bne	disk_loadmcount_transfer1
disk_loadmcount_newhd
	ldx	disk_loadmcount_dcbpt	;the buffer
	ldb	disk_loadmcount_temp
	abx
	lda	0,x
	beq	disk_loadmcount_grabheader
	cmpa	#255
	beq	disk_loadmcount_footer
; exit in error
	lbne	disk_loadmcount_exiterror
; was footer
disk_loadmcount_footer
	ldd	3,x
	std	disk_loadmcount_mach2
	jmp	disk_loadmcount_donebasld	;we are done and loaded
disk_loadmcount_grabheader
	ldd	1,x
	std	disk_loadmcount_bytestof
	ldb	#5	;play with this number
	addb	disk_loadmcount_temp
	stb	disk_loadmcount_temp
	clra
	clrb
	std	disk_loadmcount_bytescntr
	ldd	3,x
	std	disk_loadmcount_bytewrite	;reset y addr write
; transfer actual
disk_loadmcount_transfer1
	ldx	disk_loadmcount_dcbpt
	ldy	disk_loadmcount_bytewrite
	ldb	disk_loadmcount_temp
	abx
;	lda	,x
	leay	1,y
;	sta	,y+
	sty	disk_loadmcount_bytewrite
	inc	disk_loadmcount_temp
; is this the end
; does it have a header?
	lda	disk_loadmcount_header
	bne	disk_loadmcount_itsfinecnt	;needs to skip header checks
; has header system
	ldd	disk_loadmcount_bytescntr
	addd	#1
	std	disk_loadmcount_bytescntr
; is it mach1
; yes it is
	ldd	disk_loadmcount_bytescntr
	cmpd	disk_loadmcount_bytestof
; may need adjustment
	bhs	disk_loadmcount_newhd	;need new header
disk_loadmcount_itsfinecnt
	lda	disk_loadmcount_nextgran
	cmpa	#192
	blo	disk_loadmcount_notlastg1
; yes last but final?
	lda	#1
	sta	disk_loadmcount_lastgr	;safety
	lda	disk_loadmcount_readsec
	cmpa	disk_loadmcount_readsec2
	blo	disk_loadmcount_notlastg1
; yes last chunk
	ldb	disk_loadmcount_temp
	cmpb	disk_loadmcount_lastbytes
	lbhs	disk_loadmcount_donebasld	;its done loading exit for no header also
disk_loadmcount_notlastg1
	ldb	disk_loadmcount_temp
	cmpb	#0	;should be 0
	lbne	disk_loadmcount_transfer1
; end of inner loop
;	rts	;prematurehack rts
	inc	disk_loadmcount_readsec
	lda	disk_loadmcount_readsec
	cmpa	disk_loadmcount_readsec2
	lbls	disk_loadmcount_transfer2
; now we need next gran
	lda	disk_loadmcount_nextgran
	cmpa	#192
	bhs	disk_loadmcount_donebasld	;done loading
	sta	disk_loadmcount_firstgran
	ldu	disk_loadmcount_saveu
	ldb	a,u
	stb	disk_loadmcount_nextgran
	lda	disk_loadmcount_firstgran
	jsr	disk_loadmcount_setdisk
	lbra	disk_loadmcount_transfer2
disk_loadmcount_donebasld
	ldd	disk_loadmcount_mach2
	std	157
	clra
	ldb	#1
	leay	-1,y	;subtract 1
	andcc	#$ef
	sta	$ff40
	rts	;its loaded exit with b=1 
; ********************************************************************************************************
; function of finding track,sector,granual
disk_loadmcount_setdisk
	clr	disk_loadmcount_readsec
	clr	disk_loadmcount_readsec2
	sta	disk_loadmcount_gran
	lsra
	sta	disk_loadmcount_readtrk
	cmpa	#17
	bhs	disk_loadmcount_trkadd
disk_loadmcount_getds1
	lda	disk_loadmcount_gran
	anda	#1
	ldb	#1
	stb	disk_loadmcount_readsec
	ldb	#9
	stb	disk_loadmcount_readsec2
	cmpa	#1
	beq	disk_loadmcount_sect1
	bra	disk_loadmcount_isdske
disk_loadmcount_sect1
	ldb	#10
	stb	disk_loadmcount_readsec
	ldb	#18
	stb	disk_loadmcount_readsec2
	bra	disk_loadmcount_isdske
disk_loadmcount_trkadd
	adda	#1
	sta	disk_loadmcount_readtrk
	bra	disk_loadmcount_getds1
disk_loadmcount_isdske
	lda	disk_loadmcount_nextgran
	cmpa	#68
	bls	disk_loadmcount_fullsetd
	suba	#193
	sta	disk_loadmcount_temp2
	lda	disk_loadmcount_readsec
	adda	disk_loadmcount_temp2
	sta	disk_loadmcount_readsec2
disk_loadmcount_fullsetd
	ldb	disk_loadmcount_readsec
	clra
	rts
endfunction











