; include file
#dontinclude


; need to figure out revision
; single version for 4 channel




function	sid_playmusicsfx	sid_playmusic_sfxpos
rem	sid_playmusic( musicaddr.w )
rem	
rem	play sfx on channel 1
rem	

ref	sid_playmusic_sfxpos	word

sid_playmusicsfx

	lda	#1
	sta	sid_playmusic_sfxspeed
	lda	#240
	sta	sid_playmusic_sfxsustain
	lda	#3
	sta	sid_playmusic_sfxrelease
	sta	sid_playmusic_sfxoctave
	lda	#64
	sta	sid_playmusic_sfxgatectrl1
	lda	#1
	sta	sid_playmusic_sfxgatectrl2


;reset song
	lda	#0
	sta	sid_playmusic_sfxcnt
	sta	sid_playmusic_sfxdelta
	sta	sid_playmusic_sfxdelay
	lda	#1
	sta	sid_playmusic_sfxplay	;start play cmd

	rts
endfunction




function	sid_playmusic	sid_playmusic_addr,sid_playmusic_play2,sid_playmusic_speed,sid_playmusic_loopcnt
rem	sid_playmusic( musicaddr.w , play.b , speed.b , loops.b )
rem	
rem	
rem	

def	sid_playmusic_play2	byte
ref	sid_playmusic_addr	word
ref	sid_playmusic_speed	byte
ref	sid_playmusic_loopcnt	byte


sid_playmusic
	orcc	#$50
	ldd	sid_playmusic_addr
	std	sid_playmusic_pos
	std	sid_playmusic_rpt


;reset song
	lda	#0
	sta	sid_playmusic_cnt
	sta	sid_playmusic_delta
	sta	sid_playmusic_delay
	lda	sid_playmusic_play2
	sta	sid_playmusic_play	;start play cmd
	lda	#227
	sta	sid_attackrel1
	lda	#251
	sta	sid_attackrel2
	sta	sid_attackrel3
	sta	sid_attackrel4
	sta	sid_attackrel5

;set sid clock
	ldx	#sid_clock_0
	lda	#48
	sta	0,x
	sta	1,x
	sta	3,x
	sta	4,x
	clr	5,x
	lda	#58
	sta	2,x

	ldx	#sid_clock_1
	lda	#48
	sta	0,x
	sta	1,x
	sta	3,x
	sta	4,x
	clr	5,x
	lda	#58
	sta	2,x

	clr	sid_time_m
	clr	sid_time_s

	clr	sid_time_ms

; try to calculate actual song size
	clr	sid_time_cm
	clr	sid_time_cs



	andcc	#$ef


	rts


endfunction


;***********************************************************************************************************************************
function	sid_setchannel1	sid_playmusic_ctrl1
rem	sid_setchannel1( #%00000000.b )
rem	noise / pulse / saw / triangle / test / ring mod / sync / gate
rem	gate must be on to produce any noise at all
rem	
ref	sid_playmusic_ctrl1	byte

sid_setchannel1

	rts

endfunction



;***********************************************************************************************************************************
function	sid_setchannel2	sid_playmusic_ctrl2
rem	sid_setchannel2( #%00000000.b )
rem	noise / pulse / saw / triangle / test / ring mod / sync / gate
rem	gate must be on to produce any noise at all
rem	

ref	sid_playmusic_ctrl2	byte

sid_setchannel2

	rts

endfunction




;***********************************************************************************************************************************
function	sid_setchannel3	sid_playmusic_ctrl3
rem	sid_setchannel3( #%00000000.b )
rem	noise / pulse / saw / triangle / test / ring mod / sync / gate
rem	gate must be on to produce any noise at all
rem
	
ref	sid_playmusic_ctrl3	byte

sid_setchannel3

	rts

endfunction


;***********************************************************************************************************************************
function	sid_setmodevol	sid_playmusic_mvol
rem	sid_setmodevol( #%00000000.b )
rem	
rem	off / hp / bp / lp / [ v3 / v2 / v1 / v0 ] volume 0-15
rem	

ref	sid_playmusic_mvol	byte

sid_setmodevol

	rts

endfunction



;***********************************************************************************************************************************
function	sid_setresfilter	sid_playmusic_resfilter
rem	sid_setresfilter( #%00000000.b )
rem	
rem	
rem	

ref	sid_playmusic_resfilter	byte

sid_setresfilter

	rts

endfunction

;*************************************************************************************************************************************


function	sid_settings	sid_file16
def	sid_file16	word
rem	sid_settings( 16byteheader.w )
rem	loads saved settings from file system and applies it
rem	


sid_settings


	clr	sid_time_s
	clr	sid_time_m
	clr	sid_time_ms

	clr	sid_time_cs
	clr	sid_time_cm




	ldu	sid_file16
	lda	0,u
	cmpa	#88
	lbne	sid_settings_exit

	lda	1,u
	sta	sid_playmusic_speed
	lda	2,u
	sta	sid_playmusic_loopcnt
	lda	3,u
	sta	sid_playmusic_ctrl1
	lda	4,u
	sta	sid_playmusic_ctrl2
	lda	5,u
	sta	sid_playmusic_ctrl3
	lda	6,u
	sta	sid_playmusic_ctrl4
	lda	7,u
	sta	sid_playmusic_ctrl5

	lda	8,u
	sta	sid_playmusic_fh
	lda	9,u
	sta	sid_playmusic_fl



	lda	sid_slot
	sta	$ff7f
	lda	9,u
	sta	$ff55
	lda	8,u
	sta	$ff56

	lda	sid_slot1
	sta	$ff7f
	lda	9,u
	sta	$ff55
	lda	8,u
	sta	$ff56



	lda	10,u
	anda	#15
	lsla
	lsla
	lsla
	lsla
	sta	sid_playmusic_res



	lda	11,u
	anda	#112
	sta	sid_playmusic_hbl

	lda	11,u
	anda	#7
	sta	sid_playmusic_fm


;timers
	lda	12,u
	sta	sid_time_cm
	lda	13,u
	sta	sid_time_cs



	lda	sid_slot
	sta	$ff7f
	lda	sid_playmusic_res
	adda	sid_playmusic_fm
	sta	$ff57

	lda	sid_playmusic_mvol
	adda	sid_playmusic_hbl
	sta	$ff58


	lda	sid_slot1
	sta	$ff7f
	lda	sid_playmusic_res
	adda	sid_playmusic_fm
	sta	$ff57
	lda	sid_playmusic_mvol
	adda	sid_playmusic_hbl
	sta	$ff58

	lda	boot_slot
	sta	$ff7f

sid_settings_exit

	rts
endfunction








;**********************************************************************************************************************************

function	sid_chip	sid_chip_tvout
rem	sid_chip( tv_out_enable.b )
rem	enables sid chip player version 1.0
rem	value of 1 hooks the mux bit for tv out
rem	mpiboot=1 for cart

def	sid_chip_tvout	byte


def	sid_playmusic_addr	word
def	sid_playmusic_speed	byte
def	sid_playmusic_play	byte
def	sid_playmusic_pos	word
def	sid_playmusic_rpt	word
def	sid_playmusic_mvol	byte
def	sid_playmusic_cnt	byte
def	sid_playmusic_delta	byte
def	sid_playmusic_delay	byte


def	boot_slot	byte
def	sid_slot	byte
def	sid_slot1	byte

def	sid_playmusic_loopcnt	byte
def	sid_playmusic_gate1	byte
def	sid_playmusic_gate2	byte
def	sid_playmusic_gate3	byte
def	sid_playmusic_gate4	byte
def	sid_playmusic_gate5	byte

def	sid_playmusic_comgate1	byte
def	sid_playmusic_comgate2	byte
def	sid_playmusic_comgate3	byte
def	sid_playmusic_comgate4	byte
def	sid_playmusic_comgate5	byte

def	sid_playmusic_ctrl1	byte
def	sid_playmusic_ctrl2	byte
def	sid_playmusic_ctrl3	byte
def	sid_playmusic_ctrl4	byte
def	sid_playmusic_ctrl5	byte

def	sid_playmusic_drum	byte
def	sid_playmusic_resfilter	byte


def	sid_attackrel1	byte
def	sid_attackrel2	byte
def	sid_attackrel3	byte
def	sid_attackrel4	byte
def	sid_attackrel5	byte


; sfx playback target gate 1 for now
def	sid_playmusic_sfxaddr	word
def	sid_playmusic_sfxspeed	byte
def	sid_playmusic_sfxplay	byte
def	sid_playmusic_sfxpos	word

def	sid_playmusic_sfxcnt	byte
def	sid_playmusic_sfxdelta	byte
def	sid_playmusic_sfxdelay	byte



def	sid_playmusic_sfxsustain	byte
def	sid_playmusic_sfxoctave	byte
def	sid_playmusic_sfxrelease	byte
def	sid_playmusic_sfxgatectrl1	byte
def	sid_playmusic_sfxgatectrl2	byte
def	sid_playmusic_sfxtemp1	byte
def	sid_playmusic_sfxtemp2	byte
def	sid_sfxnoteplay	byte

def	sid_perc_freq	word


def	sid_playmusic_res	byte
def	sid_playmusic_fl	byte
def	sid_playmusic_fh	byte
def	sid_playmusic_hbl	byte
def	sid_playmusic_fm	byte

def	sid_clock_0	string	10
def	sid_clock_1	string	10

def	sid_time_m	byte
def	sid_time_s	byte
def	sid_time_ms	byte

def	sid_time_cm	byte
def	sid_time_cs	byte

def	sid_percussion_chan	word
def	sid_percussion_on	byte

sid_playspeed
	fcb	0,0
	fcb	0,1
	fcb	1,1
	fcb	1,2
	fcb	2,2
	fcb	2,3
	fcb	3,3
	fcb	3,4
	fcb	4,4
	fcb	5,5
	fcb	6,6
	fcb	7,7
	fcb	8,8
	fcb	9,9
	fcb	10,10
	fcb	11,11
	fcb	12,12
	fcb	13,13
	fcb	14,14
	fcb	15,15
	fcb	16,16
	fcb	17,17
	fcb	18,18
	fcb	19,19
	fcb	20,20

sid_tones
	fdb	274,291,308,326,346,366,388,411,435,461,489,518	;oct 0
	fdb	549,581,616,652,691,732,776,822,871,923,978,1036	;oct 1
	fdb	1097,1163,1232,1305,1383,1465,1552,1644,1742,1845,1955,2071	;oct 2
	fdb	2195,2325,2463,2610,2765,2930,3104,3288,3484,3691,3910,4143	;oct 3
	fdb	4389,4650,4927,5220,5530,5859,6207,6577,6968,7382,7821,8286	;oct 4
	fdb	8779,9301,9854,10440,11060,11718,12415,13153,13935,14764,15642,16572	;oct 5
	fdb	17557,18601,19709,20897,22121,23436,24830,26306,27871,29528,31234,33144	;oct 6
	fdb	35115,37203,39415,41759,44242,46873,49660,52613,55741,59056,62567,65535	;oct 7 tone b7 out of range

sid_lentable
	fcb	248,248,248
	fcb	249,249,249
	fcb	250,250,250,250,250
	fcb	251,251,251,251,251		;16

	fcb	252,252,252,252,252,252,252,252
	fcb	252,252,252,252,252,252,252,252	;16

	fcb	253,253,253,253,253,253,253,253
	fcb	253,253,253,253,253,253,253,253
	fcb	253,253,253,253,253,253,253,253
	fcb	253,253,253,253,253,253,253,253	;32

	fcb	254,254,254,254,254,254,254,254
	fcb	254,254,254,254,254,254,254,254
	fcb	254,254,254,254,254,254,254,254
	fcb	254,254,254,254,254,254,254,254	;32

sid_notetable
	fcb	9,11,0,2,4,5,7,9



sid_speedtable
	fcb	250,251,252,253



sid_chip
	orcc	#$50	;kill interupt





;set sid clock
	ldx	#sid_clock_0
	lda	#48
	sta	0,x
	sta	1,x
	sta	3,x
	sta	4,x
	clr	5,x
	lda	#58
	sta	2,x

	ldx	#sid_clock_1
	lda	#48
	sta	0,x
	sta	1,x
	sta	3,x
	sta	4,x
	clr	5,x
	lda	#58
	sta	2,x

	clr	sid_time_m
	clr	sid_time_s
	clr	sid_time_ms

	clr	sid_time_cs
	clr	sid_time_cm






	clr	sid_playmusic_play

;tv on
	if	b,sid_chip_tvout=#1
	lda	$ff01
	anda	#$f7
	sta	$ff01
	lda	$ff03
	ora	#8
	sta	$ff03
	lda	$ff23
	ora	#8
	sta	$ff23
	endif




	lda	$ff7f	;slot
	anda	#240
	sta	boot_slot	;boot slot

	lsra
	lsra
	lsra
	lsra
	anda	#12
	adda	boot_slot
	sta	sid_slot
;	adda	#1
	sta	sid_slot1

	lda	$ff7f
	sta	boot_slot	;fixed

	lda	sid_slot
	sta	$ff7f

; sid selected
	lda	#0
	sta	$ff44
	sta	$ff4b
	sta	$ff52
	lda	#127	;master volume 15 and filters set by default
	sta	$ff58

	lda	#65
	sta	sid_playmusic_ctrl1
	lda	#65
	sta	sid_playmusic_ctrl2
	lda	#49
	sta	sid_playmusic_ctrl3

	lda	#240
	sta	sid_playmusic_resfilter

;filter try
	ldd	#0
	sta	$ff55
	stb	$ff56

; set all pulse widths to square
	ldd	#2048
	sta	$ff43
	stb	$ff42

	ldd	#2048
	sta	$ff4a
	stb	$ff49

	ldd	#2048
	sta	$ff51
	stb	$ff50


	lda	#81
	sta	sid_playmusic_ctrl4
	lda	#97
	sta	sid_playmusic_ctrl5

	lda	#240
	sta	sid_playmusic_resfilter

;done setup


	lda	boot_slot
	sta	$ff7f	;mpi slot 0 of 0-3

	lda	#15
	sta	sid_playmusic_mvol	;store master volume
	clr	sid_playmusic_play	;not playing anything

; no sfx yet
	clr	sid_playmusic_sfxplay
	lda	#2
	sta	sid_playmusic_sfxoctave
	lda	#1
	sta	sid_playmusic_sfxspeed
	lda	#240
	sta	sid_playmusic_sfxsustain
	lda	#3
	sta	sid_playmusic_sfxrelease
	lda	#64
	sta	sid_playmusic_sfxgatectrl1
	lda	#1
	sta	sid_playmusic_sfxgatectrl2



	ldx	#sid_player_irq
	stx	$010d
	andcc	#$ef


	ldd	#$ff5f	;dummy write
	std	sid_percussion_chan
	lda	#1
	sta	sid_percussion_on
	rts



;****************************************************************************************************************************************
;****************** sid player version 1.5 by smdreloaded


sid_player_irq


; we are set for sid programming
	sta	$ffdf

; update system clock
	ldd	$112	;sys clock
	addd	#1
	std	$112


;1 second
	inc	sid_time_ms
	if	b,sid_time_ms>#59
	clr	sid_time_ms
	endif


; clear sid gates
; gate 1 includes sfx channel




	com	sid_playmusic_comgate1
	bmi	sid_notgate1

	ldb	sid_slot
	stb	$ff7f

	lda	sid_playmusic_gate1
	anda	#254
	sta	sid_playmusic_gate1
;	ldx	sid_percussion_chan
;	sta	,x

;fix it
;	ldd	#$ff5f
;	std	sid_percussion_chan

sid_notgate1


	ldb	sid_slot
	stb	$ff7f
	lda	sid_playmusic_hbl
	adda	sid_playmusic_mvol
	sta	$ff58


	com	sid_playmusic_comgate2
	bmi	sid_notgate2

	ldb	sid_slot
	stb	$ff7f

	lda	sid_playmusic_gate2
	anda	#126
	sta	sid_playmusic_gate2
	sta	$ff4b

sid_notgate2
	com	sid_playmusic_comgate3
	bmi	sid_notgate3

	ldb	sid_slot
	stb	$ff7f

	lda	sid_playmusic_gate3
	anda	#254
	sta	sid_playmusic_gate3
	sta	$ff52

sid_notgate3

	com	sid_playmusic_comgate4
	bmi	sid_notgate4

	ldb	sid_slot
	stb	$ff7f

	lda	sid_playmusic_gate4
	anda	#254
	sta	sid_playmusic_gate4
	sta	$ff44	;channel 1 

sid_notgate4


	lda	sid_slot
	sta	$ff7f	;mpi slot 1 of 0-3








; look at player
	if	b,sid_playmusic_play!#0

	if	b,sid_time_ms=#0
	inc	sid_time_s
	if	b,sid_time_s>#59
	clr	sid_time_s
	inc	sid_time_m
	if	b,sid_time_m>#59
	clr	sid_time_m
	endif
	endif

	endif


	if	b,sid_playmusic_cnt>#0
	dec	sid_playmusic_cnt
	else
	jsr	sid_playmusic_update	;jump to update
	endif
	endif

;look at sfx
	if	b,sid_playmusic_sfxplay!#0
	if	b,sid_playmusic_sfxcnt>#0
	dec	sid_playmusic_sfxcnt
	else
	jsr	sid_playmusic_sfxupdate	;jump to update
	endif
	endif


	lda	boot_slot
	sta	$ff7f	;mpi slot 1 of 0-3


	sta	$ffde

	lda	$ff02	;ack irq
	rti
; return to code



def	sega_data1	byte
def	sega_data2	byte





;********************************************************************************************************************************************
sid_playmusic_sfxupdate


; sort out play speed
	ldx	#sid_playspeed
	ldb	#2
	lda	sid_playmusic_sfxspeed
	mul
	addb	sid_playmusic_sfxdelta
	leax	d,x

	lda	,x
	sta	sid_playmusic_sfxcnt
	inc	sid_playmusic_sfxdelta
	if	b,sid_playmusic_sfxdelta>#1
	clr	sid_playmusic_sfxdelta
	endif



; update sfx look at delta timer 2

	lda	sid_playmusic_sfxdelay
	beq	sid_playmusic_sfxdeltagood
	dec	sid_playmusic_sfxdelay
	rts	;no play yet

sid_playmusic_sfxdeltagood



	ldx	sid_playmusic_sfxpos	;sfx pos

sid_playmusic_sfxprocess



; sus volume v=0 - f
; sus volume - +
; octave o= 0 - 7
; speed s=0-f
; release rate r=0 - f
; type t= 0 - f 
; notes c,d,e,f,g,a,b
; # and - flat
; mode = 0-f gate....etc


;	sid_playmusic_sfxsustain	byte
;	sid_playmusic_sfxoctave	byte
;	sid_playmusic_sfxrelease	byte
;	sid_playmusic_sfxgatectrl1	byte
;	sid_playmusic_sfxgatectrl2	byte

	ldd	,x++	;control 1
	sta	sid_playmusic_sfxtemp1
	stb	sid_playmusic_sfxtemp2
	cmpd	#0

	bne	sid_playmusic_sfxpro2
	lda	#0
	sta	sid_playmusic_sfxplay

;kill release
	lda	#0
	sta	$ff46	;sus vol/ release r
	lda	#1
	sta	$ff44
	rts
;exit

sid_playmusic_sfxpro2
	stx	sid_playmusic_sfxpos

; volume set 'v' 0-f
	if	b,sid_playmusic_sfxtemp1=#118	;volume 0-f
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87
	lslb
	lslb
	lslb
	lslb
	stb	sid_playmusic_sfxsustain
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	lslb
	lslb
	lslb
	lslb
	stb	sid_playmusic_sfxsustain
	endif



	lbra	sid_playmusic_sfxprocess
	endif


; pause set 'p' 0-f
	if	b,sid_playmusic_sfxtemp1=#112	;pause 0-f
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87

	stb	sid_playmusic_sfxdelay
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	stb	sid_playmusic_sfxdelay
	endif
;exit
;	lda	#$0c
;	sta	$ff45	;attack/delay
;
;	lda	#0
;	sta	$ff46	;sus vol/ release r
;
;	lda	#1
;	sta	sid_playmusic_gate1
;	sta	$ff44	;note reset
;	clr	sid_playmusic_comgate1
	rts
	endif





; release set 'r' 0-f
	if	b,sid_playmusic_sfxtemp1=#114	;release 0-f
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87
	stb	sid_playmusic_sfxrelease
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	stb	sid_playmusic_sfxrelease
	endif
	lbra	sid_playmusic_sfxprocess
	endif




; octave set '0' 0-7
	if	b,sid_playmusic_sfxtemp1=#111	;octave 0-7
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	stb	sid_playmusic_sfxoctave
	lbra	sid_playmusic_sfxprocess
	endif

; type of noise t 0-f
	if	b,sid_playmusic_sfxtemp1=#116	;type of noise
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87
	lslb
	lslb
	lslb
	lslb
	stb	sid_playmusic_sfxgatectrl1
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	lslb
	lslb
	lslb
	lslb
	stb	sid_playmusic_sfxgatectrl1
	endif
	lbra	sid_playmusic_sfxprocess
	endif


; speed s 0-f
	if	b,sid_playmusic_sfxtemp1=#115	;speed 0 - f
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87
	stb	sid_playmusic_sfxspeed
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	stb	sid_playmusic_sfxspeed
	endif
	lbra	sid_playmusic_sfxprocess
	endif


;  mode m
	if	b,sid_playmusic_sfxtemp1=#109	;type of gate
	if	b,sid_playmusic_sfxtemp2=>#97
	ldb	sid_playmusic_sfxtemp2
	subb	#87
	stb	sid_playmusic_sfxgatectrl2
	endif
	if	b,sid_playmusic_sfxtemp2=<#57
	ldb	sid_playmusic_sfxtemp2
	subb	#48
	stb	sid_playmusic_sfxgatectrl2
	endif
	lbra	sid_playmusic_sfxprocess
	endif





;process notes
	ldb	sid_playmusic_sfxtemp1	;the note
	subb	#97	;give me index
	ldy	#sid_notetable
	lda	b,y	;loaded note
;check suffix
	ldb	sid_playmusic_sfxtemp2
	cmpb	#45
	bne	sid_dontsubtractnote
	deca	;subracted 1
sid_dontsubtractnote
	cmpb	#35
	bne	sid_dontaddnote
	inca	;added 1
sid_dontaddnote
	sta	sid_sfxnoteplay

	ldy	#sid_tones	
	lda	sid_playmusic_sfxoctave
	ldb	#12
	mul
	leay	d,y
	ldb	sid_sfxnoteplay
	lda	#2
	mul
	leay	d,y


	lda	0,y
	sta	$ff41
	lda	1,y
	sta	$ff40


	lda	#$0c
	sta	$ff45	;attack/delay

	lda	sid_playmusic_sfxsustain
	adda	sid_playmusic_sfxrelease
	sta	$ff46	;sus vol/ release r

	lda	sid_playmusic_sfxgatectrl1
	adda	sid_playmusic_sfxgatectrl2

	sta	sid_playmusic_gate1
	sta	$ff44	;note reset
	clr	sid_playmusic_comgate1
	rts
;*******************************************************************************************************************************************











sid_playmusic_update


; sort out play speed
	ldx	#sid_playspeed
	ldb	#2
	lda	sid_playmusic_speed
	mul
	addb	sid_playmusic_delta
	leax	d,x

	lda	,x
	sta	sid_playmusic_cnt
	inc	sid_playmusic_delta
	if	b,sid_playmusic_delta>#1
	clr	sid_playmusic_delta
	endif



; update music look at delta timer 2

	lda	sid_playmusic_delay
	beq	sid_playmusic_deltagood
	dec	sid_playmusic_delay
	rts	;no play yet

sid_playmusic_deltagood



	ldx	sid_playmusic_pos	;song pos


	ldu	#sid_lentable

sid_playmusic_process



	ldd	,x++	;advance it

	cmpa	#12	;its a repeat looper locater
	lbeq	sid_playmusic_repeatset	;new delta counter

	cmpa	#13	;1 byte delay
	lbeq	sid_playmusic_setdelay	;new wait

	cmpa	#14
	lbeq	sid_playmusic_resetsng


; 3 percussions on z80 side
	cmpa	#9
	lbeq	sid_lib_perc1	;chan 0 of both scards
	cmpa	#10
	lbeq	sid_lib_perc2	;chan 0
	cmpa	#11
	lbeq	sid_lib_perc3	;chan 0


	cmpa	#15
	lbeq	sid_setchan2	;sid card 0 chan
	cmpa	#16
	lbeq	sid_setchan1	;sid card 0 chan

;trash channel
	cmpa	#19
	lbeq	sid_setchan5	;dead channel

	cmpa	#17
	lbeq	sid_setchan4	;sid card 1 chan 1
	cmpa	#18
	lbeq	sid_setchan3	;sid card 1 chan 2



	lbra	sid_playmusic_process





;******************************************************************************************
sid_playmusic_setdelay

	stx	sid_playmusic_pos	;sty spos
	stb	sid_playmusic_delay
	rts



;*********************************************************************************************
; repeat locator
sid_playmusic_repeatset
	stx	sid_playmusic_rpt	;song repeater set
	lbra	sid_playmusic_process


;********************************************************************************************
; reset
sid_playmusic_resetsng
	ldx	sid_playmusic_rpt
	stx	sid_playmusic_pos


;check loop hmany times
	if	b,sid_playmusic_loopcnt!#0
	lda	sid_playmusic_loopcnt
	suba	#1
	sta	sid_playmusic_loopcnt

	if	b,sid_playmusic_loopcnt=#0
	clr	sid_playmusic_play
	endif
	endif


	if	b,sid_playmusic_play=#1
	clr	sid_playmusic_play	;play only once
	endif

	rts




;**********************************************************************************
;sid_setchan0
;
;	if	b,sid_playmusic_sfxplay=#0
; set frequency chan 1
;
;	lda	,x+	;note
;	suba	#12	;calibration
;	ldy	#sid_tones
;	ldb	#2
;	mul
;	leay	d,y
;	lda	0,y
;	sta	$ff41
;	lda	1,y
;	sta	$ff40
;
;
;	lda	#$0c
;	sta	$ff45	;attack/delay
;
;	lda	,x+	;length of note
; dont care for now
; need to examine then place into release reg
;	lda	#$fb	;c
;	sta	$ff46	;sus vol/ release r
;
;	lda	sid_playmusic_ctrl1
;
;	sta	sid_playmusic_gate1
;	sta	$ff44	;note reset
;	clr	sid_playmusic_comgate1
;
;	else
;	leax	2,x
;
;	endif
;
;	lbra	sid_playmusic_process
;
;********************************************************************************************

sid_setchan1
; set frequency chan 2


	lda	sid_slot
	sta	$ff7f	;mpi slot 1 of 0-3


	lda	,x+	;note
	suba	#12	;calibration
	ldy	#sid_tones
	ldb	#2
	mul
	leay	d,y
	lda	0,y
	sta	$ff48
	lda	1,y
	sta	$ff47

	lda	#$0c
	sta	$ff4c	;attack/delay

	lda	,x+	;length of note
	ldb	a,u
	stb	$ff4d	;sus vol/ release r

	lda	sid_playmusic_ctrl2

	sta	$ff4b	;note set
	sta	sid_playmusic_gate2	;save
	clr	sid_playmusic_comgate2
	lbra	sid_playmusic_process


;*******************************************************************************************
sid_setchan2
; clear channel
	lda	sid_slot
	sta	$ff7f	;mpi slot 1 of 0-3


	lda	,x+	;note
	suba	#12	;calibration
	ldy	#sid_tones
	ldb	#2
	mul
	leay	d,y
	lda	0,y
	sta	$ff4f
	lda	1,y
	sta	$ff4e
	lda	#$0c
	sta	$ff53	;attack/delay

	lda	,x+	;length of note
	ldb	a,u
	stb	$ff54	;sus vol/ release r

	lda	sid_playmusic_ctrl3

	sta	$ff52	;note set
	sta	sid_playmusic_gate3	;save
	clr	sid_playmusic_comgate3
	lbra	sid_playmusic_process


;************************************************************************************************

;use gate 4

sid_setchan3

; use channel 1

; set frequency chan 2
	lda	sid_slot
	sta	$ff7f	;mpi slot 0 of 0-3


	lda	,x+	;note
	suba	#12	;calibration
	ldy	#sid_tones
	ldb	#2
	mul
	leay	d,y
	lda	0,y
	sta	$ff41
	lda	1,y
	sta	$ff40

	lda	#$0c
	sta	$ff45	;attack/delay

	lda	,x+	;length of note
	ldb	a,u
	stb	$ff46	;sus vol/ release r

	lda	sid_playmusic_ctrl4

	sta	$ff44	;note set
	sta	sid_playmusic_gate4	;save
	clr	sid_playmusic_comgate4
	lbra	sid_playmusic_process


;*******************************************************************************************

;use gate 5
sid_setchan4

	lda	,x+	;note
	lda	,x+	;length of note
	lbra	sid_playmusic_process


; clear channel
	lda	sid_slot1
	sta	$ff7f	;mpi slot 1 of 0-3


	lda	,x+	;note
	suba	#12	;calibration
	ldy	#sid_tones
	ldb	#2
	mul
	leay	d,y
	lda	0,y
	sta	$ff4f
	lda	1,y
	sta	$ff4e
	lda	#$0c
	sta	$ff53	;attack/delay

	lda	,x+	;length of note
	ldb	a,u
	stb	$ff54	;sus vol/ release r

	lda	sid_playmusic_ctrl5

	sta	$ff52	;note set
	sta	sid_playmusic_gate5	;save
	clr	sid_playmusic_comgate5
	lbra	sid_playmusic_process


;************************************************************************************************

;*******************************************************************************************

;use gate 5
sid_setchan5
; clear channel

	lda	,x+	;note
	lda	,x+	;length of note
	lbra	sid_playmusic_process





sid_lib_perc1
	ldd	#15000
	std	sid_perc_freq
;	sta	$ff41
;	stb	$ff40
	bra	sid_lib_perchit

sid_lib_perc2
	ldd	#10000
	std	sid_perc_freq
;	sta	$ff41
;	stb	$ff40
	bra	sid_lib_perchit

sid_lib_perc3
	ldd	#2500
	std	sid_perc_freq

;	sta	$ff41
;	stb	$ff40
	bra	sid_lib_perchit

sid_lib_perchit



;hack

	if	b,#0=sid_percussion_on
	lbra	sid_playmusic_process
	endif


	lda	sid_slot
	sta	$ff7f	;mpi slot 1 of 0-3


	if	x,#1=sid_playmusic_gate2

	lda	sid_playmusic_ctrl2
	anda	#126
	adda	#129	;assume note going
	sta	$ff4b	;note set

	sta	sid_playmusic_gate2	;save
	clr	sid_playmusic_comgate2

	sta	sid_playmusic_gate1	;save
	clr	sid_playmusic_comgate1

	else

	ldd	sid_perc_freq
	sta	$ff48
	stb	$ff47
	lda	#$03
	sta	$ff4c	;attack/decay
	lda	#227
	sta	$ff4d	;sus vol/ release r
	lda	#129
	sta	$ff4b	;note set
	sta	sid_playmusic_gate2	;save
	clr	sid_playmusic_comgate2
	sta	sid_playmusic_gate1	;save
	clr	sid_playmusic_comgate1
	endif



	lbra	sid_playmusic_process







def	sid_foundperc	byte






endfunction

