#dontinclude
; include file
; vga library for coco 2,3

; color computer vga adapter
; vg6 mode tools library
; massive wip


;*********************************************
;*   setup cocovga board for vg6
;*  setupvga()
; *********************************************
function	setupvga	setupvga_mode,setupvga_rgb,setupvga_coco3
rem	setupvga(mode.b,rgb.b,coco3.b)
rem	mode=0 or 1=multi screens. rgb=1 cmp=0
rem	make sure your code starts at $4000 as this uses two screens of 6k
def	setupvga_mode	byte
def	setupvga_rgb	byte
def	setupvga_coco3	byte
setupvga_palrgb
	fcb	0,56,63,2,16,18,8,9,32,36,28,27,42,53,52,54
setupvga_palcmp
	fcb	0,32,63,3,17,34,12,28,6,22,30,61,9,37,21,36

setupvga
	lda	setupvga_coco3
	lbne	setupvga_setupcc3
;	orcc	#$50
;
	lda	$ff02
	lda	$ff03
	anda	#252
	ora	#1
	sta	$ff03
	lda	$ff02
;
setupvga_ivga	lda	$ff03
	bpl	setupvga_ivga
	lda	$ff02
; **********************************************
; * fiddle 512 byte *regs*
; **********************************************
	lda	#$94	;enhanced/artifact cols/extras 148
	sta	$401
	lda	#$00
	sta	$400
	sta	$402
	sta	$403
	sta	$406
	sta	$407
	lda	#$0b	
	sta	$405	;extras - border/status override
	lda	#$01	;vg6
	sta	$408
; colors
	ldd	#$8000	;black
	std	$484	;border color
	std	$440	;palette 0  (cc3=0)
	ldd	#$c210	
	std	$442	;pallete 1  (cc3=56)
	ldd	#$e318
	std	$444	;pallete 2  (cc3=63)
	ldd	#$8100
	std	$446	;pallete 3  (cc3=2)
	ldd	#$8200
	std	$448	;pallete 4  (cc3=16)
	ldd	#$8300
	std	$44a	;pallete 5  (cc3=18)
	ldd	#$8010
	std	$44c	;pallete 6  (cc3=8)
	ldd	#$8018
	std	$44e	;pallete 7  (cc3=9)
	ldd	#$c000
	std	$450	;pallete 8  (cc3=32)
	ldd	#$e000
	std	$452	;pallete 9  (cc3=36)
	ldd	#$a210
	std	$454	;pallete 10  (cc3=28)
	ldd	#$8318
	std	$456	;pallete 11  (cc3=27)
	ldd	#$c110
	std	$458	;pallete 12  (cc3=42)
	ldd	#$e208
	std	$45a	;pallete 13  (cc3=skin)
	ldd	#$e200
	std	$45c	;pallete 14  (cc3=52)
	ldd	#$e300
	std	$45e	;pallete 15  (cc3=54)
; *
; **********************************************
; *
	lda   	#$90  	set combo lock 1
	sta  	$ff22  	write to pia
	lda   	#$48  	set combo lock 2
	sta  	$ff22  	write to pia
	lda   	#$a0  	set combo lock 3
	sta  	$ff22  	write to pia
	lda   	#$f8  	set combo lock 4
	sta  	$ff22  	write to pia
	lda	#0
	sta	$ff22
setupvga_wvs2
	lda	$ff03
	bpl	setupvga_wvs2
	lda	$ff02
	lda	#$e0
	sta	$ff22	
	sta	$ffc3
	sta	$ffc5	;cg6
;	andcc	#$ef	;irq back
	lda	setupvga_mode
	bne	setupvga_set2
; setup sam at e00 edit $2600view
setupvga_set1
	clra	;set value 7 so its at 3584 view
	ldx	#65478
	sta	1,x
	sta	3,x
	sta	5,x
	sta	6,x
	sta	8,x
	sta	10,x
	sta	12,x
	rts
setupvga_set2
	clra	;set value so its at 3584 edit 9728 view zone   lets try 19 =9728
	ldx	#65478
	sta	1,x
	sta	3,x
	sta	4,x
	sta	6,x
	sta	9,x
	sta	10,x
	sta	12,x
	rts
; hopefully drawing at 3584 will show on screen
setupvga_setupcc3
	lda	setupvga_rgb
	bne	setupvga_setrgb
	ldx	#setupvga_palcmp
	bra	setupvga_colorset
setupvga_setrgb
	ldx	#setupvga_palrgb
; **********************************************
; * cc3 / mmu / scs / 1616
; **********************************************
setupvga_colorset	ldd	#$4c00	
	std	$ff90	
; set palette
setupvga_setpal	lda	$ff03
	bpl	setupvga_setpal
	lda	$ff02
	ldu	#$ffb0
setupvga_pallp	ldd	,x++
	std	,u++
	cmpu	#$ffc0
	blo	setupvga_pallp
; **********************************************
; * 128 x 96 x 16 videomode + gime setup
; **********************************************
	ldd	#$8212	;$82 > $80 = gfx mode $02 = 2lpr
	std	$ff98	;$12 > 64 bytes, 192 lines, 16 colors 
; **********************************************
; * screen offset at $60000
; *
; * physical address / 8192 = mmu page
; *
; * mmu page * 1024 = offset address
; **********************************************
	ldd	#$c0c0	;$60000/$2000=$30 > $30*$400=$c000
	std	$ff9d
; **********************************************
; * 8k of mmu bank(s) at $2000 
; **********************************************
	lda	#$30	;setup mmu window (addressable screen)
	sta	$ffa1
	ldd	#0	;clear out 6k of screen
	ldx	#$2600
setupvga_cls	std	,x++
	cmpx	#$3e00
	blo	setupvga_cls
	rts
endfunction





;
; ************************************************************************************************************************
; * syncvga()
; ************************************************************************************************************************
function	syncvga	syncvga_method
rem	syncvga(color.b)
rem	0-15,  16=noclear 0-15 color clear select
rem	
def	syncvga_method	byte
def	syncvga_method2	byte

def	syncvga_stacks	word

syncvga
	lda	syncvga_method
	cmpa	#16
	lbeq	syncvga_noclear
; clear begins
	lda	syncvga_method
	ldb	#16
	mul
	addb	syncvga_method
	stb	syncvga_method
	lda	syncvga_method
	std	syncvga_method	;now loaded as d
;	pshs	cc,dp
	sts	syncvga_stacks	;save stack
	lds	#$e00
	ldu	#$2606
syncvga_loop2
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	12,u
	puls	x,y,d
	pshu	d,y,x
	leau	10,u
	puls	x,y
	pshu	y,x
	leau	10,u
	cmps	#$2600
	blo	syncvga_loop2
	lds	syncvga_stacks	;return stack
	ldu	#$2600
	ldd	syncvga_method
	ldx	syncvga_method
	ldy	syncvga_method
syncvga_cls2
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	x,y,d
	pshu	d
	cmpu	#$e00
	bhi	syncvga_cls2
	rts
; done exit
syncvga_noclear
	ldx	#$e00
	ldu	#$2600
syncvga_loop1	ldd	,x
	std	,u
	ldd	2,x
	std	2,u
	ldd	4,x
	std	4,u
	ldd	6,x
	std	6,u
	ldd	8,x
	std	8,u
	ldd	10,x
	std	10,u
	ldd	12,x
	std	12,u
	ldd	14,x
	std	14,u
	ldd	16,x
	std	16,u
	ldd	18,x
	std	18,u
	ldd	20,x
	std	20,u
	ldd	22,x
	std	22,u
	ldd	24,x
	std	24,u
	ldd	26,x
	std	26,u
	ldd	28,x
	std	28,u
	ldd	30,x
	std	30,u
	leau	32,u
	leax	32,x
	cmpx	#$2600
	blo	syncvga_loop1
	rts
endfunction




*
; ************************************************************************************************************************
; * vga_cls()
; ************************************************************************************************************************
function	vga_cls	vga_cls_col
rem	vga_cls(color.b)
rem	0-15
rem	vga screen clear

def	vga_cls_col	byte
def	vga_cls_col2	byte

vga_cls
	lda	vga_cls_col
	cmpa	#16
	bhs	vga_cls_exit1
	bra	vga_cls_noex
vga_cls_exit1
	rts
vga_cls_noex
	lda	vga_cls_col
	ldb	#16
	mul
	addb	vga_cls_col
	stb	vga_cls_col
	lda	vga_cls_col
	std	vga_cls_col	;now loaded as d
	ldx	#$e00
	ldu	vga_cls_col
vga_cls_loop2
	stu	,x
	stu	2,x
	stu	4,x
	stu	6,x
	stu	8,x
	stu	10,x
	stu	12,x
	stu	14,x
	stu	16,x
	stu	18,x
	stu	20,x
	stu	22,x
	stu	24,x
	stu	26,x
	stu	28,x
	stu	30,x
	leax	32,x
	cmpx	#$2600
	blo	vga_cls_loop2
	rts
endfunction



;
; **********************************************************************************************************
; * box code start
; **********************************************************************************************************
function	vga_box	vga_box_x1,vga_box_y1,vga_box_x2,vga_box_y2,vga_box_col1,vga_box_col2,vga_box_fill
rem	vga_box(x1.b,y1.b,x2.b,y2.b,color1.b, fillcolor.b, fill.b)
rem	x0-127,y0-96 color0-15 fill=1 nofill=0
rem	
def	vga_box_x1	byte
def	vga_box_x2	byte
def	vga_box_y1	byte
def	vga_box_y2	byte
def	vga_box_col1	byte
def	vga_box_col2	byte
def	vga_box_fill	byte
def	vga_box_fill2	byte

def	vga_box_halfx1	byte
def	vga_box_halfx2	byte


def	vga_box_dot1	byte
def	vga_box_dot2	byte
def	vga_box_odd1	byte
def	vga_box_odd2	byte
def	vga_box_cnty	byte
def	vga_box_cntx	byte
def	vga_box_halfdx	byte
def	vga_box_x3	byte


vga_box
	ldx	#$e00
	lda	vga_box_x1
;	cmpa	#128
;	bhs	vga_box_exit1
	bmi	vga_box_exit1
	cmpa	vga_box_x2
	bhi	vga_box_exit1	;x2 is lower then x1 ...no go
	lda	vga_box_y1
	cmpa	#96
	bhs	vga_box_exit1
	cmpa	vga_box_y2
	bhi	vga_box_exit1	;y2 is lower then y1 ...no go
	lda	vga_box_x2
;	cmpa	#128
;	bhs	vga_box_exit1
	bmi	vga_box_exit1
	lda	vga_box_y2
	cmpa	#96
	bhs	vga_box_exit1
	bra	vga_box_gcheck1
vga_box_exit1
	rts	;no go
; vga_box_gcheck1	lda	vga_box_x1
;	lsra
;	inca
;	sta	vga_box_halfx1
;	lda	vga_box_x2
;	lsra
;	suba	#2
;	sta	vga_box_halfx2
;	suba	vga_box_halfx1
;	sta	vga_box_halfdx	;distance saved
; simon code
vga_box_gcheck1
	ldd	vga_box_x1
	lsra
	lsrb
	inca
	subb	#2
	std	vga_box_halfx1
	subb	vga_box_halfx1
	stb	vga_box_halfdx
; simon code
	lda	vga_box_fill
	lbeq	vga_box_nofill2
; lets do the fill first
	lda	vga_box_col2
	ldb	#16
	mul
	addb	vga_box_col2
	stb	vga_box_fill
	lda	vga_box_fill
	std	vga_box_fill	;double now
; color fill set
	lda	vga_box_y1
	inca	; lets increase this so we dont draw same line twice
	sta	vga_box_cnty
	ldb	#64
	mul
	leax	d,x	;line y should be correct
	ldb	vga_box_halfx1
	abx
; ok im hoping this works
	ldu	vga_box_fill	;u has color
vga_box_yloopf
	lda	vga_box_halfx1
	sta	vga_box_cntx
vga_box_xloopf
	stu	,x+
	inc	vga_box_cntx
	lda	vga_box_cntx
	cmpa	vga_box_halfx2
	bls	vga_box_xloopf	;continue
	lda	#63
	suba	vga_box_halfdx
	leax	a,x	;hopefully that worked
;
	inc	vga_box_cnty
	lda	vga_box_cnty
	cmpa	vga_box_y2
	bhs	vga_box_nofill	;lets exit to draw outer lines
	bra	vga_box_yloopf
; end y loop
vga_box_nofill
	ldx	#$e00	;top line
	lda	vga_box_y1
	ldb	#64
	mul
	leax	d,x
	ldb	vga_box_halfx1
	abx
	ldy	#$e00	;bot line
	lda	vga_box_y2
	ldb	#64
	mul
	leay	d,y
	ldb	vga_box_halfx1
	leay	b,y
; ok both should be set
; lets run the lines the new col
	lda	vga_box_col1
	ldb	#16
	mul
	addb	vga_box_col1
	stb	vga_box_fill
	lda	vga_box_fill
	std	vga_box_fill	;fill is now d with outline color col1=preserved
; ok lets do the top lines
	ldu	vga_box_fill	;u has color
	lda	vga_box_halfx1
	sta	vga_box_cntx
vga_box_xloopo
	stu	,x+
	stu	,y+
	inc	vga_box_cntx
	lda	vga_box_cntx
	cmpa	vga_box_halfx2
	bls	vga_box_xloopo	;continue
; ok now we need last two lines
; is x1 odd?
	lda	vga_box_x1
	bita	#1
	bne	vga_box_notodd1
	clr	vga_box_odd1
	bra	vga_box_oddsch2
vga_box_notodd1
	lda	#1
	sta	vga_box_odd1
vga_box_oddsch2
	lda	vga_box_x2
	bita	#1
	bne	vga_box_notodd2
	clr	vga_box_odd2
	bra	vga_box_oddsdn
vga_box_notodd2
	lda	#1
	sta	vga_box_odd2
; ok both odds figured out
vga_box_oddsdn
	ldx	#$e00
	ldy	#$e00
	lda	vga_box_y1
	ldb	#64
	mul
	leax	d,x
	leay	d,y
	ldb	vga_box_x1
	lsrb
	abx
	leay	b,y
	lda	vga_box_x2
	suba	vga_box_x1
; try
	lsra
	leay	a,y
	lda	vga_box_odd2
	bne	vga_box_noway
	leay	1,y
; both set
vga_box_noway
	lda	vga_box_y1
	sta	vga_box_cnty
vga_box_yloopz
	lda	vga_box_odd1
	bne	vga_box_col_both
; ok we need first dot from screen
	lda	vga_box_col1
	sta	vga_box_dot1
	lda	vga_box_col2
	sta	vga_box_dot2
; check for top
	lda	vga_box_cnty
	cmpa	vga_box_y1
	beq	vga_box_fixdot1
	cmpa	vga_box_y2
	beq	vga_box_fixdot1
	bra	vga_box_looky
vga_box_fixdot1
	lda	vga_box_col1
	sta	vga_box_dot2
	bra	vga_box_looky
vga_box_col_both
	lda	,x
	lsra
	lsra
	lsra
	lsra
	sta	vga_box_dot1
	lda	vga_box_col1
	sta	vga_box_dot2
vga_box_looky
	lda	vga_box_dot1
	ldb	#16
	mul
	addb	vga_box_dot2
	stb	,x
; ok now y
	lda	vga_box_odd2
	bne	vga_box_col_both2
; ok we need first dot from screen
	lda	,y
	ora	#240
	suba	#240
	sta	vga_box_dot2
	lda	vga_box_col1
	sta	vga_box_dot1
	bra	vga_box_looky2
vga_box_col_both2
	lda	vga_box_col1
	sta	vga_box_dot2
	lda	vga_box_col2
	sta	vga_box_dot1
; do a top and bot check on y
	lda	vga_box_cnty
	cmpa	vga_box_y1
	beq	vga_box_fixdot2
	cmpa	vga_box_y2
	beq	vga_box_fixdot2
	bra	vga_box_looky2
vga_box_fixdot2
	lda	vga_box_col1
	sta	vga_box_dot1
vga_box_looky2
	lda	vga_box_dot1
	ldb	#16
	mul
	addb	vga_box_dot2
	stb	,y
	leax	64,x
	leay	64,y
	inc	vga_box_cnty
	lda	vga_box_cnty
	cmpa	vga_box_y2
	lbls	vga_box_yloopz	;lets exit to draw outer lines
	rts
; end y loop
;
;
;
;
;
;
;
vga_box_nofill2
	ldx	#$e00	;top line
	lda	vga_box_y1
	ldb	#64
	mul
	leax	d,x
	ldb	vga_box_halfx1
	abx
	ldy	#$e00	;bot line
	lda	vga_box_y2
	ldb	#64
	mul
	leay	d,y
	ldb	vga_box_halfx1
	leay	b,y
; ok both should be set
; lets run the lines the new col
	lda	vga_box_col1
	ldb	#16
	mul
	addb	vga_box_col1
	stb	vga_box_fill
	lda	vga_box_fill
	std	vga_box_fill	;fill is now d with outline color col1=preserved
; ok lets do the top lines
	ldu	vga_box_fill	;u has color
	lda	vga_box_halfx1
	sta	vga_box_cntx
vga_box_xloop_o
	stu	,x+
	stu	,y+
	inc	vga_box_cntx
	lda	vga_box_cntx
	cmpa	vga_box_halfx2
	bls	vga_box_xloop_o	;continue
; ok now we need last two lines
; is x1 odd?
	lda	vga_box_x1
	bita	#1
	bne	vga_box_notodd_1
	clr	vga_box_odd1
	bra	vga_box_oddsch_2
vga_box_notodd_1
	lda	#1
	sta	vga_box_odd1
vga_box_oddsch_2
	lda	vga_box_x2
	bita	#1
	bne	vga_box_notodd_2
	clr	vga_box_odd2
	bra	vga_box_oddsd_n
vga_box_notodd_2
	lda	#1
	sta	vga_box_odd2
; ok both odds figured out
vga_box_oddsd_n
	ldx	#$e00
	ldy	#$e00
	lda	vga_box_y1
	ldb	#64
	mul
	leax	d,x
	leay	d,y
	ldb	vga_box_x1
	lsrb
	abx
	leay	b,y
	lda	vga_box_x2
	suba	vga_box_x1
; try
	lsra
	leay	a,y
	lda	vga_box_odd2
	bne	vga_box_noway2
	leay	1,y
; both set
vga_box_noway2
	lda	vga_box_y1
	sta	vga_box_cnty
vga_box_yloop_z
	lda	vga_box_odd1
	bne	vga_box_col_both4
; ok we need first dot from screen
	lda	vga_box_col1
	sta	vga_box_dot1
; fix
	lda	,x
	ora	#240
	suba	#240
	sta	vga_box_dot2
; check for top
	lda	vga_box_cnty
	cmpa	vga_box_y1
	beq	vga_box_fixdot_1
	cmpa	vga_box_y2
	beq	vga_box_fixdot_1
	bra	vga_box_look_y
vga_box_fixdot_1
	lda	vga_box_col1
	sta	vga_box_dot2
	bra	vga_box_look_y
vga_box_col_both4
	lda	,x
	lsra
	lsra
	lsra
	lsra
	sta	vga_box_dot1
	lda	vga_box_col1
	sta	vga_box_dot2
vga_box_look_y
	lda	vga_box_dot1
	ldb	#16
	mul
	addb	vga_box_dot2
	stb	,x
; ok now y
	lda	vga_box_odd2
	bne	vga_box_col_both5
; ok we need first dot from screen
	lda	,y
	ora	#240
	suba	#240
	sta	vga_box_dot2
	lda	vga_box_col1
	sta	vga_box_dot1
	bra	vga_box_looky_2
vga_box_col_both5
	lda	vga_box_col1
	sta	vga_box_dot2
; fix
	lda	,y
	lsra
	lsra
	lsra
	lsra
	sta	vga_box_dot1
; do a top and bot check on y
	lda	vga_box_cnty
	cmpa	vga_box_y1
	beq	vga_box_fixdot_2
	cmpa	vga_box_y2
	beq	vga_box_fixdot_2
	bra	vga_box_looky_2
vga_box_fixdot_2
	lda	vga_box_col1
	sta	vga_box_dot1
vga_box_looky_2
	lda	vga_box_dot1
	ldb	#16
	mul
	addb	vga_box_dot2
	stb	,y
	leax	64,x
	leay	64,y
	inc	vga_box_cnty
	lda	vga_box_cnty
	cmpa	vga_box_y2
	lbls	vga_box_yloop_z
	rts
endfunction



;
; **************************************************************************************************************
; * vga_print(disp,posx,posy,color,transparency,start,len,text$)
; **************************************************************************************************************
function	vga_print	vga_print_disp,vga_print_cx,vga_print_cy,vga_print_cc,vga_print_ct,vga_print_start,vga_print_len,vga_print_y
rem	vga_print( displaymode.b, posx.b, posy.b, color.b, transparency.b, start.b, length.b,text pointer.w)
rem	
rem	

def	vga_print_disp	byte
def	vga_print_cx	byte
def	vga_print_cy	byte
def	vga_print_cc	byte
def	vga_print_ct	byte
def	vga_print_start	byte
def	vga_print_len	byte
def	vga_print_y	word

def	vga_print_dot1	byte
def	vga_print_dot2	byte
def	vga_print_dot3	byte
def	vga_print_dot4	byte
def	vga_print_dot5	byte
def	vga_print_dot6	byte
def	vga_print_dot7	byte
def	vga_print_dot8	byte
def	vga_print_cntr	byte
def	vga_print_cnt2	byte



; x=screen y=text u=ascii


vga_print_ascii32
	fcb	0,0,0,0,0,0,0,0	;32
	fcb	0,24,24,24,0,0,24,0	;33
	fcb	0,40,40,0,0,0,0,0	;34
	fcb	0,40,124,40,124,40,0,0	;35
	fcb	20,62,96,62,2,126,20,0	;36
	fcb	0,98,100,8,16,38,70,0	;37
	fcb	24,36,36,24,42,68,58,0	;38
	fcb	0,24,24,0,0,0,0,0	;39
	fcb	0,24,48,48,48,48,24,0	;40
	fcb	0,24,12,12,12,12,24,0	;41
	fcb	0,24,60,24,36,0,0,0	;42
	fcb	0,8,8,62,8,8,0,0	;43
	fcb	0,0,0,0,0,0,24,48	;44
	fcb	0,0,0,60,0,0,0,0	;45
	fcb	0,0,0,0,0,0,24,24	;46
	fcb	0,2,6,12,24,48,96,0	;47
	fcb	0,60,102,98,98,102,60,0	;48
	fcb	0,24,56,56,24,24,126,0	;49
	fcb	0,60,98,2,28,112,126,0	;50
	fcb	0,60,98,2,14,98,60,0	;51
	fcb	0,100,100,126,12,12,12,0	;52
	fcb	0,62,96,124,2,98,124,0	;53
	fcb	0,62,96,124,98,98,60,0	;54
	fcb	0,126,6,12,24,24,24,0	;55
	fcb	0,60,98,60,98,98,60,0	;56
	fcb	0,60,98,98,62,6,6,0	;57
	fcb	0,24,24,0,0,24,24,0	;58
	fcb	0,24,24,0,0,0,24,48	;59
	fcb	0,12,24,48,96,48,24,12	;60
	fcb	0,0,60,0,0,60,0,0	;61
	fcb	0,48,24,12,6,12,24,48	;62
	fcb	0,60,98,2,28,24,0,24	;63
	fcb	0,60,98,106,110,96,62,0	;64
	fcb	0,60,118,98,126,98,98,0	;65
	fcb	0,124,98,124,98,98,124,0	;66
	fcb	0,60,98,96,96,98,60,0	;67
	fcb	0,124,98,98,98,98,124,0	;68
	fcb	0,126,96,120,96,96,126,0	;69
	fcb	0,126,96,120,96,96,96,0	;70
	fcb	0,126,98,96,110,98,126,0	;71
	fcb	0,98,98,126,98,98,98,0	;72
	fcb	0,126,24,24,24,24,126,0	;73
	fcb	0,126,8,8,104,104,120,0	;74
	fcb	0,98,100,120,120,100,98,0	;75
	fcb	0,96,96,96,96,96,126,0	;76
	fcb	0,98,118,126,126,106,98,0	;77
	fcb	0,98,114,122,110,102,98,0	;78
	fcb	0,60,98,98,98,98,60,0	;79
	fcb	0,124,98,98,124,96,96,0	;80
	fcb	0,60,98,98,106,102,62,1	;81
	fcb	0,124,98,98,124,98,98,0	;82
	fcb	0,60,98,112,12,98,60,0	;83
	fcb	0,126,24,24,24,24,24,0	;84
	fcb	0,98,98,98,98,98,126,0	;85
	fcb	0,98,98,98,52,60,24,0	;86
	fcb	0,98,98,106,126,118,98,0	;87
	fcb	0,98,52,24,24,52,98,0	;88
	fcb	0,98,118,60,24,24,24,0	;89
	fcb	0,126,100,8,16,98,126,0	;90
	fcb	0,30,24,24,24,24,30,0	;91
	fcb	0,64,96,48,24,12,6,0	;92
	fcb	0,120,24,24,24,24,120,0	;93
	fcb	0,24,24,52,98,0,0,0	;94
	fcb	0,0,0,0,0,0,0,126	;95
	fcb	0,24,56,48,0,0,0,0	;96
	fcb	0,102,153,129,66,36,24,0	;97 extended graphic using lowercase
	fcb	0,102,255,255,126,60,24,0	;98
	fcb	0,0,0,63,48,48,48,63	;99
	fcb	0,0,0,255,0,0,0,255	;100
	fcb	0,0,0,252,68,84,68,252	;101
	fcb	48,48,63,48,63,0,0,0	;102
	fcb	0,0,255,0,255,0,0,0	;103
	fcb	12,12,252,12,252,0,0,0	;104
	fcb	48,48,48,48,48,48,48,48	;105
	fcb	12,12,12,12,12,12,12,12	;106
	fcb	127,213,213,221,201,201,255,255	;107
	fcb	254,186,34,186,10,186,254,252	;108
	fcb	127,201,205,207,203,201,255,255	;109
	fcb	254,114,82,82,82,114,254,252	;110
	fcb	48,48,63,48,63,48,48,48	;111
	fcb	12,12,252,12,252,12,12,12	;112
	fcb	0,0,127,128,128,127,0,0	;113
	fcb	0,0,254,1,1,254,0,0	;114
	fcb	24,102,66,129,129,66,102,24	;115
	fcb	24,126,102,195,195,102,126,24	;116
	fcb	24,126,126,231,231,126,126,24	;117
	fcb	24,126,126,255,255,126,126,24	;118
	fcb	0,0,0,28,24,20,2,0	;119
	fcb	16,16,0,198,0,16,16,0	;120
	fcb	255,129,129,129,129,129,129,255	;121
	fcb	255,255,255,255,255,255,255,255	;122 lower case z slot


vga_print
	ldy	vga_print_y

	clr	vga_print_cnt2	;len counter
	lda	vga_print_start
	leay	a,y	;y should be set already
; text in position
	lda	vga_print_disp
	bne	vga_print_setos
	ldx	#$e00
	bra	vga_print_setst
vga_print_setos
	ldx	#$2600
vga_print_setst
	lda	vga_print_cx
	cmpa	#119
	bls	vga_print_lp0
	rts	;outa range
vga_print_lp0
	lda	vga_print_cy
	cmpa	#87
	bls	vga_print_lp01
	rts	;outa range
; calc screen
vga_print_lp01
	lda	vga_print_cy
	ldb	#64
	mul
	leax	d,x
	ldb	vga_print_cx
	lsrb
	abx
; screen is ready
vga_print_lp1
	inc	vga_print_cnt2
	lda	vga_print_cnt2
	cmpa	vga_print_len
	bhi	vga_print_dones	;done string
	lda	,y+
; process this ascii code
	bne	vga_print_ms1
vga_print_dones
	rts	;done string
vga_print_ms1
	cmpa	#32
	blo	vga_print_adjusthf
	suba	#32
	bra	vga_print_lpp2
; make adjustment here if any
vga_print_adjusthf
	adda	#32
vga_print_lpp2
	ldu	#vga_print_ascii32
	ldb	#8
	mul
	leau	d,u
; should be there
;
	clr	vga_print_cntr
vga_print_main
	inc	vga_print_cntr
	lda	vga_print_cntr
	cmpa	#9
	blo	vga_print_main2
; need to fetch next chr
	leax	-508,x	;hopefully right?
	bra	vga_print_lp1
;
vga_print_main2
	lda	,u+
	bita	#128
	lbne	vga_print_lpd1
	clr	vga_print_dot1
	ldb	vga_print_ct
	beq	vga_print_rpd1	;not transparent
	ldb	,x
	lsrb
	lsrb
	lsrb
	lsrb
	stb	vga_print_dot1	;saved background dot
vga_print_rpd1
	bita	#64
	lbne	vga_print_lpd2
	clr	vga_print_dot2
	ldb	vga_print_ct
	beq	vga_print_rpd2	;not transparent
	ldb	,x
	orb	#240
	subb	#240
	stb	vga_print_dot2	;save background dot
vga_print_rpd2
	bita	#32
	lbne	vga_print_lpd3
	clr	vga_print_dot3
	ldb	vga_print_ct
	beq	vga_print_rpd3	;not transparent
	ldb	1,x
	lsrb
	lsrb
	lsrb
	lsrb
	stb	vga_print_dot3	;saved
vga_print_rpd3
	bita	#16
	lbne	vga_print_lpd4
	clr	vga_print_dot4
	ldb	vga_print_ct
	beq	vga_print_rpd4
	ldb	1,x
	orb	#240
	subb	#240
	stb	vga_print_dot4	;saved
vga_print_rpd4
	bita	#8
	lbne	vga_print_lpd5
	clr	vga_print_dot5
	ldb	vga_print_ct
	beq	vga_print_rpd5
	ldb	2,x
	lsrb
	lsrb
	lsrb
	lsrb
	stb	vga_print_dot5	;saved
vga_print_rpd5
	bita	#4
	lbne	vga_print_lpd6
	clr	vga_print_dot6
	ldb	vga_print_ct
	beq	vga_print_rpd6
	ldb	2,x
	orb	#240
	subb	#240
	stb	vga_print_dot6	;saved
vga_print_rpd6
	bita	#2
	lbne	vga_print_lpd7
	clr	vga_print_dot7
	ldb	vga_print_ct
	beq	vga_print_rpd7
	ldb	3,x
	lsrb
	lsrb
	lsrb
	lsrb
	stb	vga_print_dot7	;saved
vga_print_rpd7
	bita	#1
	lbne	vga_print_lpd8
	clr	vga_print_dot8
	ldb	vga_print_ct
	beq	vga_print_lp3
	ldb	3,x
	orb	#240
	subb	#240
	stb	vga_print_dot8	;saved
vga_print_rpd8
	bra	vga_print_lp3
vga_print_lpd1
	ldb	vga_print_cc
	stb	vga_print_dot1
	lbra	vga_print_rpd1
vga_print_lpd2
	ldb	vga_print_cc
	stb	vga_print_dot2
	lbra	vga_print_rpd2
vga_print_lpd3
	ldb	vga_print_cc
	stb	vga_print_dot3
	lbra	vga_print_rpd3
vga_print_lpd4
	ldb	vga_print_cc
	stb	vga_print_dot4
	lbra	vga_print_rpd4
vga_print_lpd5
	ldb	vga_print_cc
	stb	vga_print_dot5
	lbra	vga_print_rpd5
vga_print_lpd6
	ldb	vga_print_cc
	stb	vga_print_dot6
	lbra	vga_print_rpd6
vga_print_lpd7
	ldb	vga_print_cc
	stb	vga_print_dot7
	lbra	vga_print_rpd7
vga_print_lpd8
	ldb	vga_print_cc
	stb	vga_print_dot8
; ok we set the dots hopefully
vga_print_lp3
	lda	vga_print_dot1
	ldb	#16
	mul
	addb	vga_print_dot2
	stb	,x
	lda	vga_print_dot3
	ldb	#16
	mul
	addb	vga_print_dot4
	stb	1,x
	lda	vga_print_dot5
	ldb	#16
	mul
	addb	vga_print_dot6
	stb	2,x
	lda	vga_print_dot7
	ldb	#16
	mul
	addb	vga_print_dot8
	stb	3,x
	leax	64,x	;next line
	lbra	vga_print_main
endfunction



;
; *************************************************************************************************************************
; * set(x,y,c)
; *************************************************************************************************************************
function	vga_set	vga_set_x1,vga_set_y1,vga_set_setcol
rem	vga_set(x,y,color)
rem	x=0-127 0-95 color 0-15
rem	does not push to stack
def	vga_set_x1	byte
def	vga_set_y1	byte
def	vga_set_setcol	byte
def	vga_set_odd	byte
def	vga_set_dot1	byte
def	vga_set_dot2	byte


vga_set
	clr	vga_set_odd
	lda	vga_set_x1
	cmpa	#127
	bls	vga_set_xok
	rts
vga_set_xok
	lda	vga_set_y1
	cmpa	#95
	bls	vga_set_yok
	rts
vga_set_yok
	ldx	#$e00
	ldb	#64
	mul
	leax	d,x
	ldb	vga_set_x1
	bitb	#1
	bne	vga_set_notodd
	inc	vga_set_odd
vga_set_notodd
	lsrb
	leax	b,x	
; ok x is ready to draw dots
; lets grab what we have
	lda	,x
	ora	#240
	suba	#240
	sta	vga_set_dot2
	lda	,x
	lsra
	lsra
	lsra
	lsra
	sta	vga_set_dot1
	lda	vga_set_setcol
	ldb	vga_set_odd
	beq	vga_set_second
; first dot draw
	sta	vga_set_dot1
	lda	vga_set_dot1
	ldb	#16
	mul
	addb	vga_set_dot2
	stb	,x
	rts
vga_set_second
	sta	vga_set_dot2
	lda	vga_set_dot1
	ldb	#16
	mul
	addb	vga_set_dot2
	stb	,x
	rts
endfunction
;





; ***************************************************************************************************************
; *   vga_line(x1,y1,x2,y2,color)   sg mode
; ***************************************************************************************************************
function	vga_line	vga_line_x1,vga_line_y1,vga_line_x2,vga_line_y2,vga_line_setcol
rem	vga_line(x1.b,y1.b,x2.b,y2.b,col.b)
rem	color 0-8
rem	does not push to stack
def	vga_line_x1	byte
def	vga_line_y1	byte
def	vga_line_x2	byte
def	vga_line_y2	byte
def	vga_line_setcol	byte

def	vga_line_dot1	byte
def	vga_line_dot2	byte

def	vga_line_xd	byte
def	vga_line_yd	byte
def	vga_line_xc	byte
def	vga_line_yc	byte
def	vga_line_wn	byte
def	vga_line_cnt	byte
def	vga_line_setx	byte
def	vga_line_sety	byte
def	vga_line_odd	byte


vga_line
	lda	vga_line_x1	;ok no swapping just get distances
	cmpa	vga_line_x2
	bls	vga_line_lins1	;if x1 is lower
	suba	vga_line_x2	;its greater so sub x2
	sta	vga_line_xd	;save x distance
	bra	vga_line_lins2
vga_line_lins1
	lda	vga_line_x2
	suba	vga_line_x1
	sta	vga_line_xd
;
vga_line_lins2
	lda	vga_line_y1	;ok now lets look at y
	cmpa	vga_line_y2
	bls	vga_line_lins3	;y1 is lower?
	suba	vga_line_y2
	sta	vga_line_yd	;save y distance
	bra	vga_line_lins4
vga_line_lins3
	lda	vga_line_y2
	suba	vga_line_y1
	sta	vga_line_yd
;
;which is greater?
vga_line_lins4
	lda	vga_line_yd
	cmpa	vga_line_xd
	blo	vga_line_lins5	;y is lower then goto lins5
	sta	vga_line_wn	;x is lower so save y as whole fraction
	bra	vga_line_lins6	;done
vga_line_lins5
	lda	vga_line_xd	;nope y is lower so save x as whole fraction
	sta	vga_line_wn	;stored it
; ok now the main loop
vga_line_lins6
	clra
	sta	vga_line_xc	;x counter
	sta	vga_line_yc	;y counter
	lda	vga_line_wn
	sta	vga_line_cnt	;set counter
	inc	vga_line_cnt
;ok check what display
;
vga_line_line22
	ldd	vga_line_x1	;main loop
;	sta	vga_line_setx
;	lda	vga_line_y1
;	stb	vga_line_sety
	jsr	vga_line_set	;jump to draw dot
	lda	vga_line_xc
	adda	vga_line_xd	;add distance to xc counter
	cmpa	vga_line_wn	;has it gone over or same as our whole fraction?
	bhs	vga_line_adv2	;it has on x.... lets advance it
	sta	vga_line_xc	;nope keep counting 
	bra	vga_line_chk2	;lets check y now
;
vga_line_adv2
	suba	vga_line_wn	;advance the x counter....subtract the whole fraction
	sta	vga_line_xc	;store remainder to play with next loop
	lda	vga_line_x1
	cmpa	vga_line_x2
	bhi	vga_line_advx2
	inc	vga_line_x1	;increase y plot or dec?
	bra	vga_line_chk2
vga_line_advx2
	dec	vga_line_x1
vga_line_chk2
	lda	vga_line_yc	;now the y axis.... loader up
	adda	vga_line_yd	;add its distance
	cmpa	vga_line_wn	;has it gone over or the same as our whole fraction
	bhs	vga_line_advy2	;it has on y.... lets advance it
	sta	vga_line_yc	;nope... keep counting
	bra	vga_line_chkx2	;done
;advance it
vga_line_advy2
	suba	vga_line_wn	;subtract the whole number from y counter
	sta	vga_line_yc	;store the remainder for next loop
	lda	vga_line_y1
	cmpa	vga_line_y2
	bhi	vga_line_ady2
	inc	vga_line_y1	;increase y plot or dec?
	bra	vga_line_chkx2
vga_line_ady2
	dec	vga_line_y1
;done?
vga_line_chkx2
	dec	vga_line_cnt	;check the counter
	bne	vga_line_line22	;nope keep plotting the line
	rts	;we are done
;
vga_line_set
	clr	vga_line_odd
	lda	vga_line_x1
	cmpa	#127
	bls	vga_line_xok
	rts
vga_line_xok
	lda	vga_line_y1
	cmpa	#95
	bls	vga_line_yok
	rts
vga_line_yok
	ldx	#$e00
	ldb	#64
	mul
	leax	d,x
	ldb	vga_line_x1
	bitb	#1
	bne	vga_line_notodd
	inc	vga_line_odd
vga_line_notodd
	lsrb
	leax	b,x	
; ok x is ready to draw dots
; lets grab what we have
	lda	,x
	ora	#240
	suba	#240
	sta	vga_line_dot2
	lda	,x
	lsra
	lsra
	lsra
	lsra
	sta	vga_line_dot1
	lda	vga_line_setcol
	ldb	vga_line_odd
	beq	vga_line_second

; first dot draw

	sta	vga_line_dot1
	lda	vga_line_dot1
	ldb	#16
	mul
	addb	vga_line_dot2
	stb	,x
	rts

vga_line_second

	sta	vga_line_dot2
	lda	vga_line_dot1
	ldb	#16
	mul
	addb	vga_line_dot2
	stb	,x
	rts
endfunction
;




