#dontinclude

;****************************************
; 2d collision function
;****************************************

function	init_collision
rem	init_collision()
rem	
rem	sets up sqrt for collision functions
rem	

init_collision
	rts

collision_sqrt
	dc.b	0,1,1,1,2,2,2,2,2,3,3,3,3,3,3,3
	dc.b	4,4,4,4,4,4,4,4,4,5,5,5,5,5,5,5
	dc.b	5,5,5,5,6,6,6,6,6,6,6,6,6,6,6,6
	dc.b	6,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
	dc.b	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8
	dc.b	8,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9
	dc.b	9,9,9,9,10,10,10,10,10,10,10,10,10,10,10,10
	dc.b	10,10,10,10,10,10,10,10,10,11,11,11,11,11,11,11
	dc.b	11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11
	dc.b	12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12
	dc.b	12,12,12,12,12,12,12,12,12,13,13,13,13,13,13,13
	dc.b	13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13
	dc.b	13,13,13,13,14,14,14,14,14,14,14,14,14,14,14,14
	dc.b	14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14
	dc.b	14,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
	dc.b	15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15
	dc.b	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	dc.b	16,16,16,16,16,16,16,16,16,16,16,16,16,16,16,16
	dc.b	16,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17
	dc.b	17,17,17,17,17,17,17,17,17,17,17,17,17,17,17,17
	dc.b	17,17,17,17,18,18,18,18,18,18,18,18,18,18,18,18
	dc.b	18,18,18,18,18,18,18,18,18,18,18,18,18,18,18,18
	dc.b	18,18,18,18,18,18,18,18,18,19,19,19,19,19,19,19
	dc.b	19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19
	dc.b	19,19,19,19,19,19,19,19,19,19,19,19,19,19,19,19
	dc.b	20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20
	dc.b	20,20,20,20,20,20,20,20,20,20,20,20,20,20,20,20
	dc.b	20,20,20,20,20,20,20,20,20,21,21,21,21,21,21,21
	dc.b	21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21
	dc.b	21,21,21,21,21,21,21,21,21,21,21,21,21,21,21,21
	dc.b	21,21,21,21,22,22,22,22,22,22,22,22,22,22,22,22
	dc.b	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22
	dc.b	22,22,22,22,22,22,22,22,22,22,22,22,22,22,22,22
	dc.b	22,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
	dc.b	23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
	dc.b	23,23,23,23,23,23,23,23,23,23,23,23,23,23,23,23
	dc.b	24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
	dc.b	24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
	dc.b	24,24,24,24,24,24,24,24,24,24,24,24,24,24,24,24
	dc.b	24,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25
	dc.b	25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25
	dc.b	25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25
	dc.b	25,25,25,25,26,26,26,26,26,26,26,26,26,26,26,26
	dc.b	26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26
	dc.b	26,26,26,26,26,26,26,26,26,26,26,26,26,26,26,26
	dc.b	26,26,26,26,26,26,26,26,26,27,27,27,27,27,27,27
	dc.b	27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27
	dc.b	27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27
	dc.b	27,27,27,27,27,27,27,27,27,27,27,27,27,27,27,27
	dc.b	28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28
	dc.b	28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28
	dc.b	28,28,28,28,28,28,28,28,28,28,28,28,28,28,28,28
	dc.b	28,28,28,28,28,28,28,28,28,29,29,29,29,29,29,29
	dc.b	29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29
	dc.b	29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29
	dc.b	29,29,29,29,29,29,29,29,29,29,29,29,29,29,29,29
	dc.b	29,29,29,29,30,30,30,30,30,30,30,30,30,30,30,30
	dc.b	30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
	dc.b	30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
	dc.b	30,30,30,30,30,30,30,30,30,30,30,30,30,30,30,30
	dc.b	30,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31
	dc.b	31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31
	dc.b	31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31
	dc.b	31,31,31,31,31,31,31,31,31,31,31,31,31,31,31,31
	dc.b	32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	dc.b	32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	dc.b	32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	dc.b	32,32,32,32,32,32,32,32,32,32,32,32,32,32,32,32
	dc.b	32,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33
	dc.b	33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33
	dc.b	33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33
	dc.b	33,33,33,33,33,33,33,33,33,33,33,33,33,33,33,33
	dc.b	33,33,33,33,34,34,34,34,34,34,34,34,34,34,34,34
	dc.b	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34
	dc.b	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34
	dc.b	34,34,34,34,34,34,34,34,34,34,34,34,34,34,34,34
	dc.b	34,34,34,34,34,34,34,34,34,35,35,35,35,35,35,35
	dc.b	35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35
	dc.b	35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35
	dc.b	35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35
	dc.b	35,35,35,35,35,35,35,35,35,35,35,35,35,35,35,35
	dc.b	36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
	dc.b	36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
	dc.b	36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
	dc.b	36,36,36,36,36,36,36,36,36,36,36,36,36,36,36,36
	dc.b	36,36,36,36,36,36,36,36,36,37,37,37,37,37,37,37
	dc.b	37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37
	dc.b	37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37
	dc.b	37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37
	dc.b	37,37,37,37,37,37,37,37,37,37,37,37,37,37,37,37
	dc.b	37,37,37,37,38,38,38,38,38,38,38,38,38,38,38,38
	dc.b	38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38
	dc.b	38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38
	dc.b	38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38
	dc.b	38,38,38,38,38,38,38,38,38,38,38,38,38,38,38,38
	dc.b	38,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
	dc.b	39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
	dc.b	39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
	dc.b	39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
	dc.b	39,39,39,39,39,39,39,39,39,39,39,39,39,39,39,39
	dc.b	40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	dc.b	40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	dc.b	40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	dc.b	40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	dc.b	40,40,40,40,40,40,40,40,40,40,40,40,40,40,40,40
	dc.b	40,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41
	dc.b	41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41
	dc.b	41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41
	dc.b	41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41
	dc.b	41,41,41,41,41,41,41,41,41,41,41,41,41,41,41,41
	dc.b	41,41,41,41,42,42,42,42,42,42,42,42,42,42,42,42
	dc.b	42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42
	dc.b	42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42
	dc.b	42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42
	dc.b	42,42,42,42,42,42,42,42,42,42,42,42,42,42,42,42
	dc.b	42,42,42,42,42,42,42,42,42,43,43,43,43,43,43,43
	dc.b	43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43
	dc.b	43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43
	dc.b	43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43
	dc.b	43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43
	dc.b	43,43,43,43,43,43,43,43,43,43,43,43,43,43,43,43
	dc.b	44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44
	dc.b	44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44
	dc.b	44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44
	dc.b	44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44
	dc.b	44,44,44,44,44,44,44,44,44,44,44,44,44,44,44,44
	dc.b	44,44,44,44,44,44,44,44,44,45,45,45,45,45,45,45
	dc.b	45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45
	dc.b	45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45
	dc.b	45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45
	dc.b	45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45
	dc.b	45,45,45,45,45,45,45,45,45,45,45,45,45,45,45,45
	dc.b	45,45,45,45,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,46,46,46,46,46,46,46,46,46,46,46,46,46,46,46
	dc.b	46,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	47,47,47,47,47,47,47,47,47,47,47,47,47,47,47,47
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,48,48,48,48,48,48,48,48,48,48,48,48,48,48,48
	dc.b	48,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,49,49,49,49,49,49,49,49,49,49,49,49
	dc.b	49,49,49,49,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,50,50,50,50,50,50,50
	dc.b	50,50,50,50,50,50,50,50,50,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	51,51,51,51,51,51,51,51,51,51,51,51,51,51,51,51
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,52,52,52,52,52,52,52
	dc.b	52,52,52,52,52,52,52,52,52,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,53,53,53,53,53,53,53,53,53,53,53,53
	dc.b	53,53,53,53,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,54,54,54,54,54,54,54,54,54,54,54,54,54,54,54
	dc.b	54,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	55,55,55,55,55,55,55,55,55,55,55,55,55,55,55,55
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,56,56,56,56,56,56,56,56,56,56,56,56,56,56,56
	dc.b	56,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,57,57,57,57,57,57,57,57,57,57,57,57
	dc.b	57,57,57,57,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,58,58,58,58,58,58,58
	dc.b	58,58,58,58,58,58,58,58,58,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	59,59,59,59,59,59,59,59,59,59,59,59,59,59,59,59
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,60,60,60,60,60,60,60
	dc.b	60,60,60,60,60,60,60,60,60,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,61,61,61,61,61,61,61,61,61,61,61,61
	dc.b	61,61,61,61,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,62,62,62,62,62,62,62,62,62,62,62,62,62,62,62
	dc.b	62,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	63,63,63,63,63,63,63,63,63,63,63,63,63,63,63,63
	dc.b	64,64
endfunction






;*********************************************************************************************************************************************************************************
;*********************************************************************************************************************************************************************************

function	triangle_collision	triangle_collision_or,triangle_collision_x1,triangle_collision_y1,triangle_collision_size0,triangle_collision_x,triangle_collision_y,triangle_collision_size1
rem	triangle_collision( orientation.w , x1.w , y1.w , size0.w , x2.w , y2.w , size1.w )
rem	
rem	orientation is clockwise starting from downleft 1-4
rem	returns value of 1 on d7 if collision detected

def	triangle_collision_or	word
def	triangle_collision_x1	word
def	triangle_collision_y1	word
def	triangle_collision_size0	word
def	triangle_collision_x	word
def	triangle_collision_y	word
def	triangle_collision_size1	word

def	triangle_collision_spanx	word
def	triangle_collision_spany	word


stack	d0-d5

triangle_collision


	move.w	triangle_collision_x1,d0
	sub.w	triangle_collision_size0,d0
	sub.w	triangle_collision_size1,d0

	move.w	triangle_collision_x1,d1
	add.w	triangle_collision_size0,d1
	add.w	triangle_collision_size1,d1

	move.w	triangle_collision_y1,d2
	sub.w	triangle_collision_size0,d2
	sub.w	triangle_collision_size1,d2

	move.w	triangle_collision_y1,d3
	add.w	triangle_collision_size0,d3
	add.w	triangle_collision_size1,d3

	clr.l	d4
;	clr.l	d5


	if	w,triangle_collision_or=#1
	move.w	triangle_collision_y,d4
	sub.w	d2,d4
	add.w	triangle_collision_x1,d4
	endif

	if	w,triangle_collision_or=#2
	move.w	d1,d4
	sub.w	triangle_collision_x,d4
	add.w	d2,d4
	add.w	triangle_collision_size0,d4
	add.w	triangle_collision_size1,d4
	endif

	if	w,triangle_collision_or=#3
	move.w	triangle_collision_y,d4
	sub.w	d2,d4
	add.w	triangle_collision_x1,d4
	sub.w	triangle_collision_size0,d4
	sub.w	triangle_collision_size0,d4
	sub.w	triangle_collision_size1,d4
	sub.w	triangle_collision_size1,d4

	endif

	if	w,triangle_collision_or=#4
	move.w	d1,d4
	sub.w	triangle_collision_x,d4
	add.w	d2,d4
	sub.w	triangle_collision_size0,d4
	sub.w	triangle_collision_size1,d4
	endif



	if	w,d0<triangle_collision_x	w,d1>triangle_collision_x
	if	w,d2<triangle_collision_y	w,d3>triangle_collision_y


	if	w,triangle_collision_or=#1	w,triangle_collision_x<d4
	move.l	#1,d7
	rts
	endif

	if	w,triangle_collision_or=#2	w,triangle_collision_y<d4
	move.l	#1,d7
	rts
	endif


	if	w,triangle_collision_or=#3	w,triangle_collision_x>d4
	move.l	#1,d7
	rts
	endif

	if	w,triangle_collision_or=#4	w,triangle_collision_y>d4
	move.l	#1,d7
	rts
	endif


	endif
	endif




;no collision
	clr.l	d7
	rts
endfunction

;***************************************************************************************************************************************************************************************
;***************************************************************************************************************************************************************************************

function	box_collision	box_collision_x,box_collision_y,box_collision_size1,box_collision_x1,box_collision_y1,box_collision_size0
rem	box_collision( x1.w , y1.w , size1.w , x2.w , y2.w , size2.w )
rem	
rem	returns a value of one if the second point is inside the first points box on d7
rem	
def	box_collision_x	word
def	box_collision_y	word
def	box_collision_size1	word

def	box_collision_x1	word
def	box_collision_y1	word
def	box_collision_size0	word
stack	d0-d3
box_collision

	move.w	box_collision_x1,d0
	sub.w	box_collision_size0,d0
	sub.w	box_collision_size1,d0
	move.w	box_collision_x1,d1
	add.w	box_collision_size0,d1
	add.w	box_collision_size1,d1

	move.w	box_collision_y1,d2
	sub.w	box_collision_size0,d2
	sub.w	box_collision_size1,d2
	move.w	box_collision_y1,d3
	add.w	box_collision_size0,d3
	add.w	box_collision_size1,d3


	if	w,d0<box_collision_x	w,d1>box_collision_x
	if	w,d2<box_collision_y	w,d3>box_collision_y
; direction push out
;	move.w	box_collision_x1,d0
;	move.w	box_collision_x,d1


	move.l	#1,d7
	rts


	endif
	endif

	clr.l	d7
	rts
endfunction



;***************************************************************************************************************************************************************************************
;***************************************************************************************************************************************************************************************

function	box_collisionx	box_collisionx_x,box_collisionx_y,box_collisionx_size1,box_collisionx_x1,box_collisionx_y1,box_collisionx_size0
rem	box_collisionx( x1.w , y1.w , size0.w , x2.w , y2.w , size1.w )
rem	
rem	returns new x2.w value from push out on d7
rem	
def	box_collisionx_x	word
def	box_collisionx_y	word
def	box_collisionx_size1	word

def	box_collisionx_x1	word
def	box_collisionx_y1	word
def	box_collisionx_size0	word
def	box_collisionx_spanx	word
def	box_collisionx_spany	word

stack	d0-d3
box_collisionx

	move.w	box_collisionx_x1,d0
	sub.w	box_collisionx_size0,d0
	sub.w	box_collisionx_size1,d0
	move.w	box_collisionx_x1,d1
	add.w	box_collisionx_size0,d1
	add.w	box_collisionx_size1,d1

	move.w	box_collisionx_y1,d2
	sub.w	box_collisionx_size0,d2
	sub.w	box_collisionx_size1,d2
	move.w	box_collisionx_y1,d3
	add.w	box_collisionx_size0,d3
	add.w	box_collisionx_size1,d3

	if	w,box_collisionx_x1=>box_collisionx_x
	move.w	box_collisionx_x1,d7
	sub.w	box_collisionx_x,d7
	move.w	d7,box_collisionx_spanx
	else
	move.w	box_collisionx_x,d7
	sub.w	box_collisionx_x1,d7
	move.w	d7,box_collisionx_spanx
	endif

	if	w,box_collisionx_y1=>box_collisionx_y
	move.w	box_collisionx_y1,d7
	sub.w	box_collisionx_y,d7
	move.w	d7,box_collisionx_spany
	else
	move.w	box_collisionx_y,d7
	sub.w	box_collisionx_y1,d7
	move.w	d7,box_collisionx_spany
	endif



	if	w,d0<box_collisionx_x	w,d1>box_collisionx_x
	if	w,d2<box_collisionx_y	w,d3>box_collisionx_y

; direction push out

	if	w,box_collisionx_x1>box_collisionx_x

	if	w,box_collisionx_spanx>box_collisionx_spany
	clr.l	d7
	move.w	box_collisionx_x1,d7
	sub.w	box_collisionx_size0,d7
	sub.w	box_collisionx_size1,d7
	rts
	endif

	if	w,box_collisionx_spanx=box_collisionx_spany
	clr.l	d7
	move.w	box_collisionx_x1,d7
	sub.w	box_collisionx_size0,d7
	sub.w	box_collisionx_size1,d7
	add.w	#1,d7
	rts
	endif


	else

	if	w,box_collisionx_spanx>box_collisionx_spany
	clr.l	d7
	move.w	box_collisionx_x1,d7
	add.w	box_collisionx_size0,d7
	add.w	box_collisionx_size1,d7
	rts
	endif

	if	w,box_collisionx_spanx=box_collisionx_spany
	clr.l	d7
	move.w	box_collisionx_x1,d7
	add.w	box_collisionx_size0,d7
	add.w	box_collisionx_size1,d7
	sub.w	#1,d7
	rts
	endif

	endif

	endif
	endif
;exit no change
	clr.l	d7
	move.w	box_collisionx_x,d7
	rts
endfunction




;***************************************************************************************************************************************************************************************
;***************************************************************************************************************************************************************************************

function	box_collisiony	box_collisiony_x,box_collisiony_y,box_collisiony_size1,box_collisiony_x1,box_collisiony_y1,box_collisiony_size0
rem	box_collisiony( x1.w , y1.w , size0.w , x2.w , y2.w ,size1.w )
rem	
rem	returns new y2.w value from push out on d7
rem	
def	box_collisiony_x	word
def	box_collisiony_y	word
def	box_collisiony_size1	word

def	box_collisiony_x1	word
def	box_collisiony_y1	word
def	box_collisiony_size0	word
def	box_collisiony_spanx	word
def	box_collisiony_spany	word

stack	d0-d3
box_collisiony

	move.w	box_collisiony_x1,d0
	sub.w	box_collisiony_size0,d0
	sub.w	box_collisiony_size1,d0
	move.w	box_collisiony_x1,d1
	add.w	box_collisiony_size0,d1
	add.w	box_collisiony_size1,d1

	move.w	box_collisiony_y1,d2
	sub.w	box_collisiony_size0,d2
	sub.w	box_collisiony_size1,d2
	move.w	box_collisiony_y1,d3
	add.w	box_collisiony_size0,d3
	add.w	box_collisiony_size1,d3


	if	w,box_collisiony_x1=>box_collisiony_x
	move.w	box_collisiony_x1,d7
	sub.w	box_collisiony_x,d7
	move.w	d7,box_collisiony_spanx
	else
	move.w	box_collisiony_x,d7
	sub.w	box_collisiony_x1,d7
	move.w	d7,box_collisiony_spanx
	endif

	if	w,box_collisiony_y1=>box_collisiony_y
	move.w	box_collisiony_y1,d7
	sub.w	box_collisiony_y,d7
	move.w	d7,box_collisiony_spany
	else
	move.w	box_collisiony_y,d7
	sub.w	box_collisiony_y1,d7
	move.w	d7,box_collisiony_spany
	endif



	if	w,d0<box_collisiony_x	w,d1>box_collisiony_x
	if	w,d2<box_collisiony_y	w,d3>box_collisiony_y

; direction push out

	if	w,box_collisiony_y1>box_collisiony_y

	if	w,box_collisiony_spanx<box_collisiony_spany
	clr.l	d7
	move.w	box_collisiony_y1,d7
	sub.w	box_collisiony_size0,d7
	sub.w	box_collisiony_size1,d7
	rts
	endif

	if	w,box_collisiony_spanx=box_collisiony_spany
	clr.l	d7
	move.w	box_collisiony_y1,d7
	sub.w	box_collisiony_size0,d7
	sub.w	box_collisiony_size1,d7
	add.w	#1,d7
	rts
	endif


	else

	if	w,box_collisiony_spanx<box_collisiony_spany
	clr.l	d7
	move.w	box_collisiony_y1,d7
	add.w	box_collisiony_size0,d7
	add.w	box_collisiony_size1,d7
	rts
	endif

	if	w,box_collisiony_spanx=box_collisiony_spany
	clr.l	d7
	move.w	box_collisiony_y1,d7
	add.w	box_collisiony_size0,d7
	add.w	box_collisiony_size1,d7
	sub.w	#1,d7
	rts
	endif


	endif

	endif
	endif
;exit no change
	clr.l	d7
	move.w	box_collisiony_y,d7
	rts
endfunction


;**********************************************************************************************************************************************
;**********************************************************************************************************************************************


function	squareroot	squareroot_v
def	squareroot_v	word
rem	squareroot( value.w )
rem	
rem	maximum calculated value can be from 4095
rem	returns result on d7
stack a0/d6
squareroot
	clr.l	d6
	move.w	squareroot_v,d6
	if	w,d6>#4095
	move.l	#64,d7
	rts
	endif

	move.l	#collision_sqrt,a0
	lea	(a0,d6.w),a0
	clr.l	d7
	move.b	(a0),d7
	rts
endfunction



;*************************************************************************************************************************************************
;*************************************************************************************************************************************************

function	distance2d	distance2d_x1,distance2d_y1,distance2d_x2,distance2d_y2
rem	distance2d( x1.w , y1.w , x2.w , y2.w )
rem
rem	returns distance between two points with the range 0 to 64 max
rem	returns 64 if out of range. returns value on d7.b
def	distance2d_x1	word
def	distance2d_y1	word
def	distance2d_x2	word
def	distance2d_y2	word

stack	a0/d0-d2

distance2d
	clr.l	d0
	clr.l	d1
	clr.l	d2

; calc x
	if	w,distance2d_x1=>distance2d_x2
	move.w	distance2d_x1,d0
	sub.w	distance2d_x2,d0
	else
	move.w	distance2d_x2,d0
	sub.w	distance2d_x1,d0
	endif
; calc y
	if	w,distance2d_y1=>distance2d_y2
	move.w	distance2d_y1,d1
	sub.w	distance2d_y2,d1
	else
	move.w	distance2d_y2,d1
	sub.w	distance2d_y1,d1
	endif

; mulu itsself
	move.l	d0,d2
	mulu.w	d2,d0
	move.l	d1,d2
	mulu.w	d2,d1
; now add together
	add.l	d0,d1
	clr.l	d7

	if	l,d1>#4095
	move.l	#64,d7
	rts
	endif
	move.l	#64,d7
	lea	collision_sqrt,a0
	lea	(a0,d1.l),a0
	move.b	(a0),d7


	rts
endfunction




;****************************************************************************************************************************************
;****************************************************************************************************************************************
function	sphere_collision	sphere_collision_x1,sphere_collision_y1,sphere_collision_rad0,sphere_collision_x2,sphere_collision_y2,sphere_collision_rad1
def	sphere_collision_x1	word
def	sphere_collision_y1	word
def	sphere_collision_rad0	word
def	sphere_collision_x2	word
def	sphere_collision_y2	word
def	sphere_collision_rad1	word
def	sphere_collision_dist	word

rem	sphere_collision( x1.w , y1.w , rad0.w , x2.w , y2.w , rad1.w )
rem	returns collision rad length of intrusion 0 if none
rem	returns on d7.w
rem	

stack	a0/d0-d2

sphere_collision
	clr.l	d0
	clr.l	d1
; calc x
	if	w,sphere_collision_x1=>sphere_collision_x2
	move.w	sphere_collision_x1,d0
	sub.w	sphere_collision_x2,d0
	else
	move.w	sphere_collision_x2,d0
	sub.w	sphere_collision_x1,d0
	endif
; calc y
	if	w,sphere_collision_y1=>sphere_collision_y2
	move.w	sphere_collision_y1,d1
	sub.w	sphere_collision_y2,d1
	else
	move.w	sphere_collision_y2,d1
	sub.w	sphere_collision_y1,d1
	endif

; mulu itsself
	move.l	d0,d2
	mulu.w	d2,d0
	move.l	d1,d2
	mulu.w	d2,d1
; now add together
	add.w	d0,d1
	clr.l	d7

; if value is bigger then 4095 return collision result as 0
	if	w,d1=>#4095
	clr.l	d7
	rts
	endif

; now sqrt d1
	clr.l	d2

	move.l	#collision_sqrt,a0
	and.l	#$ffff,d1
	lea	(a0,d1.l),a0
	move.b	(a0),d2


; d2 has sqrt
	move.w	sphere_collision_rad0,d6
	add.w	sphere_collision_rad1,d6
	if	w,d6=>d2
	move.w	sphere_collision_rad0,d7
	add.w	sphere_collision_rad1,d7
	sub.w	d2,d7
	else
	clr.l	d7
	rts
	endif
; calc push out smooth
; d7 has push out



;	move.w	d7,sphere_collision_dist



;calc push out

;	clr.l	d7
;	move.w	sphere_collision_dist,d7

	rts
endfunction

;******************************************************************************************************************************************************************
;******************************************************************************************************************************************************************





