#dontinclude
; main library for the sega genesis
; May 7th 2022
; Writen By Sheldon MacDonald
;


; ***************************************************************************************
; * main_wordstring(value.w)   returns string address at a0
; ***************************************************************************************
; May 7th 2022 by Sheldon Macdonald
; 
function	main_wordstring		main_wordstring_value1
rem	main_wordstring( value.w ) returns human readable string on a6
rem	[ library usage d7/a6 ]
rem	DIRECT ACCESS: main_wordstring_value1 , main_wordstring_string1 , main_wordstring_string2 
def	main_wordstring_value1	word
def	main_wordstring_string1	string	6
def	main_wordstring_string2	string	6
main_wstr_str_numbers
	dc.b	'00000'
	dc.b	0
	dc.b	'00001'
	dc.b	0
	dc.b	'00002'
	dc.b	0
	dc.b	'00004'
	dc.b	0
	dc.b	'00008'
	dc.b	0
	dc.b	'00016'
	dc.b	0
	dc.b	'00032'
	dc.b	0
	dc.b	'00064'
	dc.b	0
	dc.b	'00128'
	dc.b	0
	dc.b	'00256'
	dc.b	0
	dc.b	'00512'
	dc.b	0
	dc.b	'01024'
	dc.b	0
	dc.b	'02048'
	dc.b	0
	dc.b	'04096'
	dc.b	0
	dc.b	'08192'
	dc.b	0
	dc.b	'16384'
	dc.b	0
	dc.b	'32768'
	dc.b	0
main_wordstring

	movem.l	a0-a2/d0-d2,-(a7)

	move.w	main_wordstring_value1,d0
	move.l	#main_wordstring_string1,a0
	move.l	#main_wordstring_string2,a1
	move.l	#$30303030,(0,a0)
	move.b	#$30,(4,a0)	;cleared set 1
	move.l	#$30303030,(0,a1)
	move.b	#$30,(4,a1)	;cleared set 2
; ready for some string math
	btst	#15,d0
	bne	main_wstr_stra16
main_wstr_wridr00:
	btst	#14,d0
	bne	main_wstr_stra15
main_wstr_wridr01:
	btst	#13,d0
	bne	main_wstr_stra14
main_wstr_wridr02:
	btst	#12,d0
	bne	main_wstr_stra13
main_wstr_wridr03:
	btst	#11,d0
	bne	main_wstr_stra12
main_wstr_wridr04:
	btst	#10,d0
	bne	main_wstr_stra11
main_wstr_wridr05:
	btst	#9,d0
	bne	main_wstr_stra10
main_wstr_wridr06:
	btst	#8,d0
	bne	main_wstr_stra09
main_wstr_wridr07:
	btst	#7,d0
	bne	main_wstr_stra08
main_wstr_wridr08:
	btst	#6,d0
	bne	main_wstr_stra07
main_wstr_wridr09:
	btst	#5,d0
	bne	main_wstr_stra06
main_wstr_wridr10:
	btst	#4,d0
	bne	main_wstr_stra05
main_wstr_wridr11:
	btst	#3,d0
	bne	main_wstr_stra04
main_wstr_wridr12:
	btst	#2,d0
	bne	main_wstr_stra03
main_wstr_wridr13:
	btst	#1,d0
	bne	main_wstr_stra02
main_wstr_wridr14:
	btst	#0,d0
	bne	main_wstr_stra01
	bra	main_wstr_strfix1
; jump over code
main_wstr_stra16:
	move.l	#main_wstr_str_numbers,a2
	move.l	#16,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr00
main_wstr_stra15:
	move.l	#main_wstr_str_numbers,a2
	move.l	#15,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr01
main_wstr_stra14:
	move.l	#main_wstr_str_numbers,a2
	move.l	#14,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr02
main_wstr_stra13:
	move.l	#main_wstr_str_numbers,a2
	move.l	#13,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr03
main_wstr_stra12:
	move.l	#main_wstr_str_numbers,a2
	move.l	#12,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr04
main_wstr_stra11:
	move.l	#main_wstr_str_numbers,a2
	move.l	#11,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr05
main_wstr_stra10:
	move.l	#main_wstr_str_numbers,a2
	move.l	#10,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr06
main_wstr_stra09:
	move.l	#main_wstr_str_numbers,a2
	move.l	#9,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr07
main_wstr_stra08:
	move.l	#main_wstr_str_numbers,a2
	move.l	#8,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr08
main_wstr_stra07:
	move.l	#main_wstr_str_numbers,a2
	move.l	#7,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr09
main_wstr_stra06:
	move.l	#main_wstr_str_numbers,a2
	move.l	#6,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr10
main_wstr_stra05:
	move.l	#main_wstr_str_numbers,a2
	move.l	#5,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr11
main_wstr_stra04:
	move.l	#main_wstr_str_numbers,a2
	move.l	#4,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr12
main_wstr_stra03:
	move.l	#main_wstr_str_numbers,a2
	move.l	#3,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr13
main_wstr_stra02:
	move.l	#main_wstr_str_numbers,a2
	move.l	#2,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
	bra	main_wstr_wridr14
main_wstr_stra01:
	move.l	#main_wstr_str_numbers,a2
	move.l	#1,d1
	move.l	#6,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_wstr_stringprocess
main_wstr_strfix1:
	move.l	#main_wordstring_string2,a6

	movem.l	(a7)+,a0-a2/d0-d2

	rts
main_wstr_stringprocess:
	move.l	(0,a2),d2
	move.l	d2,(0,a0)
	move.b	(4,a2),d2
	move.b	d2,(4,a0)
	move.w	#5,d1
;lets add the two strings together 5 chrs long and store answer in string 2
;start adding together
main_wstr_strlp1:
	sub.b	#1,d1	;main loop for math
	move.b	(a0,d1.w),d2	;set start x reference number to add to result
	add.b	(a1,d1.w),d2	;add u to y
	sub.b	#48,d2	;subtract 48 ascii "0" to bring ascii back into number range
	move.b	d2,(a1,d1.w)	;store answer
; //CHECK FOR CARRY
	cmp.b	#58,d2	;if the ascii=58 then the number is out of range.....this produces a carry
	bhs	main_wstr_strs0
	bra	main_wstr_strs1
main_wstr_strs0:
	sub.b	#10,d2	;subtract 10 from the ascii code to bring it back in range
	move.b	d2,(a1,d1.w)	;store remainder value
	sub.b	#48,d2	;need to subtract 48 ascii to bring this number back in range before saving it
	cmp.b	#0,d1	;if its already 0....cant carry
	beq	main_wstr_strs1
	sub.B	#1,d1	;lets go to next place for the carry
	move.b	(a1,d1.w),d2
	add.b	#1,d2
	move.b	d2,(a1,d1.w)
	add.b	#1,d1
main_wstr_strs1:
	cmp.b	#0,d1
	bhi	main_wstr_strlp1
	rts	;return from subroutine
endfunction





; ***************************************************************************************
; * main_bytestring(value.b)   returns string address at a0
; ***************************************************************************************
; May 7th 2022 by Sheldon Macdonald
; 
function	main_bytestring	main_bytestring_value1
rem	main_bytestring( value.b ) returns human readable string on a6
rem	[ library usage d7/a6 ]
rem	DIRECT ACCESS: main_bytestring_value1 , main_bytestring_string1 , main_bytestring_string2
def	main_bytestring_value1	byte
def	main_bytestring_v2	string	1
def	main_bytestring_string1	string	4
def	main_bytestring_string2	string	4
main_bstr_str_numbers:
	dc.b	'000'
	dc.b	0
	dc.b	'001'
	dc.b	0
	dc.b	'002'
	dc.b	0
	dc.b	'004'
	dc.b	0
	dc.b	'008'
	dc.b	0
	dc.b	'016'
	dc.b	0
	dc.b	'032'
	dc.b	0
	dc.b	'064'
	dc.b	0
	dc.b	'128'
	dc.b	0
main_bytestring

	movem.l	a0-a2/d0-d2,-(a7)

	clr.w	d0
	move.b	main_bytestring_value1,d0
	move.l	#main_bytestring_string1,a0
	move.l	#main_bytestring_string2,a1
	move.l	#$30303000,(0,a0)
	move.l	#$30303000,(0,a1)
	btst	#7,d0
	bne	main_bstr_stra08
main_bstr_wridr08:
	btst	#6,d0
	bne	main_bstr_stra07
main_bstr_wridr09:
	btst	#5,d0
	bne	main_bstr_stra06
main_bstr_wridr10:
	btst	#4,d0
	bne	main_bstr_stra05
main_bstr_wridr11:
	btst	#3,d0
	bne	main_bstr_stra04
main_bstr_wridr12:
	btst	#2,d0
	bne	main_bstr_stra03
main_bstr_wridr13:
	btst	#1,d0
	bne	main_bstr_stra02
main_bstr_wridr14:
	btst	#0,d0
	bne	main_bstr_stra01
	bra	main_bstr_strfix1
; jump over code
main_bstr_stra08:
	move.l	#main_bstr_str_numbers,a2
	move.l	#8,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr08
main_bstr_stra07:
	move.l	#main_bstr_str_numbers,a2
	move.l	#7,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr09
main_bstr_stra06:
	move.l	#main_bstr_str_numbers,a2
	move.l	#6,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr10
main_bstr_stra05:
	move.l	#main_bstr_str_numbers,a2
	move.l	#5,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr11
main_bstr_stra04:
	move.l	#main_bstr_str_numbers,a2
	move.l	#4,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr12
main_bstr_stra03:
	move.l	#main_bstr_str_numbers,a2
	move.l	#3,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr13
main_bstr_stra02:
	move.l	#main_bstr_str_numbers,a2
	move.l	#2,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
	bra	main_bstr_wridr14
main_bstr_stra01:
	move.l	#main_bstr_str_numbers,a2
	move.l	#1,d1
	move.l	#4,d2
	mulu.w	d1,d2
	lea	(a2,d2.w),a2
	jsr	main_bstr_stringprocess
main_bstr_strfix1:
	move.l	#main_bytestring_string2,a6

	movem.l	(a7)+,a0-a2/d0-d2


	rts
main_bstr_stringprocess:
	move.l	(0,a2),d2
	move.l	d2,(0,a0)
	move.b	(2,a2),d2
	move.b	d2,(2,a0)	;was 4
	move.w	#3,d1
;lets add the two strings together 3 chrs long and store answer in string 2
;start adding together
main_bstr_strlp1:
	sub.b	#1,d1	;main loop for math
	move.b	(a0,d1.w),d2	;set start x reference number to add to result
	add.b	(a1,d1.w),d2	;add u to y
	sub.b	#48,d2	;subtract 48 ascii "0" to bring ascii back into number range
	move.b	d2,(a1,d1.w)	;store answer
; //CHECK FOR CARRY
	cmp.b	#58,d2	;if the ascii=58 then the number is out of range.....this produces a carry
	bhs	main_bstr_strs0
	bra	main_bstr_strs1
main_bstr_strs0:
	sub.b	#10,d2	;subtract 10 from the ascii code to bring it back in range
	move.b	d2,(a1,d1.w)	;store remainder value
	sub.b	#48,d2	;need to subtract 48 ascii to bring this number back in range before saving it
	cmp.b	#0,d1	;if its already 0....cant carry
	beq	main_bstr_strs1
	sub.B	#1,d1	;lets go to next place for the carry
	move.b	(a1,d1.w),d2
	add.b	#1,d2
	move.b	d2,(a1,d1.w)
	add.b	#1,d1
main_bstr_strs1:
	cmp.b	#0,d1
	bhi	main_bstr_strlp1
	rts	;return from subroutine
endfunction




; ****************************************************************************
; main_binstring( value1.b)
; ****************************************************************************
function	main_binstring	main_binstring_value1
def	main_binstring_value1	byte
def	main_binstring_out2	string	1
def	main_binstring_out	string	8
rem	main_binstring( value.b )   returns string value on a6 with a binary number into asc code string
rem	[ library usage d7/a6 ]
rem	DIRECT ACCESS: main_binstring_value1 , main_binstring_out 

main_binstring
	

	move.b	main_binstring_value1,d7
	move.l	#main_binstring_out,a6
	move.l	#$30303030,(0,a6)
	move.l	#$30303030,(4,a6)

	btst	#7,d7
	beq	main_binstring_nextb6
	move.b	#$31,(0,a6)
main_binstring_nextb6
	btst	#6,d7
	beq	main_binstring_nextb5
	move.b	#$31,(1,a6)
main_binstring_nextb5
	btst	#5,d7
	beq	main_binstring_nextb4
	move.b	#$31,(2,a6)
main_binstring_nextb4
	btst	#4,d7
	beq	main_binstring_nextb3
	move.b	#$31,(3,a6)
main_binstring_nextb3
	btst	#3,d7
	beq	main_binstring_nextb2
	move.b	#$31,(4,a6)
main_binstring_nextb2
	btst	#2,d7
	beq	main_binstring_nextb1
	move.b	#$31,(5,a6)
main_binstring_nextb1
	btst	#1,d7
	beq	main_binstring_nextb0
	move.b	#$31,(6,a6)
main_binstring_nextb0
	btst	#0,d7
	beq	main_binstring_doneb
	move.b	#$31,(7,a6)
main_binstring_doneb

	rts
endfunction
