; include file
#dontinclude

;*****************************************************************************************************************************
;*****************************************************************************************************************************
function	device_ports
rem	device_ports()
rem	returns whats plugged into each of the two ports
rem	return variables are: device_porta.b , device_portb.b
rem	0=master system or null , 1=3 button ctrl , 2=6 button ctrl , 3=mouse , 4=multitap multi mode
def	device_ports_0	byte
def	device_ports_1	byte
def	device_ports_2	byte
def	device_ports_3	byte
def	device_ports_4	byte
def	device_ports_5	byte
def	device_ports_6	byte
def	device_ports_7	byte
def	device_porta	byte
def	device_portb	byte
def	device_ports_cnt	word
def	device_ports_init	word

stack	a6/d5-d6
device_ports


	if	w,device_ports_init=#0
	move.w	#1,device_ports_init
;	move.b	#2,device_porta
;	move.b	#2,device_portb
	move.w	#180,device_ports_cnt	;force look sooner
	endif

	add.w	#1,device_ports_cnt

	if	w,device_ports_cnt>#200
	move.w	#0,device_ports_cnt
	else
	rts
	endif




; ****************************************************************************************
; port a first 
; mouse must exit on its own detect or stay as mouse
; same as multitap
; others are easy hot swap
	if	b,device_porta!#3	b,device_porta!#4

	move.b	#$40,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#$40,($a1000b)	;ctrl two
;	move.l	#$a10005,a6


	nop
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;first read
	move.b	d7,device_ports_1
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 2
	move.b	d7,device_ports_2
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 3
	move.b	d7,device_ports_3
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 4
	move.b	d7,device_ports_4
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 5
	move.b	d7,device_ports_5
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 6
	move.b	d7,device_ports_6
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 7
	move.b	d7,device_ports_7
	move.b	#0,(a6)
	nop


	clr.b	device_porta

; multi tap
	if	b,device_ports_1=#115	b,device_ports_2=#63	or	b,device_ports_1=#64	b,device_ports_2=#0
	move.b	#0,device_porta	;hack
	bra	device_ports2
	endif

; mouse
	if	b,device_ports_1=#112	b,device_ports_2=#59	or	b,device_ports_1=#75	b,device_ports_2=#11
	move.b	#3,device_porta
	bra	device_ports2
	endif

; 6 button
	move.b	device_ports_4,d5
	move.b	device_ports_6,d6
	and.b	#15,d5
	and.b	#15,d6
	if	b,d5=#0	b,d6=#15
	move.b	#2,device_porta
	bra	device_ports2
	endif
	
; 3 button
	move.b	device_ports_1,d5
	move.b	device_ports_2,d6
	and.b	#15,d5
	and.b	#15,d6

	if	b,d5!d6	b,device_porta!#2
	move.b	#1,device_porta
	endif

	endif
;*****************************************************************************************
;port b
device_ports2

	if	b,device_portb!#3	b,device_portb!#4

;	move.b	#$40,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#$40,($a1000b)	;ctrl two
	move.l	#$a10005,a6


	nop
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;first read
	move.b	d7,device_ports_1
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 2
	move.b	d7,device_ports_2
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 3
	move.b	d7,device_ports_3
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 4
	move.b	d7,device_ports_4
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 5
	move.b	d7,device_ports_5
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 6
	move.b	d7,device_ports_6
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 7
	move.b	d7,device_ports_7
	move.b	#0,(a6)
	nop


	clr.b	device_portb

; multi tap
	if	b,device_ports_1=#115	b,device_ports_2=#63	or	b,device_ports_1=#64	b,device_ports_2=#0
	move.b	#0,device_portb	;hack
	rts
	endif

; mouse
	if	b,device_ports_1=#112	b,device_ports_2=#59	or	b,device_ports_1=#75	b,device_ports_2=#11
	move.b	#3,device_portb
	rts
	endif

; 6 button
	move.b	device_ports_4,d5
	move.b	device_ports_6,d6
	and.b	#15,d5
	and.b	#15,d6
	if	b,d5=#0	b,d6=#15
	move.b	#2,device_portb
	rts
	endif
	
; 3 button
	move.b	device_ports_1,d5
	move.b	device_ports_2,d6
	and.b	#15,d5
	and.b	#15,d6

	if	b,d5!d6	b,device_porta!#2
	move.b	#1,device_portb
	endif

	endif


	rts
endfunction



;***********************************************************************************************************************************************************************************************
;***********************************************************************************************************************************************************************************************

function	inputplayer1
rem	inputplayer1()
rem	returns player ones values including mouse to vars: data1= 0000 RLDU  data2= MYXZ SCBA / 0000 0021
rem	( inputplayer1_ :    id.b , data1.b , data2.b , mousex.w , mousey.w , movex.w , movey.w )
rem	MUST CALL device_ports()  FIRST!    id: 0=null/mast , 1=3 btn , 2=6 btn , 3=mouse , 4=multitap multi mode
def	inputplayer1_0	byte
def	inputplayer1_id	byte
def	inputplayer1_data1	byte
def	inputplayer1_data2	byte
def	inputplayer1_mousex	word
def	inputplayer1_mousey	word
def	inputplayer1_movex	word
def	inputplayer1_movey	word

stack	a6/d5-d6
inputplayer1


; setup mouse vars if blank
	if	b,inputplayer1_0<>#123
	move.b	#123,inputplayer1_0
	move.w	#284,inputplayer1_mousex
	move.w	#225,inputplayer1_mousey
	move.w	#2,inputplayer1_movex
	move.w	#2,inputplayer1_movey
	move.b	#0,inputplayer1_data1
	move.b	#0,inputplayer1_data2
	endif

	if	w,device_ports_cnt=#0
	rts
	endif

; if port is null we can grab master system values,
; dont bother if its multitap as the values keep getting killed every second frame

; master sys or null
	if	b,device_porta=<#2

	;  read all 7 toggles
	move.b	#$40,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#$40,($a1000b)	;ctrl two
;	move.l	#$a10005,a6

	nop
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;first read
	move.b	d7,device_ports_1
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 2
	move.b	d7,device_ports_2
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 3
	move.b	d7,device_ports_3
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 4
	move.b	d7,device_ports_4
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 5
	move.b	d7,device_ports_5
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 6
	move.b	d7,device_ports_6
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 7
	move.b	d7,device_ports_7
	move.b	#0,(a6)
	nop

	move.b	device_porta,d7
	move.b	d7,inputplayer1_id

; null/ mastersys
	if	b,inputplayer1_id=#0
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;1
	bchg	#5,d7	;2
	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer1_data1
	lsr.b	#4,d6
	move.b	d6,inputplayer1_data2

	rts
	endif
; 3btn
	if	b,inputplayer1_id=#1
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;b
	bchg	#5,d7	;c

	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer1_data1	;has udlr
	lsr.b	#3,d6
	and.b	#6,d6
	move.b	d6,inputplayer1_data2	;has	0000 0cb0

	move.b	device_ports_2,d7
	lsr.b	#4,d7
	bchg	#0,d7
	and.b	#1,d7
	add.b	d7,inputplayer1_data2	;has 0000 0cba

	move.b	device_ports_2,d7
	lsr.b	#2,d7
	bchg	#3,d7
	and.b	#8,d7
	add.b	d7,inputplayer1_data2	;has 0000 scba
	jsr	inputplayer1_fakemouse
	rts
	endif

; 6btn
	if	b,inputplayer1_id=#2
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;b
	bchg	#5,d7	;c

	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer1_data1	;has udlr
	lsr.b	#3,d6
	and.b	#6,d6
	move.b	d6,inputplayer1_data2	;has	0000 0cb0

	move.b	device_ports_2,d7
	lsr.b	#4,d7
	bchg	#0,d7
	and.b	#1,d7
	add.b	d7,inputplayer1_data2	;has 0000 0cba

	move.b	device_ports_2,d7
	lsr.b	#2,d7
	bchg	#3,d7
	and.b	#8,d7
	add.b	d7,inputplayer1_data2	;has 0000 scba

	move.b	device_ports_5,d7
	bchg	#0,d7	;z
	bchg	#1,d7	;y
	bchg	#2,d7	;x
	bchg	#3,d7	;m

	lsl.b	#4,d7
	and.b	#$f0,d7
	add.b	d7,inputplayer1_data2	;has mzyx scba
	jsr	inputplayer1_fakemouse

	rts
	endif

	endif
; mouse into porta
	if	b,device_porta=#3
	move.b	#3,inputplayer1_id
;toggle reads
	move.b	#$60,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#$60,($a1000b)	;ctrl two
;	move.l	#$a10005,a6
; counter
	clr.l	d6
	move.b	#20,d6	;counter
;	move.b	#180,device_ports_7	;counter cycles waisted

	move.b	#$60,(a6)
	nop
inputplayer1_mouse0
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse0
;	sub.b	d6,device_ports_7
	move.b	d7,device_ports_1	;                                    read1
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer1_mouse1
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse1
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_2	;                                   read 2


; test for unplug
	if	b,device_ports_1=#127	b,device_ports_2=#63	or	b,device_ports_1=#51	b,device_ports_2=#51
	move.b	#$40,($a10009)	;ctrl one
	move.b	#$40,(a6)
	nop
	move.b	#$0,(a6)
	clr.b	inputplayer1_id
	clr.b	device_porta
	rts
	endif

; still plugged in keep going
	move.b	#20,d6

	move.b	#0,(a6)
	nop
inputplayer1_mouse2
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer1_mouse2
;	sub.b	d6,device_ports_7

;	move.b	d7,drop it	;                                   read 3
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer1_mouse3
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse3
;	sub.b	d6,device_ports_7

;	move.b	d7,drop it	;                     read 4
	move.b	#20,d6

	move.b	#0,(a6)
	nop
inputplayer1_mouse4
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer1_mouse4
	move.b	d7,device_ports_1	;                     read 5 start of reads
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer1_mouse5
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse5
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_2	;                     read 6
	move.b	#20,d6

	move.b	#$0,(a6)
	nop
inputplayer1_mouse6
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer1_mouse6
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_3	;                     read 7
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer1_mouse7
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse7
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_4	;                     read 8
	move.b	#20,d6

	move.b	#$0,(a6)
	nop
inputplayer1_mouse8
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer1_mouse8
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_5	;                     read 9
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer1_mouse9
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer1_mouse9
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_6	;                     read 10
	move.b	#$60,(a6)	;done

;ok decifer that
	move.b	device_ports_2,d7
	and.b	#$f,d7
	move.b	d7,inputplayer1_data2

;x consolidation
	move.b	device_ports_3,d7
	lsl.b	#4,d7
	and.b	#$f0,d7

	move.b	device_ports_4,d6
	and.b	#$f,d6
	add.b	d7,d6
	move.b	d6,device_ports_4	;has x
;y consolidation
	move.b	device_ports_5,d7
	lsl.b	#4,d7
	and.b	#$f0,d7

	move.b	device_ports_6,d6
	and.b	#$f,d6
	add.b	d7,d6
	move.b	d6,device_ports_6	;has y

;0000 RLDU
;deal with x
	clr.b	inputplayer1_data1
	clr.b	d5

	if	b,device_ports_4!#0
	if	b,device_ports_4<#128
	clr.w	d6
	move.b	device_ports_4,d6
	add.w	d6,inputplayer1_mousex
	bchg	#3,d5
	else
	clr.w	d6
	move.b	#255,d6
	sub.b	device_ports_4,d6
	add.b	#1,d6
	sub.w	d6,inputplayer1_mousex
	bchg	#2,d5

	endif
	endif


;deal with y
	if	b,device_ports_6!#0
	if	b,device_ports_6<#128
	clr.w	d6
	move.b	device_ports_6,d6
	sub.w	d6,inputplayer1_mousey
	bchg	#0,d5

	else
	clr.w	d6
	move.b	#255,d6
	sub.b	device_ports_6,d6
	add.b	#1,d6
	add.w	d6,inputplayer1_mousey
	bchg	#1,d5

	endif
	endif

	move.b	d5,inputplayer1_data1

	rts
	endif


; no multitap at this point yet
	rts
; ************************fake mouse
inputplayer1_fakemouse
	move.w	inputplayer1_movey,d5
	if	x,#0=inputplayer1_data1
	sub.w	d5,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	add.w	d5,inputplayer1_mousey
	endif
	move.w	inputplayer1_movex,d5
	if	x,#2=inputplayer1_data1
	sub.w	d5,inputplayer1_mousex
	endif
	if	x,#3=inputplayer1_data1
	add.w	d5,inputplayer1_mousex
	endif


	rts

endfunction




;***********************************************************************************************************************************************************************************************
;***********************************************************************************************************************************************************************************************

function	inputplayer2
rem	inputplayer2()
rem	returns player ones values including mouse to vars: data1= 0000 RLDU  data2= MYXZ SCBA / 0000 0021
rem	( inputplayer2_ :    id.b , data1.b , data2.b , mousex.w , mousey.w , movex.w , movey.w )
rem	MUST CALL device_ports()  FIRST!    id: 0=null/mast , 1=3 btn , 2=6 btn , 3=mouse , 4=multitap multi mode
def	inputplayer2_0	byte
def	inputplayer2_id	byte
def	inputplayer2_data1	byte
def	inputplayer2_data2	byte
def	inputplayer2_mousex	word
def	inputplayer2_mousey	word
def	inputplayer2_movex	word
def	inputplayer2_movey	word

stack	a6/d5-d6
inputplayer2


; setup mouse vars if blank
	if	b,inputplayer2_0<>#123
	move.b	#123,inputplayer2_0
	move.w	#284,inputplayer2_mousex
	move.w	#225,inputplayer2_mousey
	move.w	#2,inputplayer2_movex
	move.w	#2,inputplayer2_movey
	move.b	#0,inputplayer2_data1
	move.b	#0,inputplayer2_data2
	endif

	if	w,device_ports_cnt=#0
	rts
	endif

; if port is null we can grab master system values,
; dont bother if its multitap as the values keep getting killed every second frame

; master sys or null
	if	b,device_portb=<#2

	;  read all 7 toggles
;	move.b	#$40,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#$40,($a1000b)	;ctrl two
	move.l	#$a10005,a6

	nop
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;first read
	move.b	d7,device_ports_1
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 2
	move.b	d7,device_ports_2
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 3
	move.b	d7,device_ports_3
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 4
	move.b	d7,device_ports_4
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 5
	move.b	d7,device_ports_5
	move.b	#$0,(a6)
	nop
	move.b	(a6),d7	;read 6
	move.b	d7,device_ports_6
	move.b	#$40,(a6)
	nop
	move.b	(a6),d7	;read 7
	move.b	d7,device_ports_7
	move.b	#0,(a6)
	nop

	move.b	device_portb,d7
	move.b	d7,inputplayer2_id

; null/ mastersys
	if	b,inputplayer2_id=#0
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;1
	bchg	#5,d7	;2
	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer2_data1
	lsr.b	#4,d6
	move.b	d6,inputplayer2_data2

	rts
	endif
; 3btn
	if	b,inputplayer2_id=#1
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;b
	bchg	#5,d7	;c

	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer2_data1	;has udlr
	lsr.b	#3,d6
	and.b	#6,d6
	move.b	d6,inputplayer2_data2	;has	0000 0cb0

	move.b	device_ports_2,d7
	lsr.b	#4,d7
	bchg	#0,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2	;has 0000 0cba

	move.b	device_ports_2,d7
	lsr.b	#2,d7
	bchg	#3,d7
	and.b	#8,d7
	add.b	d7,inputplayer2_data2	;has 0000 scba
	jsr	inputplayer2_fakemouse

	rts
	endif

; 6btn
	if	b,inputplayer2_id=#2
	move.b	device_ports_1,d7
	and.b	#$3f,d7
	bchg	#0,d7	;up
	bchg	#1,d7	;dn
	bchg	#2,d7	;lt
	bchg	#3,d7	;rt
	bchg	#4,d7	;b
	bchg	#5,d7	;c

	move.b	d7,d6
	and.b	#$f,d7
	move.b	d7,inputplayer2_data1	;has udlr
	lsr.b	#3,d6
	and.b	#6,d6
	move.b	d6,inputplayer2_data2	;has	0000 0cb0

	move.b	device_ports_2,d7
	lsr.b	#4,d7
	bchg	#0,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2	;has 0000 0cba

	move.b	device_ports_2,d7
	lsr.b	#2,d7
	bchg	#3,d7
	and.b	#8,d7
	add.b	d7,inputplayer2_data2	;has 0000 scba

	move.b	device_ports_5,d7
	bchg	#0,d7	;z
	bchg	#1,d7	;y
	bchg	#2,d7	;x
	bchg	#3,d7	;m

	lsl.b	#4,d7
	and.b	#$f0,d7
	add.b	d7,inputplayer2_data2	;has mzyx scba
	jsr	inputplayer2_fakemouse

	rts
	endif

	endif
; mouse into porta
	if	b,device_portb=#3
	move.b	#3,inputplayer2_id
;toggle reads
;	move.b	#$60,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#$60,($a1000b)	;ctrl two
	move.l	#$a10005,a6
; counter
	clr.l	d6
	move.b	#20,d6	;counter
;	move.b	#180,device_ports_7	;counter cycles waisted

	move.b	#$60,(a6)
	nop
inputplayer2_mouse0
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse0
;	sub.b	d6,device_ports_7
	move.b	d7,device_ports_1	;                                    read1
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer2_mouse1
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse1
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_2	;                                   read 2


; test for unplug
	if	b,device_ports_1=#127	b,device_ports_2=#63	or	b,device_ports_1=#51	b,device_ports_2=#51
	move.b	#$40,($a1000b)	;ctrl 2
	move.b	#$40,(a6)
	nop
	move.b	#$0,(a6)
	clr.b	inputplayer2_id
	clr.b	device_portb
	rts
	endif

; still plugged in keep going
	move.b	#20,d6

	move.b	#0,(a6)
	nop
inputplayer2_mouse2
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer2_mouse2
;	sub.b	d6,device_ports_7

;	move.b	d7,drop it	;                                   read 3
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer2_mouse3
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse3
;	sub.b	d6,device_ports_7

;	move.b	d7,drop it	;                     read 4
	move.b	#20,d6

	move.b	#0,(a6)
	nop
inputplayer2_mouse4
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer2_mouse4
	move.b	d7,device_ports_1	;                     read 5 start of reads
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer2_mouse5
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse5
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_2	;                     read 6
	move.b	#20,d6

	move.b	#$0,(a6)
	nop
inputplayer2_mouse6
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer2_mouse6
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_3	;                     read 7
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer2_mouse7
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse7
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_4	;                     read 8
	move.b	#20,d6

	move.b	#$0,(a6)
	nop
inputplayer2_mouse8
	move.b	(a6),d7
	btst	#4,d7
	dbeq	d6,inputplayer2_mouse8
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_5	;                     read 9
	move.b	#20,d6

	move.b	#$20,(a6)
	nop
inputplayer2_mouse9
	move.b	(a6),d7
	btst	#4,d7
	dbne	d6,inputplayer2_mouse9
;	sub.b	d6,device_ports_7

	move.b	d7,device_ports_6	;                     read 10
	move.b	#$60,(a6)	;done

;ok decifer that
	move.b	device_ports_2,d7
	and.b	#$f,d7
	move.b	d7,inputplayer2_data2

;x consolidation
	move.b	device_ports_3,d7
	lsl.b	#4,d7
	and.b	#$f0,d7

	move.b	device_ports_4,d6
	and.b	#$f,d6
	add.b	d7,d6
	move.b	d6,device_ports_4	;has x
;y consolidation
	move.b	device_ports_5,d7
	lsl.b	#4,d7
	and.b	#$f0,d7

	move.b	device_ports_6,d6
	and.b	#$f,d6
	add.b	d7,d6
	move.b	d6,device_ports_6	;has y

;0000 RLDU
;deal with x
	clr.b	inputplayer2_data1
	clr.b	d5

	if	b,device_ports_4!#0
	if	b,device_ports_4<#128
	clr.w	d6
	move.b	device_ports_4,d6
	add.w	d6,inputplayer2_mousex
	bchg	#3,d5
	else
	clr.w	d6
	move.b	#255,d6
	sub.b	device_ports_4,d6
	add.b	#1,d6
	sub.w	d6,inputplayer2_mousex
	bchg	#2,d5

	endif
	endif


;deal with y
	if	b,device_ports_6!#0
	if	b,device_ports_6<#128
	clr.w	d6
	move.b	device_ports_6,d6
	sub.w	d6,inputplayer2_mousey
	bchg	#0,d5

	else
	clr.w	d6
	move.b	#255,d6
	sub.b	device_ports_6,d6
	add.b	#1,d6
	add.w	d6,inputplayer2_mousey
	bchg	#1,d5

	endif
	endif

	move.b	d5,inputplayer2_data1

	rts
	endif


; no multitap at this point yet
	rts


inputplayer2_fakemouse
	move.w	inputplayer2_movey,d5
	if	x,#0=inputplayer2_data1
	sub.w	d5,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	add.w	d5,inputplayer2_mousey
	endif
	move.w	inputplayer2_movex,d5
	if	x,#2=inputplayer2_data1
	sub.w	d5,inputplayer2_mousex
	endif
	if	x,#3=inputplayer2_data1
	add.w	d5,inputplayer2_mousex
	endif


	rts

endfunction





