; include file
#dontinclude

; *****************************************************************************************************************************device_porta()
function	device_porta
rem	device_porta()
rem	returns result to d7 as byte / returns what device is plugged into controller port a
rem	0=atari,mastersys 1=3button 2=6button 3=mouse 4=multitap multi mode   [device_porta_id.b]
rem	uses stack & d7
def	device_porta_0	byte
def	device_porta_1	byte
def	device_porta_2	byte
def	device_porta_3	byte
def	device_porta_4	byte
def	device_porta_5	byte
def	device_porta_6	byte
def	device_porta_id	byte
def	device_porta_cnt	word

stack	a6

device_porta

	move.w	device_porta_cnt,d7
	add.w	#1,d7
	move.w	d7,device_porta_cnt

	if	w,device_porta_cnt>#200
	clr.w	device_porta_cnt
	endif


	if	b,device_porta_id=#3
	move.w	#1,device_porta_cnt
	rts
	endif

	if	b,device_porta_cnt=#0
;	or	w,device_porta_cnt>#99	b,device_porta_id=#1	or	w,device_porta_cnt>#99	b,device_porta_id=#2	

;	clr.w	device_porta_cnt

; read seven inputs with toggle switching
	move.b	#$40,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port

;	move.b	#$40,($a1000b)	;ctrl two
;	move.l	#$a10005,a6

	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	move.b	d7,device_porta_0
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	move.b	d7,device_porta_1
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 3
	move.b	d7,device_porta_2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	d7,device_porta_3
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	d7,device_porta_4
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	d7,device_porta_5
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	move.b	d7,device_porta_6
	move.b	#0,(a6)
; ok whats what
;	clr.b	device_porta_id

; nothing or atari master sys
	if	b,device_porta_0=#127	b,device_porta_1=#63
	clr.b	device_porta_id
	clr.l	d7
	rts
	endif

; mouse?
	if	b,device_porta_0=#75	b,device_porta_1=#11	or	b,device_porta_0=#112	b,device_porta_1=#59	
	move.l	#3,d7
	move.b	d7,device_porta_id
	rts
	endif

; 3 button pad
	if	b,device_porta_0=#127	b,device_porta_1=#51	b,device_porta_5=#51
	move.l	#1,d7
	move.b	d7,device_porta_id
	rts
	endif

; 6 button pad
	if	b,device_porta_0=#127	b,device_porta_1=#51	b,device_porta_5=#48
	move.l	#2,d7
	move.b	d7,device_porta_id
	rts
	endif

; multitap - multimode
	if	b,device_porta_0=#64	b,device_porta_1=#0	or	b,device_porta_0=#115	b,device_porta_1=#63
	move.l	#4,d7
	move.b	d7,device_porta_id
	rts
	endif
; nothing confirmed
	clr.l	d7
	if	b,device_porta_id>#4
	move.b	#0,device_porta_id
	endif
	rts

	endif

	rts

endfunction







; *****************************************************************************************************************************device_portb()
function	device_portb
rem	device_portb()
rem	returns result to d7 as byte / returns what device is plugged into controller port a
rem	0=atari,mastersys 1=3button 2=6button 3=mouse 4=multitap multi mode   [device_portb_id.b]
rem	uses stack & d7
def	device_portb_0	byte
def	device_portb_1	byte
def	device_portb_2	byte
def	device_portb_3	byte
def	device_portb_4	byte
def	device_portb_5	byte
def	device_portb_6	byte
def	device_portb_id	byte
def	device_portb_cnt	word

stack	a6

device_portb

	move.w	device_portb_cnt,d7
	add.w	#1,d7
	move.w	d7,device_portb_cnt

	if	w,device_portb_cnt>#200
	clr.w	device_portb_cnt
	endif

	if	b,device_portb_id=#3
	move.w	#1,device_portb_cnt
	rts
	endif



	if	b,device_portb_cnt=#0
;	or	w,device_portb_cnt>#99	b,device_portb_id=#1	or	w,device_portb_cnt>#99	b,device_portb_id=#2	

;	clr.w	device_portb_cnt

; read seven inputs with toggle switching
;	move.b	#$40,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port

	move.b	#$40,($a1000b)	;ctrl two
	move.l	#$a10005,a6

	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	move.b	d7,device_portb_0
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	move.b	d7,device_portb_1
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 3
	move.b	d7,device_portb_2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	d7,device_portb_3
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	d7,device_portb_4
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	d7,device_portb_5
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	move.b	d7,device_portb_6
	move.b	#0,(a6)
; ok whats what
;	clr.b	device_portb_id

; nothing or atari master sys
	if	b,device_portb_0=#127	b,device_portb_1=#63
	clr.b	device_portb_id
	clr.l	d7
	rts
	endif

; mouse?
	if	b,device_portb_0=#75	b,device_portb_1=#11	or	b,device_portb_0=#112	b,device_portb_1=#59	
	move.l	#3,d7
	move.b	d7,device_portb_id
	rts
	endif

; 3 button pad
	if	b,device_portb_0=#127	b,device_portb_1=#51	b,device_portb_5=#51
	move.l	#1,d7
	move.b	d7,device_portb_id
	rts
	endif

; 6 button pad
	if	b,device_portb_0=#127	b,device_portb_1=#51	b,device_portb_5=#48
	move.l	#2,d7
	move.b	d7,device_portb_id
	rts
	endif

; multitap - multimode
	if	b,device_portb_0=#64	b,device_portb_1=#0	or	b,device_portb_0=#115	b,device_portb_1=#63
	move.l	#4,d7
	move.b	d7,device_portb_id
	rts
	endif
; nothing confirmed
	clr.l	d7
	if	b,device_portb_id>#4
	move.b	#0,device_portb_id
	endif
	rts

	endif

	rts

endfunction



;*********************************************************************************************************************************
function	inputplayer1
rem	inputplayer1()
rem	updates variables for all inputs based on whats plugged in
rem	[ inputplayer1_ ] id.b data1.b data2.b mousex.w mousey.w mx.b my.b trackx.b tracky.b dx.b dy.b inverty.b
rem	uses stack & d7
def	inputplayer1_id	byte
def	inputplayer1_init	byte	;initialized
def	inputplayer1_data1	byte
def	inputplayer1_data2	byte
def	inputplayer1_mousex	word
def	inputplayer1_mousey	word
def	inputplayer1_mx	byte
def	inputplayer1_my	byte
def	inputplayer1_trackx	byte
def	inputplayer1_tracky	byte
def	inputplayer1_dx	byte
def	inputplayer1_dy	byte
def	inputplayer1_inverty	byte
def	inputplayer1_fakemouse	byte

def	inputplayer1_data3	string	32	;multitap dump

stack	a4-a6/d4-d6

inputplayer1

	if	w,device_porta_cnt=#0
	rts
	endif


;clear data
	clr.b	inputplayer1_data1
	clr.b	inputplayer1_data2
	clr.b	inputplayer1_id

	if	b,inputplayer1_init<>#123
; setup mouse vars to start
	move.b	#123,inputplayer1_init
	move.w	#284,inputplayer1_mousex
	move.w	#225,inputplayer1_mousey
	move.b	#0,inputplayer1_trackx
	move.b	#0,inputplayer1_tracky
	clr.b	inputplayer1_mx
	clr.b	inputplayer1_my
	clr.b	inputplayer1_dx
	clr.b	inputplayer1_dy
	move.b	#0,inputplayer1_inverty
	move.b	#1,inputplayer1_fakemouse	;default
	endif

; ok whats plugged in?
	if	b,device_porta_id=#0
; atari master sys or nothing
	move.b	#0,inputplayer1_id
	move.b	#%01000000,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#%01000000,($a1000b)	;ctrl two
;	move.l	#$a10005,a6
	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data1	;dpad
	move.b	(a6),d7
	lsr.b	#4,d7
	and.b	#3,d7
	bchg	#0,d7
	bchg	#1,d7
	move.b	d7,inputplayer1_data2	;a,b
	move.b	#0,(a6)
;fake mouse
	if	b,inputplayer1_fakemouse=#1
	if	b,#1=inputplayer1_inverty
	if	x,#0=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	else
	if	x,#1=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#0=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	endif

	if	x,#3=inputplayer1_data1
	add.w	#2,inputplayer1_mousex
	endif

	if	x,#2=inputplayer1_data1
	sub.w	#2,inputplayer1_mousex
	endif
	endif


	rts

	endif

	if	b,device_porta_id=#1
; 3 button controller
	move.b	#1,inputplayer1_id

	move.b	#%01000000,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#%01000000,($a1000b)	;ctrl two
;	move.l	#$a10005,a6

	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer1_data2

	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer1_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer1_data2
	move.b	#$40,(a6)
; check unplug?
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	move.b	#$0,(a6)

; not coded yet
;fake mouse
	if	b,inputplayer1_fakemouse=#1
	if	b,#1=inputplayer1_inverty
	if	x,#0=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	else
	if	x,#1=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#0=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	endif

	if	x,#3=inputplayer1_data1
	add.w	#2,inputplayer1_mousex
	endif

	if	x,#2=inputplayer1_data1
	sub.w	#2,inputplayer1_mousex
	endif
	endif

	rts

	endif

	if	b,device_porta_id=#2
; 6 button controller
	move.b	#2,inputplayer1_id

	move.b	#%01000000,($a10009)	;ctrl one
	move.l	#$a10003,a6	;read and write port
;	move.b	#%01000000,($a1000b)	;ctrl two
;	move.l	#$a10005,a6


	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer1_data2

	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer1_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer1_data2
	move.b	#$40,(a6)
;get x,y,z,mode
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)

	move.b	(a6),d7	;read 6

	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	lsl.b	#4,d7
	and.b	#$f0,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	add.b	d7,inputplayer1_data2
	move.b	#0,(a6)

;fake mouse
	if	b,inputplayer1_fakemouse=#1
	if	b,#1=inputplayer1_inverty
	if	x,#0=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	else
	if	x,#1=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#0=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	endif

	if	x,#3=inputplayer1_data1
	add.w	#2,inputplayer1_mousex
	endif

	if	x,#2=inputplayer1_data1
	sub.w	#2,inputplayer1_mousex
	endif
	endif



	rts

	endif

	if	b,device_porta_id=#3
;its a mouse
	move.b	#3,inputplayer1_id

	move.l	#$a10009,a5
	move.l	#$a10003,a6
	move.b	#$60,(a5)
; counter
	move.b	#20,d7
	move.b	#$60,(a6)
inputplayer1_mcc1
	sub.b	#1,d7
	beq	inputplayer1_mac1
	move.b	(a6),inputplayer1_data1	;1 read
	btst	#4,inputplayer1_data1
	bne	inputplayer1_mcc1
inputplayer1_mac1
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer1_mcc2
	sub.b	#1,d7
	beq	inputplayer1_mac2
	move.b	(a6),inputplayer1_data2	;2 read
	btst	#4,inputplayer1_data2
	bne	inputplayer1_mcc2
inputplayer1_mac2

; unplugged mouse?
	if	b,#127=inputplayer1_data1	b,#63=inputplayer1_data2
; ok mouse unplugged
	move.b	#0,device_porta_id
	move.l	#$a10009,a5
	move.b	#$40,(a5)
	move.b	#$40,(a6)
	move.b	#$0,(a6)

	clr.b	inputplayer1_id
	rts
	endif

; still plugged in
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer1_mcc3
	sub.b	#1,d7
	beq	inputplayer1_mac3
	move.b	(a6),d6	;3 read
	btst	#4,d6
	bne	inputplayer1_mcc3
inputplayer1_mac3
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer1_mcc4
	sub.b	#1,d7
	beq	inputplayer1_mac4
	move.b	(a6),d6	;4 read
	cmp.b	#63,d6
	bne	inputplayer1_mcc4
inputplayer1_mac4
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer1_mcc5
	sub.b	#1,d7
	beq	inputplayer1_mac5
	move.b	(a6),inputplayer1_dx	;5 read important read start
	btst	#4,inputplayer1_dx
	bne	inputplayer1_mcc5
inputplayer1_mac5
	move.b	inputplayer1_dx,d7
	lsr.b	#1,d7
	and.b	#1,d7
	move.b	d7,inputplayer1_dy
	move.b	inputplayer1_dx,d7
	and.b	#1,d7
	move.b	d7,inputplayer1_dx

; counter buttons on this one
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer1_mcc6
	sub.b	#1,d7
	beq	inputplayer1_mac6
	move.b	(a6),d6	;6 read
	btst	#4,d6
	beq	inputplayer1_mcc6
inputplayer1_mac6
	and.b	#$0f,d6
	move.b	d6,inputplayer1_data2

; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer1_mcc7
	sub.b	#1,d7
	beq	inputplayer1_mac7
	move.b	(a6),d5	;7 read high byte x
	btst	#4,d5
	bne	inputplayer1_mcc7
inputplayer1_mac7
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer1_mcc8
	sub.b	#1,d7
	beq	inputplayer1_mac8
	move.b	(a6),d6	;8 read low byte x
	btst	#4,d6
	beq	inputplayer1_mcc8
inputplayer1_mac8
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer1_mx	;stored x

; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer1_mcc9
	sub.b	#1,d7
	beq	inputplayer1_mac9
	move.b	(a6),d5	;9 read
	btst	#4,d5
	bne	inputplayer1_mcc9
inputplayer1_mac9
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer1_mcc10
	sub.b	#1,d7
	beq	inputplayer1_mac10
	move.b	(a6),d6	;10 read
	btst	#4,d6
	beq	inputplayer1_mcc10
inputplayer1_mac10
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer1_my	;stored y

; counter
; end
	move.b	#$60,(a6)


;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer1_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer1_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer1_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer1_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer1_data1

; now mouse cords
; mousex
	if	b,inputplayer1_dx=#0
	move.b	inputplayer1_mx,d7
	move.b	inputplayer1_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer1_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer1_mx,d7
	and.w	#255,d7
	move.b	inputplayer1_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousex
	endif
;mouse y
	if	b,inputplayer1_inverty=#1

	if	b,inputplayer1_dy=#0
	move.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer1_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer1_dy=#0
	move.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer1_my,d7
	and.b	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer1_mousey
	endif

	endif

	rts
	endif
;********************************************************************************************************************************************************************************
;multitap next
	if	b,device_porta_id=#4
	

	move.l	#$a10009,a5
	move.l	#$a10003,a6
	move.l	#inputplayer1_data3,a4	;holds all data
; ok ready
	move.b	#$60,(a5)
	move.b	#$60,(a6)
	move.b	(a6),inputplayer1_data1	;read1
; numba 2
	move.b	#$20,(a6)
	move.b	(a6),inputplayer1_data2	;read2
; was it unplugged?
; unplugged tap?
	if	b,#127=inputplayer1_data1	b,#63=inputplayer1_data2
; ok mouse unplugged
	move.b	#0,device_porta_id
	move.l	#$a10009,a5
	move.b	#$40,(a5)
	move.b	#$40,(a6)
	clr.b	inputplayer1_id
	rts
	endif

	clr.b	inputplayer1_data1
	clr.b	inputplayer1_data2
; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer1_m_mcc1
	sub.b	#1,d7
	beq	inputplayer1_m_mac1
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer1_m_mcc1
inputplayer1_m_mac1
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer1_m_mcc2
	sub.b	#1,d7
	beq	inputplayer1_m_mac2
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer1_m_mcc2
inputplayer1_m_mac2
	lea	(1,a4),a4
; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer1_m_mcc3
	sub.b	#1,d7
	beq	inputplayer1_m_mac3
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer1_m_mcc3
inputplayer1_m_mac3
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer1_m_mcc4
	sub.b	#1,d7
	beq	inputplayer1_m_mac4
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer1_m_mcc4
inputplayer1_m_mac4

	move.l	#13,d6
inputplayer1_m_loop

	lea	(1,a4),a4
; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer1_m_mcc5
	sub.b	#1,d7
	beq	inputplayer1_m_mac5
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer1_m_mcc5
inputplayer1_m_mac5
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer1_m_mcc6
	sub.b	#1,d7
	beq	inputplayer1_m_mac6
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer1_m_mcc6
inputplayer1_m_mac6
	dbra	d6,inputplayer1_m_loop


	move.b	#$60,(a6)


;try to get id for port 1
	move.l	#inputplayer1_data3,a6
	lea	(2,a6),a6
	move.b	(a6),d7
	and.b	#255,d7
	add.b	#1,d7
	move.b	d7,inputplayer1_id
	if	b,inputplayer1_id>#3	or	b,inputplayer1_id=#0
	clr.b	inputplayer1_id
	endif


;ok was it a 3 button
	if	b,inputplayer1_id=#1
	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer1_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer1_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer1_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data2

;fake mouse
	if	b,inputplayer1_fakemouse=#1
	if	b,#1=inputplayer1_inverty
	if	x,#0=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	else
	if	x,#1=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#0=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	endif

	if	x,#3=inputplayer1_data1
	add.w	#2,inputplayer1_mousex
	endif

	if	x,#2=inputplayer1_data1
	sub.w	#2,inputplayer1_mousex
	endif
	endif

	rts
	endif

;ok was it a 6 button
	if	b,inputplayer1_id=#2
	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer1_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer1_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer1_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer1_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer1_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer1_data2

;fake mouse
	if	b,inputplayer1_fakemouse=#1
	if	b,#1=inputplayer1_inverty
	if	x,#0=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#1=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	else
	if	x,#1=inputplayer1_data1
	add.w	#2,inputplayer1_mousey
	endif
	if	x,#0=inputplayer1_data1
	sub.w	#2,inputplayer1_mousey
	endif
	endif

	if	x,#3=inputplayer1_data1
	add.w	#2,inputplayer1_mousex
	endif

	if	x,#2=inputplayer1_data1
	sub.w	#2,inputplayer1_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer1_id=#3
	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer1_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer1_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer1_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer1_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer1_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer1_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer1_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer1_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer1_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer1_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer1_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer1_data1

; now mouse cords
; mousex
	if	b,inputplayer1_dx=#0
	move.b	inputplayer1_mx,d7
	move.b	inputplayer1_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer1_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer1_mx,d7
	and.w	#255,d7
	move.b	inputplayer1_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousex
	endif
;mouse y
	if	b,inputplayer1_inverty=#1

	if	b,inputplayer1_dy=#0
	move.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer1_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer1_dy=#0
	move.b	inputplayer1_my,d7
	and.w	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer1_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer1_my,d7
	and.b	#255,d7
	move.b	inputplayer1_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer1_mousey
	endif

	endif



	rts

	endif
;end mouse

	rts
	endif
;end multitap


	rts

endfunction




;*********************************************************************************************************************************
function	inputplayer2
rem	inputplayer2()
rem	updates variables for all inputs based on whats plugged in
rem	[ inputplayer1_ ] id.b data1.b data2.b mousex.w mousey.w mx.b my.b trackx.b tracky.b dx.b dy.b inverty.b
rem	uses stack & d7
def	inputplayer2_id	byte
def	inputplayer2_init	byte	;initialized
def	inputplayer2_data1	byte
def	inputplayer2_data2	byte
def	inputplayer2_mousex	word
def	inputplayer2_mousey	word
def	inputplayer2_mx	byte
def	inputplayer2_my	byte
def	inputplayer2_trackx	byte
def	inputplayer2_tracky	byte
def	inputplayer2_dx	byte
def	inputplayer2_dy	byte
def	inputplayer2_inverty	byte
def	inputplayer2_fakemouse	byte

def	inputplayer2_data3	string	32	;multitap dump

stack	a4-a6/d4-d6

inputplayer2
;clear data

	if	w,device_porta_cnt=#0	or	w,device_portb_cnt=#0
	rts
	endif


	clr.b	inputplayer2_data1
	clr.b	inputplayer2_data2
	clr.b	inputplayer2_id

	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.l	#$a1000b,a5



	move.b	#$40,(a6)




	if	b,inputplayer2_init<>#123
; setup mouse vars to start
	move.b	#123,inputplayer2_init
	move.w	#284,inputplayer2_mousex
	move.w	#225,inputplayer2_mousey
	move.b	#0,inputplayer2_trackx
	move.b	#0,inputplayer2_tracky
	clr.b	inputplayer2_mx
	clr.b	inputplayer2_my
	clr.b	inputplayer2_dx
	clr.b	inputplayer2_dy
	move.b	#0,inputplayer2_inverty
	move.b	#1,inputplayer2_fakemouse	;default
	endif


;******************************************************************************************************************** no multi-taps
; port 1 no multitap config port 2 no multi-tap config
	if	b,device_porta_id<>#4	b,device_portb_id<>#4
; ok whats plugged in?
	if	b,device_portb_id=#0
; atari master sys or nothing
	move.b	#0,inputplayer2_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.l	#$a1000b,a5



	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1	;dpad
	move.b	(a6),d7
	lsr.b	#4,d7
	and.b	#3,d7
	bchg	#0,d7
	bchg	#1,d7
	move.b	d7,inputplayer2_data2	;a,b

;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif

	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif

	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif
	rts
	endif






	if	b,device_portb_id=#1
; 3 button controller
	move.b	#1,inputplayer2_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer2_data2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer2_data2
	move.b	#$40,(a6)
; check unplug?
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
; not coded yet
;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif
	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif
	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif
	rts
	endif


	if	b,device_portb_id=#2
; 6 button controller
	move.b	#2,inputplayer2_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer2_data2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer2_data2
	move.b	#$40,(a6)
;get x,y,z,mode
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	lsl.b	#4,d7
	and.b	#$f0,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	add.b	d7,inputplayer2_data2
;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif
	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif
	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif
	rts
	endif




	if	b,device_portb_id=#3	b,device_porta<>#4
;its a mouse
	move.b	#3,inputplayer2_id
;	move.l	#$a10009,a5
;	move.l	#$a10003,a6
	move.l	#$a1000b,a5	;ctrl two
	move.l	#$a10005,a6
	move.b	#$60,(a5)
; counter
	move.b	#20,d7
	move.b	#$60,(a6)
inputplayer2_mcc1
	sub.b	#1,d7
	beq	inputplayer2_mac1
	move.b	(a6),inputplayer2_data1	;1 read
	btst	#4,inputplayer2_data1
	bne	inputplayer2_mcc1
inputplayer2_mac1
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer2_mcc2
	sub.b	#1,d7
	beq	inputplayer2_mac2
	move.b	(a6),inputplayer2_data2	;2 read
	btst	#4,inputplayer2_data2
	bne	inputplayer2_mcc2
inputplayer2_mac2
; unplugged mouse?
	if	b,#127=inputplayer2_data1	b,#63=inputplayer2_data2
; ok mouse unplugged
	move.b	#0,device_portb_id
	move.l	#$a1000b,a5
	move.b	#$40,(a5)
	move.b	#$40,(a6)
	clr.b	inputplayer2_id
	rts
	endif
; still plugged in
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer2_mcc3
	sub.b	#1,d7
	beq	inputplayer2_mac3
	move.b	(a6),d6	;3 read
	btst	#4,d6
	bne	inputplayer2_mcc3
inputplayer2_mac3
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer2_mcc4
	sub.b	#1,d7
	beq	inputplayer2_mac4
	move.b	(a6),d6	;4 read
	cmp.b	#63,d6
	bne	inputplayer2_mcc4
inputplayer2_mac4
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer2_mcc5
	sub.b	#1,d7
	beq	inputplayer2_mac5
	move.b	(a6),inputplayer2_dx	;5 read important read start
	btst	#4,inputplayer2_dx
	bne	inputplayer2_mcc5
inputplayer2_mac5
	move.b	inputplayer2_dx,d7
	lsr.b	#1,d7
	and.b	#1,d7
	move.b	d7,inputplayer2_dy
	move.b	inputplayer2_dx,d7
	and.b	#1,d7
	move.b	d7,inputplayer2_dx

; counter buttons on this one
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer2_mcc6
	sub.b	#1,d7
	beq	inputplayer2_mac6
	move.b	(a6),d6	;6 read
	btst	#4,d6
	beq	inputplayer2_mcc6
inputplayer2_mac6
	and.b	#$0f,d6
	move.b	d6,inputplayer2_data2
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer2_mcc7
	sub.b	#1,d7
	beq	inputplayer2_mac7
	move.b	(a6),d5	;7 read high byte x
	btst	#4,d5
	bne	inputplayer2_mcc7
inputplayer2_mac7
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer2_mcc8
	sub.b	#1,d7
	beq	inputplayer2_mac8
	move.b	(a6),d6	;8 read low byte x
	btst	#4,d6
	beq	inputplayer2_mcc8
inputplayer2_mac8
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer2_mx	;stored x
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer2_mcc9
	sub.b	#1,d7
	beq	inputplayer2_mac9
	move.b	(a6),d5	;9 read
	btst	#4,d5
	bne	inputplayer2_mcc9
inputplayer2_mac9
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer2_mcc10
	sub.b	#1,d7
	beq	inputplayer2_mac10
	move.b	(a6),d6	;10 read
	btst	#4,d6
	beq	inputplayer2_mcc10
inputplayer2_mac10
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer2_my	;stored y
; counter
; end
	move.b	#$60,(a6)
;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer2_my<>#0	b,inputplayer2_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer2_my<>#0	b,inputplayer2_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer2_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer2_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer2_data1
; now mouse cords
; mousex
	if	b,inputplayer2_dx=#0
	move.b	inputplayer2_mx,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer2_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer2_mx,d7
	and.w	#255,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousex
	endif
;mouse y
	if	b,inputplayer2_inverty=#1
	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	endif
	else
; mouse y is normal
	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.b	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	endif
	endif
	rts
	endif


	rts
;no multi ends
	endif


; dead here



; ***************************************************************************************************************grab multitap info regardless if it exists
	if	b,device_portb_id=#4

	move.l	#$a1000b,a5
	move.l	#$a10005,a6
	move.l	#inputplayer2_data3,a4	;holds all data
; ok ready
	move.b	#$60,(a5)
	move.b	#$60,(a6)
	move.b	(a6),d5	;inputplayer2_data1	;read1
; numba 2
	move.b	#$20,(a6)
	move.b	(a6),d6	;inputplayer2_data2	;read2
; was it unplugged?
; unplugged tap?
	if	b,#127=d5	b,#63=d6
; okmulti unplugged
	move.b	#0,device_portb_id
	move.l	#$a1000b,a5
	move.b	#$40,(a5)
	move.b	#$40,(a6)
	rts
	endif

;	clr.b	inputplayer2_data1
;	clr.b	inputplayer2_data2



;	move.b	#0,inputplayer2_id

; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer2_m_mcc1
	sub.b	#1,d7
	beq	inputplayer2_m_mac1
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer2_m_mcc1
inputplayer2_m_mac1
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer2_m_mcc2
	sub.b	#1,d7
	beq	inputplayer2_m_mac2
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer2_m_mcc2
inputplayer2_m_mac2
	lea	(1,a4),a4
; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer2_m_mcc3
	sub.b	#1,d7
	beq	inputplayer2_m_mac3
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer2_m_mcc3
inputplayer2_m_mac3
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer2_m_mcc4
	sub.b	#1,d7
	beq	inputplayer2_m_mac4
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer2_m_mcc4
inputplayer2_m_mac4

	move.l	#13,d6
inputplayer2_m_loop

	lea	(1,a4),a4
; counter
	move.b	#20,d7
	bchg	#5,(a6)
inputplayer2_m_mcc5
	sub.b	#1,d7
	beq	inputplayer2_m_mac5
	move.b	(a6),(a4)	;3 read
	btst	#4,(a4)
	bne	inputplayer2_m_mcc5
inputplayer2_m_mac5
; counter
	move.b	#20,d7
	bchg	#5,(a6)
	lea	(1,a4),a4
inputplayer2_m_mcc6
	sub.b	#1,d7
	beq	inputplayer2_m_mac6
	move.b	(a6),(a4)	;4 read
	btst	#4,(a4)
	beq	inputplayer2_m_mcc6
inputplayer2_m_mac6
	dbra	d6,inputplayer2_m_loop
	move.b	#$60,(a6)


; need to explore more settings inside here possibly


	endif
; end multitap dump for port 2





	if	b,device_porta_id=#4
; grab data from porta multitap


;try to get id for port 2
	move.l	#inputplayer1_data3,a6
	lea	(3,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$0f,d7
	move.b	d7,inputplayer2_id
	if	b,inputplayer2_id>#3
	clr.b	inputplayer2_id
	endif

;find skip value
	move.b	inputplayer1_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif

; ready to poll data from a6
	lea	(3,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer2_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer2_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data2

;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif

	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif

	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif

	rts
	endif

;ok was it a 6 button
	if	b,inputplayer2_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer2_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer2_data2

;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif

	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif

	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer2_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer2_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer2_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer2_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer2_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer2_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer2_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer2_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer2_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer2_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer2_data1

; now mouse cords
; mousex
	if	b,inputplayer2_dx=#0
	move.b	inputplayer2_mx,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer2_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer2_mx,d7
	and.w	#255,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousex
	endif
;mouse y
	if	b,inputplayer2_inverty=#1

	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.b	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	endif
	endif

	rts
	endif
;end mouse





	endif
; end multitap in porta







;********************************************************************************************************************************************************
; no multitap port a but there is one in port b
	if	b,device_portb_id=#4	b,device_porta_id<>#4

; grab data from portb multitap

;try to get id for port 2
	move.l	#inputplayer2_data3,a6
	lea	(2,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer2_id
	if	b,inputplayer2_id>#3
	clr.b	inputplayer2_id
	endif

	clr.b	inputplayer2_data1
	clr.b	inputplayer2_data2

;find skip value
;	move.b	inputplayer2_id,d6
;	if	b,d6=#1
;	lea	(2,a6),a6
;	endif
;	if	b,d6=#2
;	lea	(3,a6),a6
;	endif
;	if	b,d6=#3
;	lea	(6,a6),a6
;	endif

; ready to poll data from a6
	lea	(4,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer2_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer2_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data2

;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif

	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif

	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer2_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer2_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer2_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer2_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer2_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer2_data2

;fake mouse
	if	b,inputplayer2_fakemouse=#1
	if	b,#1=inputplayer2_inverty
	if	x,#0=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#1=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	else
	if	x,#1=inputplayer2_data1
	add.w	#10,inputplayer2_mousey
	endif
	if	x,#0=inputplayer2_data1
	sub.w	#10,inputplayer2_mousey
	endif
	endif

	if	x,#3=inputplayer2_data1
	add.w	#10,inputplayer2_mousex
	endif

	if	x,#2=inputplayer2_data1
	sub.w	#10,inputplayer2_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer2_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer2_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer2_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer2_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer2_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer2_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer2_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer2_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer2_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer2_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer2_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer2_data1

; now mouse cords
; mousex
	if	b,inputplayer2_dx=#0
	move.b	inputplayer2_mx,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer2_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer2_mx,d7
	and.w	#255,d7
	move.b	inputplayer2_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousex
	endif
;mouse y
	if	b,inputplayer2_inverty=#1

	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer2_dy=#0
	move.b	inputplayer2_my,d7
	and.w	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer2_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer2_my,d7
	and.b	#255,d7
	move.b	inputplayer2_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer2_mousey
	endif
	endif

	rts
	endif
;end mouse






	rts
	endif
;end last config for player 2






	rts

endfunction





;*********************************************************************************************************************************
function	inputplayer3
rem	inputplayer3()
rem	updates variables for inputs based on whats plugged in
rem	[ inputplayer1_ ] id.b data1.b data2.b mousex.w mousey.w mx.b my.b trackx.b tracky.b dx.b dy.b inverty.b
rem	uses stack & d7
def	inputplayer3_id	byte
def	inputplayer3_init	byte	;initialized
def	inputplayer3_data1	byte
def	inputplayer3_data2	byte
def	inputplayer3_mousex	word
def	inputplayer3_mousey	word
def	inputplayer3_mx	byte
def	inputplayer3_my	byte
def	inputplayer3_trackx	byte
def	inputplayer3_tracky	byte
def	inputplayer3_dx	byte
def	inputplayer3_dy	byte
def	inputplayer3_inverty	byte
def	inputplayer3_fakemouse	byte

stack	a4-a6/d4-d6

inputplayer3
	if	w,device_porta_cnt=#0	or	w,device_portb_cnt=#0
	rts
	endif

;clear data
	clr.b	inputplayer3_data1
	clr.b	inputplayer3_data2
	clr.b	inputplayer3_id
; all data is from multitap 1 or multitap 2


;	add.w	#1,inputplayer3_mousex

	if	b,inputplayer3_init<>#128
; setup mouse vars to start
	move.b	#128,inputplayer3_init
	move.w	#284,inputplayer3_mousex
	move.w	#225,inputplayer3_mousey
	move.b	#0,inputplayer3_trackx
	move.b	#0,inputplayer3_tracky
	clr.b	inputplayer3_mx
	clr.b	inputplayer3_my
	clr.b	inputplayer3_dx
	clr.b	inputplayer3_dy
	move.b	#0,inputplayer3_inverty
	move.b	#1,inputplayer3_fakemouse	;default
	endif


;*****************************************************************************************************************************************************
; if we are using multtap 1 for player 3
	if	b,device_porta_id=#4



; grab data from porta multitap

; try to get id 
	move.l	#inputplayer1_data3,a6
	lea	(4,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer3_id
	if	b,inputplayer3_id>#3
	clr.b	inputplayer3_id
	endif

	clr.b	inputplayer3_data1
	clr.b	inputplayer3_data2

;find skip value
	move.b	inputplayer1_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 2
	move.b	inputplayer2_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif

;find skip on player 3
;	move.b	inputplayer3_id,d6
;	if	b,d6=#1
;	lea	(2,a6),a6
;	endif
;	if	b,d6=#2
;	lea	(3,a6),a6
;	endif
;	if	b,d6=#3
;	lea	(6,a6),a6
;	endif


; ready to poll data from a6
	lea	(2,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer3_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer3_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data2

;fake mouse
	if	b,inputplayer3_fakemouse=#1
	if	b,#1=inputplayer3_inverty
	if	x,#0=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#1=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	else
	if	x,#1=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#0=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	endif

	if	x,#3=inputplayer3_data1
	add.w	#10,inputplayer3_mousex
	endif

	if	x,#2=inputplayer3_data1
	sub.w	#10,inputplayer3_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer3_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer3_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer3_data2

;fake mouse
	if	b,inputplayer3_fakemouse=#1
	if	b,#1=inputplayer3_inverty
	if	x,#0=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#1=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	else
	if	x,#1=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#0=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	endif

	if	x,#3=inputplayer3_data1
	add.w	#10,inputplayer3_mousex
	endif

	if	x,#2=inputplayer3_data1
	sub.w	#10,inputplayer3_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer3_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer3_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer3_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer3_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer3_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer3_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer3_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer3_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer3_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer3_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer3_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer3_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer3_data1

; now mouse cords
; mousex
	if	b,inputplayer3_dx=#0
	move.b	inputplayer3_mx,d7
	move.b	inputplayer3_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer3_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer3_mx,d7
	and.w	#255,d7
	move.b	inputplayer3_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousex
	endif
;mouse y
	if	b,inputplayer3_inverty=#1

	if	b,inputplayer3_dy=#0
	move.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer3_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer3_dy=#0
	move.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer3_my,d7
	and.b	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer3_mousey
	endif
	endif

	rts
	endif
;end mouse


	rts

	endif



; multi tap port b only




;*****************************************************************************************************************************************************
; if we are using multtap 2 for player 3
	if	b,device_porta_id<>#4	b,device_portb_id=#4



; grab data from portb multitap

; try to get id 
	move.l	#inputplayer2_data3,a6
	lea	(3,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer3_id
	if	b,inputplayer3_id>#3
	clr.b	inputplayer3_id
	endif

	clr.b	inputplayer3_data1
	clr.b	inputplayer3_data2

;find skip value
	move.b	inputplayer2_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 2
;	move.b	inputplayer3_id,d6
;	if	b,d6=#1
;	lea	(2,a6),a6
;	endif
;	if	b,d6=#2
;	lea	(3,a6),a6
;	endif
;	if	b,d6=#3
;	lea	(6,a6),a6
;	endif



; ready to poll data from a6
	lea	(3,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer3_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer3_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data2

;fake mouse
	if	b,inputplayer3_fakemouse=#1
	if	b,#1=inputplayer3_inverty
	if	x,#0=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#1=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	else
	if	x,#1=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#0=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	endif

	if	x,#3=inputplayer3_data1
	add.w	#10,inputplayer3_mousex
	endif

	if	x,#2=inputplayer3_data1
	sub.w	#10,inputplayer3_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer3_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer3_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer3_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer3_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer3_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer3_data2

;fake mouse
	if	b,inputplayer3_fakemouse=#1
	if	b,#1=inputplayer3_inverty
	if	x,#0=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#1=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	else
	if	x,#1=inputplayer3_data1
	add.w	#10,inputplayer3_mousey
	endif
	if	x,#0=inputplayer3_data1
	sub.w	#10,inputplayer3_mousey
	endif
	endif

	if	x,#3=inputplayer3_data1
	add.w	#10,inputplayer3_mousex
	endif

	if	x,#2=inputplayer3_data1
	sub.w	#10,inputplayer3_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer3_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer3_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer3_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer3_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer3_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer3_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer3_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer3_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer3_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer3_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer3_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer3_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer3_data1

; now mouse cords
; mousex
	if	b,inputplayer3_dx=#0
	move.b	inputplayer3_mx,d7
	move.b	inputplayer3_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer3_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer3_mx,d7
	and.w	#255,d7
	move.b	inputplayer3_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousex
	endif
;mouse y
	if	b,inputplayer3_inverty=#1

	if	b,inputplayer3_dy=#0
	move.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer3_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer3_dy=#0
	move.b	inputplayer3_my,d7
	and.w	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer3_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer3_my,d7
	and.b	#255,d7
	move.b	inputplayer3_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer3_mousey
	endif
	endif

	rts
	endif
;end mouse


	rts

	endif


	rts

endfunction










;*********************************************************************************************************************************
function	inputplayer4
rem	inputplayer4()
rem	updates variables for inputs based on whats plugged in
rem	[ inputplayer1_ ] id.b data1.b data2.b mousex.w mousey.w mx.b my.b trackx.b tracky.b dx.b dy.b inverty.b
rem	uses stack & d7
def	inputplayer4_id	byte
def	inputplayer4_init	byte	;initialized
def	inputplayer4_data1	byte
def	inputplayer4_data2	byte
def	inputplayer4_mousex	word
def	inputplayer4_mousey	word
def	inputplayer4_mx	byte
def	inputplayer4_my	byte
def	inputplayer4_trackx	byte
def	inputplayer4_tracky	byte
def	inputplayer4_dx	byte
def	inputplayer4_dy	byte
def	inputplayer4_inverty	byte
def	inputplayer4_fakemouse	byte

stack	a4-a6/d4-d6

inputplayer4

	if	w,device_porta_cnt=#0	or	w,device_portb_cnt=#0
	rts
	endif


;clear data
	clr.b	inputplayer4_data1
	clr.b	inputplayer4_data2
	clr.b	inputplayer4_id
; all data is from multitap 1 or multitap 2




	if	b,inputplayer4_init<>#123
; setup mouse vars to start
	move.b	#123,inputplayer4_init
	move.w	#284,inputplayer4_mousex
	move.w	#225,inputplayer4_mousey
	move.b	#0,inputplayer4_trackx
	move.b	#0,inputplayer4_tracky
	clr.b	inputplayer4_mx
	clr.b	inputplayer4_my
	clr.b	inputplayer4_dx
	clr.b	inputplayer4_dy
	move.b	#0,inputplayer4_inverty
	move.b	#1,inputplayer4_fakemouse	;default
	endif


;*****************************************************************************************************************************************************
; if we are using multtap 1 for player 4
	if	b,device_porta_id=#4



; grab data from porta multitap

; try to get id 
	move.l	#inputplayer1_data3,a6
	lea	(5,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer4_id
	if	b,inputplayer4_id>#3
	clr.b	inputplayer4_id
	endif

	clr.b	inputplayer4_data1
	clr.b	inputplayer4_data2

;find skip value
	move.b	inputplayer1_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 2
	move.b	inputplayer2_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif

;find skip on player 3
	move.b	inputplayer3_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif


; ready to poll data from a6
	lea	(1,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer4_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer4_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data2

;fake mouse
	if	b,inputplayer4_fakemouse=#1
	if	b,#1=inputplayer4_inverty
	if	x,#0=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#1=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	else
	if	x,#1=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#0=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	endif

	if	x,#3=inputplayer4_data1
	add.w	#10,inputplayer4_mousex
	endif

	if	x,#2=inputplayer4_data1
	sub.w	#10,inputplayer4_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer4_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer4_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer4_data2

;fake mouse
	if	b,inputplayer4_fakemouse=#1
	if	b,#1=inputplayer4_inverty
	if	x,#0=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#1=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	else
	if	x,#1=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#0=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	endif

	if	x,#3=inputplayer4_data1
	add.w	#10,inputplayer4_mousex
	endif

	if	x,#2=inputplayer4_data1
	sub.w	#10,inputplayer4_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer4_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer4_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer4_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer4_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer4_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer4_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer4_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer4_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer4_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer4_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer4_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer4_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer4_data1

; now mouse cords
; mousex
	if	b,inputplayer4_dx=#0
	move.b	inputplayer4_mx,d7
	move.b	inputplayer4_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer4_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer4_mx,d7
	and.w	#255,d7
	move.b	inputplayer4_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousex
	endif
;mouse y
	if	b,inputplayer4_inverty=#1

	if	b,inputplayer4_dy=#0
	move.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer4_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer4_dy=#0
	move.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer4_my,d7
	and.b	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer4_mousey
	endif
	endif

	rts
	endif
;end mouse


	rts

	endif



; multi tap port b only




;*****************************************************************************************************************************************************
; if we are using multtap 2 for player 4
	if	b,device_porta_id<>#4	b,device_portb_id=#4



; grab data from porta multitap

; try to get id 
	move.l	#inputplayer2_data3,a6
	lea	(4,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer4_id
	if	b,inputplayer4_id>#3
	clr.b	inputplayer4_id
	endif

	clr.b	inputplayer4_data1
	clr.b	inputplayer4_data2

;find skip value
	move.b	inputplayer2_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 2
	move.b	inputplayer3_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif



; ready to poll data from a6
	lea	(2,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer4_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer4_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data2

;fake mouse
	if	b,inputplayer4_fakemouse=#1
	if	b,#1=inputplayer4_inverty
	if	x,#0=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#1=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	else
	if	x,#1=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#0=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	endif

	if	x,#3=inputplayer4_data1
	add.w	#10,inputplayer4_mousex
	endif

	if	x,#2=inputplayer4_data1
	sub.w	#10,inputplayer4_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer4_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer4_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer4_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer4_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer4_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer4_data2

;fake mouse
	if	b,inputplayer4_fakemouse=#1
	if	b,#1=inputplayer4_inverty
	if	x,#0=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#1=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	else
	if	x,#1=inputplayer4_data1
	add.w	#10,inputplayer4_mousey
	endif
	if	x,#0=inputplayer4_data1
	sub.w	#10,inputplayer4_mousey
	endif
	endif

	if	x,#3=inputplayer4_data1
	add.w	#10,inputplayer4_mousex
	endif

	if	x,#2=inputplayer4_data1
	sub.w	#10,inputplayer4_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer4_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer4_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer4_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer4_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer4_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer4_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer4_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer4_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer4_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer4_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer4_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer4_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer4_data1

; now mouse cords
; mousex
	if	b,inputplayer4_dx=#0
	move.b	inputplayer4_mx,d7
	move.b	inputplayer4_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer4_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer4_mx,d7
	and.w	#255,d7
	move.b	inputplayer4_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousex
	endif
;mouse y
	if	b,inputplayer4_inverty=#1

	if	b,inputplayer4_dy=#0
	move.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer4_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer4_dy=#0
	move.b	inputplayer4_my,d7
	and.w	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer4_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer4_my,d7
	and.b	#255,d7
	move.b	inputplayer4_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer4_mousey
	endif
	endif

	rts
	endif
;end mouse


	rts

	endif


	rts

endfunction







;*********************************************************************************************************************************
function	inputplayer5
rem	inputplayer5()
rem	updates variables for inputs based on whats plugged in
rem	[ inputplayer1_ ] id.b data1.b data2.b mousex.w mousey.w mx.b my.b trackx.b tracky.b dx.b dy.b inverty.b
rem	uses stack & d7
def	inputplayer5_id	byte
def	inputplayer5_init	byte	;initialized
def	inputplayer5_data1	byte
def	inputplayer5_data2	byte
def	inputplayer5_mousex	word
def	inputplayer5_mousey	word
def	inputplayer5_mx	byte
def	inputplayer5_my	byte
def	inputplayer5_trackx	byte
def	inputplayer5_tracky	byte
def	inputplayer5_dx	byte
def	inputplayer5_dy	byte
def	inputplayer5_inverty	byte
def	inputplayer5_fakemouse	byte

stack	a4-a6/d4-d6

inputplayer5

	if	w,device_porta_cnt=#0	or	w,device_portb_cnt=#0
	rts
	endif


;clear data
	clr.b	inputplayer5_data1
	clr.b	inputplayer5_data2
	clr.b	inputplayer5_id
; all data is from multitap 1 or port b




	if	b,inputplayer5_init<>#123
; setup mouse vars to start
	move.b	#123,inputplayer5_init
	move.w	#284,inputplayer5_mousex
	move.w	#225,inputplayer5_mousey
	move.b	#0,inputplayer5_trackx
	move.b	#0,inputplayer5_tracky
	clr.b	inputplayer5_mx
	clr.b	inputplayer5_my
	clr.b	inputplayer5_dx
	clr.b	inputplayer5_dy
	move.b	#0,inputplayer5_inverty
	move.b	#1,inputplayer5_fakemouse	;default
	endif


;*****************************************************************************************************************************************************
; if we are using multtap 1 for 5 players
	if	b,device_porta_id=#4	b,device_portb_id<>#4
; take from port b


	if	b,device_portb_id=#0
; atari master sys or nothing
	move.b	#0,inputplayer5_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.l	#$a1000b,a5



	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data1	;dpad
	move.b	(a6),d7
	lsr.b	#4,d7
	and.b	#3,d7
	bchg	#0,d7
	bchg	#1,d7
	move.b	d7,inputplayer5_data2	;a,b

;fake mouse
	if	b,inputplayer5_fakemouse=#1
	if	b,#1=inputplayer5_inverty
	if	x,#0=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#1=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	else
	if	x,#1=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#0=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	endif

	if	x,#3=inputplayer5_data1
	add.w	#10,inputplayer5_mousex
	endif

	if	x,#2=inputplayer5_data1
	sub.w	#10,inputplayer5_mousex
	endif
	endif
	rts
	endif



	if	b,device_portb_id=#1
; 3 button controller
	move.b	#1,inputplayer5_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer5_data2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer5_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer5_data2
	move.b	#$40,(a6)
; check unplug?
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
; not coded yet
;fake mouse
	if	b,inputplayer5_fakemouse=#1
	if	b,#1=inputplayer5_inverty
	if	x,#0=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#1=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	else
	if	x,#1=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#0=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	endif
	if	x,#3=inputplayer5_data1
	add.w	#10,inputplayer5_mousex
	endif
	if	x,#2=inputplayer5_data1
	sub.w	#10,inputplayer5_mousex
	endif
	endif
	rts
	endif


	if	b,device_portb_id=#2
; 6 button controller
	move.b	#2,inputplayer5_id
;	move.b	#%01000000,($a10009)	;ctrl one
;	move.l	#$a10003,a6	;read and write port
	move.b	#%01000000,($a1000b)	;ctrl two
	move.l	#$a10005,a6
	move.b	#$40,(a6)
	move.b	(a6),d7	;first read
	and.b	#$f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data1
	move.b	(a6),d7
	lsr.b	#3,d7
	and.b	#6,d7
	bchg	#1,d7
	bchg	#2,d7
	move.b	d7,inputplayer5_data2
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 2
	lsr.b	#4,d7
	and.b	#1,d7
	bchg	#0,d7
	add.b	d7,inputplayer5_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#8,d7
	bchg	#3,d7
	add.b	d7,inputplayer5_data2
	move.b	#$40,(a6)
;get x,y,z,mode
	move.b	(a6),d7	;read 3
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 4
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 5
	move.b	#$0,(a6)
	move.b	(a6),d7	;read 6
	move.b	#$40,(a6)
	move.b	(a6),d7	;read 7
	lsl.b	#4,d7
	and.b	#$f0,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	add.b	d7,inputplayer5_data2
;fake mouse
	if	b,inputplayer5_fakemouse=#1
	if	b,#1=inputplayer5_inverty
	if	x,#0=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#1=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	else
	if	x,#1=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#0=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	endif
	if	x,#3=inputplayer5_data1
	add.w	#10,inputplayer5_mousex
	endif
	if	x,#2=inputplayer5_data1
	sub.w	#10,inputplayer5_mousex
	endif
	endif
	rts
	endif



	if	b,device_portb_id=#3
;its a mouse
	move.b	#3,inputplayer5_id
;	move.l	#$a10009,a5
;	move.l	#$a10003,a6
	move.l	#$a1000b,a5	;ctrl two
	move.l	#$a10005,a6
	move.b	#$60,(a5)
; counter
	move.b	#20,d7
	move.b	#$60,(a6)
inputplayer5_mcc1
	sub.b	#1,d7
	beq	inputplayer5_mac1
	move.b	(a6),inputplayer5_data1	;1 read
	btst	#4,inputplayer5_data1
	bne	inputplayer5_mcc1
inputplayer5_mac1
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer5_mcc2
	sub.b	#1,d7
	beq	inputplayer5_mac2
	move.b	(a6),inputplayer5_data2	;2 read
	btst	#4,inputplayer5_data2
	bne	inputplayer5_mcc2
inputplayer5_mac2
; unplugged mouse?
	if	b,#127=inputplayer5_data1	b,#63=inputplayer5_data2
; ok mouse unplugged
	move.b	#0,device_portb_id
	move.l	#$a1000b,a5
	move.b	#$40,(a5)
	move.b	#$40,(a6)
	clr.b	inputplayer5_id
	rts
	endif
; still plugged in
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer5_mcc3
	sub.b	#1,d7
	beq	inputplayer5_mac3
	move.b	(a6),d6	;3 read
	btst	#4,d6
	bne	inputplayer5_mcc3
inputplayer5_mac3
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer5_mcc4
	sub.b	#1,d7
	beq	inputplayer5_mac4
	move.b	(a6),d6	;4 read
	cmp.b	#63,d6
	bne	inputplayer5_mcc4
inputplayer5_mac4
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer5_mcc5
	sub.b	#1,d7
	beq	inputplayer5_mac5
	move.b	(a6),inputplayer5_dx	;5 read important read start
	btst	#4,inputplayer5_dx
	bne	inputplayer5_mcc5
inputplayer5_mac5
	move.b	inputplayer5_dx,d7
	lsr.b	#1,d7
	and.b	#1,d7
	move.b	d7,inputplayer5_dy
	move.b	inputplayer5_dx,d7
	and.b	#1,d7
	move.b	d7,inputplayer5_dx

; counter buttons on this one
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer5_mcc6
	sub.b	#1,d7
	beq	inputplayer5_mac6
	move.b	(a6),d6	;6 read
	btst	#4,d6
	beq	inputplayer5_mcc6
inputplayer5_mac6
	and.b	#$0f,d6
	move.b	d6,inputplayer5_data2
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer5_mcc7
	sub.b	#1,d7
	beq	inputplayer5_mac7
	move.b	(a6),d5	;7 read high byte x
	btst	#4,d5
	bne	inputplayer5_mcc7
inputplayer5_mac7
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer5_mcc8
	sub.b	#1,d7
	beq	inputplayer5_mac8
	move.b	(a6),d6	;8 read low byte x
	btst	#4,d6
	beq	inputplayer5_mcc8
inputplayer5_mac8
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer5_mx	;stored x
; counter
	move.b	#20,d7
	move.b	#$0,(a6)
inputplayer5_mcc9
	sub.b	#1,d7
	beq	inputplayer5_mac9
	move.b	(a6),d5	;9 read
	btst	#4,d5
	bne	inputplayer5_mcc9
inputplayer5_mac9
; counter
	move.b	#20,d7
	move.b	#$20,(a6)
inputplayer5_mcc10
	sub.b	#1,d7
	beq	inputplayer5_mac10
	move.b	(a6),d6	;10 read
	btst	#4,d6
	beq	inputplayer5_mcc10
inputplayer5_mac10
	and.b	#$0f,d5
	and.b	#$0f,d6
	lsl.b	#4,d5
	add.b	d5,d6
	move.b	d6,inputplayer5_my	;stored y
; counter
; end
	move.b	#$60,(a6)
;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer5_my<>#0	b,inputplayer5_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer5_my<>#0	b,inputplayer5_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer5_mx<>#0	b,inputplayer5_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer5_mx<>#0	b,inputplayer5_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer5_data1
; now mouse cords
; mousex
	if	b,inputplayer5_dx=#0
	move.b	inputplayer5_mx,d7
	move.b	inputplayer5_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer5_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer5_mx,d7
	and.w	#255,d7
	move.b	inputplayer5_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousex
	endif
;mouse y
	if	b,inputplayer5_inverty=#1
	if	b,inputplayer5_dy=#0
	move.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer5_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousey
	endif
	else
; mouse y is normal
	if	b,inputplayer5_dy=#0
	move.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer5_my,d7
	and.b	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer5_mousey
	endif
	endif
	rts
	endif

	rts
	endif



; multi tap port b only




;*****************************************************************************************************************************************************
; if we are using multtap 2 for player 5
	if	b,device_porta_id<>#4	b,device_portb_id=#4



; grab data from portb multitap

; try to get id 
	move.l	#inputplayer2_data3,a6
	lea	(5,a6),a6
	move.b	(a6),d7
	add.b	#1,d7
	and.b	#$03,d7
	move.b	d7,inputplayer5_id
	if	b,inputplayer5_id>#3
	clr.b	inputplayer5_id
	endif

	clr.b	inputplayer5_data1
	clr.b	inputplayer5_data2

;find skip value 2
	move.b	inputplayer2_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 3
	move.b	inputplayer3_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif
;find skip on player 4
	move.b	inputplayer4_id,d6
	if	b,d6=#1
	lea	(2,a6),a6
	endif
	if	b,d6=#2
	lea	(3,a6),a6
	endif
	if	b,d6=#3
	lea	(6,a6),a6
	endif



; ready to poll data from a6
	lea	(1,a6),a6	;should be correct


; ok was it a 3 button
	if	b,inputplayer5_id=#1
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer5_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer5_data2
	move.b	(a6),d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	inputplayer5_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data2

;fake mouse
	if	b,inputplayer5_fakemouse=#1
	if	b,#1=inputplayer5_inverty
	if	x,#0=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#1=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	else
	if	x,#1=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#0=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	endif

	if	x,#3=inputplayer5_data1
	add.w	#10,inputplayer5_mousex
	endif

	if	x,#2=inputplayer5_data1
	sub.w	#10,inputplayer5_mousex
	endif
	endif

	rts
	endif



;ok was it a 6 button
	if	b,inputplayer5_id=#2
;	lea	(4,a6),a6
	move.b	(a6)+,d7
	and.b	#$0f,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	move.b	d7,inputplayer5_data1

	move.b	(a6),d7
	and.b	#8,d7
	move.b	d7,inputplayer5_data2
	move.b	(a6),d7
	lsr.b	#2,d7
	and.b	#1,d7
	add.b	d7,inputplayer5_data2
	move.b	(a6)+,d7
	lsl.b	#1,d7
	and.b	#6,d7
	add.b	d7,inputplayer5_data2
	move.b	(a6),d7
	and.b	#15,d7
	lsl.b	#4,d7
	add.b	inputplayer5_data2,d7
	bchg	#0,d7
	bchg	#1,d7
	bchg	#2,d7
	bchg	#3,d7
	bchg	#4,d7
	bchg	#5,d7
	bchg	#6,d7
	bchg	#7,d7
	move.b	d7,inputplayer5_data2

;fake mouse
	if	b,inputplayer5_fakemouse=#1
	if	b,#1=inputplayer5_inverty
	if	x,#0=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#1=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	else
	if	x,#1=inputplayer5_data1
	add.w	#10,inputplayer5_mousey
	endif
	if	x,#0=inputplayer5_data1
	sub.w	#10,inputplayer5_mousey
	endif
	endif

	if	x,#3=inputplayer5_data1
	add.w	#10,inputplayer5_mousex
	endif

	if	x,#2=inputplayer5_data1
	sub.w	#10,inputplayer5_mousex
	endif
	endif


	rts
	endif

; now mouse plugged into multitap
	if	b,inputplayer5_id=#3
;	lea	(4,a6),a6
;6 bytes in 4 nibbles
; direction
; buttons
; x high
; x low
; y high
; y low
	move.b	(a6),d7
	and.b	#2,d7
	lsr.b	#1,d7
	move.b	d7,inputplayer5_dy
	move.b	(a6)+,d7
	and.b	#1,d7
	move.b	d7,inputplayer5_dx

	move.b	(a6)+,d7
	and.b	#15,d7
	move.b	d7,inputplayer5_data2

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer5_mx
	move.b	(a6)+,d7
	and.b	#15,d7
	add.b	d7,inputplayer5_mx

	move.b	(a6)+,d7
	lsl.b	#4,d7
	move.b	d7,inputplayer5_my
	move.b	(a6),d7
	and.b	#15,d7
	add.b	d7,inputplayer5_my



;ok need to fill vars for direction
	clr.b	d6
	if	b,inputplayer5_my<>#0	b,inputplayer1_dy=#0
	bchg	#0,d6
	endif
	if	b,inputplayer5_my<>#0	b,inputplayer1_dy=#1
	bchg	#1,d6
	endif
	if	b,inputplayer5_mx<>#0	b,inputplayer1_dx=#1
	bchg	#2,d6
	endif
	if	b,inputplayer5_mx<>#0	b,inputplayer1_dx=#0
	bchg	#3,d6
	endif
	move.b	d6,inputplayer5_data1

; now mouse cords
; mousex
	if	b,inputplayer5_dx=#0
	move.b	inputplayer5_mx,d7
	move.b	inputplayer5_trackx,d6
	lsr.b	d6,d7
	and.w	#255,d7
	add.w	d7,inputplayer5_mousex
	else
	move.b	#255,d7
	sub.b	inputplayer5_mx,d7
	and.w	#255,d7
	move.b	inputplayer5_trackx,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousex
	endif
;mouse y
	if	b,inputplayer5_inverty=#1

	if	b,inputplayer5_dy=#0
	move.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer5_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousey
	endif

	else

; mouse y is normal
	if	b,inputplayer5_dy=#0
	move.b	inputplayer5_my,d7
	and.w	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	sub.w	d7,inputplayer5_mousey
	else
	move.b	#255,d7
	sub.b	inputplayer5_my,d7
	and.b	#255,d7
	move.b	inputplayer5_tracky,d6
	lsr.b	d6,d7
	add.w	d7,inputplayer5_mousey
	endif
	endif

	rts
	endif
;end mouse


	rts

	endif


	rts

endfunction








