#dontinclude


; remake to standardize commands
; may 25th 2025
; sheldon macdonald





function	memory_compair	memory_compair1,memory_compair2,memory_compair_len
rem	memory_compair( address_source.l , address_cmp.l , address_cmp_len.w )
rem	returns value on d7.b  1=yes 0=no
rem	
rem	
stack	a5-a6/d5-d6

def	memory_compair1	long
def	memory_compair2	long
def	memory_compair_len	word

memory_compair
	move.l	memory_compair1,a5
	move.l	memory_compair2,a6
	move.l	#0,d5

memory_compair_lp
	move.b	(a5),d6
	move.b	(a6),d7
	cmp.b	d6,d7
	bne	memory_compair_exit
	lea	(1,a5),a5
	lea	(1,a6),a6
	add.w	#1,d5
	cmp.w	memory_compair_len,d5
	blo	memory_compair_lp
	move.b	#1,d7
	rts

memory_compair_exit
	move.b	#0,d7
	rts
endfunction




;**********************************************************************************************************************
function	sega_clearspriteorder
rem	sega_clearspriteorder()
rem	clears the 80 sprite bank
rem	
rem	

def	sega_spriteorder_mem	string	168
stack	a6
sega_clearspriteorder

	move.w	#39,d7
	lea	sega_spriteorder_mem,a6

sega_clearspriteorder_lp
	clr.l	(a6)+
	dbra	d7,sega_clearspriteorder_lp

	rts

endfunction

;*********************************************************************************************************************
function	sega_setspriteorder	sega_spriteorder_spr,sega_spriteorder_posy
rem	sega_setspriteorder( sprite.b, yposition.w )
rem	
rem	puts sprites in database known as #sega_spriteorder_mem
rem	

def	sega_spriteorder_spr	byte
def	sega_spriteorder_spr2	byte
def	sega_spriteorder_posy	word

stack	a6

sega_setspriteorder

	lea	sega_spriteorder_mem,a6
	clr.l	d7
	move.b	sega_spriteorder_spr,d7
	mulu.w	#2,d7
	lea	(a6,d7),a6
	move.w	sega_spriteorder_posy,d7
	move.w	d7,(0,a6)

	rts

endfunction



;*********************************************************************************************************************************************************************************************systemclock()
function	systemclock
rem	systemclock()
rem	used for random number generator
rem	returns word value on d7  variable name= systemclock_c
def	systemclock_c	word
systemclock
;	move.w	systemclock_c,d7
	add.w	#1,systemclock_c
;	move.w	d7,systemclock_c
	rts
endfunction



; ****************************************************************************************************************************************
function	sega_setplanepicb	sega_setplanepicb_pointer,sega_setplanepicb_adjust,sega_setplanepicb_pal

rem	sega_setplanepicb( tileset_pointer.l ,tile_adjust.w, palette.b )
rem	40x24?
rem	
rem	

stack	a6/d4-d6
def	sega_setplanepicb_pointer	long
def	sega_setplanepicb_adjust	word
def	sega_setplanepicb_pal	byte
def	sega_setplanepicb_pal2	byte

sega_setplanepicb

	move.w	#$8f02,$c00004	; set vdp autoincrement to 128 bytes/write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num

	move.w	#0,d7
	mulu.w	#128,d7	;64 x 2 each tile is word
	lsl.l	#8,d7
	lsl.l	#8,d7
	add.l	#$60000003,d7
	move.l	d7,$00c00004	;what register?


	move.l	sega_setplanepicb_pointer,a6	
	move.w	sega_setplanepicb_adjust,d6
	move.w	#2047,d4	;main counter
sega_setplanepicb_lp3
	move.w	(a6)+,d5
	add.w	d6,d5
	move.w	d5,$00c00000	;written
	dbra	d4,sega_setplanepicb_lp3
	rts
endfunction





; ****************************************************************************************************************************************
function	sega_setplanepica	sega_setplanepica_pointer,sega_setplanepica_adjust,sega_setplanepicb_pal
rem	sega_setplanepica( tileset_pointer.l ,tile_adjust.w , palette.b)
rem	40x24?
rem	
rem	

stack	a6/d4-d6
def	sega_setplanepica_pointer	long
def	sega_setplanepica_adjust	word
def	sega_setplanepica_pal	byte
def	sega_setplanepica_pal2	byte


sega_setplanepica

	move.w	#$8f02,$c00004	; set vdp autoincrement
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num

	move.w	#0,d7
	mulu.w	#128,d7	;64 x 2 each tile is word
	lsl.l	#8,d7
	lsl.l	#8,d7

	add.l	#$40000003,d7
	move.l	d7,$00c00004	;what register?



	move.l	sega_setplanepica_pointer,a6	
	move.w	sega_setplanepica_adjust,d6
	move.w	#2047,d4	;main counter
sega_setplanepica_lp3
	move.w	(a6)+,d5
	add.w	d6,d5
	move.w	d5,$00c00000	;written
	dbra	d4,sega_setplanepica_lp3
	rts


endfunction




;*************************************************************************************************************************************************************************sync()

function	sync
rem	sync()
rem	start of vblank status
rem	uses D7
sync
	move.w	$c00004,d7 ; Move VDP status word to d7
	andi.w	#$0008,d7     ; AND with bit 4 (vblank), result in status register
	bne	sync	; Branch if not equal (to zero)
	rts
endfunction


;*************************************************************************************************************************************************************************syncend()
function	syncend
rem	syncend()
rem	end of vblank status
rem	uses D7
syncend
	move.w	$c00004,d7 ; Move VDP status word to d0
	andi.w	#$0008,d7     ; AND with bit 4 (vblank), result in status register
	beq    syncend	; Branch if equal (to zero)
	rts
endfunction


;***********************************************************************************************************************************************************************init_sega()
function	init_sega
rem	init_sega()
rem	disables sega security system and holds z80 in reset state
rem	clears all ram
rem	uses a6,d7


;lets dump system font in here
sega_font_set
; sprite #0
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000

; sprite #1
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
; sprite #2
	dc.l	$00110000,$01111000,$01111000,$00110000,$00110000,$00000000,$00110000,$00000000
; sprite #3
	dc.l	$01101100,$01101100,$01101100,$00000000,$00000000,$00000000,$00000000,$00000000
; sprite #4
	dc.l	$01101100,$01101100,$11111110,$01101100,$11111110,$01101100,$01101100,$00000000
; sprite #5
	dc.l	$00110000,$01111100,$11000000,$01111000,$00001100,$11111000,$00110000,$00000000
; sprite #6
	dc.l	$00000000,$11000110,$11001100,$00011000,$00110000,$01100110,$11000110,$00000000
; sprite #7
	dc.l	$00111000,$01101100,$00111000,$01110110,$11011100,$11001100,$01110110,$00000000
; sprite #8
	dc.l	$01100000,$01100000,$11000000,$00000000,$00000000,$00000000,$00000000,$00000000
; sprite #9
	dc.l	$00011000,$00110000,$01100000,$01100000,$01100000,$00110000,$00011000,$00000000
; sprite #10
	dc.l	$01100000,$00110000,$00011000,$00011000,$00011000,$00110000,$01100000,$00000000
; sprite #11
	dc.l	$00000000,$01100110,$00111100,$11111111,$00111100,$01100110,$00000000,$00000000
; sprite #12
	dc.l	$00000000,$00110000,$00110000,$11111100,$00110000,$00110000,$00000000,$00000000
; sprite #13
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00110000,$00110000,$01100000
; sprite #14
	dc.l	$00000000,$00000000,$00000000,$11111100,$00000000,$00000000,$00000000,$00000000
; sprite #15
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00110000,$00110000,$00000000
; sprite #16
	dc.l	$00000110,$00001100,$00011000,$00110000,$01100000,$11000000,$10000000,$00000000
; sprite #17
	dc.l	$01111100,$11000110,$11001110,$11011110,$11110110,$11100110,$01111100,$00000000
; sprite #18
	dc.l	$00110000,$01110000,$00110000,$00110000,$00110000,$00110000,$11111100,$00000000
; sprite #19
	dc.l	$01111000,$11001100,$00001100,$00111000,$01100000,$11001100,$11111100,$00000000
; sprite #20
	dc.l	$01111000,$11001100,$00001100,$00111000,$00001100,$11001100,$01111000,$00000000
; sprite #21
	dc.l	$00011100,$00111100,$01101100,$11001100,$11111110,$00001100,$00011110,$00000000
; sprite #22
	dc.l	$11111100,$11000000,$11111000,$00001100,$00001100,$11001100,$01111000,$00000000
; sprite #23
	dc.l	$00111000,$01100000,$11000000,$11111000,$11001100,$11001100,$01111000,$00000000
; sprite #24
	dc.l	$11111100,$11001100,$00001100,$00011000,$00110000,$00110000,$00110000,$00000000
; sprite #25
	dc.l	$01111000,$11001100,$11001100,$01111000,$11001100,$11001100,$01111000,$00000000
; sprite #26
	dc.l	$01111000,$11001100,$11001100,$01111100,$00001100,$00011000,$01110000,$00000000
; sprite #27
	dc.l	$00000000,$00110000,$00110000,$00000000,$00000000,$00110000,$00110000,$00000000
; sprite #28
	dc.l	$00000000,$00110000,$00110000,$00000000,$00110000,$00110000,$01100000,$00000000
; sprite #29
	dc.l	$00011000,$00110000,$01100000,$11000000,$01100000,$00110000,$00011000,$00000000
; sprite #30
	dc.l	$00000000,$00000000,$11111100,$00000000,$00000000,$11111100,$00000000,$00000000
; sprite #31
	dc.l	$01100000,$00110000,$00011000,$00001100,$00011000,$00110000,$01100000,$00000000
; sprite #32
	dc.l	$01111000,$11001100,$00001100,$00011000,$00110000,$00000000,$00110000,$00000000
; sprite #33
	dc.l	$01111100,$11000110,$11011110,$11011110,$11011110,$11000000,$01111000,$00000000
; sprite #34
	dc.l	$00110000,$01111000,$11001100,$11001100,$11111100,$11001100,$11001100,$00000000
; sprite #35
	dc.l	$11111100,$01100110,$01100110,$01111100,$01100110,$01100110,$11111100,$00000000
; sprite #36
	dc.l	$00111100,$01100110,$11000000,$11000000,$11000000,$01100110,$00111100,$00000000
; sprite #37
	dc.l	$11111000,$01101100,$01100110,$01100110,$01100110,$01101100,$11111000,$00000000
; sprite #38
	dc.l	$11111110,$01100010,$01101000,$01111000,$01101000,$01100010,$11111110,$00000000
; sprite #39
	dc.l	$11111110,$01100010,$01101000,$01111000,$01101000,$01100000,$11110000,$00000000
; sprite #40
	dc.l	$00111100,$01100110,$11000000,$11000000,$11001110,$01100110,$00111110,$00000000
; sprite #41
	dc.l	$11001100,$11001100,$11001100,$11111100,$11001100,$11001100,$11001100,$00000000
; sprite #42
	dc.l	$01111000,$00110000,$00110000,$00110000,$00110000,$00110000,$01111000,$00000000
; sprite #43
	dc.l	$00011110,$00001100,$00001100,$00001100,$11001100,$11001100,$01111000,$00000000
; sprite #44
	dc.l	$11100110,$01100110,$01101100,$01111000,$01101100,$01100110,$11100110,$00000000
; sprite #45
	dc.l	$11110000,$01100000,$01100000,$01100000,$01100010,$01100110,$11111110,$00000000
; sprite #46
	dc.l	$11000110,$11101110,$11111110,$11111110,$11010110,$11000110,$11000110,$00000000
; sprite #47
	dc.l	$11000110,$11100110,$11110110,$11011110,$11001110,$11000110,$11000110,$00000000
; sprite #48
	dc.l	$00111000,$01101100,$11000110,$11000110,$11000110,$01101100,$00111000,$00000000
; sprite #49
	dc.l	$11111100,$01100110,$01100110,$01111100,$01100000,$01100000,$11110000,$00000000
; sprite #50
	dc.l	$01111000,$11001100,$11001100,$11001100,$11011100,$01111000,$00011100,$00000000
; sprite #51
	dc.l	$11111100,$01100110,$01100110,$01111100,$01101100,$01100110,$11100110,$00000000
; sprite #52
	dc.l	$01111000,$11001100,$11100000,$01110000,$00011100,$11001100,$01111000,$00000000
; sprite #53
	dc.l	$11111100,$10110100,$00110000,$00110000,$00110000,$00110000,$01111000,$00000000
; sprite #54
	dc.l	$11001100,$11001100,$11001100,$11001100,$11001100,$11001100,$11111100,$00000000
; sprite #55
	dc.l	$11001100,$11001100,$11001100,$11001100,$11001100,$01111000,$00110000,$00000000
; sprite #56
	dc.l	$11000110,$11000110,$11000110,$11010110,$11111110,$11101110,$11000110,$00000000
; sprite #57
	dc.l	$11000110,$11000110,$01101100,$00111000,$00111000,$01101100,$11000110,$00000000
; sprite #58
	dc.l	$11001100,$11001100,$11001100,$01111000,$00110000,$00110000,$01111000,$00000000
; sprite #59
	dc.l	$11111110,$11000110,$10001100,$00011000,$00110010,$01100110,$11111110,$00000000
; sprite #60
	dc.l	$01111000,$01100000,$01100000,$01100000,$01100000,$01100000,$01111000,$00000000
; sprite #61
	dc.l	$11000000,$01100000,$00110000,$00011000,$00001100,$00000110,$00000010,$00000000
; sprite #62
	dc.l	$01111000,$00011000,$00011000,$00011000,$00011000,$00011000,$01111000,$00000000
; sprite #63
	dc.l	$00010000,$00111000,$01101100,$11000110,$00000000,$00000000,$00000000,$00000000
; sprite #64
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$11111111
; sprite #65
	dc.l	$00110000,$00110000,$00011000,$00000000,$00000000,$00000000,$00000000,$00000000
; sprite #66
	dc.l	$00000000,$00000000,$01111000,$00001100,$01111100,$11001100,$01110110,$00000000
; sprite #67
	dc.l	$11100000,$01100000,$01100000,$01111100,$01100110,$01100110,$11011100,$00000000
; sprite #68
	dc.l	$00000000,$00000000,$01111000,$11001100,$11000000,$11001100,$01111000,$00000000
; sprite #69
	dc.l	$00011100,$00001100,$00001100,$01111100,$11001100,$11001100,$01110110,$00000000
; sprite #70
	dc.l	$00000000,$00000000,$01111000,$11001100,$11111100,$11000000,$01111000,$00000000
; sprite #71
	dc.l	$00111000,$01101100,$01100000,$11110000,$01100000,$01100000,$11110000,$00000000
; sprite #72
	dc.l	$00000000,$00000000,$01110110,$11001100,$11001100,$01111100,$00001100,$11111000
; sprite #73
	dc.l	$11100000,$01100000,$01101100,$01110110,$01100110,$01100110,$11100110,$00000000
; sprite #74
	dc.l	$00110000,$00000000,$01110000,$00110000,$00110000,$00110000,$01111000,$00000000
; sprite #75
	dc.l	$00001100,$00000000,$00001100,$00001100,$00001100,$11001100,$11001100,$01111000
; sprite #76
	dc.l	$11100000,$01100000,$01100110,$01101100,$01111000,$01101100,$11100110,$00000000
; sprite #77
	dc.l	$01110000,$00110000,$00110000,$00110000,$00110000,$00110000,$01111000,$00000000
; sprite #78
	dc.l	$00000000,$00000000,$11001100,$11111110,$11111110,$11010110,$11000110,$00000000
; sprite #79
	dc.l	$00000000,$00000000,$11111000,$11001100,$11001100,$11001100,$11001100,$00000000
; sprite #80
	dc.l	$00000000,$00000000,$01111000,$11001100,$11001100,$11001100,$01111000,$00000000
; sprite #81
	dc.l	$00000000,$00000000,$11011100,$01100110,$01100110,$01111100,$01100000,$11110000
; sprite #82
	dc.l	$00000000,$00000000,$01110110,$11001100,$11001100,$01111100,$00001100,$00011110
; sprite #83
	dc.l	$00000000,$00000000,$11011100,$01110110,$01100110,$01100000,$11110000,$00000000
; sprite #84
	dc.l	$00000000,$00000000,$01111100,$11000000,$01111000,$00001100,$11111000,$00000000
; sprite #85
	dc.l	$00010000,$00110000,$01111100,$00110000,$00110000,$00110100,$00011000,$00000000
; sprite #86
	dc.l	$00000000,$00000000,$11001100,$11001100,$11001100,$11001100,$01110110,$00000000
; sprite #87
	dc.l	$00000000,$00000000,$11001100,$11001100,$11001100,$01111000,$00110000,$00000000
; sprite #88
	dc.l	$00000000,$00000000,$11000110,$11010110,$11111110,$11111110,$01101100,$00000000
; sprite #89
	dc.l	$00000000,$00000000,$11000110,$01101100,$00111000,$01101100,$11000110,$00000000
; sprite #90
	dc.l	$00000000,$00000000,$11001100,$11001100,$11001100,$01111100,$00001100,$11111000
; sprite #91
	dc.l	$00000000,$00000000,$11111100,$10011000,$00110000,$01100100,$11111100,$00000000
; sprite #92
	dc.l	$00011100,$00110000,$00110000,$11100000,$00110000,$00110000,$00011100,$00000000
; sprite #93
	dc.l	$00011000,$00011000,$00011000,$00000000,$00011000,$00011000,$00011000,$00000000
; sprite #94
	dc.l	$11100000,$00110000,$00110000,$00011100,$00110000,$00110000,$11100000,$00000000
; sprite #95
	dc.l	$01110110,$11011100,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000
; sprite #96
	dc.l	$00000000,$00010000,$00111000,$01101100,$11000110,$11000110,$11111110,$00000000
; sprite #97
	dc.l	$00100010,$10001000,$00100010,$10001000,$00100010,$10001000,$00100010,$10001000
; sprite #98
	dc.l	$01010101,$10101010,$01010101,$10101010,$01010101,$10101010,$01010101,$10101010
; sprite #99
	dc.l	$11011011,$01110111,$11011011,$11101110,$11011011,$01110111,$11011011,$11101110
; sprite #100
	dc.l	$00011000,$00011000,$00011000,$00011000,$00011000,$00011000,$00011000,$00011000
; sprite #101
	dc.l	$00011000,$00011000,$00011000,$00011000,$11111000,$00011000,$00011000,$00011000
; sprite #102
	dc.l	$00011000,$00011000,$11111000,$00011000,$11111000,$00011000,$00011000,$00011000
; sprite #103
	dc.l	$00110110,$00110110,$00110110,$00110110,$11110110,$00110110,$00110110,$00110110
; sprite #104
	dc.l	$00000000,$00000000,$00000000,$00000000,$11111110,$00110110,$00110110,$00110110
; sprite #105
	dc.l	$00000000,$00000000,$11111000,$00011000,$11111000,$00011000,$00011000,$00011000
; sprite #106
	dc.l	$00110110,$00110110,$11110110,$00000110,$11110110,$00110110,$00110110,$00110110
; sprite #107
	dc.l	$00110110,$00110110,$00110110,$00110110,$00110110,$00110110,$00110110,$00110110
; sprite #108
	dc.l	$00000000,$00000000,$11111110,$00000110,$11110110,$00110110,$00110110,$00110110
; sprite #109
	dc.l	$00110110,$00110110,$11110110,$00000110,$11111110,$00000000,$00000000,$00000000
; sprite #110
	dc.l	$00110110,$00110110,$00110110,$00110110,$11111110,$00000000,$00000000,$00000000
; sprite #111
	dc.l	$00011000,$00011000,$11111000,$00011000,$11111000,$00000000,$00000000,$00000000
; sprite #112
	dc.l	$00000000,$00000000,$00000000,$00000000,$11111000,$00011000,$00011000,$00011000
; sprite #113
	dc.l	$00011000,$00011000,$00011000,$00011000,$00011111,$00000000,$00000000,$00000000
; sprite #114
	dc.l	$00011000,$00011000,$00011000,$00011000,$11111111,$00000000,$00000000,$00000000
; sprite #115
	dc.l	$00000000,$00000000,$00000000,$00000000,$11111111,$00011000,$00011000,$00011000
; sprite #116
	dc.l	$00011000,$00011000,$00011000,$00011000,$00011111,$00011000,$00011000,$00011000
; sprite #117
	dc.l	$00000000,$00000000,$00000000,$00000000,$11111111,$00000000,$00000000,$00000000
; sprite #118
	dc.l	$00011000,$00011000,$00011000,$00011000,$11111111,$00011000,$00011000,$00011000
; sprite #119
	dc.l	$00011000,$00011000,$00011111,$00011000,$00011111,$00011000,$00011000,$00011000
; sprite #120
	dc.l	$00110110,$00110110,$00110110,$00110110,$00110111,$00110110,$00110110,$00110110
; sprite #121
	dc.l	$01101100,$01101100,$01101100,$01100000,$01111100,$00000000,$00000000,$00000000
; sprite #122
	dc.l	$00000000,$00000000,$01111111,$01100000,$01101111,$01101100,$01101100,$01101100
; sprite #123
	dc.l	$01101100,$01101100,$11101111,$00000000,$11111111,$00000000,$00000000,$00000000
; sprite #124
	dc.l	$00000000,$00000000,$11111110,$00000000,$11101110,$01101100,$01101100,$01101100
; sprite #125
	dc.l	$01101100,$01101100,$01101111,$01100000,$01101111,$01101100,$01101100,$01101100
; sprite #126
	dc.l	$00000000,$00000000,$11111111,$00000000,$11111111,$00000000,$00000000,$00000000
; sprite #127
	dc.l	$01101100,$01101100,$11101111,$00000000,$11101111,$01101100,$01101100,$01101100
; sprite #128
	dc.l	$00110000,$00110000,$11111110,$00000000,$11111111,$00000000,$00000000,$00000000
; sprite #129
	dc.l	$01101100,$01101100,$01101101,$01101100,$11111111,$00000000,$00000000,$00000000
; sprite #130
	dc.l	$00000000,$00000000,$11111110,$00000000,$11111111,$00110000,$00110000,$00110000
; sprite #131
	dc.l	$00000000,$00000000,$00000000,$00000000,$11111110,$01101100,$01101100,$01101100
; sprite #132
	dc.l	$01101100,$01101100,$01101100,$01101100,$01111110,$00000000,$00000000,$00000000
; sprite #133
	dc.l	$00110000,$00110000,$00111110,$00110000,$00111110,$00000000,$00000000,$00000000
; sprite #134
	dc.l	$00000000,$00000000,$00011111,$00011000,$00011111,$00011000,$00011000,$00011000
; sprite #135
	dc.l	$00000000,$00000000,$00000000,$00000000,$01111111,$01101100,$01101100,$01101100
; sprite #136
	dc.l	$01101100,$01101100,$01101101,$01101100,$11111111,$01101100,$01101100,$01101100
; sprite #137
	dc.l	$00110000,$00110000,$11111110,$00110000,$11111111,$00110000,$00110000,$00110000
; sprite #138
	dc.l	$00011000,$00011000,$00011000,$00011000,$11111000,$00000000,$00000000,$00000000
; sprite #139
	dc.l	$00000000,$00000000,$00000000,$00000000,$00011111,$00011000,$00011000,$00011000
; sprite #140
	dc.l	$11111111,$11111111,$11111111,$11111111,$11111111,$11111111,$11111111,$11111111
; sprite #141
	dc.l	$00000001,$00000001,$00000001,$00000001,$11111111,$11111111,$11111111,$11111111
; sprite #142
	dc.l	$11100000,$11100000,$11100000,$11100000,$11100000,$11100000,$11100000,$11100000
; sprite #143
	dc.l	$00011111,$00011111,$00011111,$00011111,$00011111,$00011111,$00011111,$00011111
; sprite #144
	dc.l	$11111111,$11111111,$11111111,$11111111,$00000000,$00000000,$00000000,$00000000
; sprite #145
	dc.l	$00000000,$00011000,$00110000,$01111110,$01111110,$00110000,$00011000,$00000000
; sprite #146
	dc.l	$00000000,$11111000,$00000100,$00100100,$01100100,$11111000,$01100000,$00100000
;mouse
	dc.l	$11111100,$13333100,$13311100,$13131000,$13113100,$11101310,$00000131,$00000011



sega_font_set2
;sp0
	dc.l	$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000,$00000000


; sprite #1
	dc.l	$22222222,$22222222,$22222222,$22222222,$22222222,$22222222,$22222222,$22222222
; sprite #2
	dc.l	$22112222,$21111222,$21111222,$22112222,$22112222,$22222222,$22112222,$22222222
; sprite #3
	dc.l	$21121122,$21121122,$21121122,$22222222,$22222222,$22222222,$22222222,$22222222
; sprite #4
	dc.l	$21121122,$21121122,$11111112,$21121122,$11111112,$21121122,$21121122,$22222222
; sprite #5
	dc.l	$22112222,$21111122,$11222222,$21111222,$22221122,$11111222,$22112222,$22222222
; sprite #6
	dc.l	$22222222,$11222112,$11221122,$22211222,$22112222,$21122112,$11222112,$22222222
; sprite #7
	dc.l	$22111222,$21121122,$22111222,$21112112,$11211122,$11221122,$21112112,$22222222
; sprite #8
	dc.l	$21122222,$21122222,$11222222,$22222222,$22222222,$22222222,$22222222,$22222222
; sprite #9
	dc.l	$22211222,$22112222,$21122222,$21122222,$21122222,$22112222,$22211222,$22222222
; sprite #12
	dc.l	$21122222,$22112222,$22211222,$22211222,$22211222,$22112222,$21122222,$22222222
; sprite #11
	dc.l	$22222222,$21122112,$22111122,$11111111,$22111122,$21122112,$22222222,$22222222
; sprite #12
	dc.l	$22222222,$22112222,$22112222,$11111122,$22112222,$22112222,$22222222,$22222222
; sprite #13
	dc.l	$22222222,$22222222,$22222222,$22222222,$22222222,$22112222,$22112222,$21122222
; sprite #14
	dc.l	$22222222,$22222222,$22222222,$11111122,$22222222,$22222222,$22222222,$22222222
; sprite #15
	dc.l	$22222222,$22222222,$22222222,$22222222,$22222222,$22112222,$22112222,$22222222
; sprite #16
	dc.l	$22222112,$22221122,$22211222,$22112222,$21122222,$11222222,$12222222,$22222222
; sprite #17
	dc.l	$21111122,$11222112,$11221112,$11211112,$11112112,$11122112,$21111122,$22222222
; sprite #18
	dc.l	$22112222,$21112222,$22112222,$22112222,$22112222,$22112222,$11111122,$22222222
; sprite #19
	dc.l	$21111222,$11221122,$22221122,$22111222,$21122222,$11221122,$11111122,$22222222
; sprite #22
	dc.l	$21111222,$11221122,$22221122,$22111222,$22221122,$11221122,$21111222,$22222222
; sprite #21
	dc.l	$22211122,$22111122,$21121122,$11221122,$11111112,$22221122,$22211112,$22222222
; sprite #22
	dc.l	$11111122,$11222222,$11111222,$22221122,$22221122,$11221122,$21111222,$22222222
; sprite #23
	dc.l	$22111222,$21122222,$11222222,$11111222,$11221122,$11221122,$21111222,$22222222
; sprite #24
	dc.l	$11111122,$11221122,$22221122,$22211222,$22112222,$22112222,$22112222,$22222222
; sprite #25
	dc.l	$21111222,$11221122,$11221122,$21111222,$11221122,$11221122,$21111222,$22222222
; sprite #26
	dc.l	$21111222,$11221122,$11221122,$21111122,$22221122,$22211222,$21112222,$22222222
; sprite #27
	dc.l	$22222222,$22112222,$22112222,$22222222,$22222222,$22112222,$22112222,$22222222
; sprite #28
	dc.l	$22222222,$22112222,$22112222,$22222222,$22112222,$22112222,$21122222,$22222222
; sprite #29
	dc.l	$22211222,$22112222,$21122222,$11222222,$21122222,$22112222,$22211222,$22222222
; sprite #32
	dc.l	$22222222,$22222222,$11111122,$22222222,$22222222,$11111122,$22222222,$22222222
; sprite #31
	dc.l	$21122222,$22112222,$22211222,$22221122,$22211222,$22112222,$21122222,$22222222
; sprite #32
	dc.l	$21111222,$11221122,$22221122,$22211222,$22112222,$22222222,$22112222,$22222222
; sprite #33
	dc.l	$21111122,$11222112,$11211112,$11211112,$11211112,$11222222,$21111222,$22222222
; sprite #34
	dc.l	$22112222,$21111222,$11221122,$11221122,$11111122,$11221122,$11221122,$22222222
; sprite #35
	dc.l	$11111122,$21122112,$21122112,$21111122,$21122112,$21122112,$11111122,$22222222
; sprite #36
	dc.l	$22111122,$21122112,$11222222,$11222222,$11222222,$21122112,$22111122,$22222222
; sprite #37
	dc.l	$11111222,$21121122,$21122112,$21122112,$21122112,$21121122,$11111222,$22222222
; sprite #38
	dc.l	$11111112,$21122212,$21121222,$21111222,$21121222,$21122212,$11111112,$22222222
; sprite #39
	dc.l	$11111112,$21122212,$21121222,$21111222,$21121222,$21122222,$11112222,$22222222
; sprite #42
	dc.l	$22111122,$21122112,$11222222,$11222222,$11221112,$21122112,$22111112,$22222222
; sprite #41
	dc.l	$11221122,$11221122,$11221122,$11111122,$11221122,$11221122,$11221122,$22222222
; sprite #42
	dc.l	$21111222,$22112222,$22112222,$22112222,$22112222,$22112222,$21111222,$22222222
; sprite #43
	dc.l	$22211112,$22221122,$22221122,$22221122,$11221122,$11221122,$21111222,$22222222
; sprite #44
	dc.l	$11122112,$21122112,$21121122,$21111222,$21121122,$21122112,$11122112,$22222222
; sprite #45
	dc.l	$11112222,$21122222,$21122222,$21122222,$21122212,$21122112,$11111112,$22222222
; sprite #46
	dc.l	$11222112,$11121112,$11111112,$11111112,$11212112,$11222112,$11222112,$22222222
; sprite #47
	dc.l	$11222112,$11122112,$11112112,$11211112,$11221112,$11222112,$11222112,$22222222
; sprite #48
	dc.l	$22111222,$21121122,$11222112,$11222112,$11222112,$21121122,$22111222,$22222222
; sprite #49
	dc.l	$11111122,$21122112,$21122112,$21111122,$21122222,$21122222,$11112222,$22222222
; sprite #52
	dc.l	$21111222,$11221122,$11221122,$11221122,$11211122,$21111222,$22211122,$22222222
; sprite #51
	dc.l	$11111122,$21122112,$21122112,$21111122,$21121122,$21122112,$11122112,$22222222
; sprite #52
	dc.l	$21111222,$11221122,$11122222,$21112222,$22211122,$11221122,$21111222,$22222222
; sprite #53
	dc.l	$11111122,$12112122,$22112222,$22112222,$22112222,$22112222,$21111222,$22222222
; sprite #54
	dc.l	$11221122,$11221122,$11221122,$11221122,$11221122,$11221122,$11111122,$22222222
; sprite #55
	dc.l	$11221122,$11221122,$11221122,$11221122,$11221122,$21111222,$22112222,$22222222
; sprite #56
	dc.l	$11222112,$11222112,$11222112,$11212112,$11111112,$11121112,$11222112,$22222222
; sprite #57
	dc.l	$11222112,$11222112,$21121122,$22111222,$22111222,$21121122,$11222112,$22222222
; sprite #58
	dc.l	$11221122,$11221122,$11221122,$21111222,$22112222,$22112222,$21111222,$22222222
; sprite #59
	dc.l	$11111112,$11222112,$12221122,$22211222,$22112212,$21122112,$11111112,$22222222
; sprite #62
	dc.l	$21111222,$21122222,$21122222,$21122222,$21122222,$21122222,$21111222,$22222222
; sprite #61
	dc.l	$11222222,$21122222,$22112222,$22211222,$22221122,$22222112,$22222212,$22222222
; sprite #62
	dc.l	$21111222,$22211222,$22211222,$22211222,$22211222,$22211222,$21111222,$22222222
; sprite #63
	dc.l	$22212222,$22111222,$21121122,$11222112,$22222222,$22222222,$22222222,$22222222
; sprite #64
	dc.l	$22222222,$22222222,$22222222,$22222222,$22222222,$22222222,$22222222,$11111111
; sprite #65
	dc.l	$22112222,$22112222,$22211222,$22222222,$22222222,$22222222,$22222222,$22222222
; sprite #66
	dc.l	$22222222,$22222222,$21111222,$22221122,$21111122,$11221122,$21112112,$22222222
; sprite #67
	dc.l	$11122222,$21122222,$21122222,$21111122,$21122112,$21122112,$11211122,$22222222
; sprite #68
	dc.l	$22222222,$22222222,$21111222,$11221122,$11222222,$11221122,$21111222,$22222222
; sprite #69
	dc.l	$22211122,$22221122,$22221122,$21111122,$11221122,$11221122,$21112112,$22222222
; sprite #72
	dc.l	$22222222,$22222222,$21111222,$11221122,$11111122,$11222222,$21111222,$22222222
; sprite #71
	dc.l	$22111222,$21121122,$21122222,$11112222,$21122222,$21122222,$11112222,$22222222
; sprite #72
	dc.l	$22222222,$22222222,$21112112,$11221122,$11221122,$21111122,$22221122,$11111222
; sprite #73
	dc.l	$11122222,$21122222,$21121122,$21112112,$21122112,$21122112,$11122112,$22222222
; sprite #74
	dc.l	$22112222,$22222222,$21112222,$22112222,$22112222,$22112222,$21111222,$22222222
; sprite #75
	dc.l	$22221122,$22222222,$22221122,$22221122,$22221122,$11221122,$11221122,$21111222
; sprite #76
	dc.l	$11122222,$21122222,$21122112,$21121122,$21111222,$21121122,$11122112,$22222222
; sprite #77
	dc.l	$21112222,$22112222,$22112222,$22112222,$22112222,$22112222,$21111222,$22222222
; sprite #78
	dc.l	$22222222,$22222222,$11221122,$11111112,$11111112,$11212112,$11222112,$22222222
; sprite #79
	dc.l	$22222222,$22222222,$11111222,$11221122,$11221122,$11221122,$11221122,$22222222
; sprite #82
	dc.l	$22222222,$22222222,$21111222,$11221122,$11221122,$11221122,$21111222,$22222222
; sprite #81
	dc.l	$22222222,$22222222,$11211122,$21122112,$21122112,$21111122,$21122222,$11112222
; sprite #82
	dc.l	$22222222,$22222222,$21112112,$11221122,$11221122,$21111122,$22221122,$22211112
; sprite #83
	dc.l	$22222222,$22222222,$11211122,$21112112,$21122112,$21122222,$11112222,$22222222
; sprite #84
	dc.l	$22222222,$22222222,$21111122,$11222222,$21111222,$22221122,$11111222,$22222222
; sprite #85
	dc.l	$22212222,$22112222,$21111122,$22112222,$22112222,$22112122,$22211222,$22222222
; sprite #86
	dc.l	$22222222,$22222222,$11221122,$11221122,$11221122,$11221122,$21112112,$22222222
; sprite #87
	dc.l	$22222222,$22222222,$11221122,$11221122,$11221122,$21111222,$22112222,$22222222
; sprite #88
	dc.l	$22222222,$22222222,$11222112,$11212112,$11111112,$11111112,$21121122,$22222222
; sprite #89
	dc.l	$22222222,$22222222,$11222112,$21121122,$22111222,$21121122,$11222112,$22222222
; sprite #92
	dc.l	$22222222,$22222222,$11221122,$11221122,$11221122,$21111122,$22221122,$11111222
; sprite #91
	dc.l	$22222222,$22222222,$11111122,$12211222,$22112222,$21122122,$11111122,$22222222
; sprite #92
	dc.l	$22211122,$22112222,$22112222,$11122222,$22112222,$22112222,$22211122,$22222222
; sprite #93
	dc.l	$22211222,$22211222,$22211222,$22222222,$22211222,$22211222,$22211222,$22222222
; sprite #94
	dc.l	$11122222,$22112222,$22112222,$22211122,$22112222,$22112222,$11122222,$22222222
; sprite #95
	dc.l	$21112112,$11211122,$22222222,$22222222,$22222222,$22222222,$22222222,$22222222
; sprite #96
	dc.l	$22222222,$22212222,$22111222,$21121122,$11222112,$11222112,$11111112,$22222222
; sprite #97
	dc.l	$22122212,$12221222,$22122212,$12221222,$22122212,$12221222,$22122212,$12221222
; sprite #98
	dc.l	$21212121,$12121212,$21212121,$12121212,$21212121,$12121212,$21212121,$12121212
; sprite #99
	dc.l	$11211211,$21112111,$11211211,$11121112,$11211211,$21112111,$11211211,$11121112
; sprite #122
	dc.l	$22211222,$22211222,$22211222,$22211222,$22211222,$22211222,$22211222,$22211222
; sprite #121
	dc.l	$22211222,$22211222,$22211222,$22211222,$11111222,$22211222,$22211222,$22211222
; sprite #122
	dc.l	$22211222,$22211222,$11111222,$22211222,$11111222,$22211222,$22211222,$22211222
; sprite #123
	dc.l	$22112112,$22112112,$22112112,$22112112,$11112112,$22112112,$22112112,$22112112
; sprite #124
	dc.l	$22222222,$22222222,$22222222,$22222222,$11111112,$22112112,$22112112,$22112112
; sprite #125
	dc.l	$22222222,$22222222,$11111222,$22211222,$11111222,$22211222,$22211222,$22211222
; sprite #126
	dc.l	$22112112,$22112112,$11112112,$22222112,$11112112,$22112112,$22112112,$22112112
; sprite #127
	dc.l	$22112112,$22112112,$22112112,$22112112,$22112112,$22112112,$22112112,$22112112
; sprite #128
	dc.l	$22222222,$22222222,$11111112,$22222112,$11112112,$22112112,$22112112,$22112112
; sprite #129
	dc.l	$22112112,$22112112,$11112112,$22222112,$11111112,$22222222,$22222222,$22222222
; sprite #112
	dc.l	$22112112,$22112112,$22112112,$22112112,$11111112,$22222222,$22222222,$22222222
; sprite #111
	dc.l	$22211222,$22211222,$11111222,$22211222,$11111222,$22222222,$22222222,$22222222
; sprite #112
	dc.l	$22222222,$22222222,$22222222,$22222222,$11111222,$22211222,$22211222,$22211222
; sprite #113
	dc.l	$22211222,$22211222,$22211222,$22211222,$22211111,$22222222,$22222222,$22222222
; sprite #114
	dc.l	$22211222,$22211222,$22211222,$22211222,$11111111,$22222222,$22222222,$22222222
; sprite #115
	dc.l	$22222222,$22222222,$22222222,$22222222,$11111111,$22211222,$22211222,$22211222
; sprite #116
	dc.l	$22211222,$22211222,$22211222,$22211222,$22211111,$22211222,$22211222,$22211222
; sprite #117
	dc.l	$22222222,$22222222,$22222222,$22222222,$11111111,$22222222,$22222222,$22222222
; sprite #118
	dc.l	$22211222,$22211222,$22211222,$22211222,$11111111,$22211222,$22211222,$22211222
; sprite #119
	dc.l	$22211222,$22211222,$22211111,$22211222,$22211111,$22211222,$22211222,$22211222
; sprite #122
	dc.l	$22112112,$22112112,$22112112,$22112112,$22112111,$22112112,$22112112,$22112112
; sprite #121
	dc.l	$21121122,$21121122,$21121122,$21122222,$21111122,$22222222,$22222222,$22222222
; sprite #122
	dc.l	$22222222,$22222222,$21111111,$21122222,$21121111,$21121122,$21121122,$21121122
; sprite #123
	dc.l	$21121122,$21121122,$11121111,$22222222,$11111111,$22222222,$22222222,$22222222
; sprite #124
	dc.l	$22222222,$22222222,$11111112,$22222222,$11121112,$21121122,$21121122,$21121122
; sprite #125
	dc.l	$21121122,$21121122,$21121111,$21122222,$21121111,$21121122,$21121122,$21121122
; sprite #126
	dc.l	$22222222,$22222222,$11111111,$22222222,$11111111,$22222222,$22222222,$22222222
; sprite #127
	dc.l	$21121122,$21121122,$11121111,$22222222,$11121111,$21121122,$21121122,$21121122
; sprite #128
	dc.l	$22112222,$22112222,$11111112,$22222222,$11111111,$22222222,$22222222,$22222222
; sprite #129
	dc.l	$21121122,$21121122,$21121121,$21121122,$11111111,$22222222,$22222222,$22222222
; sprite #132
	dc.l	$22222222,$22222222,$11111112,$22222222,$11111111,$22112222,$22112222,$22112222
; sprite #131
	dc.l	$22222222,$22222222,$22222222,$22222222,$11111112,$21121122,$21121122,$21121122
; sprite #132
	dc.l	$21121122,$21121122,$21121122,$21121122,$21111112,$22222222,$22222222,$22222222
; sprite #133
	dc.l	$22112222,$22112222,$22111112,$22112222,$22111112,$22222222,$22222222,$22222222
; sprite #134
	dc.l	$22222222,$22222222,$22211111,$22211222,$22211111,$22211222,$22211222,$22211222
; sprite #135
	dc.l	$22222222,$22222222,$22222222,$22222222,$21111111,$21121122,$21121122,$21121122
; sprite #136
	dc.l	$21121122,$21121122,$21121121,$21121122,$11111111,$21121122,$21121122,$21121122
; sprite #137
	dc.l	$22112222,$22112222,$11111112,$22112222,$11111111,$22112222,$22112222,$22112222
; sprite #138
	dc.l	$22211222,$22211222,$22211222,$22211222,$11111222,$22222222,$22222222,$22222222
; sprite #139
	dc.l	$22222222,$22222222,$22222222,$22222222,$22211111,$22211222,$22211222,$22211222
; sprite #142
	dc.l	$11111111,$11111111,$11111111,$11111111,$11111111,$11111111,$11111111,$11111111
; sprite #141
	dc.l	$22222221,$22222221,$22222221,$22222221,$11111111,$11111111,$11111111,$11111111
; sprite #142
	dc.l	$11122222,$11122222,$11122222,$11122222,$11122222,$11122222,$11122222,$11122222
; sprite #143
	dc.l	$22211111,$22211111,$22211111,$22211111,$22211111,$22211111,$22211111,$22211111
; sprite #144
	dc.l	$11111111,$11111111,$11111111,$11111111,$22222222,$22222222,$22222222,$22222222
; sprite #145
	dc.l	$22222222,$22211222,$22112222,$21111112,$21111112,$22112222,$22211222,$22222222
; sprite #146
	dc.l	$22222222,$11111222,$22222122,$22122122,$21122122,$11111222,$21122222,$22122222
;mouse
	dc.l	$11111100,$13333100,$13311100,$13131000,$13113100,$11101310,$00000131,$00000011


init_sega
	move	#$2700,sr	; disable interrupts
	move.b	$00A10001,d7	; Move Megadrive hardware version to d7
	andi.b	#$0F,d7	; The version is stored in last four bits,
	beq     init_sega_skip         ; If version is equal to 0,skip TMSS signature
	move.l	#'SEGA',$00A14000	; Move the string "SEGA" to $A14000
init_sega_skip
; Z80 grab it and hang it
	move.w	#$0100,$00A11100	; Request access to the Z80 bus
	move.w	#$0100,$00A11200	; Hold the Z80 in a reset state
init_sega_wait:
	btst	#$0,$00A11101	; Check if we have access to the Z80 bus yet
	bne	init_sega_wait	; If we don't yet have control,branch back up to Wait
	move.l	#$00A00000,a6	; Copy Z80 RAM address to a1
	move.l	#$00C30000,(a6)	; Copy data,and increment the source/dest addresses
;	move.w  #$0000,$00A11200	; Release reset state
;	move.w	#$0000,$00A11100	; Release control of bus
; do not release the state of z80.... music player uses 68k to process music but must have z80 locked up



; new lets clear all ram except last kb used for stack
	move.l	#$ff0000,a6
	move.l	#16128,d7
	move.l	#0,d6
init_sega_cr
	move.l	d6,(a6)+
	dbra	d7,init_sega_cr



	rts
endfunction







;********************************************************************************************************************************************************************init_segavdp()
function	init_segavdpw2
rem	init_segavdpw2()
rem	initializes the sega vdp with a 2 line window
rem	uses stack , d7
stack	a6/d6
; vdp register startup
init_segavdp_regsw2
aVDPReg0	dc.b	$04	; 0: H interrupt on, palettes on was 4
aVDPReg1	dc.b	$74	; 1: V interrupt on, display on, DMA on, Genesis mode on was 64
aVDPReg2	dc.b	$30	; 2: c000 Pattern table for Scroll Plane A at VRAM $C000 (bits 3-5 = bits 13-15) *$400 is vram addr
aVDPReg3	dc.b	$34	; 3:20= x8000Pattern table for Window Plane at VRAM (bits 1-5 = bits 11-15) *$400
aVDPReg4	dc.b	$07	; 4:e000 Pattern table for Scroll Plane B at VRAM $e000 (bits 0-2 = bits 11-15) *2000 is vram addr
aVDPReg5	dc.b	$7c	; 5: 7c xf800 new ,old b200 Sprite table at VRAM $b200 (bits 0-6 = bits 9-15) *200 is vram loc f800 try 78=f000
aVDPReg6	dc.b	$00	; 6: Unused
aVDPReg7	dc.b	$00	; 7: Background colour - bits 0-3 = colour, bits 4-5 = palette
aVDPReg8	dc.b	$00	; 8: Unused
aVDPReg9	dc.b	$00	; 9: Unused
aVDPRegA	dc.b	$ff	;10: Frequency of Horiz. interrupt in Rasters (number of lines travelled by the beam)
aVDPRegB	dc.b	$00	;11: External interrupts off, V scroll fullscreen, H scroll fullscreen
aVDPRegC	dc.b	$81	;12: Shadows and highlights off, interlace off, H40 mode (320 x 224 screen res)
aVDPRegD	dc.b	$3c	;13:2c b000 Horiz. scroll table at VRAM $b000 *400 28=a000 3c=f000
aVDPRegE	dc.b	$00	;14: Unused
aVDPRegF	dc.b	$02	;15: Autoincrement 2 bytes
aVDPReg10	dc.b	$01	;16: Vert. scroll 32, Horiz. scroll 64?
aVDPReg11	dc.b	$00	;17: Window Plane X pos 0 left (pos in bits 0-4, left/right in bit 7)
aVDPReg12	dc.b	$02	;18: Window Plane Y pos 0 up (pos in bits 0-4, up/down in bit 7) change to a $04 for 4 lines at top
aVDPReg13	dc.b	$00	;19: DMA length lo byte
aVDPReg14	dc.b	$00	;20: DMA length hi byte
aVDPReg15	dc.b	$00	;21: DMA source address lo byte
aVDPReg16	dc.b	$00	;22: DMA source address mid byte
aVDPReg17	dc.b	$80	;23: DMA source address hi byte,  memory-to-VRAM mode (bits 6-7)
init_segavdpw2

	move.l  #init_segavdp_regsw2,a6 ; Load address of register table into a6
	move.l  #$18,d6          ; 24 registers to write
	move.l  #$00008000,d7    ; 'Set register 0' command
init_segavdp_copyvdpw2
	move.b	(a6)+,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port
	add.w	#$0100,d7	; Increment register #
	dbra	d6,init_segavdp_copyvdpw2
	move	#$2700,sr	; enable interrupts
	move.w	#$2000,sr	; enable irq

	rts
endfunction




;********************************************************************

function	sega_displayon
rem	sega_displayon()
rem	
rem	turns the display on
rem	

sega_displayon
	move.l  #$00008000,d7    ; 'Set register 0' command
	move.b	#$4,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port

	move.l  #$00008100,d7    ; 'Set register 0' command
	move.b	#$74,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port

	rts

endfunction


;********************************************************************

function	sega_displayoff
rem	sega_displayoff()
rem	
rem	turns the display off
rem	

sega_displayoff
	move.l  #$00008000,d7    ; 'Set register 0' command
	move.b	#$5,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port

	move.l  #$00008100,d7    ; 'Set register 0' command
	move.b	#$34,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port


	rts

endfunction




;********************************************************************************************************************************************************************init_segavdp()
function	init_segavdpw4
rem	init_segavdpw4()
rem	initializes the sega vdp with a 4 line window
rem	uses stack , d7
stack	a6/d6
; vdp register startup
init_segavdp_regsw4
bVDPReg0	dc.b	$04	; 0: H interrupt on, palettes on
bVDPReg1	dc.b	$74	; 1: V interrupt on, display on, DMA on, Genesis mode on was 64
bVDPReg2	dc.b	$30	; 2: c000 Pattern table for Scroll Plane A at VRAM $C000 (bits 3-5 = bits 13-15) *$400 is vram addr
bVDPReg3	dc.b	$34	; 3:20= x8000Pattern table for Window Plane at VRAM (bits 1-5 = bits 11-15) *$400
bVDPReg4	dc.b	$07	; 4:e000 Pattern table for Scroll Plane B at VRAM $e000 (bits 0-2 = bits 11-15) *2000 is vram addr
bVDPReg5	dc.b	$7c	; 5: 7c xf800 new ,old b200 Sprite table at VRAM $b200 (bits 0-6 = bits 9-15) *200 is vram loc f800 try 78=f000
bVDPReg6	dc.b	$00	; 6: Unused
bVDPReg7	dc.b	$00	; 7: Background colour - bits 0-3 = colour, bits 4-5 = palette
bVDPReg8	dc.b	$00	; 8: Unused
bVDPReg9	dc.b	$00	; 9: Unused
bVDPRegA	dc.b	$ff	;10: Frequency of Horiz. interrupt in Rasters (number of lines travelled by the beam)
bVDPRegB	dc.b	$00	;11: External interrupts off, V scroll fullscreen, H scroll fullscreen
bVDPRegC	dc.b	$81	;12: Shadows and highlights off, interlace off, H40 mode (320 x 224 screen res)
bVDPRegD	dc.b	$3c	;13:2c b000 Horiz. scroll table at VRAM $b000 *400 28=a000 3c=f000
bVDPRegE	dc.b	$00	;14: Unused
bVDPRegF	dc.b	$02	;15: Autoincrement 2 bytes
bVDPReg10	dc.b	$01	;16: Vert. scroll 32, Horiz. scroll 64?
bVDPReg11	dc.b	$00	;17: Window Plane X pos 0 left (pos in bits 0-4, left/right in bit 7)
bVDPReg12	dc.b	$04	;18: Window Plane Y pos 0 up (pos in bits 0-4, up/down in bit 7) change to a $04 for 4 lines at top
bVDPReg13	dc.b	$00	;19: DMA length lo byte
bVDPReg14	dc.b	$00	;20: DMA length hi byte
bVDPReg15	dc.b	$00	;21: DMA source address lo byte
bVDPReg16	dc.b	$00	;22: DMA source address mid byte
bVDPReg17	dc.b	$80	;23: DMA source address hi byte,  memory-to-VRAM mode (bits 6-7)
init_segavdpw4


	move.l  #init_segavdp_regsw4,a6 ; Load address of register table into a6
	move.l  #$18,d6          ; 24 registers to write
	move.l  #$00008000,d7    ; 'Set register 0' command
init_segavdp_copyvdpw4
	move.b	(a6)+,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port
	add.w	#$0100,d7	; Increment register #
	dbra	d6,init_segavdp_copyvdpw4
	move	#$2700,sr	; enable interrupts
	move.w	#$2000,sr	; enable irq

	rts
endfunction



;********************************************************************************************************************************************************************init_segavdp()
function	init_segavdp
rem	init_segavdp()
rem	initializes the sega vdp with no window
rem	uses stack , d7
stack	a6/d6
; vdp register startup
init_segavdp_regs
cVDPReg0	dc.b	$04	; 0: H interrupt on, palettes on
cVDPReg1	dc.b	$74	; 1: V interrupt on, display on, DMA on, Genesis mode on was 64
cVDPReg2	dc.b	$30	; 2: c000 Pattern table for Scroll Plane A at VRAM $C000 (bits 3-5 = bits 13-15) *$400 is vram addr
cVDPReg3	dc.b	$34	; 3:20= x8000Pattern table for Window Plane at VRAM (bits 1-5 = bits 11-15) *$400
cVDPReg4	dc.b	$07	; 4:e000 Pattern table for Scroll Plane B at VRAM $e000 (bits 0-2 = bits 11-15) *2000 is vram addr
cVDPReg5	dc.b	$7c	; 5: 7c xf800 new ,old b200 Sprite table at VRAM $b200 (bits 0-6 = bits 9-15) *200 is vram loc f800 try 78=f000
cVDPReg6	dc.b	$00	; 6: Unused
cVDPReg7	dc.b	$00	; 7: Background colour - bits 0-3 = colour, bits 4-5 = palette
cVDPReg8	dc.b	$00	; 8: Unused
cVDPReg9	dc.b	$00	; 9: Unused
cVDPRegA	dc.b	$ff	;10: Frequency of Horiz. interrupt in Rasters (number of lines travelled by the beam)
cVDPRegB	dc.b	$00	;11: External interrupts off, V scroll fullscreen, H scroll fullscreen
cVDPRegC	dc.b	$81	;12: Shadows and highlights off, interlace off, H40 mode (320 x 224 screen res)
cVDPRegD	dc.b	$3c	;13:2c b000 Horiz. scroll table at VRAM $b000 *400 28=a000 3c=f000
cVDPRegE	dc.b	$00	;14: Unused
cVDPRegF	dc.b	$02	;15: Autoincrement 2 bytes
cVDPReg10	dc.b	$01	;16: Vert. scroll 32, Horiz. scroll 64?
cVDPReg11	dc.b	$00	;17: Window Plane X pos 0 left (pos in bits 0-4, left/right in bit 7)
cVDPReg12	dc.b	$00	;18: Window Plane Y pos 0 up (pos in bits 0-4, up/down in bit 7) change to a $04 for 4 lines at top
cVDPReg13	dc.b	$00	;19: DMA length lo byte
cVDPReg14	dc.b	$00	;20: DMA length hi byte
cVDPReg15	dc.b	$00	;21: DMA source address lo byte
cVDPReg16	dc.b	$00	;22: DMA source address mid byte
cVDPReg17	dc.b	$80	;23: DMA source address hi byte,  memory-to-VRAM mode (bits 6-7)
init_segavdp


	move.l  #init_segavdp_regs,a6 ; Load address of register table into a6
	move.l  #$18,d6          ; 24 registers to write
	move.l  #$00008000,d7    ; 'Set register 0' command
init_segavdp_copyvdp:
	move.b	(a6)+,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port
	add.w	#$0100,d7	; Increment register #
	dbra	d6,init_segavdp_copyvdp
	move	#$2700,sr	; enable interrupts
	move.w	#$2000,sr	; enable irq

	rts
endfunction



;********************************************************************************************************************************************************************init_segavdph()
function	init_segavdph
rem	init_segavdph()
rem	initializes the sega vdp with no window
rem	uses stack , d7
stack	a6/d6
; vdp register startup
init_segavdph_regs
cVDPReg0	dc.b	$14	; 0: H interrupt on, palettes on
cVDPReg1	dc.b	$74	; 1: V interrupt on, display on, DMA on, Genesis mode on was 64
cVDPReg2	dc.b	$30	; 2: c000 Pattern table for Scroll Plane A at VRAM $C000 (bits 3-5 = bits 13-15) *$400 is vram addr
cVDPReg3	dc.b	$34	; 3:20= x8000Pattern table for Window Plane at VRAM (bits 1-5 = bits 11-15) *$400
cVDPReg4	dc.b	$07	; 4:e000 Pattern table for Scroll Plane B at VRAM $e000 (bits 0-2 = bits 11-15) *2000 is vram addr
cVDPReg5	dc.b	$7c	; 5: 7c xf800 new ,old b200 Sprite table at VRAM $b200 (bits 0-6 = bits 9-15) *200 is vram loc f800 try 78=f000
cVDPReg6	dc.b	$00	; 6: Unused
cVDPReg7	dc.b	$00	; 7: Background colour - bits 0-3 = colour, bits 4-5 = palette
cVDPReg8	dc.b	$00	; 8: Unused
cVDPReg9	dc.b	$00	; 9: Unused
cVDPRegA	dc.b	$01	;10: Frequency of Horiz. interrupt in Rasters (number of lines travelled by the beam)
cVDPRegB	dc.b	$00	;11: External interrupts off, V scroll fullscreen, H scroll fullscreen
cVDPRegC	dc.b	$81	;12: Shadows and highlights off, interlace off, H40 mode (320 x 224 screen res)
cVDPRegD	dc.b	$3c	;13:2c b000 Horiz. scroll table at VRAM $b000 *400 28=a000 3c=f000
cVDPRegE	dc.b	$00	;14: Unused
cVDPRegF	dc.b	$02	;15: Autoincrement 2 bytes
cVDPReg10	dc.b	$01	;16: Vert. scroll 32, Horiz. scroll 64?
cVDPReg11	dc.b	$00	;17: Window Plane X pos 0 left (pos in bits 0-4, left/right in bit 7)
cVDPReg12	dc.b	$00	;18: Window Plane Y pos 0 up (pos in bits 0-4, up/down in bit 7) change to a $04 for 4 lines at top
cVDPReg13	dc.b	$00	;19: DMA length lo byte
cVDPReg14	dc.b	$00	;20: DMA length hi byte
cVDPReg15	dc.b	$00	;21: DMA source address lo byte
cVDPReg16	dc.b	$00	;22: DMA source address mid byte
cVDPReg17	dc.b	$80	;23: DMA source address hi byte,  memory-to-VRAM mode (bits 6-7)
init_segavdph


	move.l  #init_segavdph_regs,a6 ; Load address of register table into a6
	move.l  #$18,d6          ; 24 registers to write
	move.l  #$00008000,d7    ; 'Set register 0' command
init_segavdph_copyvdp:
	move.b	(a6)+,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port
	add.w	#$0100,d7	; Increment register #
	dbra	d6,init_segavdph_copyvdp
	move	#$2700,sr	; enable interrupts
	move.w	#$2000,sr	; enable irq

	rts
endfunction




;********************************************************************************************************************************************************************init_segavdp()
function	init_segavdp_ls
rem	init_segavdp_ls()
rem	initializes the sega vdp with no window and line scroll on plane b
rem	uses stack , d7
stack	a6/d6
; vdp register startup
init_segavdp_ls_regs
cVDPReg0	dc.b	$04	; 0: H interrupt on, palettes on
cVDPReg1	dc.b	$74	; 1: V interrupt on, display on, DMA on, Genesis mode on was 64
cVDPReg2	dc.b	$30	; 2: c000 Pattern table for Scroll Plane A at VRAM $C000 (bits 3-5 = bits 13-15) *$400 is vram addr
cVDPReg3	dc.b	$34	; 3:20= x8000Pattern table for Window Plane at VRAM (bits 1-5 = bits 11-15) *$400
cVDPReg4	dc.b	$07	; 4:e000 Pattern table for Scroll Plane B at VRAM $e000 (bits 0-2 = bits 11-15) *2000 is vram addr
cVDPReg5	dc.b	$7c	; 5: 7c xf800 new ,old b200 Sprite table at VRAM $b200 (bits 0-6 = bits 9-15) *200 is vram loc f800 try 78=f000
cVDPReg6	dc.b	$00	; 6: Unused
cVDPReg7	dc.b	$00	; 7: Background colour - bits 0-3 = colour, bits 4-5 = palette
cVDPReg8	dc.b	$00	; 8: Unused
cVDPReg9	dc.b	$00	; 9: Unused
cVDPRegA	dc.b	$ff	;10: Frequency of Horiz. interrupt in Rasters (number of lines travelled by the beam)
cVDPRegB	dc.b	$03	;11: External interrupts off, V scroll fullscreen, H scroll fullscreen
cVDPRegC	dc.b	$81	;12: Shadows and highlights off, interlace off, H40 mode (320 x 224 screen res)
cVDPRegD	dc.b	$3c	;13:2c b000 Horiz. scroll table at VRAM $b000 *400 28=a000 3c=f000
cVDPRegE	dc.b	$00	;14: Unused
cVDPRegF	dc.b	$02	;15: Autoincrement 2 bytes
cVDPReg10	dc.b	$01	;16: Vert. scroll 32, Horiz. scroll 64?
cVDPReg11	dc.b	$00	;17: Window Plane X pos 0 left (pos in bits 0-4, left/right in bit 7)
cVDPReg12	dc.b	$00	;18: Window Plane Y pos 0 up (pos in bits 0-4, up/down in bit 7) change to a $04 for 4 lines at top
cVDPReg13	dc.b	$00	;19: DMA length lo byte
cVDPReg14	dc.b	$00	;20: DMA length hi byte
cVDPReg15	dc.b	$00	;21: DMA source address lo byte
cVDPReg16	dc.b	$00	;22: DMA source address mid byte
cVDPReg17	dc.b	$80	;23: DMA source address hi byte,  memory-to-VRAM mode (bits 6-7)
init_segavdp_ls


	move.l  #init_segavdp_ls_regs,a6 ; Load address of register table into a6
	move.l  #$18,d6          ; 24 registers to write
	move.l  #$00008000,d7    ; 'Set register 0' command
init_segavdp_ls_copyvdp:
	move.b	(a6)+,d7	; Move register value to lower byte of d7
	move.w	d7,$C00004	; Write command and value to VDP control port
	add.w	#$0100,d7	; Increment register #
	dbra	d6,init_segavdp_ls_copyvdp
	move	#$2700,sr	; enable interrupts
	move.w	#$2000,sr	; enable irq

	rts
endfunction




; **************************************************************************************************************************sega_printb( xpos,ypos,text pointer,palette,vflip,hflip,priority )

function	sega_printb	sega_printb_xpos,sega_printb_ypos,sega_printb_text,sega_printb_vflip,sega_printb_hflip,sega_printb_pal,sega_printb_pr
def	sega_printb_xpos	byte
def	sega_printb_ypos	byte
def	sega_printb_text	long
def	sega_printb_pal	byte
def	sega_printb_vflip	byte
def	sega_printb_hflip	byte
def	sega_printb_pr	byte
rem	sega_printb( xpos.b , ypos.b , text pointer.l , vflip.b , hflip.b , palette.b , priority.b )
rem	prints text onto layer plane b
rem	uses stack , d7
stack	a6/d4-d6
sega_printb
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write
;	move.l	#$60000003,$c00004	;what register? plane b write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d6
	clr.w	d5
	move.b	sega_printb_ypos,d6
	move.b	sega_printb_xpos,d5
	clr.l	d4
	move.b	sega_printb_pr,d4
	lsl.b	#2,d4
	add.b	sega_printb_pal,d4
	lsl.b	#1,d4
	add.b	sega_printb_vflip,d4
	lsl.b	#1,d4
	add.b	sega_printb_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	mulu.w	#2,d5	;x2 for word
	add.l	d5,d6
	lsl.l	#8,d6
	lsl.l	#8,d6
	add.l	#$60000003,d6
	move.l	d6,$00c00004	;what register?
	move.l	sega_printb_text,a6
; lets create a loop print
sega_printb_lp
	clr.l	d7	;prep d7
	move.b	(a6)+,d6
	beq	sega_printb_break
	sub.b	#31,d6
	add.l	d6,d7
	add.l	d4,d7
	move.w	d7,$00c00000	;written
	bra	sega_printb_lp
sega_printb_break
	rts
endfunction



; ****************************************************************************************************************************sega_printa( xpos,ypos,text pointer,vflip,hflip,palette,priority )

function	sega_printa	sega_printa_xpos,sega_printa_ypos,sega_printa_text,sega_printa_vflip,sega_printa_hflip,sega_printa_pal,sega_printa_pr
def	sega_printa_xpos	byte
def	sega_printa_ypos	byte
def	sega_printa_text	long
def	sega_printa_pal	byte
def	sega_printa_vflip	byte
def	sega_printa_hflip	byte
def	sega_printa_pr	byte
rem	sega_printa(  xpos.b , ypos.b , text pointer.l , vflip.b , hflip.b , palette.b , priority.b )
rem	prints text onto plane a
rem	uses stack & d7
stack	a6/d4-d6
sega_printa
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write
;	move.l	#$40000003,$c00004	;what register? plane b write	
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d5
	clr.w	d6
	move.b	sega_printa_ypos,d6
	move.b	sega_printa_xpos,d5
	clr.l	d4
	move.b	sega_printa_pr,d4
	lsl.b	#2,d4
	add.b	sega_printa_pal,d4
	lsl.b	#1,d4
	add.b	sega_printa_vflip,d4
	lsl.b	#1,d4
	add.b	sega_printa_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	mulu.w	#2,d5	;x2 for word
	add.l	d5,d6
	lsl.l	#8,d6
	lsl.l	#8,d6
;	add.l	d4,d7
	add.l	#$40000003,d6
	move.l	d6,$00c00004	;what register?
	move.l	sega_printa_text,a6
; lets create a loop print
sega_printa_lp
	clr.l	d7	;prep d7
	move.b	(a6)+,d6
	beq	sega_printa_break
	sub.b	#31,d6
	add.l	d6,d7
	add.l	d4,d7
	move.w	d7,$00c00000	;written
	bra	sega_printa_lp
sega_printa_break
	rts
endfunction


;****************************************************************************************************************************************************sega_linksprite( sprite_a.b, sprite_b.b )

function	sega_linksprite	sega_linksprite_a,sega_linksprite_b
rem	sega_linksprite( sprite1.b , sprite2.b )
rem	close out the final sprite by linking it to #0
rem	
stack	d5-d6
def	sega_linksprite_a	byte
def	sega_linksprite_b	byte
sega_linksprite

	move.w	#$8F00,$C00004	; Set VDP autoincrement to 0 words/write
	clr.l	d7
	move.b	sega_linksprite_a,d7

	move.l	#8,d6	;8 entries per sprite
	mulu.w	d6,d7
	add.w	#2,d7
	swap	d7
;read first
	add.l	#$38000003,d7	;f800read
	move.l	d7,$c00004	; start of sprite table for read first

	move.w	$c00000,d6	;- - - - hhvv   - LLLLLLL

	and.w	#3840,d6
	add.b	sega_linksprite_b,d6
	and.w	#3967,d6	;new value to write
;change over to write

	add.l	#$40000000,d7	;f800
	move.l	d7,$c00004	; start of sprite table for write
	move.w	d6,$c00000
	rts
endfunction













;**********************************************************************sega_setsprite( number.w, tileindex.w , spritex.w, spritey.w, hflip.b , vflip.b, palette.b ,sizex.b , sizey.b , priority.b)

function	sega_setsprite	sega_setsprite_spr,sega_setsprite_tile,sega_setsprite_x,sega_setsprite_y,sega_setsprite_sx,sega_setsprite_sy,sega_setsprite_h,sega_setsprite_v,sega_setsprite_pal,sega_setsprite_pr
rem	sega_setsprite( sprite.b , tileindex.w , posx.w, posy.w, sizex.b, sizey.b , hflip.b , vflip.b, palette.b ,priority.b )
rem	sprite 0-79 , tile start , position x , position y , size of sprite x 0-3 , size of sprite y 0-3 , horizontal flip,
rem	vertical flip , palette 0-3 , priority 0-1
rem	| sega_setsprite_ysort.w string 160 bytes |
stack	d5-d6
def	sega_setsprite_spr	byte
def	sega_setsprite_even	byte
def	sega_setsprite_tile	word
def	sega_setsprite_x	word
def	sega_setsprite_y	word
def	sega_setsprite_sx	byte
def	sega_setsprite_sy	byte
def	sega_setsprite_h	byte
def	sega_setsprite_v	byte
def	sega_setsprite_pal	byte
def	sega_setsprite_pr	byte
def	sega_setsprite_link	byte
def	sega_setsprite_link2	byte


sega_setsprite

;read link table

;	move.l	#sega_setsprite_ysort,a6
;	move.l	#0,d7


	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write
	clr.l	d5
	move.b	sega_setsprite_spr,d5
;	move.b	d5,d7

; handle table ysort
;	mulu.w	#2,d7
;	lea	(a6,d7.l),a6

	move.l	#8,d6
	mulu.w	d6,d5
	swap	d5

	add.l	#$38000003,d5	;f800 read
	move.l	d5,$c00004	; start of sprite table
	move.w	($c00000),d5
	move.w	($c00000),d5	;- - - - hhvv - LLLLLLL
	and.w	#$7f,d5
	move.b	d5,sega_setsprite_link

;write
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write
	clr.l	d5
	move.b	sega_setsprite_spr,d5
	move.l	#8,d6
	mulu.w	d6,d5
	swap	d5
	add.l	#$78000003,d5	;f800
;	add.l	#$70000003,d5	;f000
	move.l	d5,$c00004	; start of sprite table

	move.w	sega_setsprite_y,d5
;	move.w	d5,(a6)	;save y

	and.w	#$3ff,d5	
	move.w	d5,$c00000

	clr.w	d5
	move.b	sega_setsprite_sx,d5
	lsl.b	#2,d5
	add.b	sega_setsprite_sy,d5
	and.w	#$f,d5
	lsl.w	#8,d5
	add.b	sega_setsprite_link,d5
	move.w	d5,$c00000	;link plus size??

	clr.w	d5
	move.b	sega_setsprite_h,d5
	ror.w	#1,d5
	add.b	sega_setsprite_v,d5
	ror.w	#1,d5
	add.b	sega_setsprite_pal,d5
	ror.w	#2,d5
	add.b	sega_setsprite_pr,d5
	ror.w	#1,d5
	and.w	#$f800,d5
	add.w	sega_setsprite_tile,d5
	move.w	d5,$c00000
	move.w	sega_setsprite_x,d5
	and.w	#$3ff,d5
	move.w	d5,$c00000
	rts
endfunction








;**********************************************************************sega_clearsprites( )

function	sega_clearsprites	
rem	sega_clearsprites()
rem	clears vdp sprites 0-79
rem	
rem	
stack	d4-d6

sega_clearsprites


;write
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write

	move.l	#0,d4	;sprite counter

sega_clearsprites_lp

	move.l	d4,d5
	mulu.w	#8,d5
	swap	d5
	add.l	#$78000003,d5	;f800
	move.l	d5,$c00004	; start of sprite table

	move.w	#0,d5


	and.w	#$3ff,d5	
	move.w	d5,$c00000

	clr.w	d5
	move.b	#0,d5
	lsl.b	#2,d5
	add.b	#0,d5
	and.w	#$f,d5
	lsl.w	#8,d5
	add.b	#0,d5
	move.w	d5,$c00000	;link plus size??

	clr.w	d5
;	move.b	#0,d5
;	ror.w	#1,d5
;	add.b	#0,d5
;	ror.w	#1,d5
;	add.b	#0,d5
;	ror.w	#2,d5
;	add.b	#0,d5
;	ror.w	#1,d5
;	and.w	#$f800,d5
;	add.w	#0,d5
	move.w	d5,$c00000
	move.w	#0,d5
;	and.w	#$3ff,d5
	move.w	d5,$c00000

	add.b	#1,d4
	if	b,d4<#80
	bra	sega_clearsprites_lp
	endif

	rts
endfunction


; ****************************************************************************************************************************************sega_lscrollplanea( avaluex.w , avaluey.w )
function	sega_lscrollplanea	sega_lscrollplanea_x,sega_lscrollplanea_y
def	sega_lscrollplanea_x	word
def	sega_lscrollplanea_y	word
rem	sega_lscrollplanea( scroll x.w , scroll y.w )
rem	
rem	
rem	
stack	d6
sega_lscrollplanea
	move.w	#$8f04,$c00004	; set vdp autoincrement to 2 words/write
	move.w	sega_lscrollplanea_y,d7	; copy y map position to d0 lower word
	move.l	#$40000010,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp 
	move.w	sega_lscrollplanea_x,d7	; copy y map position to d7 lower word
	move.l	#$70000003,$c00004 ; setup write to vsega_vdp

	move.l	#223,d6	;hits whole layer
sega_lscrollplanea_lp
	move.w	d7,$c00000 ; copy y position to vsega_vdp
	dbra	d6,sega_lscrollplanea_lp
	rts
endfunction


;*****************************************************************************************************************************************

function	sega_lscrollplaneb	sega_lscrollplaneb_x,sega_lscrollplaneb_y
def	sega_lscrollplaneb_x	word
def	sega_lscrollplaneb_y	word
def	sega_lscrollplaneb_tbl	string	448

rem	sega_lscrollplaneb( scroll x.w , scroll y.w )
rem	
rem	
rem	
stack	a6/d6

sega_lscrollplaneb
	move.w	#$8f04,$c00004	; set vdp autoincrement to 2 words/write

	move.w	sega_lscrollplaneb_y,d7	; copy y map position to d0 lower word
	move.l	#$40020010,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp 
;	move.w	sega_lscrollplaneb_x,d7	; copy y map position to d7 lower word
	move.l	#$70020003,$c00004 ; setup write to vsega_vdp


	lea	sega_lscrollplaneb_tbl,a6


	move.l	#223,d6	;hits whole layer

sega_lscrollplaneb_lp
	move.w	d6,d7
	mulu.w	#2,d7
	move.w	(a6,d7),d7

	add.w	sega_lscrollplaneb_x,d7
	move.w	d7,$c00000 ; copy y position to vsega_vdp
	dbra	d6,sega_lscrollplaneb_lp

	rts
endfunction

;******************************************************************************************************************************************

function	sega_setscroll_layerb	sega_setscroll_layerb_v1,sega_setscroll_layerb_v2
def	sega_setscroll_layerb_v1	word
def	sega_setscroll_layerb_v2	word

rem	sega_setscroll_layerb(line.w,scroll.w)
rem	
rem	
rem	
stack	a6/d6

sega_setscroll_layerb
	lea	sega_lscrollplaneb_tbl,a6

	move.w	sega_setscroll_layerb_v1,d7
	mulu.w	#2,d7
	lea	(a6,d7.w),a6
	move.w	sega_setscroll_layerb_v2,d7
	move.w	d7,(a6)

	rts
endfunction





; ****************************************************************************************************************************************sega_scrollplanea( avaluex.w , avaluey.w )
function	sega_scrollplanea	sega_scrollplanea_x,sega_scrollplanea_y
def	sega_scrollplanea_x	word
def	sega_scrollplanea_y	word
rem	sega_scrollplanea( scroll x.w , scroll y.w )
rem	
rem	
rem	
stack	d6
sega_scrollplanea
	move.w	#$8f00,$c00004	; set vdp autoincrement to 2 words/write
	move.w	sega_scrollplanea_y,d7	; copy y map position to d0 lower word
	move.l	#$40000010,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp 
	move.w	sega_scrollplanea_x,d7	; copy y map position to d7 lower word
	move.l	#$70000003,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp
	rts
endfunction

; ***************************************************************************************************************************************sega_scrollplaneb( avaluex.w , avaluey.w )

function	sega_scrollplaneb	sega_scrollplaneb_x,sega_scrollplaneb_y
def	sega_scrollplaneb_x	word
def	sega_scrollplaneb_y	word
rem	sega_scrollplaneb( scroll x.w , scroll y.w )
rem	
rem	
rem	

sega_scrollplaneb
	move.w	#$8f02,$c00004	; set vdp autoincrement to 2 words/write

	move.w	sega_scrollplaneb_y,d7	; copy y map position to d0 lower word
	move.l	#$40020010,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp 
	move.w	sega_scrollplaneb_x,d7	; copy y map position to d7 lower word
	move.l	#$70020003,$c00004 ; setup write to vsega_vdp
	move.w	d7,$c00000 ; copy y position to vsega_vdp
	rts
endfunction




; **************************************************************************************************************************************************sega_clearplanea( tilenumber )
function	sega_clearplanea	sega_clearplanea_tile
def	sega_clearplanea_tile	word
rem	sega_clearplanea( tilenumber.w )
rem	clears whole plane with said tile
rem	
stack	d6
sega_clearplanea
	move.w	#$8f02,$c00004	; set vdp autoincrement to 2 words/write
	move.l	#$40000003,$c00004	;what register? plane a
	move.w	#2047,d7	;counter
	move.w	sega_clearplanea_tile,d6
sega_clearplanea_lp
	move.w	d6,$00c00000	;written
	dbra	d7,sega_clearplanea_lp
	rts
endfunction

; **************************************************************************************************************************************************sega_clearplaneb( tilenumber )
function	sega_clearplaneb	sega_clearplaneb_tile
def	sega_clearplaneb_tile	word
rem	sega_clearplaneb( tilenumber.w )
rem	sets the whole layer with said tile
rem	
stack	d6
sega_clearplaneb
	move.w	#$8f02,$c00004	; set vdp autoincrement to 2 words/write
	move.l	#$60000003,$c00004	;what register? plane a
	move.w	#2047,d7	;counter
	move.w	sega_clearplaneb_tile,d6
sega_clearplaneb_lp
	move.w	d6,$00c00000	;written
	dbra	d7,sega_clearplaneb_lp
	rts
endfunction




















; **************************************************************************************************************************************************sega_clearwindow( tilenumber )
function	sega_clearwindow	sega_clearwindow_tile,sega_clearwindow_pal,sega_clearwindow_pri
def	sega_clearwindow_tile	word
def	sega_clearwindow_pri	byte
def	sega_clearwindow_pal	byte

rem	sega_clearwindow( tilenumber.w , palette.b , priority.b )
rem	sets the whole layer with said tile
rem	
stack	d6
sega_clearwindow
	move.w	#$8f02,$c00004	; set vdp autoincrement to 2 words/write
	move.l	#$50000003,$c00004	;what register? plane a

	move.w	sega_clearwindow_tile,d6
	add.w	#$8000,d6	;priority set

	clr.l	d7
	move.b	sega_clearwindow_pri,d7
	lsl.b	#2,d7
	add.b	sega_clearwindow_pal,d7
	lsl.b	#5,d7
	lsl.l	#8,d7
	add.w	d7,d6
	move.w	#255,d7	;counter

sega_clearwindow_lp
	move.w	d6,$00c00000	;written
	dbra	d7,sega_clearwindow_lp
	rts
endfunction








; ********************************************************************************************************************sega_setwindowtile( xpos,ypos,tilenumber,vflip,hflip,palette,priority )

function	sega_setwindowtile	sega_setwindowtile_xpos,sega_setwindowtile_ypos,sega_setwindowtile_tile,sega_setwindowtile_vflip,sega_setwindowtile_hflip,sega_setwindowtile_pal,sega_setwindowtile_pr
def	sega_setwindowtile_xpos	byte
def	sega_setwindowtile_ypos	byte
def	sega_setwindowtile_tile	word
def	sega_setwindowtile_pal	byte
def	sega_setwindowtile_vflip	byte
def	sega_setwindowtile_hflip	byte
def	sega_setwindowtile_pr	byte
rem	sega_setwindowtile(  xpos.b , ypos.b , tile.w , vflip.b , hflip.b , palette.b , priority.b )
rem	sets a single tile on the screen
rem	
stack	d4-d6
sega_setwindowtile
	move.w	#$8F00,$C00004	; Set VDP autoincrement to 0 words/write
	move.l	#$50000003,$c00004	;what register? plane a write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d6
	clr.w	d5
	move.b	sega_setwindowtile_ypos,d6
	move.b	sega_setwindowtile_xpos,d5
	move.w	sega_setwindowtile_tile,d7
	clr.l	d4
	move.b	sega_setwindowtile_pr,d4
	lsl.b	#2,d4
	add.b	sega_setwindowtile_pal,d4
	lsl.b	#1,d4
	add.b	sega_setwindowtile_vflip,d4
	lsl.b	#1,d4
	add.b	sega_setwindowtile_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	mulu.w	#2,d5	;x2 for word
	add.l	d5,d6
	lsl.l	#8,d6
	lsl.l	#8,d6
	add.l	d4,d7
	add.l	#$50000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	d7,$00c00000	;written
	rts
endfunction




; **************************************************************************************************************************sega_printw( xpos,ypos,text pointer,vflip,hflip,palette,priority )

function	sega_printw	sega_printw_xpos,sega_printw_ypos,sega_printw_text,sega_printw_vflip,sega_printw_hflip,sega_printw_pal,sega_printw_pr
def	sega_printw_xpos	byte
def	sega_printw_ypos	byte
def	sega_printw_text	long
def	sega_printw_pal	byte
def	sega_printw_vflip	byte
def	sega_printw_hflip	byte
def	sega_printw_pr	byte
rem	sega_printw( xpos.b , ypos.b , text pointer.l , vflip.b , hflip.b  , palette.b , priority.b )
rem	prints text onto layer plane b
rem	uses stack , d7
stack	a6/d4-d6
sega_printw
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 2 words/write
;	move.l	#$50000003,$c00004	;what register? plane b write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d6
	clr.w	d5
	move.b	sega_printw_ypos,d6
	move.b	sega_printw_xpos,d5
	clr.l	d4
	move.b	sega_printw_pr,d4
	lsl.b	#2,d4
	add.b	sega_printw_pal,d4
	lsl.b	#1,d4
	add.b	sega_printw_vflip,d4
	lsl.b	#1,d4
	add.b	sega_printw_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	mulu.w	#2,d5	;x2 for word
	add.l	d5,d6
	lsl.l	#8,d6
	lsl.l	#8,d6
	add.l	#$50000003,d6
	move.l	d6,$00c00004	;what register?
	move.l	sega_printw_text,a6
; lets create a loop print
sega_printw_lp
	clr.l	d7	;prep d7
	move.b	(a6)+,d6
	beq	sega_printw_break
	sub.b	#31,d6
	add.l	d6,d7
	add.l	d4,d7
	move.w	d7,$00c00000	;written
	bra	sega_printw_lp
sega_printw_break
	rts
endfunction







; ********************************************************************************************************************sega_setplanea( xpos,ypos,tilenumber,vflip,hflip,palette,priority )

function	sega_setplanea	sega_setplanea_xpos,sega_setplanea_ypos,sega_setplanea_tile,sega_setplanea_vflip,sega_setplanea_hflip,sega_setplanea_pal,sega_setplanea_pr
def	sega_setplanea_xpos	byte
def	sega_setplanea_ypos	byte
def	sega_setplanea_tile	word
def	sega_setplanea_pal	byte
def	sega_setplanea_vflip	byte
def	sega_setplanea_hflip	byte
def	sega_setplanea_pr	byte
rem	sega_setplanea(  xpos.b , ypos.b , tile.w  , vflip.b , hflip.b , palette.b, priority.b )
rem	sets a single tile on the screen
rem	
stack	d4-d6
sega_setplanea
	and.b	#63,sega_setplanea_xpos
	and.b	#31,sega_setplanea_ypos

	move.w	#$8F00,$C00004	; Set VDP autoincrement to 0 words/write
	move.l	#$40000003,$c00004	;what register? plane a write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	move.l	#0,d6
	move.l	#0,d5
	move.l	#0,d7
	move.l	#0,d4
	move.b	sega_setplanea_ypos,d6
	move.b	sega_setplanea_xpos,d5
	move.w	sega_setplanea_tile,d7

	move.b	sega_setplanea_pr,d4
	lsl.b	#2,d4
	add.b	sega_setplanea_pal,d4
	lsl.b	#1,d4
	add.b	sega_setplanea_vflip,d4
	lsl.b	#1,d4
	add.b	sega_setplanea_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	lsl.w	#1,d5	;x2 for word
	add.l	d5,d6
;	lsl.l	#8,d6
;	lsl.l	#8,d6
	swap	d6
	add.l	d4,d7
	add.l	#$40000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	d7,$00c00000	;written
	rts
endfunction




; ********************************************************************************************************************sega_setplanea( xpos,ypos)

function	sega_getplanea	sega_getplanea_xpos,sega_getplanea_ypos
def	sega_getplanea_xpos	byte
def	sega_getplanea_ypos	byte

rem	sega_getplanea(  xpos.b , ypos.b )
rem	gets a single tile on the screen and returns on d7.w
rem	

stack	d4-d6
sega_getplanea
	move.w	#$8F00,$C00004	; Set VDP autoincrement to 0 words/write
	move.l	#$00000003,$c00004	;what register? plane a write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	move.l	#0,d6
	move.l	#0,d5
	move.b	sega_getplanea_ypos,d6
	move.b	sega_getplanea_xpos,d5


	mulu.w	#128,d6	;64 x 2 each tile is word
;	mulu.w	#2,d5	;x2 for word
	lsl.w	#1,d5
	add.l	d5,d6
;	lsl.l	#8,d6
;	lsl.l	#8,d6
	swap	d6

	add.l	#$00000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	$c00000,d7	;read
	and.l	#4095,d7
	rts
endfunction



; ******************************************************************************************************************sega_setplaneb( xpos,ypos,tilenumber,vflip,hflip,palette,priority )

function	sega_setplaneb	sega_setplaneb_xpos,sega_setplaneb_ypos,sega_setplaneb_tile,sega_setplaneb_vflip,sega_setplaneb_hflip,sega_setplaneb_pal,sega_setplaneb_pr
def	sega_setplaneb_xpos	byte
def	sega_setplaneb_ypos	byte
def	sega_setplaneb_tile	word
def	sega_setplaneb_pal	byte
def	sega_setplaneb_vflip	byte
def	sega_setplaneb_hflip	byte
def	sega_setplaneb_pr	byte
rem	sega_setplaneb(  xpos.b , ypos.b , tile.w , vflip.b , hflip.b , palette.b , priority.b )
rem	sets a single tile on the screen
rem	
stack	d4-d6
sega_setplaneb

	and.b	#63,sega_setplaneb_xpos
	and.b	#31,sega_setplaneb_ypos

	move.w	#$8f00,$c00004	; set vdp autoincrement to 0 words/write
	move.l	#$60000003,$c00004	;what register? plane b write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	move.l	#0,d6
	move.l	#0,d5
	move.l	#0,d7
	move.b	sega_setplaneb_ypos,d6
	move.b	sega_setplaneb_xpos,d5
	move.w	sega_setplaneb_tile,d7
	move.l	#0,d4
	move.b	sega_setplaneb_pr,d4
	lsl.b	#2,d4
	add.b	sega_setplaneb_pal,d4
	lsl.b	#1,d4
	add.b	sega_setplaneb_vflip,d4
	lsl.b	#1,d4
	add.b	sega_setplaneb_hflip,d4
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	lsl.w	#1,d5	;x2 for word
	add.l	d5,d6
;	lsl.l	#8,d6
;	lsl.l	#8,d6
	swap d6
	add.l	d4,d7
	add.l	#$60000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	d7,$00c00000	;written
	rts
endfunction











; ********************************************************************************************************************sega_setplaneb( xpos,ypos)

function	sega_getplaneb	sega_getplaneb_xpos,sega_getplaneb_ypos
def	sega_getplaneb_xpos	byte
def	sega_getplaneb_ypos	byte

rem	sega_getplaneb(  xpos.b , ypos.b )
rem	gets a single tile on the screen and returns on d7.w
rem	

stack	d4-d6
sega_getplaneb
	move.w	#$8F00,$C00004	; Set VDP autoincrement to 0 words/write
	move.l	#$20000003,$c00004	;what register? plane b write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	move.l	#0,d6
	move.l	#0,d5
	move.b	sega_getplaneb_ypos,d6
	move.b	sega_getplaneb_xpos,d5


	mulu.w	#128,d6	;64 x 2 each tile is word
;	mulu.w	#2,d5	;x2 for word
	lsl.w	#1,d5	;new
	add.l	d5,d6
;	lsl.l	#8,d6
;	lsl.l	#8,d6
	swap	d6	;new
	add.l	#$20000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	$c00000,d7	;read
	and.l	#4095,d7
	rts
endfunction









; ************************************************************************************************************** sega_setplaneav( line#.b, tileset_pointer.l ,priority.b )

function	sega_setplaneav	sega_setplaneav_line,sega_setplaneav_pointer,sega_setplaneav_pr
rem	sega_setplaneav( line_number.b ,  tileset_pointer.l , priority.b ) 
rem	line number=0-63 and sets a vertical scroll line set of 32 tiles from pointer location
rem	
stack	a6/d6
def	sega_setplaneav_line	byte
def	sega_setplaneav_pr	byte
def	sega_setplaneav_pointer	long
sega_setplaneav
	move.w	#$8f80,$c00004	; set vdp autoincrement to 128 bytes/write
	clr.l	d7
	move.w	#2,d6
	move.b	sega_setplaneav_line,d7
	mulu.w	d6,d7
	swap	d7
	add.l	#$40000003,d7
	move.l	d7,$c00004	;what register? plane a
	move.w	#31,d7	;counter
	move.l	sega_setplaneav_pointer,a6
sega_setplaneav_lp
	move.w	(a6)+,d6
	add.b	sega_setplaneav_pr,d6
	move.w	d6,$00c00000	;written
	dbra	d7,sega_setplaneav_lp
	rts
endfunction

; *************************************************************************************************************************sega_setplaneah( line#.b, tileset_pointer.l )

function	sega_setplaneah	sega_setplaneah_line,sega_setplaneah_pointer,sega_setplaneah_pr
rem	sega_setplaneah( line_number.b , tileset_pointer.l  , priority.b )
rem	line number=0-31 and sets a horizontal scroll line set of 64 tiles from pointer location
rem	
stack	a6/d6
def	sega_setplaneah_line	byte
def	sega_setplaneah_pr	byte
def	sega_setplaneah_pointer	long
sega_setplaneah
	move.w	#$8f02,$c00004	; set vdp autoincrement to 128 bytes/write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d7
	move.b	sega_setplaneah_line,d7	
	mulu.w	#128,d7	;64 x 2 each tile is word
	swap	d7
	add.l	#$40000003,d7
	move.l	d7,$00c00004	;what register?
	move.w	#63,d7	;counter
	move.l	sega_setplaneah_pointer,a6
sega_setplaneah_lp
	move.w	(a6)+,d6
	add.b	sega_setplaneah_pr,d6
	move.w	d6,$c00000	;written
	dbra	d7,sega_setplaneah_lp
	rts
endfunction

; ****************************************************************************************************************************sega_setplanebv( line#.b, tileset_pointer.l )
function	sega_setplanebv	sega_setplanebv_line,sega_setplanebv_pointer
rem	sega_setplanebv( line_number.b , tileset_pointer.l )
rem	line number=0-63 and sets a vertical scroll line set of 32 tiles from pointer location
rem	
stack	a6/d6
def	sega_setplanebv_line	byte
def	sega_setplanebv_dummy	byte
def	sega_setplanebv_pointer	long
sega_setplanebv
	move.w	#$8f80,$c00004	; set vdp autoincrement to 128 bytes/write
	clr.l	d7
	move.w	#2,d6
	move.b	sega_setplanebv_line,d7
	and.b	#63,d7
	mulu.w	d6,d7
	swap	d7
	add.l	#$60000003,d7
	move.l	d7,$c00004	;what register? plane a
	move.w	#31,d7	;counter
	move.l	sega_setplanebv_pointer,a6
sega_setplanebv_lp
	move.w	(a6)+,$00c00000	;written
	dbra	d7,sega_setplanebv_lp
	rts
endfunction

; *****************************************************************************************************************************************sega_setplanebh( line#.b, tileset_pointer.l )
function	sega_setplanebh	sega_setplanebh_line,sega_setplanebh_pointer
rem	sega_setplanebh( line_number.b , tileset_pointer.l )
rem	line number=0-31 and sets a horizontal scroll line set of 64 tiles from pointer location
rem	
stack	a6
def	sega_setplanebh_line	byte
def	sega_setplanebh_dummy	byte
def	sega_setplanebh_pointer	long
sega_setplanebh
	move.w	#$8f02,$c00004	; set vdp autoincrement to 128 bytes/write
; d4 working
; d5 x axis
; d6 y axis
; d7 tile num
	clr.w	d7
	move.b	sega_setplanebh_line,d7
	and.b	#31,d7
	mulu.w	#128,d7	;64 x 2 each tile is word
;	lsl.l	#8,d7
;	lsl.l	#8,d7
	swap	d7
	add.l	#$60000003,d7
	move.l	d7,$00c00004	;what register?
	move.w	#63,d7	;counter
	move.l	sega_setplanebh_pointer,a6
sega_setplanebh_lp
	move.w	(a6)+,$00c00000	;written
	dbra	d7,sega_setplanebh_lp
	rts
endfunction

;******************************************************************************************************************************************************sega_loadtile( tilestart.w, tiles.w, pointer.l )
function	sega_loadtile	sega_loadtile_tile,sega_loadtile_tiles,sega_loadtile_pointer
rem	sega_loadtile( tilestart.w, tiles_to_load.w , tile_pointer.l )
rem	loads new tile info into starting vdp tile slot number
rem	
rem	
stack	a6/d6
def	sega_loadtile_tile	word
def	sega_loadtile_tiles	word
def	sega_loadtile_pointer	long
sega_loadtile
	move.w	#$8f02,$c00004
	move.l	#0,d7
	move.l	#0,d6
	move.w	sega_loadtile_tile,d7
	mulu.w	#32,d7
	move.w	d7,d6
	and.w	#$3fff,d6
	add.w	#$4000,d6	;d6 high bytes
	rol.w	#2,d7
	and.w	#3,d7	;low byte
	swap	d6
	add.w	d7,d6
	move.l	d6,$c00004	; set up vdp to write to vram address 0x0020 (leave first one blank 32bytes)
	move.l	sega_loadtile_pointer,a6
;	move.w	sega_loadtile_tiles,d6
	move.l	#8,d7
	mulu.w	sega_loadtile_tiles,d7
	sub.w	#1,d7
sega_loadtile_lp
	move.l	(a6)+,$c00000
	dbra	d7,sega_loadtile_lp
	rts
endfunction

;**********************************************************************************************************************************************sega_palette(number,red,green,blue)

function	sega_palette	sega_palette_paletten,sega_palette_paletter,sega_palette_paletteg,sega_palette_paletteb
rem	sega_palette( palette#.w , red.b , green.b , blue.b )
rem	RGB format!   palette number= 0-63   color range = 0-7
rem	
stack	d6
def	sega_palette_paletten	word
def	sega_palette_color	word
def	sega_palette_paletter	byte
def	sega_palette_paletteg	byte
def	sega_palette_paletteb	byte
def	sega_palette_palettes	byte
sega_palette
	move.w	#$8f00,$c00004	; set vdp autoincrement to 2 words/write
	move.w	sega_palette_paletten,d7
	move.l	#2,d6
	mulu.w	d6,d7
	move.w	d7,sega_palette_paletten	;corrected
	move.b	sega_palette_paletter,d7
	lsl.b	#1,d7
	move.b	d7,sega_palette_paletter	;corrected shift
	clr.w	d7
	move.b	sega_palette_paletteb,d7	;now we start
	lsl.w	#4,d7
	add.b	sega_palette_paletteg,d7
	lsl.w	#5,d7
	add.b	sega_palette_paletter,d7
	move.w	d7,sega_palette_color
	clr.l	d7
	move.w	sega_palette_paletten,d7
	swap	d7
	add.l	#$c0000003,d7
	move.l	d7,$c00004	; set up vdp to write to cram address $0000 plus pointer
	move.w	sega_palette_color,d7
	move.w	d7,$c00000
	rts
endfunction

; ***************************************************************************************************************************************sega_background( palette.b, color.b)

function	sega_background	sega_backgroundp,sega_backgroundc
def	sega_backgroundp	byte
def	sega_backgroundc	byte
rem	sega_background( palette.b , color.b )
rem	palette 0-3   color 0-15
rem	
sega_background
	move.l	#0,d7
	move.b	sega_backgroundp,d7
	lsl.b	#4,d7
	add.b	sega_backgroundc,d7
	add.l	#$00008700,d7	;background reg
	move.w	d7,$c00004
	rts
endfunction

;*******************************************************************************************************************************************************sega_texttotile( tilestart.w , pointer.l )
function	sega_texttotile	sega_texttotile_tile,sega_texttotile_pointer
rem	sega_texttotile( tilestart.w , tile_pointer.l )
rem	loads new tile info into vdp tile slot number. must call sega_font() first to create the font
rem	
stack	a5-a6/d6
def	sega_texttotile_tile	word
def	sega_texttotile_pointer	long
sega_texttotile
	move.w	#$8f02,$c00004
	move.l	#0,d7
	move.l	#0,d6
	move.w	sega_texttotile_tile,d7

	mulu.w	#32,d7
	move.w	d7,d6
	and.w	#$3fff,d6
	add.w	#$4000,d6	;d6 high bytes
	rol.w	#2,d7
	and.w	#3,d7	;low byte
	swap	d6
	add.w	d7,d6
	move.l	d6,$c00004	; set up vdp to write to vram address 0x0020 (leave first one blank 32bytes)
	move.l	sega_texttotile_pointer,a6
sega_texttotile_lp
	move.l	#sega_font_set,a5
	move.b	(a6)+,d7
	beq	sega_texttotile_break
	sub.b	#31,d7	;was 33
	and.l	#255,d7

	mulu.w	#32,d7
	lea	(a5,d7.l),a5
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	move.l	(a5)+,$c00000
	bra	sega_texttotile_lp
sega_texttotile_break
	rts
endfunction

;********************************************************************************************************************************************************************************sega_font()
function	sega_font
rem	sega_font()
rem	loads the first 96 tiles with alpha numerals
rem	
stack	a6/d6
sega_font
; lets clear to 71f
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 1 word/write
	move.l	#$40000000,$C00004	; Set up VDP to write to VRAM address 0x0020 (LEAVE FIRST ONE BLANK 32BYTES)
	lea	sega_font_set,a6	; Load address of Characters into a6
	move.l	#$1020,d7	;clear
	clr.l	d6
sega_font_loop1
	move.l  d6,$c00000	; Move data to VDP data port, and increment source address
	dbra	d7,sega_font_loop1
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 1 word/write
	move.l	#$40000000,$C00004	; Set up VDP to write to VRAM address 0x0020 (LEAVE FIRST ONE BLANK 32BYTES)
	lea	sega_font_set,a6	; Load address of Characters into a6
	move.l	#1183,d7	;#8x8  
sega_font_loop2
	move.l  (a6)+,$c00000	; Move data to VDP data port, and increment source address
	dbra	d7,sega_font_loop2
	rts
endfunction


;********************************************************************************************************************************************sega_displayimage(tilestart,pointer)
function	sega_displayimage	sega_displayimage_tile,sega_displayimage_pointer,sega_displayimage_pal
rem	sega_displayimage( tilestart.w, pointer.l , palette.b )
rem
rem	loads image into plane b
stack	a6/d4-d6
def	sega_displayimage_tile	word
def	sega_displayimage_tiles	word
def	sega_displayimage_pointer	long
def	sega_displayimage_posx	word
def	sega_displayimage_posy	word
def	sega_displayimage_pal	byte
def	sega_displayimage_pal2	byte
sega_displayimage
;scroll fix
;	move.w	#$8F00,$C00004	; Set VDP autoincrement to 2 words/write
;	move.w	#0,d7	; copy Y map position to d0 lower word
;	move.l	#$40020010,$c00004 ; setup write to vsega_vdp
;	move.w	d7,$c00000 ; copy y position to vsega_vdp 
;	move.w	#0,d7	; copy Y map position to d7 lower word
;	move.l	#$70020002,$c00004 ; setup write to vsega_vdp
;	move.w	d7,$c00000 ; copy y position to vsega_vdp 
;load tile code
	move.w	#$8F02,$C00004
	clr.l	d7
	clr.l	d6
	move.w	sega_displayimage_tile,d7
	move.w	#32,d6
	mulu.w	d6,d7
	move.w	d7,d6
	and.w	#$3fff,d6
	add.w	#$4000,d6	;d6 high bytes
	rol.w	#2,d7
	and.w	#3,d7	;low byte
	swap	d6
	add.w	d7,d6
	move.l	d6,$C00004	; Set up VDP to write to VRAM address 0x0020 (LEAVE FIRST ONE BLANK 32BYTES)
	move.l	sega_displayimage_pointer,a6
	move.w	#1120,d6
	move.w	#8,d7
	mulu.w	d6,d7
	sub.w	#1,d7
sega_displayimage_lp
	move.l	(a6)+,$c00000
	dbra	d7,sega_displayimage_lp
;set display
	move.w	#0,d5
	move.w	#0,d6
	move.w	sega_displayimage_tile,d7
sega_displayimage_setscreen1
	move.w	d5,sega_displayimage_posx
	move.w	d6,sega_displayimage_posy
	move.w	d7,sega_displayimage_tile
;	sega_setplanea(posx,posy,tile,#0,#0,#0,#0) 
;	move.w	sega_displayimage_posy,d6
;	move.w	sega_displayimage_posx,d5
;	move.w	sega_displayimage_tile,d7
	clr.l	d4
;	move.b	#0,d4	;priority
	lsl.b	#2,d4
	add.b	sega_displayimage_pal,d4
	lsl.b	#1,d4
	add.b	#0,d4	;vflip
	lsl.b	#1,d4
	add.b	#0,d4	;hflip
	lsl.b	#3,d4
	lsl.l	#8,d4
	mulu.w	#128,d6	;64 x 2 each tile is word
	mulu.w	#2,d5	;x2 for word
	add.l	d5,d6
	lsl.l	#8,d6
	lsl.l	#8,d6
	add.l	d4,d7
	add.l	#$60000003,d6
	move.l	d6,$00c00004	;what register?
	move.w	d7,$00c00000	;written
	move.w	sega_displayimage_posy,d6
	move.w	sega_displayimage_posx,d5
	move.w	sega_displayimage_tile,d7
	add.w	#1,d7	;tile
	add.w	#1,d5	;xpos
	cmp.w	#40,d5
	blo	sega_displayimage_setscreen1
	move.w	#0,d5
	add.w	#1,d6
	cmp.w	#28,d6
	blo	sega_displayimage_setscreen1
	rts
endfunction







;********************************************************************************************************************************************************************************sega_font2()
function	sega_font2
rem	sega_font2()
rem	loads the first 96 tiles with alpha numerals
rem	uses pal 1+2 colors
stack	a6/d6
sega_font2
; lets clear to 71f
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 1 word/write
	move.l	#$40000000,$C00004	; Set up VDP to write to VRAM address 0x0020 (LEAVE FIRST ONE BLANK 32BYTES) 40200000
	lea	sega_font_set2,a6	; Load address of Characters into a6
	move.l	#$1020,d7	;clear
	clr.l	d6
sega_font2_loop1
	move.l  d6,$c00000	; Move data to VDP data port, and increment source address
	dbra	d7,sega_font2_loop1
	move.w	#$8F02,$C00004	; Set VDP autoincrement to 1 word/write
	move.l	#$40000000,$C00004	; Set up VDP to write to VRAM address 0x0020 (LEAVE FIRST ONE BLANK 32BYTES) 40200000
	lea	sega_font_set2,a6	; Load address of Characters into a6
	move.l	#1183,d7	;#8x8  768
sega_font2_loop2
	move.l  (a6)+,$c00000	; Move data to VDP data port, and increment source address
	dbra	d7,sega_font2_loop2
	rts
endfunction















