#dontinclude

; sega math library
; may 25th 2023
; sheldon macdonald

; ****************************************************************************************************************************************************************************checkangle(wa.w)
function	checkangle	checkangle_v
rem	checkangle( byte angle.b)
rem	returns word value 0-359 from a byte angle to d7
rem	uses d7 for return
stack	a6/d6
def	checkangle_v	byte
def	checkangle_d	byte
checkangle
	move.l	#checkangle_data,a6
	move.w	#2,d6
	clr.w	d7
	move.b	checkangle_v,d7
	mulu.w	d6,d7
	lea	(a6,d7.w),a6
	clr.l	d7
	move.w	(a6),d7
	rts
checkangle_data
	dc.w	0,1,2,4,5,7,8,9,11,12,14,15,16,18,19,21,22,23,25,26,28,29,31,32,33,35,36,38,39,40,42,43
	dc.w	45,46,47,49,50,52,53,55,56,57,59,60,62,63,64,66,67,69,70,71,73,74,76,77,79,80,81,83,84,86,87,88
	dc.w	90,91,93,94,95,97,98,100,101,103,104,105,107,108,110,111,112,114,115,117,118,119,121,122,124,125,127,128,129,131,132,134
	dc.w	135,136,138,139,141,142,143,145,146,148,149,151,152,153,155,156,158,159,160,162,163,165,166,167,169,170,172,173,175,176,177,179
	dc.w	180,182,183,184,186,187,189,190,191,193,194,196,197,199,200,201,203,204,206,207,208,210,211,213,214,215,217,218,220,221,223,224
	dc.w	225,227,228,230,231,232,234,235,237,238,239,241,242,244,245,247,248,249,251,252,254,255,256,258,259,261,262,263,265,266,268,269
	dc.w	271,272,273,275,276,278,279,280,282,283,285,286,287,289,290,292,293,295,296,297,299,300,302,303,304,306,307,309,310,311,313,314
	dc.w	316,317,319,320,321,323,324,326,327,328,330,331,333,334,335,337,338,340,341,343,344,345,347,348,350,351,352,354,355,357,358,359
endfunction

; *****************************************************************************************************************************************************************************************pointangle(x1,y1,x2,y2)
function	pointangle	pointangle_xp1,pointangle_yp1,pointangle_xp2,pointangle_yp2
rem	pointangle( x1,w, y1.w, x2.w, y2.w )
rem	
rem	returns byte value on d7
stack	a6/d3-d6
def	pointangle_xp1	word
def	pointangle_yp1	word
def	pointangle_xp2	word
def	pointangle_yp2	word
def	pointangle_xd	word
def	pointangle_yd	word
def	pointangle_wn	word
def	pointangle_xc	word
def	pointangle_yc	word
pointangle
; d4 neg x
; d3 neg y
	clr.w	d4	;x
	clr.w	d3	;y
	move.w	pointangle_xp1,d7
	move.w	pointangle_xp2,d6
	cmp.w	d6,d7
	blo	pointangle_xreverse1
;sub d7-d6
	sub.w	d6,d7
	move.w	#1,d4
	bra	pointangle_ynext1
pointangle_xreverse1
;sub d6-d7
	sub.w	d7,d6
	move.w	d6,d7
pointangle_ynext1
	move.w	d7,pointangle_xd
;y
	move.w	pointangle_yp1,d7
	move.w	pointangle_yp2,d6
	cmp.w	d6,d7
	blo	pointangle_yreverse1
;sub d7-d6
	sub.w	d6,d7
	bra	pointangle_znext1
pointangle_yreverse1
;sub d6-d7
	sub.w	d7,d6
	move.w	#1,d3
	move.w	d6,d7
pointangle_znext1
	move.w	d7,pointangle_yd
; ok which is bigger?
	move.w	pointangle_xd,d6
	cmp.w	d6,d7
	bhs	pointangle_xisbigger1
; y is bigger
	move.w	d6,pointangle_wn
	bra	pointangle_lins6
pointangle_xisbigger1
;x is bigger
	move.w	d7,pointangle_wn
;setup
pointangle_lins6
;hiscale
	move.l	#pointangle_data2,a6
	lea	(1088,a6),a6
; 4 scale
;	move.l	#pointangle_data,a6
;	lea	(80,a6),a6
	move.w	#0,pointangle_xc	;x counter
	move.w	#0,pointangle_yc	;y counter
;d7 has wn
	move.w	pointangle_wn,d7	;d7
	move.w	d7,d6	;counter
; 4 scale
;	cmp.w	#4,d6
;	bls	pointangle_line222
;	move.w	#4,d6	;new counter needed
; hi scale
	cmp.w	#16,d6
	bls	pointangle_line222
	move.w	#16,d6	;new counter needed
; ok now the main loop
pointangle_line222
	cmp.w	#0,d6
	bne	pointangle_line22
	bra	pointangle_good
; main loop
pointangle_line22

	move.w	pointangle_xc,d5
	add.w	pointangle_xd,d5	;add distance to xc counter
	cmp.w	d5,d7	;has it gone over or same as our whole fraction?
	bhs	pointangle_adv2	;it has on x.... lets advance it
	move.w	d5,pointangle_xc	;nope keep counting 
	bra	pointangle_chk2	;lets check y now
pointangle_adv2
	sub.w	pointangle_wn,d5	;advance the x counter....subtract the whole fraction
	move.w	d5,pointangle_xc	;store remainder to play with next loop
	move.w	pointangle_xp1,d5
	cmp.w	pointangle_xp2,d5
	bhi	pointangle_advx2
;	inc	x1	;increase y plot or dec?
	lea	(2,a6),a6
; change to lea operation
	bra	pointangle_chk2
pointangle_advx2
;	dec	x1
	lea	(-2,a6),a6
; change lea operation
pointangle_chk2
	move.w	pointangle_yc,d5	;now the y axis.... loader up
	add.w	pointangle_yd,d5	;add its distance
	cmp.w	pointangle_wn,d5	;has it gone over or the same as our whole fraction
	bhs	pointangle_advy2	;it has on y.... lets advance it
	move.w	d5,pointangle_yc	;nope... keep counting
	bra	pointangle_chkx2	;done
;advance it
pointangle_advy2
	sub.w	pointangle_wn,d5	;subtract the whole number from y counter
	move.w	d5,pointangle_yc	;store the remainder for next loop
	move.w	pointangle_yp1,d5
	cmp.w	pointangle_yp2,d5
	bhi	pointangle_ady2
;	inc	y1	;increase y plot or dec?
; 4 scale
;	lea	(18,a6),a6
	lea	(66,a6),a6
; lea adjust
	bra	pointangle_chkx2
pointangle_ady2	
;	dec	y1
; 4 scale
;	lea	(-18,a6),a6
	lea	(-66,a6),a6
; lea adjust
;done?
pointangle_chkx2
	sub.w	#1,d6	;check the counter
	bne	pointangle_line22	;nope keep plotting the line
pointangle_good
	clr.l	d7
	move.w	(a6),d7
	rts	;we are done
;4 scale
pointangle_data
	dc.w	160,154,147,139,128,117,109,102,96	;0
	dc.w	166,160,152,141,128,115,104,96,90	;1
	dc.w	173,168,160,147,128,109,96,88,83	;2
	dc.w	182,179,173,160,128,96,83,77,74	;3
	dc.w	192,192,192,192,0,64,64,64,64	;4
	dc.w	202,205,211,224,255,32,45,51,54	;5
	dc.w	211,216,224,237,255,19,32,40,45	;6
	dc.w	218,224,232,243,255,13,24,32,38	;7
	dc.w	224,230,237,246,255,10,19,26,32	;8
pointangle_data2
	dc.w	160,159,158,156,154,153,151,149,147,145,143,141,139,136,134,131,128,125,122,120,117,115,113,111,109,107,105,103,102,100,98,97,96	;
	dc.w	161,160,159,157,156,154,152,150,149,146,144,141,139,136,134,131,128,125,122,119,117,115,112,110,107,106,104,102,100,99,97,96,95	;
	dc.w	163,161,160,158,157,156,153,151,149,147,145,142,139,137,134,132,128,124,122,119,117,114,111,109,107,105,102,100,99,98,96,95,93	;
	dc.w	164,163,162,160,158,157,155,153,151,149,146,144,141,137,134,132,128,124,122,119,115,112,110,107,105,103,101,99,98,96,94,93,92	;
	dc.w	166,165,163,162,160,158,156,154,152,150,147,144,141,139,135,132,128,124,121,117,115,112,109,106,104,102,100,98,96,94,93,91,90	;
	dc.w	168,166,165,163,162,160,158,156,154,151,149,146,142,139,136,132,128,124,120,117,114,110,107,105,102,100,98,96,94,93,91,90,88	;
	dc.w	169,168,167,166,164,162,160,158,156,153,150,147,144,140,136,132,128,124,119,116,112,109,106,103,100,98,96,94,92,90,89,88,87	;
	dc.w	171,170,169,168,166,164,163,160,158,155,152,149,145,141,137,133,128,123,119,115,111,107,104,101,98,96,93,92,90,88,87,85,85	;
	dc.w	173,172,171,170,168,166,165,163,160,158,154,151,147,143,139,134,128,122,117,113,109,105,102,98,96,93,91,90,88,86,85,84,83	;
	dc.w	175,174,173,172,170,169,168,166,163,160,157,153,149,145,139,134,128,122,117,111,107,102,99,96,93,90,88,87,85,84,83,82,81	;
	dc.w	178,177,175,175,173,172,170,168,166,163,160,156,152,147,141,135,128,121,115,109,104,100,96,93,90,88,85,84,83,81,81,79,78	;
	dc.w	180,179,178,177,176,175,173,171,169,167,164,160,156,150,144,136,128,119,112,106,100,96,92,89,87,85,83,81,80,79,78,77,76	;
	dc.w	182,182,181,180,179,178,177,175,173,171,168,165,160,154,147,139,128,117,109,102,96,91,88,85,83,81,79,78,77,76,75,74,74	;
	dc.w	185,184,183,183,182,181,180,179,178,175,173,170,166,160,154,136,128,113,103,96,90,85,83,81,78,77,76,75,74,73,73,72,71	;
	dc.w	187,187,186,186,185,185,184,183,182,181,179,177,173,166,160,143,128,117,96,90,83,79,77,75,74,73,72,71,71,70,70,69,69	;
	dc.w	190,190,189,189,189,188,188,187,187,186,185,184,182,178,171,160,128,96,85,76,74,72,71,70,69,68,68,68,67,67,67,66,66	;
	dc.w	192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,0,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64,64	;
	dc.w	195,195,195,195,195,196,196,197,197,198,199,200,202,204,211,224,255,32,56,54,54,56,57,58,59,59,60,60,61,61,61,61,61	;
	dc.w	197,197,198,198,199,200,200,201,202,203,205,207,211,218,224,233,255,23,32,38,45,49,51,53,54,55,56,56,57,58,58,59,59	;
	dc.w	200,200,201,201,202,203,204,205,207,209,211,214,218,224,228,239,255,15,26,32,38,42,45,47,49,51,52,53,54,55,55,56,56	;
	dc.w	202,202,203,204,205,206,207,209,211,213,216,219,224,230,237,246,255,10,19,26,32,37,40,43,45,47,49,50,51,51,53,54,54	;
	dc.w	204,205,206,207,208,209,211,213,215,217,220,224,229,234,241,248,255,8,15,22,27,32,36,39,41,43,45,47,48,49,50,51,51	;
	dc.w	207,207,209,209,211,212,214,216,218,221,224,228,232,237,243,249,255,7,13,19,24,28,32,35,38,40,42,44,45,47,47,49,49	;
	dc.w	209,210,211,212,214,215,217,219,221,224,227,231,235,239,245,250,255,6,11,17,21,25,29,32,34,37,39,41,42,44,45,46,47	;
	dc.w	211,212,213,214,216,218,219,221,224,226,230,233,237,241,246,251,255,5,10,15,19,23,26,30,32,34,37,38,40,42,43,44,45	;
	dc.w	213,214,215,217,218,220,221,224,226,229,232,235,239,243,247,251,255,5,9,13,17,21,24,27,30,32,34,36,38,39,41,42,43	;
	dc.w	215,216,217,219,220,222,224,226,229,231,234,237,241,244,248,252,255,4,8,12,15,19,22,25,27,30,32,34,36,37,39,40,41	;
	dc.w	217,218,219,221,222,224,226,228,230,233,236,238,242,245,248,252,255,4,8,11,14,17,20,23,26,28,30,32,34,35,37,38,39	;
	dc.w	218,219,221,222,224,226,228,230,232,234,237,240,243,246,249,253,255,3,7,10,13,16,19,22,24,26,28,30,32,34,35,37,38	;
	dc.w	220,221,222,224,226,227,229,231,234,236,238,241,243,247,250,253,255,3,6,9,13,15,17,20,22,25,27,29,30,32,34,35,36	;
	dc.w	221,223,224,226,227,229,231,233,235,237,239,242,245,247,250,253,255,3,6,9,11,14,17,19,21,23,25,27,29,30,32,33,34	;
	dc.w	223,224,225,227,229,230,232,234,236,238,241,243,246,248,251,253,255,3,5,8,10,13,15,18,20,22,24,26,27,29,31,32,33	;
	dc.w	224,225,226,228,230,231,233,235,237,239,241,243,246,248,251,253,255,3,5,8,10,13,15,17,19,21,23,25,26,28,30,31,32	;

endfunction


; ********************************************************************************************************************************************************************wordstring(word,return string address) 
function	wordstring	wordstring_num,wordstring_ret
rem	wordstring(word_value.w,write_string_address.l )
rem	word is a value or 0-65535 and needs a return address to populate string.
rem	6 BYTES REQUIRED
stack	a5-a6/d5-d6
def	wordstring_num	word
def	wordstring_ret	long
wordstring
	move.l	#wordstring_data,a6	;data
	move.l	wordstring_ret,a5	;where to write
	move.w	wordstring_num,d7	;word
	move.w	#15,d6	;counter for loop
;clear bits
	move.w	#0,(0,a5)
	move.l	#0,(2,a5)
wordstring_lp1
	btst	d6,d7
	beq	wordstring_lp2
	move.b	(5,a6),d5
	add.b	(4,a5),d5
	move.b	d5,(4,a5)
	cmp.b	#9,d5
	bls	wordstring_lp3
	sub.b	#10,d5
	move.b	d5,(4,a5)
	move.b	(3,a5),d5
	add.b	#1,d5
	move.b	d5,(3,a5)
wordstring_lp3
	move.b	(4,a6),d5
	add.b	(3,a5),d5
	move.b	d5,(3,a5)
	cmp.b	#9,d5
	bls	wordstring_lp4
	sub.b	#10,d5
	move.b	d5,(3,a5)
	move.b	(2,a5),d5
	add.b	#1,d5
	move.b	d5,(2,a5)
wordstring_lp4
	move.b	(3,a6),d5
	add.b	(2,a5),d5
	move.b	d5,(2,a5)
	cmp.b	#9,d5
	bls	wordstring_lp5
	sub.b	#10,d5
	move.b	d5,(2,a5)
	move.b	(1,a5),d5
	add.b	#1,d5
	move.b	d5,(1,a5)
wordstring_lp5
	move.b	(2,a6),d5
	add.b	(1,a5),d5
	move.b	d5,(1,a5)
	cmp.b	#9,d5
	bls	wordstring_lp6
	sub.b	#10,d5
	move.b	d5,(1,a5)
	move.b	(0,a5),d5
	add.b	#1,d5
	move.b	d5,(0,a5)
wordstring_lp6
	move.b	(1,a6),d5
	add.b	(0,a5),d5
	move.b	d5,(0,a5)
; cant add more to this one
wordstring_lp2
	lea	(6,a6),a6	;advance counter
	dbra	d6,wordstring_lp1
	move.b	(0,a5),d5
	add.b	#48,d5
	move.b	d5,(0,a5)
	move.b	(1,a5),d5
	add.b	#48,d5
	move.b	d5,(1,a5)
	move.b	(2,a5),d5
	add.b	#48,d5
	move.b	d5,(2,a5)
	move.b	(3,a5),d5
	add.b	#48,d5
	move.b	d5,(3,a5)
	move.b	(4,a5),d5
	add.b	#48,d5
	move.b	d5,(4,a5)
	move.b	#0,(5,a5)
	rts
wordstring_data
	dc.b	0,3,2,7,6,8
	dc.b	0,1,6,3,8,4
	dc.b	0,0,8,1,9,2
	dc.b	0,0,4,0,9,6
	dc.b	0,0,2,0,4,8
	dc.b	0,0,1,0,2,4
	dc.b	0,0,0,5,1,2
	dc.b	0,0,0,2,5,6
	dc.b	0,0,0,1,2,8
	dc.b	0,0,0,0,6,4
	dc.b	0,0,0,0,3,2
	dc.b	0,0,0,0,1,6
	dc.b	0,0,0,0,0,8
	dc.b	0,0,0,0,0,4
	dc.b	0,0,0,0,0,2
	dc.b	0,0,0,0,0,1
	dc.b	0,0,0,0,0,0
endfunction

; *********************************************************************************************************************************************************************************bytestring(byte ,return string address)
function	bytestring	bytestring_num,bytestring_ret
rem	bytestring(byte,write string address)
rem	byte is a value or 0-255 and needs a return address to populate string.
rem	4 BYTES REQUIRED
stack	a5-a6/d5-d6
def	bytestring_num	byte
def	bytestring_num2	byte
def	bytestring_ret	long
bytestring
	move.l	#bytestring_data,a6	;data
	move.l	bytestring_ret,a5	;where to write
	move.b	bytestring_num,d7	;byte
	move.w	#7,d6	;counter for loop
;clear bits
	move.l	#0,(0,a5)	;cleared 4 bytes
bytestring_lp1
	btst	d6,d7
	beq	bytestring_lp2
	move.b	(3,a6),d5	;add value
	add.b	(2,a5),d5	;to this
	move.b	d5,(2,a5)	;store
	cmp.b	#9,d5
	bls	bytestring_lp3
	sub.b	#10,d5
	move.b	d5,(2,a5)
	move.b	(1,a5),d5
	add.b	#1,d5
	move.b	d5,(1,a5)
bytestring_lp3
	move.b	(2,a6),d5
	add.b	(1,a5),d5
	move.b	d5,(1,a5)
	cmp.b	#9,d5
	bls	bytestring_lp4
	sub.b	#10,d5
	move.b	d5,(1,a5)
	move.b	(0,a5),d5
	add.b	#1,d5
	move.b	d5,(0,a5)
bytestring_lp4
	move.b	(1,a6),d5
	add.b	(0,a5),d5
	move.b	d5,(0,a5)





; cant add more to this one
bytestring_lp2
	lea	(4,a6),a6	;advance counter
	dbra	d6,bytestring_lp1
	move.b	(0,a5),d5
	add.b	#48,d5
	move.b	d5,(0,a5)
	move.b	(1,a5),d5
	add.b	#48,d5
	move.b	d5,(1,a5)
	move.b	(2,a5),d5
	add.b	#48,d5
	move.b	d5,(2,a5)
	move.b	#0,(3,a5)
	rts
bytestring_data
	dc.b	0,1,2,8
	dc.b	0,0,6,4
	dc.b	0,0,3,2
	dc.b	0,0,1,6
	dc.b	0,0,0,8
	dc.b	0,0,0,4
	dc.b	0,0,0,2
	dc.b	0,0,0,1
	dc.b	0,0,0,0
endfunction




; *********************************************************************************************************************************************************************************hexbytestring(hexbyte ,return string address)
function	hexbytestring	hexbytestring_num,hexbytestring_ret
rem	hexbytestring(hexbyte,write string address)
rem	hexbyte is a value or 0-255 and needs a return address to populate string.
rem	4 BYTES REQUIRED
stack	a5-a6
def	hexbytestring_num	byte
def	hexbytestring_num2	byte

def	hexbytestring_ret	long
hexbytestring
	move.l	#hexbytestring_data,a6	;data
	move.l	hexbytestring_ret,a5	;where to write
	move.b	hexbytestring_num,d7	;hexbyte
	move.w	#7,d6	;counter for loop
;clear bits
	move.b	#32,(2,a5)
	move.b	#0,(3,a5)
	move.b	#0,(4,a5)

	and.l	#255,d7
	mulu.w	#2,d7
	lea	(a6,d7.l),a6
	move.b	(0,a6),d7
	move.b	d7,(0,a5)
	move.b	(1,a6),d7
	move.b	d7,(1,a5)

	rts
hexbytestring_data
	dc.b	'00','01','02','03','04','05','06','07','08','09','0A','0B','0C','0D','0E','0F'
	dc.b	'10','11','12','13','14','15','16','17','18','19','1A','1B','1C','1D','1E','1F'
	dc.b	'20','21','22','23','24','25','26','27','28','29','2A','2B','2C','2D','2E','2F'
	dc.b	'30','31','32','33','34','35','36','37','38','39','3A','3B','3C','3D','3E','3F'
	dc.b	'40','41','42','43','44','45','46','47','48','49','4A','4B','4C','4D','4E','4F'
	dc.b	'50','51','52','53','54','55','56','57','58','59','5A','5B','5C','5D','5E','5F'
	dc.b	'60','61','62','63','64','65','66','67','68','69','6A','6B','6C','6D','6E','6F'
	dc.b	'70','71','72','73','74','75','76','77','78','79','7A','7B','7C','7D','7E','7F'
	dc.b	'80','81','82','83','84','85','86','87','88','89','8A','8B','8C','8D','8E','8F'
	dc.b	'90','91','92','93','94','95','96','97','98','99','9A','9B','9C','9D','9E','9F'
	dc.b	'A0','A1','A2','A3','A4','A5','A6','A7','A8','A9','AA','AB','AC','AD','AE','AF'
	dc.b	'B0','B1','B2','B3','B4','B5','B6','B7','B8','B9','BA','BB','BC','BD','BE','BF'
	dc.b	'C0','C1','C2','C3','C4','C5','C6','C7','C8','C9','CA','CB','CC','CD','CE','CF'
	dc.b	'D0','D1','D2','D3','D4','D5','D6','D7','D8','D9','DA','DB','DC','DD','DE','DF'
	dc.b	'E0','E1','E2','E3','E4','E5','E6','E7','E8','E9','EA','EB','EC','ED','EE','EF'
	dc.b	'F0','F1','F2','F3','F4','F5','F6','F7','F8','F9','FA','FB','FC','FD','FE','FF'


endfunction




; *********************************************************************************************************************************************************************************tonebytestring(hexbyte ,return string address)
function	tonebytestring	tonebytestring_num,tonebytestring_ret
rem	tonebytestring(hexbyte,write string address)
rem	hexbyte is a value or 0-255 and needs a return address to populate string.
rem	4 BYTES REQUIRED
stack	a5-a6
def	tonebytestring_num	byte
def	tonebytestring_num2	byte

def	tonebytestring_ret	long
tonebytestring
	move.l	#tonebytestring_data,a6	;data
	move.l	tonebytestring_ret,a5	;where to write
	move.b	tonebytestring_num,d7	;hexbyte
	move.w	#7,d6	;counter for loop
;clear bits
	move.b	#32,(2,a5)
	move.b	#0,(3,a5)
	move.b	#0,(4,a5)

	and.l	#255,d7
	mulu.w	#2,d7
	lea	(a6,d7.l),a6
	move.b	(0,a6),d7
	move.b	d7,(0,a5)
	move.b	(1,a6),d7
	move.b	d7,(1,a5)

	rts
tonebytestring_data
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','RP','DT','C1','C2'	;16
	dc.b	'C3','C4','C5','P1','P2','EN','--','--','--','--'	;10
	dc.b	'0D','0e','0E','0F','0g','0G','0a','0A','0b','0B','0C','1d'	;octave 0
	dc.b	'1D','1e','1E','1F','1g','1G','1a','1A','1b','1B','1C','2d'	;octave 1
	dc.b	'2D','2e','2E','2F','2g','2G','2a','2A','2b','2B','2C','3d'	;octave 2
	dc.b	'3D','3e','3E','3F','3g','3G','3a','3A','3b','3B','3C','4d'	;octave 3
	dc.b	'4D','4e','4E','4F','4g','4G','4a','4A','4b','4B','4C','5d'	;octave 4
	dc.b	'5D','5e','5E','5F','5g','5G','5a','5A','5b','5B','5C','6d'	;octave 5
	dc.b	'6D','6e','6E','6F','6g','6G','6a','6A','6b','6B','6C','7d'	;octave 6
	dc.b	'7D','7e','7E','7F','7g','7G','7a','7A','7b','7B','7C','8d'	;octave 7
	dc.b	'--','--','--','--','--','--'	;128 up can be cmds
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','--','--','--'
	dc.b	'--','--','--','--','--','--','--','--','--','--','--','--','--','RP','EN','KO'




endfunction










; *********************************************************************************************************************************************************************************balancebytestring(hexbyte ,return string address)
function	balancebytestring	balancebytestring_num,balancebytestring_ret
rem	balancebytestring(hexbyte,write string address)
rem	hexbyte is a value or 0-255 and needs a return address to populate string.
rem	4 BYTES REQUIRED
stack	a5-a6/d6
def	balancebytestring_num	byte
def	balancebytestring_num2	byte

def	balancebytestring_ret	long
balancebytestring
	move.l	#balancebytestring_data,a6	;data
	move.l	balancebytestring_ret,a5	;where to write
	move.b	balancebytestring_num,d7	;hexbyte
	move.b	d7,d6
	and.b	#3,d7

;clear bits
	move.b	#32,(2,a5)
	move.b	#0,(3,a5)
	move.b	#0,(4,a5)

	and.l	#255,d7
	mulu.w	#2,d7
	lea	(a6,d7.l),a6
	move.b	(0,a6),d7
;	move.b	d7,(0,a5)
	move.b	(1,a6),d7
	move.b	d7,(1,a5)

	lsr.b	#4,d6
	and.l	#15,d6
	move	d6,d7
	move.l	#balancebytestring_data2,a6	;data
	mulu.w	#2,d7
	lea	(a6,d7.l),a6
	move.b	(0,a6),d7
	move.b	d7,(0,a5)
	move.b	(1,a6),d7
;	move.b	d7,(1,a5)



	rts
balancebytestring_data
	dc.b	'--','RR','LL','SS'
balancebytestring_data2
	dc.b	'--','11','22','33','44','55','66','77','88','99','AA','BB','CC','DD','EE','FF'



endfunction




;*****************************************************************************************************************************************************************************************
function	random	random_lowv,random_highv
rem	random( lowrange.w , highrange.w )
rem	
rem	returns a random number based from system clock on d7.w
rem	
def	random_lowv	word
def	random_highv	word
stack	d6
random
	move.l	#0,d7
	move.l	#0,d6

; Assume A0 points to the system's clock location
; D0 will be used to store the random number

	move.w	systemclock_c,d7	; Move the system clock value into D0
; To generate a number within a specific range, for example, 1 to 100:
	move.w	random_highv,d6	; D1 contains the maximum value of the range minus 1
	sub.w	random_lowv,d6

	add.w	#1,d7         ; Increase randomness range from 0-99 to 1-100
	divu	d6,d7	; Divide D0 by D1, the remainder + 1 is the random number
	swap	d7	; The remainder of the division is now in the lower word of D0
	and.l	#$ffff,d7
	add.w	random_lowv,d7
	sub.w	#1,d7
	rts
endfunction






;***********************************************************************************************************************************************************************************************rnd(x,y)

function	rnd	rnd_lowv,rnd_highv
rem	rnd( low_range.b, high_range.b)
rem	value is from range 0-254 and low cannot be higher then high range
rem	returns byte result to d7.l and d6.l register (requires systemclock)

def	rnd_rndr	byte
def	rnd_lowv	byte
def	rnd_highv	byte
def	rnd_stepr	byte
def	rnd_res	byte
def	rnd_subt	byte
def	systemclock_cr	word


rnd
	clr.l	d7
	clr.l	d6
	add.w	systemclock_c,d7
	add.w	systemclock_cr,d7
	move.w	d7,systemclock_cr
	move.b	rnd_highv,d6
	add.b	#1,d6
	move.b	d6,rnd_highv
	sub.b	rnd_lowv,d6
	move.b	d6,rnd_rndr
	sub.b	#1,rnd_highv

	move.w	systemclock_cr,d6	;referenced from systemclock
	add.b	rnd_stepr,d6
	move.b	d6,rnd_res


;now i should have 0-15 in the bit bucket
;wrap it
;	LSLB
	move.b	d6,rnd_stepr

rndl15

	cmp.b	rnd_rndr,d6
	bls	rndr15
	sub.b	rnd_rndr,d6


	bra	rndl15

rndr15

	add.b	rnd_lowv,d6

rnx15

	cmp.b	rnd_highv,d6
	bls	rny15
	add.b	#1,rnd_stepr
	move.b	rnd_lowv,d6

rny15

	and.l	#255,d6
	move.b	d6,rnd_res
	move.l	d6,d7

	rts

endfunction







;****************************************************************************************************************************************************************************************resetscore( string pointer.l )
function	resetscore	resetscore_pointer
rem	resetscore( pointer.l )
rem	clears the ascii score 10 bytes required
rem	
stack	a6/d7
def	resetscore_pointer	long
resetscore
	move.l	resetscore_pointer,a6
	move.b	#$30,d7
	move.b	d7,(0,a6)
	move.b	d7,(1,a6)
	move.b	d7,(2,a6)
	move.b	d7,(3,a6)
	move.b	d7,(4,a6)
	move.b	d7,(5,a6)
	move.b	d7,(6,a6)
	move.b	d7,(7,a6)
	clr.b	(8,a6)
	clr.b	(9,a6)
	rts
endfunction

;***********************************************************************************************************************************************************************addscore( target pointer.l pointer.l)
function	addscore	addscore_p1,addscore_p2
rem	addscore( pointer.l , pointer2)
rem	adds the ascii score 10 bytes required
rem	
stack	a6/d5-d6
def	addscore_p1	long
def	addscore_p2	long
addscore
	clr.l	d5
	clr.l	d6
	clr.l	d7
	move.l	addscore_p1,a6
	move.l	addscore_p2,a5
	move.b	#7,d7
	move.b	#0,d6
addscore_lp1
	move.b	(a6,d7),d5
	add.b	(a5,d7),d5
	add.b	d6,d5	;add carry if any
	clr.b	d6	;mt carry
	cmp.b	#57,d5
	bls	addscore_lpp
	sub.b	#10,d5
	move.b	#1,d6
addscore_lpp
	move.b	d5,(a6,d7)
	dbra	d7,addscore_lp1
addscore_lp2
	clr.b	(8,a6)
	clr.b	(9,a6)
	rts
endfunction






; ************************************************************************************************************************************************************************** binstring(byte address,retstring adr)
function	binstring	binstring_numsta,binstring_x
rem	binstring(byte.b , return_string.l )
rem	byte is a value of 0-255 and needs a return address to populate string.
rem	10 BYTES REQUIRED
stack	a6
def	binstring_x	long	;populate x register with string at x
def	binstring_numsta	byte	;save 
def	binstring_dummy	byte
binstring
	move.b	binstring_numsta,d7
	move.l	binstring_x,a6
	move.b	#$30,(0,a6)
	btst	#7,d7
	beq	binstring_test7
	move.b	#$31,(0,a6)
binstring_test7
	move.b	#$30,(1,a6)
	btst	#6,d7
	beq	binstring_test6
	move.b	#$31,(1,a6)
binstring_test6
	move.b	#$30,(2,a6)
	btst	#5,d7
	beq	binstring_test5
	move.b	#$31,(2,a6)
binstring_test5
	move.b	#$30,(3,a6)
	btst	#4,d7
	beq	binstring_test4
	move.b	#$31,(3,a6)
binstring_test4
	move.b	#$30,(4,a6)
	btst	#3,d7
	beq	binstring_test3
	move.b	#$31,(4,a6)
binstring_test3
	move.b	#$30,(5,a6)
	btst	#2,d7
	beq	binstring_test2
	move.b	#$31,(5,a6)
binstring_test2
	move.b	#$30,(6,a6)
	btst	#1,d7
	beq	binstring_test1
	move.b	#$31,(6,a6)
binstring_test1
	move.b	#$30,(7,a6)
	btst	#0,d7
	beq	binstring_test0
	move.b	#$31,(7,a6)
binstring_test0
	move.b	#0,(8,a6)
	move.b	#0,(9,a6)
	rts
endfunction

; ***************************************************************************************************************************************************************************createsinetable( pointer.l)

function	createsinetable	createsinetable_pointer
rem	createsinetable( return pointer.l )
rem	this table is needed for rotational graphics such as circle
rem	
stack	a6
def	createsinetable_pointer	long
createsinetable_table
; word values
	dc.w	$80,$83,$86,$89,$8C,$90,$93,$96,$99,$9C,$9F,$A2,$A5,$A8,$AB,$AE
	dc.w	$B1,$B3,$B6,$B9,$BC,$BF,$C1,$C4,$C7,$C9,$CC,$CE,$D1,$D3,$D5,$D8
	dc.w	$DA,$DC,$DE,$E0,$E2,$E4,$E6,$E8,$EA, $EB, $ED, $EF, $F0, $F1, $F3, $F4
	dc.w	$F5, $F6, $F8, $F9, $FA, $FA, $FB, $FC,$FD, $FD, $FE, $FE, $FE, $FE, $FE, $FE
	dc.w	$FE, $FE, $FE, $FE, $FE, $FE, $FE, $FD,$FD, $FC, $FB, $FA, $FA, $F9, $F8, $F6
	dc.w	$F5, $F4, $F3, $F1, $F0, $EF, $ED, $EB,$EA, $E8, $E6, $E4, $E2, $E0, $DE, $DC
	dc.w	$DA, $D8, $D5, $D3, $D1, $CE, $CC, $C9,$C7, $C4, $C1, $BF, $BC, $B9, $B6, $B3
	dc.w	$B1, $AE, $AB, $A8, $A5, $A2, $9F, $9C,$99, $96, $93, $90, $8C, $89, $86, $83
	dc.w	$80, $7D, $7A, $77, $74, $70, $6D, $6A,$67, $64, $61, $5E, $5B, $58, $55, $52
	dc.w	$4F, $4D, $4A, $47, $44, $41, $3F, $3C,$39, $37, $34, $32, $2F, $2D, $2B, $28
	dc.w	$26, $24, $22, $20, $1E, $1C, $1A, $18,$16, $15, $13, $11, $10, $0F, $0D, $0C
	dc.w	$0B, $0A, $08, $07, $06, $06, $05, $04,$03, $03, $02, $02, $02, $01, $01, $01
	dc.w	$01, $01, $01, $01, $02, $02, $02, $03,$03, $04, $05, $06, $06, $07, $08, $0A
	dc.w	$0B, $0C, $0D, $0F, $10, $11, $13, $15,$16, $18, $1A, $1C, $1E, $20, $22, $24
	dc.w	$26, $28, $2B, $2D, $2F, $32, $34, $37,$39, $3C, $3F, $41, $44, $47, $4A, $4D
	dc.w	$4F, $52, $55, $58, $5B, $5E, $61, $64,$67, $6A, $6D, $70, $74, $77, $7A, $7D
createsinetable
	move.l	createsinetable_pointer,a6
	move.l	#createsinetable_table,(a6)
	rts
endfunction



; *****************************************************************************************************************************************************************plotangle(sin_costable,x1,y1,dx,dy,angle)
function	plotangle	plotangle_sine,plotangle_x,plotangle_y,plotangle_radx,plotangle_rady,plotangle_angle
rem	plotangle( sine_table_pointer.l , pos_x1.w , pos_y1.w ,diamx.w , diamy.w , angle.b)
rem	
rem	results returned at x=d6.w, y=d7.w
stack	a5-a6/d5
def	plotangle_sine	long
def	plotangle_angle	byte
def	plotangle_ad	byte
def	plotangle_x	word
def	plotangle_y	word
def	plotangle_radx	word
def	plotangle_rady	word
plotangle


	clr.w	d7
	clr.w	d6
	move.l	plotangle_sine,a6	;sinetable
	move.b	plotangle_angle,d7
	and.w	#$ff,d7
	mulu.w	#2,d7
	lea	(a6,d7.w),a6
	move.l	plotangle_sine,a5	;cosinetable
	clr.w	d7
	move.b	plotangle_angle,d7
	add.b	#64,d7
	mulu.w	#2,d7
	lea	(a5,d7.w),a5
; both tables should be good
	move.w	(a6),d7
	move.w	plotangle_radx,d6
	mulu.w	d6,d7
	move.b	d7,d6	;b on d6
	lsr.w	#8,d7	;a on d7
	and.w	#255,d7
	asl.b	#1,d6
	roxl.b	#1,d7
	add.w	plotangle_x,d7

	sub.w	plotangle_radx,d7

	move.w	d7,d5	;x temp
	if	w,d5<plotangle_x
	add.w	#1,d5
	endif
	move.w	d5,plotangle_x	;new

	move.w	(a5),d7
	move.w	plotangle_rady,d6
	add.w	#1,d7
	mulu.w	d6,d7
	move.b	d7,d6	;b on d6
	lsr.w	#8,d7	;a on d7
	and.w	#255,d7
	asl.b	#1,d6
	roxl.b	#1,d7
	add.w	plotangle_y,d7
	sub.w	plotangle_rady,d7
	move.w	d7,d6
	if	w,d6<plotangle_y
	add.w	#1,d6
	endif
	move.w	d6,plotangle_y

	move.w	plotangle_x,d6
	move.w	plotangle_y,d7



	rts


endfunction





; *****************************************************************************************************************************************************************plotangled(sin_costable,x1,y1,dx,dy,angle)
function	plotangled	plotangled_sine,plotangled_x,plotangled_y,plotangled_radx,plotangled_rady,plotangled_angle
rem	plotangled( sine_table_pointer.l , pos_x1.w , pos_y1.w ,diamx.w , diamy.w , angle.b)
rem	
rem	results returned at x=d6.w, y=d7.w
stack	a5-a6/d5
def	plotangled_sine	long
def	plotangled_angle	byte
def	plotangled_ad	byte
def	plotangled_x	word
def	plotangled_y	word
def	plotangled_radx	word
def	plotangled_rady	word
def	plotangled_plusx	word
def	plotangled_plusy	word
plotangled


	clr.w	d7
	clr.w	d6
	move.l	plotangled_sine,a6	;sinetable
	move.b	plotangled_angle,d7
	and.w	#$ff,d7
	mulu.w	#2,d7
	lea	(a6,d7.w),a6
	move.l	plotangled_sine,a5	;cosinetable
	clr.w	d7
	move.b	plotangled_angle,d7
	add.b	#64,d7
	mulu.w	#2,d7
	lea	(a5,d7.w),a5
; both tables should be good
	move.w	(a6),d7
	move.w	plotangled_radx,d6
	mulu.w	d6,d7
	move.b	d7,d6	;b on d6
	lsr.w	#8,d7	;a on d7
	and.w	#255,d7
	asl.b	#1,d6
	roxl.b	#1,d7
;	add.w	plotangled_x,d7

	sub.w	plotangled_radx,d7

	move.w	d7,d5	;x temp


	move.w	(a5),d7
	move.w	plotangled_rady,d6
	add.w	#1,d7
	mulu.w	d6,d7
	move.b	d7,d6	;b on d6
	lsr.w	#8,d7	;a on d7
	and.w	#255,d7
	asl.b	#1,d6
	roxl.b	#1,d7
;	add.w	plotangled_y,d7
	sub.w	plotangled_rady,d7
	move.w	d5,d6
	rts
endfunction






***************************************************************************************************************************************************************************************************
* rough_distance(x1,y1,x2,y2)
***************************************************************************************************************************************************************************************************
function	rough_distance	rough_distance_x1,rough_distance_y1,rough_distance_x2,rough_distance_y2
rem	; rough_distance(x1.w , y1.w , x2.w , y2.w )
rem	; Returns result to d7.W register
rem	; uses D7

def	rough_distance_x1	word
def	rough_distance_y1	word
def	rough_distance_x2	word
def	rough_distance_y2	word

def	rough_distance_dx1	word
def	rough_distance_dy1	word

stack	d6
rough_distance

; lets figure out which is greater
	move.w	rough_distance_x1,d7
	cmp.w	rough_distance_x2,d7
	bhs	rough_distance_bigx1
;x2-x1
	move.w	rough_distance_x2,d7
	sub.w	rough_distance_x1,d7
	move.w	d7,rough_distance_dx1
	bra	rough_distance_nexty
rough_distance_bigx1
	sub.w	rough_distance_x2,d7
	move.w	d7,rough_distance_dx1
rough_distance_nexty
; lets figure out which is greater
	move.w	rough_distance_y1,d7
	cmp.w	rough_distance_y2,d7
	bhs	rough_distance_bigy1
;y2-y1
	move.w	rough_distance_y2,d7
	sub.w	rough_distance_y1,d7
	move.w	d7,rough_distance_dy1
	bra	rough_distance_nextz
rough_distance_bigy1
	sub.w	rough_distance_y2,d7
	move.w	d7,rough_distance_dy1
rough_distance_nextz
; talk longest and add 1/4 of other

	move.w	rough_distance_dx1,d6
	cmp.w	d6,d7
	blo	rough_distance_dister1

	lsr.w	#2,d6
	add.w	d6,d7
	rts

rough_distance_dister1

	lsr.w	#2,d7
	add.w	d6,d7
	rts



endfunction











































