#dontinclude

;************************************************************************************************************************************************************
; init_sram()
;************************************************************************************************************************************************************
; validate if said ram is formatted and ready for reading and writing
function	init_sram
rem	init_sram()
rem	returns 1 on d7 if the granual table is setup. returns 0 on d7 if it needs to be formated
rem	
rem	
stack	a4-a6/d5-d6
;may change
sram_init_iocode
	dc.b	'SegaIDE VR 1.0.0'
def	sram_files	string	1280	;verified

init_sram
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200001,a6	;start of save ram
	move.l	#sram_init_iocode,a4	;verify
	move.l	#15,d5	;counter
sram_init_lp1
	move.b	(a6),d7
	lea	(2,a6),a6
	move.b	(a4),d6
	cmp.b	d6,d7
	bne	sram_init_fail
	lea	(1,a4),a4
	dbra	d5,sram_init_lp1
	move.l	#1,d7	;success
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
sram_init_fail
	move.l	#0,d7
	rts
endfunction

;*******************************************************************************************************************************************************************
; sram_format()
;*******************************************************************************************************************************************************************
function	sram_format
rem	sram_format()
rem	will partition said save ram for file input/output
rem	vr 1.0.0
rem	
stack	a4-a6/d6
sram_format_granuals
	dc.b	'SegaIDE VR 1.0.0'	;16
	dc.b	$f0,$f0,$f0,$f0,$f0,$f0,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;32
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;48
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;64
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;80
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;96
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;112
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;128
	dc.b	$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff,$ff	;144
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;160
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;176
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;192
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;208
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;224
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;240
	dc.b	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0	;256 end of granual table
; $ff is free
; $c0 used and indicates last granual in file
; $f0 file system
; first 6 granuals is the file system first granual....granual table 122grans available
;first 16 bytes is version number followed by max 79 files
sram_format
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200001,a6	;start of save ram
	move.l	#sram_format_granuals,a4	;verify
	move.l	#255,d6	;counter testing
sram_init_lp2
	move.b	(a4)+,d7	;load it
	move.b	d7,(a6)	;save it
	lea	(2,a6),a6
	dbra	d6,sram_init_lp2
;ok lets actually format all of it
; that takes care of granual system
; now file system and file area
	move.l	#32511,d7	;ram area
sram_init_lp3
	move.b	#$ff,(a6)
	lea	(2,a6),a6
	dbra	d7,sram_init_lp3
	move.l	#1,d7	;success
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
endfunction

;***************************************************************************************************************************************************************
;*   sram_free()
;***************************************************************************************************************************************************************
function	sram_free
rem	sram_free()
rem	returns how many free granuals are left on d7
rem	each granual is 256 bytes / 122 max with format
rem	you can multiply this result by 256 to find free sram space thats left
stack	a6/d5-d6
sram_free
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#150,d7
	clr.l	d5	;counter
sram_free_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	bne	sram_free_lpsk
	add.w	#1,d5
sram_free_lpsk
	lea	(2,a6),a6
	dbra	d7,sram_free_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.w	d5,d7
	rts
endfunction


;*****************************************************************************************************************************************************************
;* sram_freefiles()
;*****************************************************************************************************************************************************************
function	sram_freefiles
rem	sram_freefiles()
rem	returns how many files are left to be created in the file system
rem	maximum files is 80
rem	
stack	a6/d5-d6
sram_freefiles
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files
	move.l	#79,d7
	clr.l	d5	;counter
sram_freefiles_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	bne	sram_freefiles_lpsk
	add.w	#1,d5
sram_freefiles_lpsk
	lea	(32,a6),a6
	dbra	d7,sram_freefiles_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.w	d5,d7
	rts
endfunction


;*****************************************************************************************************************************************************************************
;* sram_dir()
;*****************************************************************************************************************************************************************************
function	sram_dir
rem	sram_dir
rem	returns full directory into #sram_files    label
rem	each file consists of 16 byte descriptions 80 files max
rem	[ filename12 ] [ bytes used 2 ] [granual start 2 ]  asciiname,word,word

stack	a5-a6/d6
sram_dir
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files
	move.l	#sram_files,a5
;mt out dir
	move.l	#1279,d7
sram_dir_mtout
	move.b	#255,(a5)
	lea	(1,a5),a5
	dbra	d7,sram_dir_mtout
	move.l	#sram_files,a5
	move.l	#79,d7
sram_dir_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_dir_lpskip
	move.l	#15,d6
sram_dir_lp2
	move.b	(a6),(a5)
	lea	(2,a6),a6
	lea	(1,a5),a5
	dbra	d6,sram_dir_lp2
	dbra	d7,sram_dir_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
sram_dir_lpskip
	lea	(32,a6),a6
	dbra	d7,sram_dir_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
endfunction



;*****************************************************************************************************************************************************************************
;* sram_dir2( extension.l)
;*****************************************************************************************************************************************************************************
function	sram_dir2	sram_dir2_ext
rem	sram_dir2( ext.l )
rem	returns full directory into #sram_files    label with the extension string provided only [3char expected]
rem	each file consists of 16 byte descriptions 80 files max
rem	[ filename12 ] [ bytes used 2 ] [granual start 2 ]  asciiname,word,word

def	sram_dir2_ext	long
stack	a4-a6/d4-d6
sram_dir2
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files
	move.l	#sram_files,a5
	move.l	sram_dir2_ext,a4	;ext string 3 bytes

;mt out dir
	move.l	#1279,d7
sram_dir2_mtout
	move.b	#0,(a5)
	lea	(1,a5),a5
	dbra	d7,sram_dir2_mtout

	move.l	#sram_files,a5
	move.l	#79,d7
sram_dir2_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_dir2_lpskip
;check ext $
	move.b	(18,a6),d5
	move.b	(0,a4),d4
	cmp.b	d5,d4
	bne	sram_dir2_lpskip
	move.b	(20,a6),d5
	move.b	(1,a4),d4
	cmp.b	d5,d4
	bne	sram_dir2_lpskip
	move.b	(22,a6),d5
	move.b	(2,a4),d4
	cmp.b	d5,d4
	bne	sram_dir2_lpskip

	move.l	#15,d6
sram_dir2_lp2
	move.b	(a6),(a5)
	lea	(2,a6),a6
	lea	(1,a5),a5
	dbra	d6,sram_dir2_lp2
	dbra	d7,sram_dir2_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
sram_dir2_lpskip
	lea	(32,a6),a6
	dbra	d7,sram_dir2_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
endfunction


;****************************************************************************************************************************************************************************************
;* sram_openfile(directory number,load location.l) 0-79
;****************************************************************************************************************************************************************************************
function	sram_openfile	sram_openfile_dirnum,sram_openfile_load
rem	sram_openfile( dir_file.w , ram_load_start.l )
rem	you must pull a directory call first in order to open a file.
rem	will load the file completely into specified ram location
rem	
def	sram_openfile_dirnum	word
def	sram_openfile_load	long
stack	a5-a6/d0-d6
sram_openfile
	clr.l	d6
	move.l	#sram_files,a6
	move.w	sram_openfile_dirnum,d6
	and.l	#255,d6
	mulu.w	#16,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_openfile_fail
	cmp.b	#0,d6
	beq	sram_openfile_fail
; ok lets open this file and load the whole thing
	move.w	(12,a6),d0	;d0 has bytes total
	sub.w	#1,d0	;0 based

	move.w	(14,a6),d1	;d1 has granual start
	and.l	#65535,d0
	and.l	#255,d1


	move.l	sram_openfile_load,a5	;where to dump this file

	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

sram_openfile_loop2
	move.l	#$200001,a6	;sram start of granuals
	move.l	#512,d7

	mulu.w	d1,d7
	lea	(a6,d7.l),a6	;ready for 512 tfr

	move.l	#255,d6	;counter

sram_openfile_loop1
	move.b	(a6),d7
	move.b	d7,(a5)
	cmp.w	#0,d0
	beq	sram_openfile_cmp
	sub.w	#1,d0	;bytes total deduction
	lea	(1,a5),a5
	lea	(2,a6),a6
	dbra	d6,sram_openfile_loop1
; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_openfile_cmp	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2


	bra	sram_openfile_loop2
; ok done?


sram_openfile_cmp
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#1,d7
	rts
sram_openfile_fail
	move.l	#0,d7
	rts
endfunction


;*******************************************************************************************************************************************************
;* sram_deletefile( file number #)
;*******************************************************************************************************************************************************
function	sram_deletefile	sram_deletefile_num
rem	sram_deletefile( filenumber. w )
rem	will delete the selected file and free up granuals
rem	must perform a directory call first
rem	
def	sram_deletefile_num	word

stack	a5-a6/d0-d6

sram_deletefile



	clr.l	d6
	move.l	#sram_files,a6
	move.w	sram_deletefile_num,d6
	and.l	#255,d6
	mulu.w	#16,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_deletefile_fail
	cmp.b	#0,d6
	beq	sram_deletefile_fail
; ok lets open this file and trace granuals while deleting
; need to find location on directory tree also



	move.w	(12,a6),d0	;d0 has bytes total
	sub.w	#1,d0	;0 based

	move.w	(14,a6),d1	;d1 has granual start
	and.l	#65535,d0
	and.l	#255,d1
; ok lets look at file table and find a match for granual start d1

	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;sram file table

	move.l	#79,d7	;files count

sram_deletefile_lp1
	move.b	(30,a6),d7
	cmp.b	d7,d1
	beq	sram_deletefile_fnd
	lea	(32,a6),a6
	dbra	d7,sram_deletefile_lp1
;failed to find

	bra	sram_deletefile_fail

sram_deletefile_fnd
	
	move.b	#255,(0,a6)	;kill file



sram_deletefile_loop2

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

	move.b	#255,(a6)	;now free

; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_deletefile_cmp	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2
	bra	sram_deletefile_loop2
; ok done?

sram_deletefile_cmp
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#1,d7
	rts

sram_deletefile_fail
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#0,d7
	rts

endfunction


;**********************************************************************************************************************************************
;* sram_savefile( filename , datalocation , size )
;**********************************************************************************************************************************************
function	sram_savefile	sram_savefile_name,sram_savefile_data,sram_savefile_size
rem	sram_savefile( filename.l , data_location.l , size.w )
rem	file name must be 12 bytes long
rem	will return 1 if successful on d7 and 0 if it fails
rem	
def	sram_savefile_name	long
def	sram_savefile_data	long
def	sram_savefile_size	word


stack	a5-a6/d0-d6

sram_savefile

; look for file exist



	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;sram file table
	move.l	sram_savefile_name,a5	;has file name

	move.l	#79,d7	;files count

sram_savefile_lp1
	move.b	(0,a6),d6
	move.b	(0,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(2,a6),d6
	move.b	(1,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(4,a6),d6
	move.b	(2,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(6,a6),d6
	move.b	(3,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(8,a6),d6
	move.b	(4,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(10,a6),d6
	move.b	(5,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(12,a6),d6
	move.b	(6,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(14,a6),d6
	move.b	(7,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(16,a6),d6
	move.b	(8,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(18,a6),d6
	move.b	(9,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(20,a6),d6
	move.b	(10,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
	move.b	(22,a6),d6
	move.b	(11,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile_not
; ok found it
; exact match

; now delete it and chase it


	move.b	#255,(0,a6)	;kill file

	move.b	(30,a6),d1	;granual start
	and.w	#255,d1

sram_savefile_loop2

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

	move.b	#255,(a6)	;now free

; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_savefile_fnd	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2
	bra	sram_savefile_loop2
; ok done?


	beq	sram_savefile_fnd

sram_savefile_not
	lea	(32,a6),a6
	dbra	d7,sram_savefile_lp1
;failed to find
; thats ok lets make a new file then after a quick granual count check

sram_savefile_fnd

;count space
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#150,d7
	clr.l	d5	;counter
	clr.l	d3	;put granual in here
sram_savefilefree_lp1
	move.b	(a6),d6
	cmp.b	#0,d3
	bne	sram_savefile_needg
	cmp.b	#255,d6
	bne	sram_savefilefree_lpsk
	move.w	#150,d3
	sub.w	d7,d3
; saved it?
sram_savefile_needg
	cmp.b	#255,d6
	bne	sram_savefilefree_lpsk
	add.w	#1,d5
sram_savefilefree_lpsk
	lea	(2,a6),a6
	dbra	d7,sram_savefilefree_lp1
; d5.w has grans free
	and.l	#65535,d5
	mulu.w	#256,d5
	move.w	sram_savefile_size,d7
	cmp.w	d7,d5
	blo	sram_savefile_fail	

;good.... save it

; find free file and write descriptor





	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files

	move.l	#79,d7
sram_savefiledir_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_savefiledir_fnd
	lea	(32,a6),a6
	dbra	d7,sram_savefiledir_lp1
	bra	sram_savefile_fail
sram_savefiledir_fnd

;copy file name
;a5-a6

	move.b	(0,a5),d6
	move.b	d6,(0,a6)
	move.b	(1,a5),d6
	move.b	d6,(2,a6)
	move.b	(2,a5),d6
	move.b	d6,(4,a6)
	move.b	(3,a5),d6
	move.b	d6,(6,a6)
	move.b	(4,a5),d6
	move.b	d6,(8,a6)
	move.b	(5,a5),d6
	move.b	d6,(10,a6)
	move.b	(6,a5),d6
	move.b	d6,(12,a6)
	move.b	(7,a5),d6
	move.b	d6,(14,a6)
	move.b	(8,a5),d6
	move.b	d6,(16,a6)
	move.b	(9,a5),d6
	move.b	d6,(18,a6)
	move.b	(10,a5),d6
	move.b	d6,(20,a6)
	move.b	(11,a5),d6
	move.b	d6,(22,a6)
; file name copied
	move.w	sram_savefile_size,d5
;	sub.w	#1,d5	;0 based
	move.w	d5,d4
	lsr.w	#8,d5
	move.b	d5,(24,a6)
	move.b	d4,(26,a6)
	move.b	#0,(28,a6)
	move.b	d3,(30,a6)
;hopefully its ready?


	move.l	sram_savefile_data,a5	;has data
;ok save it
	clr.l	d7
	clr.l	d0
	move.w	d4,d7	;total byte transfer
	move.w	d3,d0	;active granual
	and.l	#255,d0

sram_savefile_loopw1

;ok lets write out active granual
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#2,d6
	mulu.w	d0,d6	;d0 has active granual
	lea	(a6,d6.w),a6
	move.b	#240,(a6)	;write as last just incase it is

;ok setup block
	move.l	#$200001,a6	;start of granuals
	move.l	#512,d6
	mulu.w	d0,d6
	lea	(a6,d6.l),a6	;ok

	move.l	#255,d6	;blocktransfer ready

sram_savefile_loopw2
	move.b	(a5),d5
	move.b	d5,(a6)
	lea	(1,a5),a5
	lea	(2,a6),a6
	sub.w	#1,d7
	beq	sram_savefile_cmp
	dbra	d6,sram_savefile_loopw2

; find another granual that is free





;d0 is active granual




;count space
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#150,d4
	clr.l	d5	;counter
	clr.l	d3	;put granual in here
sram_savefilefree_lp12
	move.b	(a6),d6
	cmp.b	#0,d3
	bne	sram_savefile_needg2
	cmp.b	#255,d6
	bne	sram_savefilefree_lpsk2
	move.w	#150,d3
	sub.w	d4,d3
; saved it?
sram_savefile_needg2
	cmp.b	#255,d6
	bne	sram_savefilefree_lpsk2
	add.w	#1,d5
sram_savefilefree_lpsk2
	lea	(2,a6),a6
	dbra	d4,sram_savefilefree_lp12
; d5.w has grans free
;d3 has new granual
;lets write d3 into d0


	move.l	#$200021,a6	;start of save ram granuals
	move.l	#2,d6
	mulu.w	d0,d6	;d0 has active granual
	lea	(a6,d6.w),a6
	move.b	d3,(a6)	;write as last just incase it is
	move.b	d3,d0	;new active
	and.l	#255,d0

	bra	sram_savefile_loopw1



; good!
sram_savefile_cmp
	sub.w	#1,d6
	bmi	sram_savefile_loopw223

sram_savefile_loopw22
	move.b	#0,(a6)
	lea	(2,a6),a6
	dbra	d6,sram_savefile_loopw22


sram_savefile_loopw223


	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#1,d7
	rts
; fail?
sram_savefile_fail
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#0,d7
	rts

endfunction

;***********************************************************************************************************************************************************************************************************************



;**********************************************************************************************************************************************
;* sram_savefile2( filename , size )
;**********************************************************************************************************************************************
function	sram_savefile2	sram_savefile2_name,sram_savefile2_size
rem	sram_savefile2( filename.l , size.w )
rem	file name must be 12 bytes long
rem	will return file number if successful on d7 and 255 if it fails
rem	fills file with ff's
def	sram_savefile2_name	long
def	sram_savefile2_size	word
def	sram_savefile2_fn	word	;file number

stack	a5-a6/d0-d6

sram_savefile2

; look for file exist



	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;sram file table
	move.l	sram_savefile2_name,a5	;has file name

	move.l	#79,d7	;files count

sram_savefile2_lp1
	move.b	(0,a6),d6
	move.b	(0,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(2,a6),d6
	move.b	(1,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(4,a6),d6
	move.b	(2,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(6,a6),d6
	move.b	(3,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(8,a6),d6
	move.b	(4,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(10,a6),d6
	move.b	(5,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(12,a6),d6
	move.b	(6,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(14,a6),d6
	move.b	(7,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(16,a6),d6
	move.b	(8,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(18,a6),d6
	move.b	(9,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(20,a6),d6
	move.b	(10,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
	move.b	(22,a6),d6
	move.b	(11,a5),d5
	cmp.b	d6,d5
	bne	sram_savefile2_not
; ok found it
; exact match

; now delete it and chase it


	move.b	#255,(0,a6)	;kill file

	move.b	(30,a6),d1	;granual start
	and.w	#255,d1

sram_savefile2_loop2

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

	move.b	#255,(a6)	;now free

; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_savefile2_fnd	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2
	bra	sram_savefile2_loop2
; ok done?


	beq	sram_savefile2_fnd

sram_savefile2_not
	lea	(32,a6),a6
	dbra	d7,sram_savefile2_lp1
;failed to find
; thats ok lets make a new file then after a quick granual count check

sram_savefile2_fnd

;count space
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#150,d7
	clr.l	d5	;counter
	clr.l	d3	;put granual in here
sram_savefile2free_lp1
	move.b	(a6),d6
	cmp.b	#0,d3
	bne	sram_savefile2_needg
	cmp.b	#255,d6
	bne	sram_savefile2free_lpsk
	move.w	#150,d3
	sub.w	d7,d3
; saved it?
sram_savefile2_needg
	cmp.b	#255,d6
	bne	sram_savefile2free_lpsk
	add.w	#1,d5
sram_savefile2free_lpsk
	lea	(2,a6),a6
	dbra	d7,sram_savefile2free_lp1
; d5.w has grans free
	and.l	#65535,d5
	mulu.w	#256,d5
	move.w	sram_savefile2_size,d7
	cmp.w	d7,d5
	blo	sram_savefile2_fail	

;good.... save it

; find free file and write descriptor





	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files
	move.w	#0,sram_savefile2_fn	;file number

	move.l	#79,d7
sram_savefile2dir_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_savefile2dir_fnd
	add.w	#1,sram_savefile2_fn
	lea	(32,a6),a6
	dbra	d7,sram_savefile2dir_lp1
	bra	sram_savefile2_fail
sram_savefile2dir_fnd

;copy file name
;a5-a6

	move.b	(0,a5),d6
	move.b	d6,(0,a6)
	move.b	(1,a5),d6
	move.b	d6,(2,a6)
	move.b	(2,a5),d6
	move.b	d6,(4,a6)
	move.b	(3,a5),d6
	move.b	d6,(6,a6)
	move.b	(4,a5),d6
	move.b	d6,(8,a6)
	move.b	(5,a5),d6
	move.b	d6,(10,a6)
	move.b	(6,a5),d6
	move.b	d6,(12,a6)
	move.b	(7,a5),d6
	move.b	d6,(14,a6)
	move.b	(8,a5),d6
	move.b	d6,(16,a6)
	move.b	(9,a5),d6
	move.b	d6,(18,a6)
	move.b	(10,a5),d6
	move.b	d6,(20,a6)
	move.b	(11,a5),d6
	move.b	d6,(22,a6)
; file name copied
	move.w	sram_savefile2_size,d5
;	sub.w	#1,d5	;0 based
	move.w	d5,d4
	lsr.w	#8,d5
	move.b	d5,(24,a6)
	move.b	d4,(26,a6)
	move.b	#0,(28,a6)
	move.b	d3,(30,a6)
;hopefully its ready?


;ok save it
	clr.l	d7
	clr.l	d0
	move.w	d4,d7	;total byte transfer
	move.w	d3,d0	;active granual
	and.l	#255,d0

sram_savefile2_loopw1

;ok lets write out active granual
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#2,d6
	mulu.w	d0,d6	;d0 has active granual
	lea	(a6,d6.w),a6
	move.b	#240,(a6)	;write as last just incase it is

;ok setup block
	move.l	#$200001,a6	;start of granuals
	move.l	#512,d6
	mulu.w	d0,d6
	lea	(a6,d6.l),a6	;ok

	move.l	#255,d6	;blocktransfer ready

sram_savefile2_loopw2
	move.b	#255,d5	;write ff
	move.b	d5,(a6)
	lea	(2,a6),a6
	sub.w	#1,d7
	beq	sram_savefile2_cmp
	dbra	d6,sram_savefile2_loopw2

; find another granual that is free





;d0 is active granual




;count space
	move.l	#$200021,a6	;start of save ram granuals
	move.l	#150,d4
	clr.l	d5	;counter
	clr.l	d3	;put granual in here
sram_savefile2free_lp12
	move.b	(a6),d6
	cmp.b	#0,d3
	bne	sram_savefile2_needg2
	cmp.b	#255,d6
	bne	sram_savefile2free_lpsk2
	move.w	#150,d3
	sub.w	d4,d3
; saved it?
sram_savefile2_needg2
	cmp.b	#255,d6
	bne	sram_savefile2free_lpsk2
	add.w	#1,d5
sram_savefile2free_lpsk2
	lea	(2,a6),a6
	dbra	d4,sram_savefile2free_lp12
; d5.w has grans free
;d3 has new granual
;lets write d3 into d0


	move.l	#$200021,a6	;start of save ram granuals
	move.l	#2,d6
	mulu.w	d0,d6	;d0 has active granual
	lea	(a6,d6.w),a6
	move.b	d3,(a6)	;write as last just incase it is
	move.b	d3,d0	;new active
	and.l	#255,d0

	bra	sram_savefile2_loopw1


; good!
sram_savefile2_cmp
	sub.w	#1,d6
	bmi	sram_savefile2_loopw223

sram_savefile2_loopw22
	move.b	#0,(a6)
	lea	(2,a6),a6
	dbra	d6,sram_savefile2_loopw22


sram_savefile2_loopw223


	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr

;get file number success!
	move.w	sram_savefile2_fn,d7

	rts
; fail?
sram_savefile2_fail
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.l	#255,d7
	rts

endfunction




;****************************************************************************************************************************************************************************************
;* sram_openfilebyte(directory number,byte number.w) 0-79
;****************************************************************************************************************************************************************************************
function	sram_openfilebyte	sram_openfilebyte_dirnum,sram_openfilebyte_load
rem	sram_openfilebyte( dir_file.w , byte load.w )
rem	you must pull a directory call first in order to open a file.
rem	will load the byte and return on d6
rem	will return 1 on d7 if success 0 if fail
def	sram_openfilebyte_dirnum	word
def	sram_openfilebyte_load	word
stack	a5-a6/d0-d5
sram_openfilebyte
	move.w	sram_openfilebyte_load,d3	;looking for
	clr.l	d6
	move.l	#sram_files,a6
	move.w	sram_openfilebyte_dirnum,d6
	and.l	#255,d6
	mulu.w	#16,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_openfilebyte_fail
	cmp.b	#0,d6
	beq	sram_openfilebyte_fail
; ok lets open this file and load the whole thing
	move.w	(12,a6),d0	;d0 has bytes total
	sub.w	#1,d0	;0 based

	move.w	(14,a6),d1	;d1 has granual start
	and.l	#65535,d0
	and.l	#255,d1


;	move.l	sram_openfilebyte_load,a5	;where to dump this file

	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

sram_openfilebyte_loop2
	move.l	#$200001,a6	;sram start of granuals
	move.l	#512,d7

	mulu.w	d1,d7
	lea	(a6,d7.l),a6	;ready for 512 tfr

	move.l	#255,d6	;counter

	if	w,d3>#255
	move.l	#0,d6	;counter
	sub.w	#255,d3
	sub.w	#255,d0	;bytes total deduction

	endif
sram_openfilebyte_loop1
;	move.b	(a6),d7
;	move.b	d7,(a5)

	cmp.w	#0,d3
	beq	sram_openfilebyte_cmp	;done

	cmp.w	#0,d0
	beq	sram_openfilebyte_cmp
	sub.w	#1,d3
	sub.w	#1,d0	;bytes total deduction
;	lea	(1,a5),a5
	lea	(2,a6),a6
	dbra	d6,sram_openfilebyte_loop1
; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_openfilebyte_cmp	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2


	bra	sram_openfilebyte_loop2
; ok done?


sram_openfilebyte_cmp
	move.b	(a6),d6	;read
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	and.l	#255,d6
	move.w	#1,d7
	rts
sram_openfilebyte_fail
	move.l	#0,d7
	rts
endfunction




;****************************************************************************************************************************************************************************************
;* sram_writefilebyte(directory number,byte number.w, byte.b) 0-79
;****************************************************************************************************************************************************************************************
function	sram_writefilebyte	sram_writefilebyte_dirnum,sram_writefilebyte_load,sram_writefilebyte_byte
rem	sram_writefilebyte( dir_file.w , byte number.w , value.b )
rem	you must pull a directory call first in order to open a file.
rem	will return 1 on d7 if success 0 if fail
rem	
def	sram_writefilebyte_dirnum	word
def	sram_writefilebyte_load	word
def	sram_writefilebyte_byte	byte
def	sram_writefilebyte_byte1	byte
stack	a5-a6/d0-d6
sram_writefilebyte
	move.w	sram_writefilebyte_load,d3	;looking for
	clr.l	d6
	move.l	#sram_files,a6
	move.w	sram_writefilebyte_dirnum,d6
	and.l	#255,d6
	mulu.w	#16,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_writefilebyte_fail
	cmp.b	#0,d6
	beq	sram_writefilebyte_fail
; ok lets open this file and load the whole thing
	move.w	(12,a6),d0	;d0 has bytes total
	sub.w	#1,d0	;0 based

	move.w	(14,a6),d1	;d1 has granual start
	and.l	#65535,d0
	and.l	#255,d1


;	move.l	sram_writefilebyte_load,a5	;where to dump this file

	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2

sram_writefilebyte_loop2
	move.l	#$200001,a6	;sram start of granuals
	move.l	#512,d7

	mulu.w	d1,d7
	lea	(a6,d7.l),a6	;ready for 512 tfr

	move.l	#255,d6	;counter

	if	w,d3>#255
	move.l	#0,d6	;counter
	sub.w	#255,d3
	sub.w	#255,d0	;bytes total deduction
	move.w	#512,d7
	lea	(a6,d7.l),a6
	endif


sram_writefilebyte_loop1
;	move.b	(a6),d7
;	move.b	d7,(a5)

	cmp.w	#0,d3
	beq	sram_writefilebyte_cmp	;done

	cmp.w	#0,d0
	beq	sram_writefilebyte_cmp
	sub.w	#1,d3
	sub.w	#1,d0	;bytes total deduction
;	lea	(1,a5),a5
	lea	(2,a6),a6
	dbra	d6,sram_writefilebyte_loop1
; ok is there another?
	move.w	d2,d1
	and.w	#255,d1
	cmp.b	#240,d1
	beq	sram_writefilebyte_cmp	;ok its done

;lets load next gran

	move.l	#$200021,a6	;sram start of granuals
	clr.l	d6
	move.w	d1,d6	;granual
	mulu.w	#2,d6
	lea	(a6,d6.w),a6
	move.b	(a6),d2	;next granual =240 if last
	and.w	#255,d2


	bra	sram_writefilebyte_loop2
; ok done?


sram_writefilebyte_cmp
	move.b	sram_writefilebyte_byte,d7
	move.b	d7,(a6)	;write


	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	move.w	#1,d7
	rts
sram_writefilebyte_fail
	move.l	#0,d7
	rts
endfunction







;*****************************************************************************************************************************************************************************
;* sram_fileexist( name.l)
;*****************************************************************************************************************************************************************************
function	sram_fileexist	sram_fileexist_ext
rem	sram_fileexist( filename exists.l )
rem	
rem	
rem	returns 1 on d6 if exists/ returns file size w on d7

def	sram_fileexist_ext	long
stack	a4-a6/d4-d5
sram_fileexist
	move.w	#$2700,sr	; disable interrupts
	move.b	#1,$A130F1   ; Unlock SRAM
	move.l	#$200201,a6	;start of save ram file blocks.... should have 80 files
	move.l	#sram_files,a5
	move.l	sram_fileexist_ext,a4	;ext string 3 bytes

;mt out dir
	move.l	#1279,d7
sram_fileexist_mtout
	move.b	#0,(a5)
	lea	(1,a5),a5
	dbra	d7,sram_fileexist_mtout

	move.l	#sram_files,a5
	move.l	#79,d7
sram_fileexist_lp1
	move.b	(a6),d6
	cmp.b	#255,d6
	beq	sram_fileexist_lpskip
;check file name
	move.b	(0,a6),d5
	move.b	(0,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(2,a6),d5
	move.b	(1,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(4,a6),d5
	move.b	(2,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(6,a6),d5
	move.b	(3,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(8,a6),d5
	move.b	(4,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(10,a6),d5
	move.b	(5,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(12,a6),d5
	move.b	(6,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(14,a6),d5
	move.b	(7,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(16,a6),d5
	move.b	(8,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip

	move.b	(18,a6),d5
	move.b	(9,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(20,a6),d5
	move.b	(10,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip
	move.b	(22,a6),d5
	move.b	(11,a4),d4
	cmp.b	d5,d4
	bne	sram_fileexist_lpskip

; found file

; [ filename12 ] [ bytes used 2 ] [granual start 2 ]  asciiname,word,word

	move.b	(24,a6),d0
	and.w	#255,d0
	lsl.w	#8,d0
	add.b	(26,a6),d0
	move.w	d0,d7	;file size
	move.w	#1,d6	;exists

	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	rts
sram_fileexist_lpskip
	lea	(32,a6),a6
	dbra	d7,sram_fileexist_lp1
	move.b	#0,$A130F1	; Lock SRAM
	move.w	#$2000,sr
	clr.w	d6
	clr.w	d7
	rts
endfunction





