; *************************************************************************************************
; * sega rom template 1.4
; *************************************************************************************************
; do not modify the start and end labels
; your code will be reconstructed when compiled in the correct place

#include	sega\s_main.mdl
#include	sega\s_math.mdl
#include	sega\s_input.mdl
#include	sega\s_dma.mdl
#include	sega\s_collision.mdl
#include	sega\s_saveram.mdl
#include	sega\s_z80.mdl

#segaromwavstart	458752	;wav files start originating
#memstart	16711680	;$ff0000

	org	512
segaromstart

	init_sega()	;get past sega security and clear ram
	init_segavdp()	;setup graphics and irq6 enabled also
	init_z80()		;setup dac



	ym_setpatch( #0, #1, #ins1)
	ym_setpatch( #1, #2, #ins1)
	ym_setpatch( #2, #3 , #ins1)
	ym_setpatch( #4, #1 , #ins1)
	ym_setpatch( #5, #2 , #ins1)
	ym_setpatch( #6, #3 , #ins1)

	ym_playmusic( #music1, #2 , #4, #12 , #15)

; setup 4 palettes red,green,blue   0-63 and color 0-7

	sega_palette(#1,#0,#0,#0)	;black 0,0,0
	sega_palette(#2,#2,#2,#2)	;grey text font color
	sega_palette(#3,#4,#4,#4)	;grey
	sega_palette(#4,#7,#7,#7)	;white 255,255,255
	sega_palette(#5,#0,#3,#0)	;dgreen 0,109,0
	sega_palette(#6,#0,#7,#0)	;green 0,255,0
	sega_palette(#7,#0,#7,#7)	;cyan 0,200,200
	sega_palette(#8,#0,#0,#3)	;lblue 0,0,109
	sega_palette(#9,#0,#0,#7)	;blue 0,0,255
	sega_palette(#10,#3,#0,#5)	;purple 109,0,182
	sega_palette(#11,#6,#0,#3)	;pink 218,0,109
	sega_palette(#12,#7,#0,#0)	;red 255,0,0
	sega_palette(#13,#7,#3,#0)	;orange 255,109,0
	sega_palette(#14,#7,#5,#0)	;peach 255,182,0
	sega_palette(#15,#7,#6,#0)	;peachl 255,218,0


	sega_palette(#17,#0,#0,#0)	;black 0,0,0
	sega_palette(#18,#2,#2,#2)	;grey
	sega_palette(#19,#4,#4,#4)	;grey
	sega_palette(#20,#7,#7,#7)	;white 255,255,255
	sega_palette(#21,#0,#3,#0)	;dgreen 0,109,0
	sega_palette(#22,#0,#7,#0)	;green 0,255,0
	sega_palette(#23,#0,#7,#7)	;cyan 0,200,200
	sega_palette(#24,#0,#0,#3)	;lblue 0,0,109
	sega_palette(#25,#0,#0,#7)	;blue 0,0,255
	sega_palette(#26,#3,#0,#5)	;purple 109,0,182
	sega_palette(#27,#6,#0,#3)	;pink 218,0,109
	sega_palette(#28,#7,#0,#0)	;red 255,0,0
	sega_palette(#29,#7,#3,#0)	;orange 255,109,0
	sega_palette(#30,#7,#5,#0)	;peach 255,182,0
	sega_palette(#31,#7,#6,#0)	;peachl 255,218,0




	sega_palette(#33,#0,#0,#0)	;black 0,0,0
	sega_palette(#34,#1,#1,#1)	;
	sega_palette(#35,#2,#2,#2)	;
	sega_palette(#36,#3,#3,#3)	;
	sega_palette(#37,#4,#4,#4)	;
	sega_palette(#38,#5,#5,#5)	;
	sega_palette(#39,#6,#6,#6)	;
	sega_palette(#40,#7,#7,#7)	;
	sega_palette(#41,#1,#1,#0)	;skin
	sega_palette(#42,#2,#1,#0)	;
	sega_palette(#43,#3,#2,#1)	;
	sega_palette(#44,#4,#3,#2)	;
	sega_palette(#45,#5,#4,#3)	;
	sega_palette(#46,#6,#5,#4)	;
	sega_palette(#47,#7,#6,#5)	;

	sega_palette(#49,#1,#1,#1)	;black
	sega_palette(#50,#3,#3,#3)	;grey
	sega_palette(#51,#7,#7,#7)	;white
	sega_palette(#52,#3,#0,#0)	;red
	sega_palette(#53,#5,#0,#0)	;red
	sega_palette(#54,#7,#0,#0)	;red
	sega_palette(#55,#0,#3,#0)	;green
	sega_palette(#56,#0,#5,#0)	;green
	sega_palette(#57,#0,#7,#0)	;green
	sega_palette(#58,#0,#0,#3)	;blue
	sega_palette(#59,#0,#0,#5)	;blue
	sega_palette(#60,#0,#0,#7)	;blue
	sega_palette(#61,#5,#4,#3)	;skin 150,125,100  5,4,3
	sega_palette(#62,#6,#5,#4)	;skin 200,175,150  6,5,4
	sega_palette(#63,#7,#6,#5)	;skin 250,225,200    7,6,5



;	ym_playsfx('test.wav',#3,#1) if you have an 8000khz sound of <32kb

	sega_font()	;setup diagnostic ascii (tiles 0-145) uses color #2 index


	sega_background(#0,#61)	;change background color like this or
; like this
	sega_background(#3,#13)	;same thing


	sega_clearplanea(#0)	;clears plane a layer with tile 0
	sega_clearplaneb(#0)

	sega_printa(#2,#2,#hello,#0,#0,#3,#0)	;prints x,y,text,hflip,vflip,palette,priority

; how to disable irq 6 and re-enable it
;	move.w	#$2700,sr	; kill irq
;	move.w	#$2000,sr	; enable irq


doloop
	wordstring(systemclock_c,#word)	;convert system clock to text and store as word
	sega_printa(#0,#0,#word,#0,#0,#3,#0)	;print that word

	sync()	;sync start
; code loop
	syncend()	;sync ending
	bra	doloop





def	word	string	16	;defined a 16 byte string space



hello
	dc.b	'Hello Sega Genesis Developer'	;text to display
	dc.b	0,0	;terminate text with two 0 value bytes
	even	;make your code even

; make sure all data structures are even.  odd will work on emulation but crash on real hardware




; ***********************************************************************************************
; * code handlers
; ***********************************************************************************************
ignore_handler
	rte	; return from exception

;*************************************************************************************************
;irq 6
;*************************************************************************************************
interrupt6
;push to stack
	movem.l	a0-a6/d0-d7,-(a7)
;process things such as system clock and music player


	systemclock()	;update system clock saved as var systemclock_c 'dword'
	ym_updateplayer()	;update music player

;pull from stack
	movem.l	(a7)+,a0-a6/d0-d7
	rte	; return from exception

; place wav files here near the end
;	incbin	'test.wav'	;30508
;if you had sound


; included data goes here before compile automatically

music1
	incbin	'mariok.mdm'	;8332
	even




ins1
	dc.b	0,0,1,1,1,1,3,3,3,3,9,0,5,1,23,20,50,20,0,0,0,0,31,31,31,31,0,0,0,0,12,7,10,10,7,7,7,9,7,7,7,7,7,7,7,7,0,0,0,0,5,0,68,73,83,84,79,82,84,49,8
	even



segaromend	;end marker for rom size calculation



